<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	if(!$admin_show['application_requests']) { show_error('Forbidden',403); }
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$count = 0;
?>
				<div id="success">&nbsp;</div>
				<div id="error">&nbsp;</div> 

				<div class="breadcrumb-header-block">
					<h1>Administration</h1><span class="seperator">&#9658;</span><h2>Application Requests</h2>
				</div>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div id="message_info" class="message_info">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					
					<script>
						$(function() {
							$("#tabs").tabs();
							$("#pending_link").removeAttr("tabindex");
							$("#approved_link").removeAttr("tabindex");
							$("#denied_link").removeAttr("tabindex");

							$("[id^=dialog-form]").dialog({
								autoOpen: false,
								width: 600,
								height: 300,
								modal: true,
								buttons: {
									Submit: function(){
										var id = $(this).attr('id').replace('dialog-form','');
										$('#denyForm'+id).submit();
									},
									Cancel: function(){
										$(this).dialog("close");
									}
								}
							});
							$("[id^=deny-app]").click(function(e) {
								var id = 0;
								if($(e.target).attr('id')){
									id = $(e.target).attr('id').replace('deny-app',''); 
								}
								else{
									id = $(e.target).parent().attr('id').replace('deny-app',''); //get parent id since click is on image
								}
								$("#dialog-form"+id).dialog("open");
							});
						});
					</script>
					<?PHP
						echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'pending_page_on_bar' => '',
							'pending_page_select' => '',
							'pending_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'approved_page_on_bar' => '',
							'approved_page_select' => '',
							'approved_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'denied_page_on_bar' => '',
							'denied_page_select' => '',
							'denied_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div id="tabs" class="column">					
						
						<ul>
							<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>						
							<li><a id="pending_link" href="#pending" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Pending Approval</a></li>
							<li><a id="approved_link" href="#approved" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Approved</a></li>
							<li><a id="denied_link" href="#denied" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Denied</a></li>
							<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
						</ul>	
						<div id="pending">
							<p>This table lists the applications that are awaiting approval for access to the API services.</p>						
							<?php if (sizeof($pending_list) == 0) { ?>
								<div class="message">There are currently no application requests awaiting approval.</div>
							<?php }else{ ?>
								<table id="pending_table" class="display">
									<caption class="hidden_context">Pending Application Requests</caption>
									<thead>
										<tr class="gridheader">
											<th align="center" scope="col">Application</th>
											<th scope="col">POC</th>											
											<th scope="col">Description</th>
											<th scope="col">Requested Date</th>
											<th scope="col" width="10%" class="displaylast">Actions</th>
										</tr>
									</thead>
									<tbody>							
									<?php foreach($pending_list as $request){ ?>
										<tr id="<?php echo $request->id; ?>row">
											<td class="pending_application_request_name">
												<?php echo $request->name; ?>&nbsp;
												<?php if ($request->url){?>
													<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->description){?>
													<br/><?php echo $request->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="pending_application_request_poc">
												<?php if ($request->poc_name){?>
													<?php echo $request->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($request->poc_email){?>
													<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->poc_phone){?>
													<br/><?php echo $request->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="pending_application_request_description"><?php echo $request->justification; ?>&nbsp;</td>
											<td class="pending_application_request_date"><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
											<td class="pending_application_request_actions">
												<?PHP
													echo form_open('/administration/approve_request',array('id'=>'approveForm'.$request->id,'class'=>'approveForm'));
													$hidden_inputs = array(
														'request_id' => $request->id,
														'pending_page_select_from_approve_button' => $pending_cur_page,
														'pending_items_per_page_from_approve_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														'approved_page_select_from_approve_button' => $approved_cur_page,
														'approved_items_per_page_from_approve_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														'denied_page_select_from_approve_button' => $denied_cur_page,
														'denied_items_per_page_from_approve_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													);
													echo form_hidden($hidden_inputs,TRUE);
													echo form_close();
												?>
												<div id="dialog-form<?php echo $request->id; ?>" title="Reason for Denial">
													<?PHP
														echo form_open('/administration/deny_request',array('id'=>'denyForm'.$request->id));
														echo form_label('Reason for Denial:','denial_reason'.$request->id,array('class'=>'modal'));
														echo form_textarea('reason','','id="denial_reason'.$request->id.'" class="modal"');
														$hidden_inputs = array(
															'request_id' => $request->id,
															'pending_page_select_from_deny_button' => $pending_cur_page,
															'pending_items_per_page_from_deny_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
															'approved_page_select_from_deny_button' => $approved_cur_page,
															'approved_items_per_page_from_deny_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
															'denied_page_select_from_deny_button' => $denied_cur_page,
															'denied_items_per_page_from_deny_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														);
														echo form_hidden($hidden_inputs,TRUE);
														echo form_close();
													?>
												</div>
												<div class="center">
													<a href="#" onclick="if (confirm('Are you sure you want to approve <?php echo $request->name; ?>?')){$('#approveForm<?php echo $request->id; ?>').submit();}" title="Approve Request: <?php echo $request->name; ?>"><img src="/images/icons/accept.png" alt="Approve Request: <?php echo $request->name; ?>" /></a>
													<a href="#" id="deny-app<?php echo $request->id; ?>" title="Deny Request: <?php echo $request->name; ?>"><img src="/images/icons/cancel.png" alt="Deny Request: <?php echo $request->name; ?>" /></a>
												</div>
											</td>
										</tr>
									<?php $count++; } ?>
									</tbody>
								</table>
							<?php } ?>
						</div>
						
						<div id="approved">
							<p>This table lists the applications that have been approved for access to the API services.</p>
							<?php if (sizeof($approved_list) == 0) { ?>
								<div class="message">There are currently no applications that have been approved.</div>
							<?php }else{ ?>
								<br/>
								<table id="approved_table" class="display">
									<caption class="hidden_context">Approved Application Requests</caption>
									<thead>
										<tr class="gridheader">
											<th align="center" scope="col">Application</th>
											<th scope="col">POC</th>											
											<th scope="col">Requested Date</th>
											<th scope="col">Approval Date</th>
										</tr>
									</thead>
									<?php foreach($approved_list as $request){ ?>
										<tr id="<?php echo $request->id; ?>row">
											<td class="approve_or_deny_application_request_name">
												<?php echo $request->name; ?>&nbsp;
												<?php if ($request->url){?>
													<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->description){?>
													<br/><?php echo $request->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="approve_or_deny_application_request_poc">
												<?php if ($request->poc_name){?>
													<?php echo $request->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($request->poc_email){?>
													<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->poc_phone){?>
													<br/><?php echo $request->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="approve_or_deny_application_request_date"><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
											<td class="approve_or_deny_application_request_approve_or_deny_date">
												<?php echo date("M d Y H:i:s",$request->approved_date); ?>&nbsp;
											</td>
										</tr>
									<?php } ?>
								</table>
							<?php } ?>
						</div>						
						<div id="denied">
							<p>This table lists the applications that have been denied access to the API services.</p>
							<?php if (sizeof($denied_list) == 0) { ?>
								<div class="message">There are currently no application requests that have been denied.</div>
							<?php }else{ ?>
								<br/>
								<table id="denied_table" class="display">
									<caption class="hidden_context">Denied Application Requests</caption>
									<thead>
										<tr class="gridheader">
											<th align="center" scope="col">Application</th>
											<th scope="col">POC</th>											
											<th scope="col">Requested Date</th>
											<th scope="col">Denial Date</th>
										</tr>
									</thead>
									<?php foreach($denied_list as $request){ ?>
										<tr id="<?php echo $request->id; ?>row">
											<td class="approve_or_deny_application_request_name">
												<?php echo $request->name; ?>&nbsp;
												<?php if ($request->url){?>
													<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->description){?>
													<br/><?php echo $request->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="approve_or_deny_application_request_poc">
												<?php if ($request->poc_name){?>
													<?php echo $request->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($request->poc_email){?>
													<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->poc_phone){?>
													<br/><?php echo $request->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="approve_or_deny_application_request_date"><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
											<td class="approve_or_deny_application_request_approve_or_deny_date">
												<?php echo $request->denial_reason; ?>&nbsp;
											</td>
										</tr>
									<?php } ?>
								</table>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>

<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo get_instance()->json->encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo get_instance()->json->encode($form_values); ?>);

	$(document).ready(function() {
		$('#pending_table').dataTable({
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
					$(oSettings.nTableWrapper).find('.dataTables_length').hide();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
			                 { 'bSearchable': false, 'aTargets': 4},
			                 { "sClass": "center", 'aTargets': []}],
			//set default sorting to Last Modified 2nd column, ascending
			"aaSorting": [[0,"asc"]],
			//"bPaginate": false,
			//set search box text
			"oLanguage": {
				"sSearch": "Find Application: ",
				"sEmptyTable":    "No applications were found",
				"sZeroRecords":   "No applications were found",
				"sInfo": "_TOTAL_ results",
				"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
					if(iTotal == 1) { return iTotal + " result"; }
					return iTotal + " results";
				},
				"sLengthMenu": "Records per page _MENU_",
				"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
			}
		});
	});

	$(document).ready(function() {
		$('#approved_table').dataTable({
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
					$(oSettings.nTableWrapper).find('.dataTables_length').hide();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
			                 { "sClass": "center", 'aTargets': []}],
			//set default sorting to Last Modified 2nd column, ascending
			"aaSorting": [[0,"asc"]],
			//"bPaginate": false,
			//set search box text
			"oLanguage": {
				"sSearch": "Find Application: ",
				"sEmptyTable":    "No applications were found",
				"sZeroRecords":   "No applications were found",
				"sInfo": "_TOTAL_ results",
				"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
					if(iTotal == 1) { return iTotal + " result"; }
					return iTotal + " results";
				},
				"sLengthMenu": "Records per page _MENU_",
				"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
			}
		});
	});

	$(document).ready(function() {
		$('#denied_table').dataTable({
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
					$(oSettings.nTableWrapper).find('.dataTables_length').hide();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
			                 { "sClass": "center", 'aTargets': []}],
			//set default sorting to Last Modified 2nd column, ascending
			"aaSorting": [[0,"asc"]],
			//"bPaginate": false,
			//set search box text
			"oLanguage": {
				"sSearch": "Find Application: ",
				"sEmptyTable":    "No applications were found",
				"sZeroRecords":   "No applications were found",
				"sInfo": "_TOTAL_ results",
				"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
					if(iTotal == 1) { return iTotal + " result"; }
					return iTotal + " results";
				},
				"sLengthMenu": "Records per page _MENU_",
				"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
			}
		});
	});
</script>