<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */
?>
					<script>
						$(function() {
							$("#tabs").tabs();
							$("#accounts_link").removeAttr("tabindex");
							$("#deactivated_link").removeAttr("tabindex");
							$("#ui-id-1").removeAttr("tabindex");
						});
					</script>
					<div class="column">
						<?PHP if(isset($message)) { echo '<div id="message_info" class="message_info">'.$message.'</div>'; } ?>
						<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
						<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
						<div id="tabs" class="column">
							<ul>
								<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>
								<li><a id="accounts_link" href="#accounts" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Groups</a></li>
								<li><a id="deactivated_link" href="#deactivated" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Disabled Groups</a></li>
								<?PHP if($create_group_show) { ?><li><a href="#create" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Create Group</a></li><?PHP } ?>
								<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
							</ul>
							<div id="accounts">
								<p>This table lists the active groups.</p>
									<br/>
									<table id="active_group_table" class="display">
									<caption class="hidden_context">Active Groups</caption>
									<thead>
										<tr class="gridheader">
											<th scope="col">Group Name</th>
											<th scope="col">Display name</th>											
											<th scope="col">Description</th>
											<th scope="col">Access</th>
											<th scope="col" width="10%" class="displaylast">Actions</th>
										</tr>
									</thead>
									<tbody>
										<?PHP foreach($groups as $group) { ?>
											<tr>
												<td class="center break-word"><a href="/administration/manage/groups/edit/<?PHP echo $group['ou']; ?>"><?PHP echo $group['ou']; ?></a></td>
												<td class="center break-word"><?PHP echo $group['cn']; ?></td>
												<td class="center break-word"><?PHP echo $group['description']; ?></td>
												<td class="center break-word"><?PHP foreach($group['access'] as $access) { echo $access . '<br/>'; } ?></td>
												<td class="center">
													<a href="/administration/manage/groups/edit/<?PHP echo $group['ou']; ?>" title="Edit Group: <?PHP echo $group['ou']; ?>"><img src="/images/icons/user_edit.png" alt="Edit Group: <?PHP echo $group['ou']; ?>" /></a>
													<a href="/administration/manage/groups/edit/access/<?PHP echo $group['ou']; ?>" title="Edit Access: <?PHP echo $group['ou']; ?>"><img src="/images/icons/group_edit.png" alt="Edit Access: <?PHP echo $group['ou']; ?>" /></a>
													<a href="/administration/manage_groups/application_list/<?PHP echo $group['ou']; ?>" title="List Authorized Applications: <?PHP echo $group['ou']; ?>"><img src="/images/icons/application_view_list.png" alt="List Authorized Applications: <?PHP echo $group['ou']; ?>" /></a>
													<a onclick="if(confirm('Are you sure you want to disable <?PHP echo $group['ou']; ?>?')) { $('#disable<?PHP echo $group['ou']; ?>').submit(); return false; }" href="#" title="Disable Group: <?PHP echo $group['ou']; ?>"><img src="/images/icons/delete.png" alt="Disable Group: <?PHP echo $group['ou']; ?>" /></a>
													<?PHP
														echo form_open('/administration/manage/groups/disable',array('id'=>'disable'.$group['ou']));
														echo form_hidden('ou',$group['ou']);
														echo form_close();
													?>
												</td>
											</tr>
										<?PHP } ?>
									</tbody>
									</table>
							</div>
							<div id="deactivated">
								<p>This table lists the disabled groups.</p>
									<br/>
									<table id="disabled_group_table" class="display">
									<caption class="hidden_context">Disabled Groups</caption>
									<thead>
										<tr class="gridheader">
											<th scope="col">Group Name</th>
											<th scope="col">Display name</th>											
											<th scope="col">Description</th>
											<th scope="col">Access</th>
											<th scope="col" class="displaylast">Actions</th>
										</tr>
									</thead>
									<tbody>
										<?PHP foreach($disabled_groups as $group) { ?>
											<tr>
												<td class="center break-word"><a href="/administration/manage/groups/edit/<?PHP echo $group['ou']; ?>"><?PHP echo $group['ou']; ?></a></td>
												<td class="center break-word"><?PHP echo $group['cn']; ?></td>
												<td class="center break-word"><?PHP echo $group['description']; ?></td>
												<td class="center break-word"><?PHP foreach($group['access'] as $access) { echo $access . '<br/>'; } ?></td>
												<td class="center">
													<a href="/administration/manage/groups/edit/<?PHP echo $group['ou']; ?>" title="Edit Group: <?PHP echo $group['ou']; ?>"><img src="/images/icons/user_edit.png" alt="Edit Group: <?PHP echo $group['ou']; ?>" /></a>
													<a href="/administration/manage/groups/edit/access/<?PHP echo $group['ou']; ?>" title="Edit Access: <?PHP echo $group['ou']; ?>"><img src="/images/icons/group_edit.png" alt="Edit Access: <?PHP echo $group['ou']; ?>" /></a>
													<a onclick="if(confirm('Are you sure you want to enable <?PHP echo $group['ou']; ?>?')) { $('#enable<?PHP echo $group['ou']; ?>').submit(); return false; }" href="#" title="Enable Group: <?PHP echo $group['ou']; ?>"><img src="/images/icons/add.png" alt="Enable Group: <?PHP echo $group['ou']; ?>" /></a>
													<?PHP
														echo form_open('/administration/manage/groups/enable',array('id'=>'enable'.$group['ou']));
														echo form_hidden('ou',$group['ou']);
														echo form_close();
													?>
												</td>
											</tr>
										<?PHP } ?>
									</tbody>
									</table>
							</div>
							<?PHP if($create_group_show) { ?>
								<div id ="create" class="column">		
									<p>This form allows an administrator to manually create a group. All fields are required.</p>
									<?PHP echo form_open('/administration/create_group',array('id'=>'createAccountForm')); ?>
										<div class="form" style="width:100%;">
											<label for="group_name">Group Name:</label> <input type="text" name="group_name" id="group_name"  maxlength="50"<?PHP if(isset($group_name)) { echo 'value="'.$group_name.'"'; }?>/>
											<label for="display_name">Display Name:</label> <input type="text" name="display_name" id="display_name"  maxlength="200"<?PHP if(isset($display_name)) { echo 'value="'.$display_name.'"'; }?>/>
											<label for="description">Description:</label> <textarea name="description" id="description"  maxlength="4000" ><?php if(isset($description)){echo $description;}?></textarea>
											<label for="facility">Facility:</label>
											<select id="facility_select" name="facility_select" data-placeholder="Choose a Facility">
				           	 					<option value=""></option>
				           	 					<option value="">&nbsp;</option>
				           						<?php foreach($facilities as $fac) {
				           							$option = '<option value=' . $fac->id;
				           							if(isset($facility_select) && $fac->id == $facility_select) {
														$option .= ' selected';
													}
													$option .= '>' . $fac->name . '</option>';
				           							echo $option;
				           						}?>
				            				</select>
										</div>
										<div class="text-right" style="width:100%;"><input class="blue-button" type="submit" value="Submit"/></div> 
									<?PHP echo form_close(); ?>
								</div>								
							<?PHP } ?>	
						</div>
					</div>
<script type='text/javascript'>
	$('#facility_select').chosen();

	$(document).ready(function() {
		$('#active_group_table').dataTable( {
			"bSort" : false,
	    	"bProcessing": true,
	        "bServerSide": true,
	        "bStateSave": true,
			"iDeferLoading" : <?PHP echo $group_total; ?>,
	         "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
	            $('td:eq(1),td:eq(2),td:eq(3)', nRow).addClass('gridrow');
	          },
          	"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3,4]},
        		             { 'bSearchable': false, 'aTargets': [3,4]},
        		             { "sClass": "center break-word", 'aTargets': [0,1,2,4]}],
	        "sAjaxSource": '/administration/admin_group_search/?active=true&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
	        "oLanguage": {
	        	"sEmptyTable": "No groups were found",
	        	"sZeroRecords": "No groups were found",
				"sInfo": "_TOTAL_ results",
				"sLengthMenu": "Records per page _MENU_",
	        	},  
	    } );
	} );   

	$(document).ready(function() {
		$('#disabled_group_table').dataTable( {
			"bSort" : false,
	    	"bProcessing": true,
	        "bServerSide": true,
			"iDeferLoading" : <?PHP echo $disabled_group_total; ?>,
	         "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
	            $('td:eq(1),td:eq(2),td:eq(3)', nRow).addClass('gridrow');
	          },
          	"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3,4]},
        		             { 'bSearchable': false, 'aTargets': [3,4]},
        		             { "sClass": "center break-word", 'aTargets': [0,1,2,4]}],
	        "sAjaxSource": '/administration/admin_group_search/?active=false&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
	        "oLanguage": {
	        	"sEmptyTable": "No groups were found",
	        	"sZeroRecords": "No groups were found",
				"sInfo": "_TOTAL_ results",
				"sLengthMenu": "Records per page _MENU_",
	        },  
	    } );
	} );
</script>