<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class RequestModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    function create_request($app_id, $call, $date, $code, $response)
    {
    	$create = $this->db->query('insert into request (application_id, call, call_date, response_code, response) values ('.$this->db->escape($app_id).','.$this->db->escape($call).','.$this->db->escape($date).','.$this->db->escape($code).','.$this->db->escape($response).')');
		if(!$create) { return FALSE; }
		else { return $this->db->insert_id(); }
    }
    
    function add_response($id, $code, $response)
    {
    	$this->db->query('update request set response_code = '.$this->db->escape($code).', response = '.$this->db->escape($response).' where id = '.$this->db->escape($id));
    }
    
    function get_request_by_id($id)
    {
    	return $this->db->query('select * from request where id = '.$this->db->escape($id));
    }
    
	function get_responses(){
    	return $this->db->query('SELECT * FROM request ORDER BY call_date DESC');
    }
    
	function get_request_by_app_id($id)
    {
    	return $this->db->query('select * from request where application_id = '.$this->db->escape($id));
    }
    
	function get_request_filter_export($sql,$order)//get respose with filters for export
	{
		return $this->db->query('select * FROM request where '.$sql.' ORDER BY '.$order);
	}
	
	function get_request_filter_export_app_order($sql,$order)//get respose with filters for export
	{
		if ($order == 'application_id DESC'){
			$order = 'DESC';
		}
		else{
			$order = 'ASC';
		}
		$sql= str_replace("(id","(r.id",$sql);//needed because both tables have the same column name
		return $this->db->query('select r.*  from request r LEFT OUTER JOIN application a on r.application_id= a.id where '.$sql.' order by a.name '.$order);
	}
	function get_request_filter($sql,$order,$start,$size)//get respose with filters
	{
		return $this->db->query('select * from (select *, ROW_NUMBER() over (order by '.$order.') as row FROM request where '.$sql.') a where row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
	}
	function get_request_filter_app_order($sql,$order,$start,$size)//get respose with filters
	{
		if ($order == 'application_id DESC'){
			$order = 'DESC';
		}
		else{
			$order = 'ASC';
		}
		$sql= str_replace("(id","(r.id",$sql);//needed because both tables have the same column name
		return $this->db->query('select * from (select r.*, ROW_NUMBER() over (order by a.name '.$order.') as row FROM request r LEFT OUTER JOIN application a on r.application_id= a.id where '.$sql.') a where row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
	}
	function get_first_responses($size)//get response when no filters for first page
	{
    	return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (ORDER BY call_date DESC) as row from request) a where row >=1 and row <='.$this->db->escape($size));
    }
	function get_size()//get size of entire thing
	{
		return $this->db->query('select COUNT(*) as count from request');
	}
	function get_filted_size($sql)//get size after filter
	{
		return $this->db->query('select COUNT(*) as count from request where '.$sql);
	}
}