<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*/

/**
* @package direct-as-a-service
* @subpackage models
*/
class Patient extends Entity {
	
	protected $_attachment_name;
	
//////////////////
// STATIC VARS
///////////////////	
	static $database_group = 'mail_db';
	static $table = 'patients';	
	protected static $_relationships = array( 'message' => array('type' => 'belongs_to'));
	
/////////////////////
// INSTANCE METHODS
/////////////////////
	
	function attachment_name(){
		if(!isset($this->_attachment_name)){
			$message = $this->message;
			if(Message::is_an_entity($message)){
				require_library('attachments/Zip_attachment');
				foreach($message->attachment_files as $name => $binary_string){	
					$archived_file_matches = FALSE;
					$extension = strtolower(pathinfo($name, PATHINFO_EXTENSION));
					if($extension === 'zip' && ($zip = Zip_attachment::create($name, $binary_string))) {
						$archive_files = $zip->archive_files();
						array_walk_recursive($archive_files, function($value, $key) {
							if($this->file_hash == sha1($key.base64_decode($value->body))) {
								$this->_attachment_name = $key;
								$archived_file_matches = TRUE;
							}
						});
					}
					else if($this->file_hash == sha1($name.$binary_string) || $archived_file_matches){
						$this->_attachment_name = $name;
						break;
					}			
				}
			}
		}
		return $this->_attachment_name;
	}
		
	function name(){
		return implode_nonempty(' ', array($this->given_name, $this->family_name));
	}
	
	function values_for_api(){
		$values = $this->values();
		unset($values['id']); //not that useful for API, since we rewrite patient db entries frequently
		unset($values['message_id']); 
		$values['file_name'] = $this->attachment_name();
		return $values;
	}
	
///////////////////////
// STATIC METHODS
///////////////////////	
	
	public static function populate_for_message($message){
		require_library('attachment');
		require_model('message');
				
		if(!Message::is_an_entity($message)) return should_be('message entity', $message);
		
		//clear any old patients for this message
		Patient::db()->where(Message::foreign_key('patient'), $message->id)->delete(Patient::$table);	
				
		
		//populate with new patients for the message
		foreach($message->attachment_files as $name => $binary_string){
			$attachment = Attachment::create($name, $binary_string, array('message_id' => $message->id));
			if(is_a($attachment, 'Patient_document_attachment') && is_object($attachment->parser)){
				Patient::create( array(Message::foreign_key('patient') => $message->id,
									   'given_name' => implode_nonempty(' ', $attachment->parser->given_names),
									   'family_name' => $attachment->parser->family_name,
									   'title' => $attachment->parser->title,
									   'date_of_birth' => $attachment->parser->raw_value('date_of_birth'),
									   'organization' => $attachment->parser->organization,
									   'file_hash' => sha1($name.$binary_string),
								));				   
			}
			//check for clinical documents inside zipped attachments
			else if(is_a($attachment, 'Zip_attachment')) {
				$archive_files = $attachment->archive_files();
				array_walk_recursive($archive_files, function($value, $key, $attachment) {
					require_library('attachments/archived_attachment');
					$zip_attachment = Archived_Attachment::create($key, base64_decode($value->body), array(), $attachment);
					if(is_a($zip_attachment->_source_class, 'Patient_document_attachment') && is_object($zip_attachment->parser)){
						Patient::create( array(Message::foreign_key('patient') => $attachment->_message_id,
									   'given_name' => implode_nonempty(' ', $zip_attachment->parser->given_names),
									   'family_name' => $zip_attachment->parser->family_name,
									   'title' => $zip_attachment->parser->title,
									   'date_of_birth' => $zip_attachment->parser->raw_value('date_of_birth'),
									   'organization' => $zip_attachment->parser->organization,
									   'file_hash' => sha1($zip_attachment->name.$zip_attachment->binary_string),
								));
					}
				}, $attachment);
			}
		}	
	}
		
}
