<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class HispModel extends CI_Model {
	var $delimiter;
	var $http;
	var $https;
	var $right_angle_bracket;
	var $www;
    function __construct() {
        parent::__construct();
        $this->delimiter = '@';
        $this->http = 'http://';
        $this->https = 'https://';
        $this->right_angle_bracket = '>';
        $this->www = 'www.';
		$this->doublequote = '"';
		$this->singlequote = "'";
		$this->load->database();
    }
    
    function get_domains() {
    	$sql = "select replace(replace(replace(RIGHT(ml.sender,CHARINDEX('@',REVERSE(ml.sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') sender_domain, recipient " .
    			'from mail_log ml ' .
    			'where mdn = 0 ';
    	$mail_log_data =  $this->db->query($sql)->result();
    	$domains = array();
    	foreach($mail_log_data as $mail_log) {
    		$sender_domain = $mail_log->sender_domain;
    		array_push($domains, $sender_domain);
    		$recipient_array = get_instance()->json->decode($mail_log->recipient);
    		foreach($recipient_array as $recipient) {
    			$recipient_domain = str_replace('>', '' ,explode("@", $recipient)[sizeof(explode("@", $recipient))-1]);
    			array_push($domains, $recipient_domain);
    		}
    	}
    	$domains = array_unique($domains);
    	asort($domains);
    	return $domains;
    }
    
    function get_empty_msg_counts_grouped_by_domains($selected_domain) {
    	$array = array();
    	if(mb_strtolower($selected_domain) == '(all)' || $selected_domain == false) {
    		$domains = $this->get_domains();
    		foreach($domains as $domain) {
    			$array[$domain]['domain'] = $domain;
    			$array[$domain]['sent'] = 0;
    			$array[$domain]['received'] = 0;
    			$array[$domain]['total'] = 0;
    		}
    	}
    	else {
    		$array[$selected_domain]['domain'] = $selected_domain;
    		$array[$selected_domain]['sent'] = 0;
    		$array[$selected_domain]['received'] = 0;
    		$array[$selected_domain]['total'] = 0;
    	}  	
    	return $array;
    }
    
    function get_message_counts_grouped_by_domain($selected_domain, $between = null, $order, $dir, $destination_page, $items_per_page, $is_export) {
    	 
    	$sql = "select replace(replace(replace(RIGHT(ml.sender,CHARINDEX('@',REVERSE(ml.sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') sender_domain, recipient, inbound_outbound " .
    			'from mail_log ml ' .
    			'where ml.success = 1 and mdn = 0 ';
    	if($between != null) {
    		foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
    			if($value['end']){
    				$sql .= "AND (ml.". $key ." <= ".$this->db->escape($value['end']).") ";
    			}
    			if($value['start']){
    				$sql .= "AND (ml.". $key ." >= ".$this->db->escape($value['start']). ")";
    			}
    		}
    	}
    	$mail_log_data =  $this->db->query($sql)->result();
    	$msg_counts_grouped_by_domains = $this->get_empty_msg_counts_grouped_by_domains($selected_domain);
    	$total_sent_to_all_doamins = 0;
    	$total_received_from_all_doamins = 0;
    	$total_by_all_doamins = 0;
    	foreach($mail_log_data as $mail_log) {
    		$sender_domain = $mail_log->sender_domain;
    		$recipient_array = get_instance()->json->decode($mail_log->recipient);
    		$inbound = $mail_log->inbound_outbound;
    		$recipient_domain_array = array();
    		foreach($recipient_array as $recipient) {
    			$recipient_domain = str_replace('>', '' ,explode("@", $recipient)[sizeof(explode("@", $recipient))-1]);
    			array_push($recipient_domain_array, $recipient_domain);
    		}
    		$recipient_domain_array = array_unique($recipient_domain_array);
    
    		foreach($recipient_domain_array as $recipient_domain) {
    			if($inbound) {
    				if(mb_strtolower($selected_domain) == '(all)' || $selected_domain == false || array_key_exists($sender_domain, $msg_counts_grouped_by_domains)) {
	    				$msg_counts_grouped_by_domains[$sender_domain]['received']++;
	    				//add [$recipient_domain]['total'] for excel export
	    				$msg_counts_grouped_by_domains[$sender_domain]['total']++;
	    				$total_received_from_all_doamins++;
	    				$total_by_all_doamins++;
    				}
    			}
    			else if($sender_domain === DIRECT_DOMAIN && !$inbound) {
    				if(mb_strtolower($selected_domain) == '(all)' || $selected_domain == false || array_key_exists($recipient_domain, $msg_counts_grouped_by_domains)) {
	    				$msg_counts_grouped_by_domains[$recipient_domain]['sent']++;
	    				//add [$recipient_domain]['total'] for excel export
	    				$msg_counts_grouped_by_domains[$recipient_domain]['total']++;
	    				$total_sent_to_all_doamins++;
	    				$total_by_all_doamins++;
    				}
    			}
    		}
    	}
    	
    	if($order != null && $dir != null) {
    		$this->_hisp_info_sort($msg_counts_grouped_by_domains, $order, $dir);
    	}
    	$total_size = sizeof($msg_counts_grouped_by_domains);
    	if($is_export) {
    		if($is_export === 'excel') {
    			$msg_counts_grouped_by_domains['total_va']['domain'] = 'Total VA:';
    			$msg_counts_grouped_by_domains['total_va']['sent'] = $total_sent_to_all_doamins;
    			$msg_counts_grouped_by_domains['total_va']['received'] = $total_received_from_all_doamins;
    			$msg_counts_grouped_by_domains['total_va']['total'] = $total_by_all_doamins;
    		}
    		return array('list'=>$msg_counts_grouped_by_domains, 'total_size'=>$total_size);
    	}
    	
    	//get the content for the page
    	$paginated_msg_counts = array();
    	$start = ($destination_page - 1) * $items_per_page + 1;
    	$counter= 1;
    	foreach($msg_counts_grouped_by_domains as $doamin => $mc) {
    		if($counter >= $start && $counter < $start + $items_per_page) {
    			$paginated_msg_counts[$doamin] = $mc;
    		}
    		$counter++;
    	}
    	return array('list'=>$paginated_msg_counts, 'total_size'=>$total_size);
    }
    
    function get_domain_by_application_id($application_id) {
		$sql = "SELECT replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  domain FROM [api].[dbo].[mail_log]	
				WHERE  LEN(sender) > 0
				AND LEN(sender) > 0 AND replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  = '".$application_id."'
				GROUP BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') 
				ORDER BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  ASC";
    	return  $this->db->query($sql)->result()[0]->domain;
    }
    
    function get_domain_app_id_maps() {
		$sql = "SELECT replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') domain, replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  application_id FROM [api].[dbo].[mail_log] 
				WHERE  LEN(sender) > 0
				GROUP BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') 
				ORDER BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  ASC";
		return  $this->db->query($sql)->result();
    }
    
    //sort the nested input array on the key column with the direction
    private function _hisp_info_sort(&$array, $key, $dir) {
    	if(mb_strtoupper($key) == 'DOMAIN_NAME') {
    		if(mb_strtoupper($dir) == 'ASC') {
    			ksort($array);
    		}
    		else {
    			krsort($array);
    		}
    	}
    	else {
	    	$sorter = array();
	    	$ret = array();
	    	reset($array);
	    	foreach($array as $ii => $va) {
	    		$sorter[$ii] = $va[$key];
	    	}
	    	$domains = array();
	    	$msg_count = array();
	    	foreach($sorter as $key => $value) {
	    		$domains[] = $key;
	    		$msg_count[] = $value;
	    	}
	    	if(mb_strtoupper($dir) == 'ASC') {
	    		array_multisort($msg_count, SORT_ASC, $domains, SORT_ASC, $sorter);
	    	}
	    	else {
	    		array_multisort($msg_count, SORT_DESC, $domains, SORT_ASC, $sorter);
	    	}
	    	foreach($sorter as $ii => $va) {
	    		$ret[$ii] = $array[$ii];
	    	}
	    	$array = $ret;
    	}
    }
}
