<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*//** */

/**
* @package direct-as-a-service
* @subpackage models
*/
class GroupsModel extends CI_Model {
	
	public function create_group ($ou,$application_id,$cn,$description){
		//validate the parameters
		if(!$this->is->string_like_an_email_address($ou.'@'.DIRECT_DOMAIN)) return $this->error->should_be_a_valid_first_half_of_an_address($ou);
		if(Mailbox::exists(array('name' => $ou))) return $this->error->warning('There already is a mailbox with the name '.$this->error->describe($ou));
		if(!$this->is->nonempty_string($cn)) return $this->error->should_be_a_nonempty_string($cn);
		if(!$this->is->nonempty_string($description)) return $this->error->should_be_a_string($description);
		
		$this->load->model('applicationmodel');
		$application_dn = $this->applicationmodel->get_users_dn_from_app_id($application_id);
		if(empty($application_dn) || !is_string($application_dn)) return $this->error->warning('Could not create group '.$this->error->describe($cn).'; could not determine dn for application#'.$application_id);
		
		//validate that we have an LDAP connection
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if(!$ldap_bind)	return $this->error->warning("I couldn't create user ".$this->error->describe($username)." because I couldn't connect to LDAP; please check your config file");
		
		//create the mailbox		
		$mailbox = Mailbox::create( array('name' => $ou, 'is_active' => true, 'is_group' => true) );
		if(!Mailbox::is_an_entity($mailbox)) return $this->error->warning('Could not create a mailbox for group '.$this->error->describe($ou));
		
		$attributes = array(
			'ou' => $ou,
			'cn' => $cn,
			'description' => $description,
			'member' => array("cn=admin,".LDAP_BASE_RDN),
			'mail' => $ou."@".DIRECT_DOMAIN,
			'objectClass' => array("extensibleObject","groupOfNames","top")
		);
		
		$success = ldap_add($ldap_conn, $mailbox->dn(), $attributes);
		if(!$success){
			#$this->error->warning('Unable to create group '.$mailbox->name.'; LDAP says '.$this->error->describe(ldap_error($ldap_conn)));// apparently ldap_add actually gives error messages
			if(!Mailbox::delete($mailbox->id)) $this->error->warning('Unable to delete '.$mailbox->describe().' from the database; please manually delete this entry.');
		}
		if($success){
			//TO-DO: check here for success and delete other entries if this fails, then return FALSE
			$added = ldap_mod_add($ldap_conn, $application_dn, array('member' => $mailbox->dn()));
			if(!$added) $this->error->warning('Unable to add '.$mailbox->describe().' to application#'.$application_id);
		}
		return $success;
	}
	
#TODO - IDEALLY THIS FUNCTIONALITY WOULD TAKE PLACE ON THE MAILBOX MODEL (EITHER A DEACTIVATE METHOD OR WHEN IS_ACTIVE IS SET TO FALSE) - OR ON A GROUP MODEL OF 	
	public function disable_group($group_name){
		//validate the parameters
		$mailbox = Mailbox::find_one( array('name' => $group_name) );
		if(!Mailbox::is_an_entity($mailbox)) return $this->error->should_be_a_mailbox_name($group_name);
		if(!$mailbox->is_group) return $this->error->should_be_a_group_name($group_name);
		
		if(!$mailbox->is_active) return true; //we're done
		
		$current_dn = $mailbox->dn();
		$mailbox->is_active = false;
		if(!$mailbox->save()) return $this->error->warning('Could not disable group '.$this->error->describe($group_name).'; could not change status of '.$mailbox->describe().' to inactive');
		
		//validate that we have an LDAP connection
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if(!$ldap_bind)	return $this->error->warning("I couldn't disable group ".$this->error->describe($group_name)." because I couldn't connect to LDAP; please check your config file");		
		
		$success = ldap_rename($ldap_conn, $current_dn,'ou=' . $group_name,LDAP_DISABLED_GROUPS_GROUP, TRUE);
		if(!$success){
			$this->error->warning('Could not disable group '.$this->error->describe($group_name).'; LDAP says '.$this->error->describe(ldap_error($ldap_conn)));
			$mailbox->is_active = true;
			if(!$mailbox->save()) $this->error->warning('Could not reactivate '.$mailbox->describe().'; please update this mailbox manually.');
		}
		
		return $success;
	}
	
	
	public function enable_group($group_name){
		//validate the parameters
		$mailbox = Mailbox::find_one( array('name' => $group_name) );
		if(!Mailbox::is_an_entity($mailbox)) return $this->error->should_be_a_mailbox_name($group_name);
		if(!$mailbox->is_group) return $this->error->should_be_a_group_name($group_name);
		
		if($mailbox->is_active) return true; //we're done
		
		$current_dn = $mailbox->dn();
		$mailbox->is_active = true;
		if(!$mailbox->save()) return $this->error->warning('Could not enable group '.$this->error->describe($group_name).'; could not change status of '.$mailbox->describe().' to active');
		
		//validate that we have an LDAP connection
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if(!$ldap_bind)	return $this->error->warning("I couldn't enable group ".$this->error->describe($group_name)." because I couldn't connect to LDAP; please check your config file");				
		
		
		$success = ldap_rename($ldap_conn, $current_dn,'ou=' . $group_name, LDAP_GROUPS_GROUP, TRUE);
		if(!$success){
			$this->error->warning('Could not enable group '.$this->error->describe($group_name).'; LDAP says '.$this->error->describe(ldap_error($ldap_conn)));
			$mailbox->is_active = false;
			if(!$mailbox->save()) $this->error->warning('Could not deactivate '.$mailbox->describe().'; please update this mailbox manually.');
		}		
		
		return $success;
	}
		/* Simple function to format a dn for a given groupname on this system
	 * abstracted to a function so that it can be changed in only
	 * one place if the format ever changes.
	 */ 
	public function get_dn_from_groupname($username) {
		return 'ou='.$username.','.LDAP_GROUPS_GROUP;
	}
	/* Similar to get dn, but gets the dn as if the group were disabled */
	public function get_disabled_dn_from_groupname($username) {
		return 'ou='.$username.','.LDAP_DISABLED_GROUPS_GROUP;
	}
	public function get_group_from_groupname($group,$active = TRUE){
		$ldap_conn = $this->prepare_ldap_conn();
    	$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$fields = array('ou','cn','description','mail','members');
			$base_dn = LDAP_GROUPS_GROUP;
			if(!$active) { $base_dn = LDAP_DISABLED_GROUPS_GROUP; }
			$search = ldap_search($ldap_conn, $base_dn, '(&(ou='.$group.')(cn=*))', $fields);
			$entries = ldap_get_entries($ldap_conn, $search);
			$groups = array();
			for($i = 0; $i < $entries['count']; $i++) {
				$entry = $entries[$i];
				$group = array();
				foreach($fields as $key) {
					if($key !== 'count' && isset($entry[$key][0])) { $group[$key] = $entry[$key][0];} 
				}
				$group['access'] = $this->get_access($group['ou']);
				$group['applications'] = $this->get_applications($group['ou']);
				array_push($groups,$group);
				
			}
			
			usort($groups, create_function('$a, $b','return strnatcasecmp($a[\'ou\'], $b[\'ou\']);'));
			return $groups;
		}
		return false;
	}
	
	public function get_disabled_groups(){
		return $this->get_group_from_groupname("*",FALSE);
	}
	
	public function get_disabled_groups_by_page_number($start, $size) {
		$groups_by_page_number = array();
		$groups = $this->get_disabled_groups();
		$j = 0;
		for($i = 0; $i < sizeOf($groups); $i++) {
	
			if($i >= $start - 1 && $i < $start - 1 + $size) {
				$groups_by_page_number[$j] = $groups[$i];
				$j++;
			}
		}
		return $groups_by_page_number;
	}
	
	public function get_groups(){
		return $this->get_group_from_groupname("*",TRUE);
	}
	
	public function get_groups_by_page_number($start, $size,$groups) {
		$groups_by_page_number = array();
		$j = 0;
		for($i = 0; $i < sizeOf($groups); $i++) {
				
			if($i >= $start - 1 && $i < $start - 1 + $size) {
				$groups_by_page_number[$j] = $groups[$i];
				$j++;
			}
		}
		return $groups_by_page_number;
	}
	
	public function get_access($group) {
		
		$dn = $this->get_dn_from_groupname($group);
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = ldap_search($ldap_conn, LDAP_BASE_RDN, '(&(member='.$dn.'))', array('cn'));
			$entries = ldap_get_entries($ldap_conn, $search);
			$groups = array();
			for($i = 0; $i < $entries['count']; $i++) { 
				array_push($groups,$entries[$i]['cn'][0]); 
				$dn = $entries[$i]['dn'];
				$dn_parts=ldap_explode_dn($dn,1);
			}
			return $groups;
		}
		
		return FALSE;
	}
	
	public function get_applications($group) {
	
		$dn = $this->get_dn_from_groupname($group);
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = ldap_search($ldap_conn, LDAP_BASE_RDN, '(&(member='.$dn.'))', array('cn'));
			$entries = ldap_get_entries($ldap_conn, $search);
			$applications = array();
			for($i = 0; $i < $entries['count']; $i++) {
				//array_push($groups,$entries[$i]['cn'][0]);
				$dn = $entries[$i]['dn'];
				
				$application = element( 1, $application=ldap_explode_dn($dn,1) );
				array_push($applications,$application);
			}
			return $applications;
		}
	
		return FALSE;
	}
	
	public function group_exist($group) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = ldap_search($ldap_conn, LDAP_GROUPS_GROUP, '(&(ou=' . $group . ')(cn=*))', array('ou'));
			$entries = ldap_get_entries($ldap_conn, $search);

			if($entries['count'] !== 0) { return TRUE; }
			else{
				$search = ldap_search($ldap_conn, LDAP_DISABLED_GROUPS_GROUP, '(&(ou=' . $group . ')(cn=*))', array('ou'));
				$entries = ldap_get_entries($ldap_conn, $search);
				if($entries['count'] !== 0) { return TRUE; }
				else{return FALSE;}
			}
		}
		else { return NULL; }
	}
	public function change_group_membership($action, $group_name, $group_cn) {
		if($action !== 'add' && $action !== 'remove') { return FALSE; }
		
		$user_dn = $this->get_dn_from_groupname($group_name); //even disabled users are stored in groups as their non-disabled dn
		
		$ldap_conn = $this->prepare_ldap_conn();
		//because this potentially will be exposed as an API function, we cannot get client cert to link to a user account
		//so use anonymous LDAP admin account and log that the request came from this application
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if($ldap_bind) {
			$search = ldap_search($ldap_conn, LDAP_BASE_RDN, '(&(cn='.$group_cn.')(objectClass=groupOfNames))', array('dn'));
    		$entries = ldap_get_entries($ldap_conn, $search);
			if($entries['count'] === 1) { //has to be just one entry or it can't be sure what to remove
				$group_dn = $entries[0]['dn'];
				if($action === 'remove') { 
					$remove = @ldap_mod_del($ldap_conn,$group_dn,array('member'=>$user_dn));
					//if the attribute didn't exist before (error 16), then we didn't need to get rid of it and therefore we did what we wanted
					if(!$remove && ldap_errno($ldap_conn) === 16) { return TRUE; }
					else { return $remove; }
				}
				if($action === 'add') { 
					return ldap_mod_add($ldap_conn,$group_dn,array('member'=>$user_dn));
				}
			}
		}
		return FALSE;
	}
	public function get_allowed_groups_for_access($permissions) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			//if the user is part of the API admins group, return all groups
			if($permissions['API']['admins']) {
				$search = ldap_search($ldap_conn, LDAP_BASE_RDN, '(objectClass=groupOfNames)', array('dn','cn','ou'));
				$entries = ldap_get_entries($ldap_conn, $search);
				$result = array();
				foreach($entries as $key => $entry) {
					//don't include count array entry, and don't show groups that are for application entries only
					if(is_numeric($key) && $entry['dn'] !== LDAP_DIRECT_API_PERMISSIONS_GROUP && $entry['dn'] !== LDAP_ADMIN_API_PERMISSIONS_GROUP && $entry['dn'] !== LDAP_DISCLOSURE_API_PERMISSIONS_GROUP && $entry['ou'][0] === "users") { 
						array_push($result,$entry['cn'][0]); 
					}
				}
				return $result;
			}
			//TO-DO: for now, everyone else gets nothing, this will need to change
			return array();
		}
		return FALSE;
	}
	public function update_group($group_name, $display_name, $description) {
		if($group_name) {
			$ldap_conn = $this->prepare_ldap_conn();
			//because this potentially will be exposed as an API function, we cannot get client cert to link to a user account
			//so use anonymous LDAP admin account and log that the request came from this application
			$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
			if($ldap_bind) {
				if(count($this->get_group_from_groupname($group_name)) === 1){//check if group is deleted
					$group_dn = $this->get_dn_from_groupname($group_name); 
				}
				else { 
					$group_dn = $this->get_disabled_dn_from_groupname($group_name);
				}
				$attribute_arr = array(
					'description' => $description,
					'cn' => $display_name
				);
				return ldap_modify($ldap_conn,$group_dn,$attribute_arr);
			}
		}
		return FALSE;
	}
	public function get_group_dn_from_direct_address($address){
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			//search for groups that this user is in
			$search = ldap_search($ldap_conn, LDAP_GROUPS_GROUP, '(&(mail=' . $address . '))', array('dn'));
			$entries = ldap_get_entries($ldap_conn, $search);
			if($entries['count'] === 0 || $entries['count'] > 1) { return FALSE; } //if no entries, or too many entries
			return ($entries[0]['dn']);
		}
		return FALSE;
	}
	public function get_group_address_permissions_for_app_dn($address,$app_id,$app_dn){
		$group_dn = $this->get_group_dn_from_direct_address($address);
		if($group_dn){
			$ldap_conn = $this->prepare_ldap_conn();
			$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
			if($ldap_bind) {
				$search = ldap_search($ldap_conn, $app_dn, '(&(member=' . $group_dn . '))', array('dn'));
				$entries = ldap_get_entries($ldap_conn, $search);
				if($entries['count'] === 0 || $entries['count'] > 1) { return FALSE; }
				else{
					$group_dn = $this->get_group_dn_from_direct_address($address);
					$group_name = element(0, ldap_explode_dn($group_dn, 1));
					$mailbox_id = $this->usersettingsmodel->get_mailbox_id_by_name($group_name, true);
					$mailbox_settings = $this->usersettingsmodel->get_mailbox_settings_by_application($mailbox_id, $app_id)->result();
					$permissions = array();
					foreach($mailbox_settings as $setting) {
						$permissions[$setting->web_service_name] = (boolean)$setting->authorized;
					}
					return  $permissions;
				}
			}
		}	
		return false;
		
	}
	public function get_groups_for_user($user_dn, $enabled){
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		
		if($enabled){
			$dn = LDAP_GROUPS_GROUP;
		}else{
			$dn = LDAP_DISABLED_GROUPS_GROUP;
		}
		$fields = array('ou','cn','description','mail','members');
		$search = ldap_search($ldap_conn, $dn, '(&(member=' . $user_dn . '))', $fields);
		$entries = ldap_get_entries($ldap_conn, $search);
		$groups = array();
		for($i = 0; $i < $entries['count']; $i++) {
			$entry = $entries[$i];
			$group = array();
			foreach($fields as $key) {
				if($key !== 'count' && isset($entry[$key][0])) { $group[$key] = $entry[$key][0];} 
			}
			$group['access'] = $this->get_access($group['ou']);
			$group['applications'] = $this->get_applications($group['ou']);
			array_push($groups,$group);
		}

		return $groups;
	}
	public function user_is_member($group,$user_dn){
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$fields = array('ou');
			$search = ldap_search($ldap_conn, LDAP_GROUPS_GROUP, '(&(member=' . $user_dn . ')(&(ou='.$group.')(cn=*)))', $fields);
			$entries = ldap_get_entries($ldap_conn, $search);
			if($entries['count'] === 0){
				$search = ldap_search($ldap_conn, LDAP_DISABLED_GROUPS_GROUP, '(&(member=' . $user_dn . ')(&(ou='.$group.')(cn=*)))', $fields);
				$entries = ldap_get_entries($ldap_conn, $search);
				return ($entries['count'] !== 0);
			}
			else{
				return true;
			}
		}
		return false;
	}
	
	public function get_members($group_name) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if(!$ldap_bind)	return $this->error->warning('Could not connect to LDAP; please check your config file to ensure that the LDAP configuration is correct');
			
		$search = ldap_search($ldap_conn, LDAP_GROUPS_GROUP, '(&(ou=' . $group_name . '))', array('member'));
		$entries = ldap_get_entries($ldap_conn, $search);
		$members = array();
		for($i = 0; $i < $entries[0]['member']['count']; $i++) { 
			$entry = $entries[0]['member'][$i];
			if(string_begins_with('uid=', $entry)) {
				array_push($members, ldap_explode_dn($entry,1)[0]);
			}
		}
		return $members;
	}
	
	/* ----------------------------------------------*
	 *  FUNCTIONS FOR GROUP ACTIVITY SUMMARY REPORT  *
	 * ----------------------------------------------*/
	function get_first_group_activities($size)//get response when no filters for first page
	{
		return $this->db->query("SELECT * FROM (SELECT F.id, F.[Name], M.[name] as group_name, M. " .
				"[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, " .
				"ISNULL(sum(ms.seen), 0) AS Number_of_seen, COUNT(ms.id) as Total_messages, " .
				"ROW_NUMBER() over (ORDER BY UPPER(F.name) DESC, UPPER(M.[name]) ASC) as row FROM [mail].[dbo].[mailboxes] M " .
				"LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id " .
				"left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id " .
				"where M.is_group = 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY M.name, F.name, F.id, M.is_active) A WHERE row >= 1 and row <= " . $size);
	}
	
	/*
     * get the list of group mailbox activity
     */
	public function get_first_group_activities_list_size()//get size of entire for reports
	{
		return $this->db->query("SELECT COUNT(ms.id) as count " .
								 "FROM [mail].[dbo].[mailboxes] M " . 
								 "LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id " . 
								 "LEFT JOIN [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id " .
								 "WHERE (ms.draft = 0 OR ms.draft IS NULL) " .
								 "AND M.is_group = 1 " .
								 "GROUP BY M.name, F.name, F.id, M.is_active");
	}
	
	/*
	 * get the list of facilities and where
	*/
	
	public function get_group_list_size($sql)//get size of entire for reports
	{
		return $this->db->query('SELECT count(*) count FROM (SELECT F.id as FacilityId, M.[name] as group_name ' .
				'FROM [mail].[dbo].[mailboxes] M LEFT OUTER '.
				'JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON ' .
				'MS.mailbox_id = M.id ' .
				'where ' . $sql .
				'AND M.is_group = 1 AND (MS.draft = 0 OR MS.draft IS NULL) GROUP BY M.name, F.name, F.id, M.is_active) A');
	}
	
	function get_request_filter_group_activities($sql,$sql_date_filter_excluded,$order,$start,$size)
	{
		//Name
		if ($order == 'facilityName DESC,id DESC'  || $order == 'facilityName DESC,id DESC' ){
			$order = '(ORDER BY F.name DESC, M.[name] ASC';
		}
		if ($order == 'facilityName ASC,id ASC'  || $order == 'facilityName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC, M.[name] ASC';
		}
		//Seen
		if ($order == 'groupNumber_of_seen DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.seen) DESC, M.[name] ASC';
		}
		if ($order == 'groupNumber_of_seen ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.seen) ASC, M.[name] ASC';
		}
		//Sent
		if ($order == 'groupNumber_of_sent DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.sent) DESC, M.[name] ASC';
		}
		if ($order == 'groupNumber_of_sent ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.sent) ASC, M.[name] ASC';
		}
		//Total
		if ($order == 'groupTotal_of_messages DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.id) DESC, M.[name] ASC';
		}
		if ($order == 'groupTotal_of_messages ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.id) ASC, M.[name] ASC';
		}
		//LDAP Ordering
	
		if ($order == 'groupName DESC,id DESC'){
			$order = '(ORDER BY M.[name] DESC';
		}
		
		if ($order == 'groupName ASC,id ASC' ){
			$order = '(ORDER BY M.[name] ASC';
		}
	
		if ($order == 'groupDisplayName DESC,id DESC' OR $order == 'groupDisplayName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
	
		if ($order == 'groupName DESC,id DESC' OR $order == 'groupName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
	
		if ($order == 'groupMail DESC,id DESC'){
			$order = '(ORDER BY M.name DESC';
		}
	
		if ($order == 'groupMail ASC,id ASC' ){
			$order = '(ORDER BY M.name ASC';
		}
		
		if ($order == 'groupStatus DESC,id DESC'){
			$order = '(ORDER BY M.[is_active] DESC, M.[name] ASC';
		}
		
		if ($order == 'groupStatus ASC,id ASC'){
			$order = '(ORDER BY M.[is_active] ASC, M.[name] ASC';
		}
		
		$responses_list = $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as group_name, M.[is_active], ' . 
		'ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(COUNT(ms.id), 0) - ISNULL(sum(ms.sent), 0)AS Number_of_seen, ' .
		'COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row ' . 
		'FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id ' .
		'left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id ' . 
		'WHERE '.$sql.' and  M.is_group = 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY  M.name, F.name, F.id, M.is_active) A  ')->result();
	
		$responses_list_date_filter_excluded = $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as group_name, M.[is_active], ' . 
		'ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(COUNT(ms.id), 0) - ISNULL(sum(ms.sent), 0)AS Number_of_seen, ' .
		'COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row ' . 
		'FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id ' .
		'left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id ' . 
		'WHERE '.$sql_date_filter_excluded.' and  M.is_group = 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY  M.name, F.name, F.id, M.is_active) A  ')->result();
	
		//include the groups who had no acitivty in the time period specified
		$new_response_list = [];
		foreach($responses_list as $summary) {
			$new_response_list[$summary->group_name] = $summary;
		}
		$complete_responses_list = [];
		foreach($responses_list_date_filter_excluded as $summary) {
			if(key_exists($summary->group_name, $new_response_list)) {
				$complete_responses_list[$summary->group_name] = $new_response_list[$summary->group_name];
			}
			else {
				$summary->Number_of_sent = 0;
				$summary->Number_of_seen = 0;
				$summary->Total_messages = 0;
				$complete_responses_list[$summary->group_name] = $summary;
			}
		}
		return $complete_responses_list;
	}
	
	function get_request_filter_group_activities_export($sql,$sql_date_filter_excluded,$order,$start,$size)//get response with filters
	{
		//Name
		if ($order == 'facilityName DESC,id DESC'  || $order == 'facilityName DESC,id DESC' ){
			$order = '(ORDER BY F.name DESC, M.[name] ASC';
		}
		if ($order == 'facilityName ASC,id ASC'  || $order == 'facilityName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC, M.[name] ASC';
		}
		//Seen
		if ($order == 'groupNumber_of_seen DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.seen) DESC, M.[name] ASC';
		}
		if ($order == 'groupNumber_of_seen ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.seen) ASC, M.[name] ASC';
		}
		//Sent
		if ($order == 'groupNumber_of_sent DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.sent) DESC, M.[name] ASC';
		}
		if ($order == 'groupNumber_of_sent ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.sent) ASC, M.[name] ASC';
		}
		//Total
		if ($order == 'groupTotal_of_messages DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.id) DESC, M.[name] ASC';
		}
		if ($order == 'groupTotal_of_messages ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.id) ASC, M.[name] ASC';
		}
		//LDAP Ordering
	
		if ($order == 'groupName DESC,id DESC'){
			$order = '(ORDER BY M.[name] DESC';
		}
		
		if ($order == 'groupName ASC,id ASC' ){
			$order = '(ORDER BY M.[name] ASC';
		}
	
		if ($order == 'groupDisplayName DESC,id DESC' OR $order == 'groupDisplayName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
	
		if ($order == 'groupName DESC,id DESC' OR $order == 'groupName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
	
		if ($order == 'groupMail DESC,id DESC'){
			$order = '(ORDER BY M.name DESC';
		}
	
		if ($order == 'groupMail ASC,id ASC' ){
			$order = '(ORDER BY M.name ASC';
		}
		
		if ($order == 'groupStatus DESC,id DESC'){
			$order = '(ORDER BY M.[is_active] DESC, M.[name] ASC';
		}
		
		if ($order == 'groupStatus ASC,id ASC'){
			$order = '(ORDER BY M.[is_active] ASC, M.[name] ASC';
		}
		
		$sql= str_replace("(id","(F.id",$sql);//needed because both tables have the same column name
		$sql_date_filter_excluded= str_replace("(id","(F.id",$sql_date_filter_excluded);
		$responses_list = $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as group_name, M.[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(COUNT(ms.id), 0) - ISNULL(sum(ms.sent), 0)AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id where '.$sql.' and  M.is_group = 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY  M.name, F.name, F.id, M.is_active) A  ')->result();
		$responses_list_date_filter_excluded = $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as group_name, M.[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(COUNT(ms.id), 0) - ISNULL(sum(ms.sent), 0)AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id where '.$sql_date_filter_excluded.' and  M.is_group = 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY  M.name, F.name, F.id, M.is_active) A  ')->result();
	
		//include the groups who had no acitivty in the time period specified
		$new_response_list = [];
		foreach($responses_list as $summary) {
			$new_response_list[$summary->group_name] = $summary;
		}
		$complete_responses_list = [];
		foreach($responses_list_date_filter_excluded as $summary) {
			if(key_exists($summary->group_name, $new_response_list)) {
				$complete_responses_list[$summary->group_name] = $new_response_list[$summary->group_name];
			}
			else {
				$summary->Number_of_sent = 0;
				$summary->Number_of_seen = 0;
				$summary->Total_messages = 0;
				$complete_responses_list[$summary->group_name] = $summary;
			}
		}
		return $complete_responses_list;
	}
	
	function get_ldap_request($group_name)//get response when no filters for first page
	{
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$base_dn = LDAP_GROUPS_GROUP;
			$fields = array('ou','cn','description','mail');
			$search = @ldap_search($ldap_conn, $base_dn, '(&(ou='.$group_name.'))', $fields);
				
			if($search){ 
				$entries = ldap_get_entries($ldap_conn, $search);
				if (!isset ($entries[0]['cn'][0])){
					$base_dn = LDAP_DISABLED_GROUPS_GROUP;
					$search = @ldap_search($ldap_conn, $base_dn, '(&(ou='.$group_name.'))', $fields);
					$entries = ldap_get_entries($ldap_conn, $search);
				}
			}
			else{ $entries = array('count' => 0); }
	
			return $entries;
		}
	}
	
	/* -----------------------------*
	 *  PRIVATE FUNCTIONS           *
	 * -----------------------------*/
	
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
}