<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class EventModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    function create_event($target_type, $target_id, $actor_type,$actor_id, $action, $date, $success)
    {
    	//echo 'insert into event_log (id, target_type, target_id, actor_type, actor_id, action, event_date, success) values ('.$this->db->escape($id).','.$this->db->escape($target_type).','.$this->db->escape($target_id).','.$this->db->escape($actor_type).','.$this->db->escape($actor_id).','.$this->db->escape($action).','.$this->db->escape($date).','.$this->db->escape($success).')';
		$this->db->query('insert into event_log ( target_type, target_id, actor_type, actor_id, action, event_date, success) values ('.$this->db->escape($target_type).','.$this->db->escape($target_id).','.$this->db->escape($actor_type).','.$this->db->escape($actor_id).','.$this->db->escape($action).','.$this->db->escape($date).','.$this->db->escape($success).')');
    }
    
    function get_max_id()
    {
    	return $this->db->query('select max(id) as id from event_log');
    }
    
    function get_event_by_id($id)
    {
    	return $this->db->query('select * from event_log where id = '.$this->db->escape($id));
    }
	function get_events(){
    	return $this->db->query('SELECT * FROM event_log ORDER BY date DESC');
    }
	function get_event_filter_export($sql,$order)//get respose with filters
	{
		return $this->db->query('select * FROM event_log where '.$sql.' ORDER BY '.$order);
	}
	function get_event_filter($sql,$order,$start,$size)//get respose with filters
	{
		return $this->db->query('select * from (select *, ROW_NUMBER() over (order by '.$order.') as row FROM event_log where '.$sql.') a where row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
	}
	function get_first_events($size)//get response when no filters for first page
	{
    	return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (ORDER BY event_date DESC) as row from event_log) a where row >=1 and row <='.$this->db->escape($size));
    }
	function get_size()//get size of entire thing
	{
		return $this->db->query('select COUNT(*) as count from event_log');
	}
	function get_filted_size($sql)//get size after filter
	{
		return $this->db->query('select COUNT(*) as count from event_log where '.$sql);
	}
}