<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage libraries
*//** */


/**
* DaaS CodeIgniter Form validation Extension
*
* @author          , Shawn        s
* @package direct-as-a-service
* @subpackage libraries
*/
class DAAS_Form_validation extends VLER_Form_validation {
	
/*
 Note to developers - this class is an extension of the Codeigniter form validation class, and Codeigniter will automatically use it when
 you load the form validation library.  There is no need to load the form validation library from within this class or try to call
 $CI->form_validation->set_message() instead of $this->set_message(), it just incurs additional overhead.  If you're not familiar with
 Codeigniter's system for extending libraries, see the "Extending Native Libraries" section of the docs: http://ellislab.com/codeigniter/user-guide/general/creating_libraries.html.  -MG 2014-06-26
*/	
	
	public function allowed_mailbox_characters($name) {
		$valid = (preg_match('/[^A-Za-z0-9._-]/', $name) === 1) ? FALSE : TRUE;
		if($valid) { return TRUE; }
		$this->set_message('allowed_mailbox_characters', 'The %s field may only contain alpha-numeric characters (A-Z, a-z, 0-9), underscores, periods, and dashes.');
		return FALSE;
	}
	
	/*
	 * checks if the user name entered on create user page already exists in the database 
	*/
	public function unique_username($user_name) {
		$CI = get_instance();
		$CI->load->model('usersmodel');
		$user_name = mb_strtolower($user_name);
		if(!$CI->usersmodel->username_exists($user_name)) {
			return true;
		}
		else {
			$this->set_message('unique_username', 'The user name already exists in the system.');
			return false;
		}
	}
	
	public function va_email($email) {
		$valid = (preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@+((.*(\.va\.gov))|va\.gov)$/ix", $email)) ? TRUE : FALSE;
		if($valid) { return TRUE; }
		$this->set_message('va_email', 'The %s field must contain a valid domain email address.');
		return FALSE;
	}	
	public function valid_facility($facility_id){
		$CI =& get_instance();
       	$CI->load->model('facilitymodel');
		$result = $CI->facilitymodel->get_facility($facility_id);
		if($result && $result->num_rows() > 0){
			return true;
		}
		$this->set_message('valid_facility', 'The Faility field is invalid.');
		return false;
	}
	
	public function valid_url($url){       
	  $pattern = '/' . '^(https?:\/\/)[^\s]+$' . '/';
	  preg_match($pattern, $url, $matches);	
	  $this->set_message('valid_url', "The url must start with http:// or https:// and contain no spaces");      
	  return (empty($matches)) ? FALSE : TRUE;
	}
	
	/*
	 * phone validation checks that the passed value is a valid phone number
	*/
	public function validate_phone($phone){
		//if the phone number is null or not set return true
		if (!isset($phone) || $phone === ''){
			return true;
		}
		//check if the phone number follows standard format
		if (preg_match('/^(?:\((\+?\d+)?\)|\+?\d+) ?\d*(-?\d{2,3} ?){0,4}$/', $phone)){
			return true;
		}else{
			$this->set_message('validate_phone', 'The %s field must be a valid phone number.');
			return false;
		}
	}	 
	
}