<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage helpers
*//** */


function validate($sender,$address_arr) {
	$invalid_addresses = array();
	$valid_message = true;
		
	//call direct reference implementation web service to validate trust
	$url = 'http://'.GATEWAY_HOSTNAME.':8081/config-service/ConfigurationService?wsdl';
	try {
		$client = new SoapClient($url);
		foreach($address_arr as $address){
			$result = $client->validateTrust(array('sender'=>$sender,'address'=>$address));
			if(!$result->return) {
				array_push($invalid_addresses, $address);	
				$valid_message = $result->return;
			}
		}
	}
	catch (Exception $e) {
		//If java web service fails, native PHP check if any of the addresses are invalid and add them to this array
		foreach($address_arr as $address){
			$has_cert = $this->has_trusted_certificate($address);
			//if there is no cert for that address add it to the invalid array
			if (!$has_cert){
				array_push($invalid_addresses, $address);
				$valid_message = $has_cert;
			}
		}
	}
	return array("valid_message" =>$valid_message, "invalid_addresses"=>$invalid_addresses);
}

/* This function utilizes the config-service of the Direct Project Reference Implementation to
 * check the trust chain of provided address. It can check if the address is trusted for outgoing
 * or incoming messages individually by use of the directon parameter, but checks that it is trusted
 * for both by default. It will return TRUE for a trusted address or domain and FALSE for an untrusted
 * address or if trust cannot be checked due to a failure. IT calls validate_trust_chain for the heavy
 * lifting on checking the trust chain.
 */
function has_trusted_certificate($address,$direction = 'both'){
	//load helpers/libraries needed, connect to SOAP client
	$url = 'http://'.GATEWAY_HOSTNAME.':8081/config-service/ConfigurationService?wsdl';
	$client = new SoapClient($url);
	$this->load->helper('netdns2');
	$this->load->helper('mail');
	$this->load->helper('cert');
	
	//parse address so that we get just the address part
	$address = normalize_address_string($address);
	
	//get domain of address
	$domain = explode("@", $address);
	$domain = $domain[(count($domain)-1)];
	
	$cert = get_dns_cert($address);
	if(!$cert) { $cert = get_dns_cert($domain); } //if no cert for address, check for organizational cert
	
	//if still no cert, look for cert through web service TO-DO: we are repeating logic here, need to abstract this to a function or something
	if(!$cert) {
		$result = $client->getCertificatesForOwner(array('owner'=>$address));
		if(isset($result->return) && $result->return->status === 'ENABLED') {
			$parsed_cert = openssl_x509_parse($result->return->data);
			if(empty($parsed_cert)) { $pem_cert = convert_cert('DER','PEM',$result->return->data); } //if that didn't work, try converting it to PEM
			if(isset($pem_cert)) { $parsed_cert = openssl_x509_parse($pem_cert); } //parse converted cert
			$cert = $parsed_cert;
		}
	}
	if(empty($cert) || !$cert) { //if still no cert, look for organizational cert in web service
		$result = $client->getCertificatesForOwner(array('owner'=>$domain));
		if(isset($result->return) && $result->return->status === 'ENABLED') {
			$parsed_cert = openssl_x509_parse($result->return->data);
			if(empty($parsed_cert)) { $pem_cert = convert_cert('DER','PEM',$result->return->data); } //if that didn't work, try converting it to PEM
			if(isset($pem_cert)) { $parsed_cert = openssl_x509_parse($pem_cert); } //parse converted cert
			$cert = $parsed_cert;
		}
	} 
	//if we still can't find a certificate then they are not trusted
	if(empty($cert) || !$cert) { return FALSE; }
	
	//look for anchors in web service here
	$result = $client->listAnchors();
	$anchors = $result->return;
	$trusted = $this->validate_trust_chain($cert,$anchors,$direction);
	return $trusted;
}


/* This function recursively checks the trust chain of the provided certificate (cert parameter is
 * expected to be an array result from openssl_x509_parse of a certificate). Anchors is data from the
 * Direct Project RI config-service from the listAnchors function. 
 */
function validate_trust_chain($cert,$anchors,$direction = 'both') {
	if((time() < $cert['validFrom_time_t']) || (time() > $cert['validTo_time_t'])) { return FALSE; } //check for certificate expiration/not yet valid-ness
	foreach($anchors as $anchor) {
		unset($parsed_anchor); unset($pem_anchor);
		$parsed_anchor = openssl_x509_parse($anchor->data);
		if(empty($parsed_anchor)) { $pem_anchor = convert_cert('DER','PEM',$anchor->data); } //if that didn't work, try converting it to PEM
		if(isset($pem_anchor)) { $parsed_anchor = openssl_x509_parse($pem_anchor); } //parse converted cert
		$anchor_cert = $parsed_anchor;
		
		//TO-DO: Check if certificates are revoked
		//check if cert issuer matches the anchor cert we are checking, if the current cert is not also the current anchor
		if($cert['issuer'] == $anchor_cert['subject'] && $cert['subject'] != $anchor_cert['subject']) {
			return $this->validate_trust_chain($anchor_cert,$anchors);
		}
		//if the current cert is issued by the current anchor, and the current cert is also the current anchor, we are at the root certificate
		else if($cert['issuer'] == $anchor_cert['subject'] && $cert['subject'] == $anchor_cert['subject']) { 
			if($direction === 'both' && $anchor->outgoing && $anchor->incoming && $anchor->status === 'ENABLED') { return TRUE; }
			else if($direction === 'incoming' && $anchor->incoming && $anchor->status === 'ENABLED') { return TRUE; }
			else if($direction === 'outgoing' && $anchor->outgoing && $anchor->status === 'ENABLED') { return TRUE; }
		}
	}
	return FALSE;
}
