<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require_once APPPATH.'/libraries/DaaS_REST_Controller.php';

/** 
* @package direct-as-a-service
* @subpackage controllers
*/
class Reports extends DaaS_REST_Controller{	

	public function mailbox_activities_get() {			
		//make sure the required fields have been provided
		if(!array_key_exists('username', $this->get())){
			$this->missing_required_fields[] = 'username';
		}
		$this->respond_with_error_if_fields_are_missing();
			
		//set up var values from parameters	
		$username = $this->get('username');
		$group_names = base64_decode(rawurldecode($this->get('group_names')));
		$start_date = base64_decode(rawurldecode($this->get('start_date')));
		$end_date = base64_decode(rawurldecode($this->get('end_date')));
		$order = 'default_order';
		if(array_key_exists('order', $this->get()))
			$order = base64_decode(rawurldecode($this->get('order')));
		$direction = element('direction', $this->get(), 'asc');
		$is_export = $this->get('export');
		
		//make sure the var values are valid
		$mailbox = Mailbox::find_one( array('name' => $username) );
		if(!Mailbox::is_an_entity($mailbox)){
			$this->invalid_fields[] = 'username';		
		}
		$this->mailbox = $mailbox;
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$groups = array();
		if(!empty($group_names)){
			//check to make sure our main mailbox isn't a group - groups can't belong to any other mailboxes, so any group names would be invalid
			if(!$this->is->comma_separated_list_of_nonempty_string_with_no_whitespaces($group_names))
				$this->invalid_fields[] = 'group_names';
			elseif($mailbox->is_group)
				$this->invalid_fields[] = 'group_names';
			else{
				$group_names_arr = explode(',', $group_names);
				//check to make sure the group names provided are actually existing group mailboxes
				Mailbox::db()->where_in('name', $group_names_arr);
				if(Mailbox::count( array('is_group' => true)) != count($group_names_arr)){
					$this->invalid_fields[] = 'group_names';
				}
				foreach ($group_names_arr as $name){
					$group_per = $this->permissions->get_user_permissions_for_address($name."@".DIRECT_DOMAIN,$this->application_id);
					if(isset($group_per['manage']) && $group_per['manage'] === TRUE) {
						$groups[]= $name;
					}				
				}
			}
		}	
		
		if(!empty($start_date)){
			$start_date = strtotime($start_date);
			if(!$this->is->unix_timestamp($start_date))
				$this->invalid_fields[] = 'start_date';
		}
		
		if(!empty($end_date)){
			$end_date = strtotime($end_date);
			if(!$this->is->unix_timestamp($end_date))
				$this->invalid_fields[] = 'end_date';
		}
		$this->respond_with_error_if_fields_are_invalid();
	
		//set up conditions for the model
		$conditions = array();		
		if($this->is->unix_timestamp($start_date))
			$conditions['timestamp >='] = $start_date;
		if($this->is->unix_timestamp($end_date))
			$conditions['timestamp <='] = $end_date;
		
		$message_counts = $mailbox->message_activity_statistics($conditions, array_filter(array_map('trim', $groups), 'mb_strlen'));
		if(!is_array($message_counts)) return $this->response('An error occurred', 500);
		$this->_mailbox_nested_array_sort($message_counts, $order, $direction);
		
		//add the total activity statistics, for more than just this mailbox
#TODO - might want to consider a less specific key than 'Total VA:' - maybe just total?  that way it's not organization-specific	
		$message_counts['Total VA:'] = array('default_order' => count($message_counts) + 1,
											 'address' => 'Total VA:',
											 'sent_by_you' => Message::count(array_merge($conditions, array('sent' => true, 'original_sender_id' => $mailbox->id))),
											 'sent_total' => Message::count(array_merge($conditions, array('sent' => true))),
											 'received' => Message::count(array_merge($conditions, array('sent' => false, 'draft' => false))),
											 'total' => Message::count(array_merge($conditions, array('draft' => false))));
											 
		if($is_export == 'excel') {
			foreach($message_counts as &$message_count) {
				unset($message_count['default_order']);
			} 
		}	
						
			
		$response = array(
				'message_counts' => $message_counts,
				'group_names' => $group_names,
		);
		$this->response($response,200);	
	}
	
	protected function _mailbox_nested_array_sort(&$array, $key, $direction) {		
		if(mb_strtoupper($key) == 'ADDRESS') {
			if(mb_strtoupper($direction) == 'ASC') {
				ksort($array);
			}
			else {
				krsort($array);
			}
		}
		else {
			$sorter = array();
			$ret = array();
			reset($array);
			foreach($array as $ii => $va) {
				$sorter[$ii] = $va[$key];
			}
			$domains = array();
			$msg_count = array();
			foreach($sorter as $key => $value) {
				$domains[] = $key;
				$msg_count[] = $value;
			}
			if(mb_strtoupper($direction) == 'ASC') {
				array_multisort($msg_count, SORT_ASC, $domains, SORT_ASC, $sorter);
			}
			else {
				array_multisort($msg_count, SORT_DESC, $domains, SORT_ASC, $sorter);
			}
			foreach($sorter as $ii => $va) {
				$ret[$ii] = $array[$ii];
			}
			$array = $ret;
		}
	}	
	
}






























