<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
 
require_once APPPATH.'libraries/DaaS_REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Mailbox_controller extends DaaS_REST_Controller{	
	var $mailbox;
	
	/**
	* Everything that applies to all actions should go here.
	*/
	function __construct(){
		parent::__construct();		
				
		$http_verb = $this->_detect_method();
		
		//SET UP THE MAILBOX	
		//determine the mailbox - setting this as a class variable will make it available throughout the application, which is going to help the models
		$methods_that_find_mailbox_by_sender = array( 'save_post', 'send_draft_post', 'send_post'  ); //save draft will go here as well
		if(in_array($this->router_method, $methods_that_find_mailbox_by_sender)){
			$mailbox_identifier = 'sender';
			if(array_key_exists( $mailbox_identifier, $this->$http_verb() ))			
				$mailbox_name = strip_from_end( '@'.DIRECT_DOMAIN, $this->$http_verb($mailbox_identifier) );
		}	
		else{
			$mailbox_identifier= 'mailbox';
			$mailbox_name = $this->$http_verb( $mailbox_identifier );
		}
		
		//verify that a valid mailbox was provided & set $this->mailbox
		if(!array_key_exists($mailbox_identifier, $this->$http_verb()))
			$this->missing_required_fields[] = $mailbox_identifier;
		elseif(!$this->is->nonempty_string($mailbox_name))
			$this->invalid_fields[] = $mailbox_identifier;
		else{
			$mailbox = Mailbox::find_one( array('name' => $mailbox_name) );
			if(Mailbox::is_an_entity($mailbox)){
				$this->mailbox = $mailbox;
				$this->response_message['mailbox'] = $this->mailbox->name;			
			}else{
				$this->invalid_fields[] = $mailbox_identifier;
			}
		}
	}
	
	protected function valid_locations(){
		return array('inbox', 'draft', 'archived', 'sent','all');
	}
	
}
?>