<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'libraries/DaaS_REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/	
class Disclosure_controller extends DaaS_REST_Controller{
	
	function __construct() {
		parent::__construct();
		require_model('attachment_disclosure');
		
		if (!$this->request->disclosure_api_authorized) { //authorize request
				$this->response( 'Access Denied. Use Not Authorized.', 403);
		}
	}
	
	
	public function audit_get() {
		$optional_fields = array('first','last','ssn','start','end','records','page','order');
		
		//set variables for each optional field
		foreach($optional_fields as $optional_field){
			$$optional_field = element($optional_field, $this->get(), null); //checks to see if $field is in $get - if not, sets to null
		}
		
		if($start && !$this->is->unsigned_integer($start)){
			$this->invalid_fields[] = 'start';
		}
		
		if($end && !$this->is->unsigned_integer($end)){
			$this->invalid_fields[] = 'end';
		}
		
		if($ssn && (!$this->is->unsigned_integer($ssn) || strlen($ssn) != 9)){
			$this->invalid_fields[] = 'ssn';
		}
		
		$allowed_orders = array('ssn','first','last','disclosed','title','recipient','username','purpose');
		
		if($order){
			$order_pieces = explode(" ",$order);
			if(in_array($order_pieces[0], $allowed_orders) && ($order_pieces[1] === 'desc' || $order_pieces[1] === 'asc')){
				Attachment_disclosure::db()->order_by($order_pieces[0],$order_pieces[1]);
			}
			else{
				$this->invalid_fields[] = 'order';
			}
		}else{
			Attachment_disclosure::db()->order_by("disclosed","desc");
		}
		
		if($records && !$this->is->unsigned_integer($records)){
			$this->invalid_fields[] = 'records';
		}
		
		if($page && !$this->is->unsigned_integer($page)){
			$this->invalid_fields[] = 'page';
		}
		
		$this->respond_with_error_if_fields_are_invalid();
		
		$conditions = array('recipient != ' => '');
		
		if(isset($start)) 
			$conditions['disclosed >='] = $start;
		
		if(isset($end)) 
			$conditions['disclosed <='] = $end;
			
		if(isset($records)){
			if(!isset($page)){
				$page = 1;
			}
			Attachment_disclosure::db()->limit($records,($page*$records));
		}
		
		foreach(array('first', 'last', 'ssn') as $field){
			if(isset($$field)) $conditions[$field] = $$field;
		}
		
		$disclosures = Attachment_disclosure::find($conditions);
		if(!is_array($disclosures)) $this->response('Failed to get disclosure log.', 500);
		
		foreach($disclosures as $key => $disclosure){
			$disclosures[$key] = $disclosure->values(array('recipient', 'first', 'last', 'disclosed', 'received', 'title', 'sent_to', 'received_from', 'username', 'facility', 'purpose', 'ssn', 'patient_id'));
		}
		
		//todo - would be much better to have disclosures within an array, to make it easier for end developers to pull out all the disclosures without the metadata
		$this->response($disclosures, 200);
	}
	
	public function summary_get() {
		$optional_fields = array('start','end','order');
	
		//set variables for each optional field
		foreach($optional_fields as $optional_field){
			$$optional_field = element($optional_field, $this->get(), null); //checks to see if $field is in $get - if not, sets to null
		}
		if($start && !$this->is->unsigned_integer($start)){
			$this->invalid_fields[] = 'start';
		}
		if($end && !$this->is->unsigned_integer($end)){
			$this->invalid_fields[] = 'end';
		}
		$allowed_orders = array('sent_to','total');
		if($order){
			$order_piece = explode(" ",$order);
			if(in_array($order_piece[0], $allowed_orders) && ($order_piece[1] === 'desc' || $order_piece[1] === 'asc'))	{
				Attachment_disclosure::db()->order_by($order_piece[0],$order_piece[1]);
			}
			else{
				$this->invalid_fields[] = 'order';
			}
				
		}
		$this->respond_with_error_if_fields_are_invalid();
	
		$conditions = array('recipient != ' => '');
		if(isset($start)) $conditions['disclosed >='] = $start;
		if(isset($end)) $conditions['disclosed <='] = $end;
		
		
		Attachment_disclosure::db()->select('sent_to, COUNT(*) as \'total\'');
		Attachment_disclosure::db()->group_by('sent_to');
		$disclosures = Attachment_disclosure::find($conditions,'sent_to');
		if(!is_array($disclosures)) $this->response('Failed to get disclosure log.', 500);
		$return = array();
		foreach($disclosures as $key => $disclosure){
			$return[] = $disclosure->values(array('sent_to', 'total'));
		}
		//todo - would be much better to have disclosures within an array, to make it easier for end developers to pull out all the disclosures without the metadata
		$this->response($return, 200);
	}
}