<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */


// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require_once APPPATH.'/libraries/DaaS_REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Direct extends DaaS_REST_Controller
{	

	/* VALIDATE (GET request only)
	 * This function validates whether the provided address or domain is trusted by the
	 * system.
	 */
	public function validate_get() {
		$this->load->model('requestmodel');
		$this->load->helper('mail');
		$this->load->helper('validate');
		$request_id = $this->create_request($this->request->uri . ' ' . mb_strtoupper($this->request->method));
		$response_message['request_id'] = $request_id;
		
		$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
		$is_authorized = $this->request->direct_api_authorized; //authorize request
		
		if(!$is_authenticated) {
			$response_message['message'] = 'Access Denied. Authentication Failed.';
			$this->requestmodel->add_response($request_id, 401, $this->json->encode($response_message));
			$this->response($response_message, 401);
		}
		if(!$is_authorized) {
			$response_message['message'] = 'Access Denied. Use Not Authorized.';
			$this->requestmodel->add_response($request_id, 403, $this->json->encode($response_message));
			$this->response($response_message, 403);
		}

		
		//if no address provided, return message that that field is required
		if(!$this->get('address')) { 
			$response_message['valid'] = false;
			$response_message['message'] = 'Must provide address field.';
			$this->requestmodel->add_response($request_id, 422, $this->json->encode($response_message));
			$this->response($response_message, 422); 
		}
		else { $address = base64_decode(rawurldecode($this->get('address'))); }

		//if no sender provided, assume that there is an organizational cert that any domain address will work for
		if(!$this->get('sender')) { 
			$sender = 'validitytest@'.DIRECT_DOMAIN;
		}
		else { $sender = base64_decode(rawurldecode($this->get('sender'))); }
		$address_arr = array();
		$to_arr = array();
		normalize_address($address, $to_arr, $address_arr);
		$message = validate($sender,$address_arr);
		
		if($message['valid_message']) { //if everything is valid, then return response	
			$response_message['valid'] = true;
			$this->requestmodel->add_response($request_id, 200, $this->json->encode($response_message));			
			$this->response($response_message, 200); 
		}
		else { //if something is invalid, then return response
			$response_message['valid'] = false;
			$response_message['message'] = $this->generate_invalid_recipients_message($message['invalid_addresses']);
			$this->requestmodel->add_response($request_id, 200, $this->json->encode($response_message));
			$this->response($response_message, 200); 
		}
	}
}