<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

// This can be removed if you use Modular Extensions
require_once APPPATH.'controllers/admin/admin_controller.php';
require_once APPPATH.'libraries/REST_Controller.php';
require_once APPPATH.'third_party/Paginator.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class User_Settings extends Admin_controller
{
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt','eventlog','permissions','auth','locale'));
		$this->load->model('applicationmodel');
		$this->load->model('usersettingsmodel');
		$this->load->model('usersmodel');
		$this->load->model('groupsmodel');
		$this->load->model('facilitymodel');
	
		$this->load->helper('url'); 
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);

		//check if the user is authorized
		$login_status = $this->session->userdata('is_loggedin');
		if(!isset($login_status) || $login_status !== 'true') {
			//if the user has authenticated via CAC, the controller will load 
			//if not then a 401 Unauthorized error will be shown
			if(!$this->auth->perform_auth()) { show_error('Unauthorized',401); }
		}
		
		//check if user has agreed to dod banner
		$banner = $this->session->userdata('banner_agree');
		if (!isset($banner) || $banner !== 'true') {
			$this->session->set_flashdata('redirect_uri',uri_string());
			redirect('onboarding/banner');
		}
	}
	
	/* -----------------------------*
	 *  USER_SETTINGS TAB FUNCTIONS       *
	 * -----------------------------*/
	public function index() {
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$show = $this->show;
		
		if(isset($show['user_settings']) && $show['user_settings']) { $this->application_list(); }
		else { redirect('onboarding'); }
	}

	/*
	 * Edit page for web service access.
	 * for users when $group_name is null
	 */
	public function webservice_access_edit($mailbox_name = null, $app_id = null, $active_cur_page = null, $active_items_per_page = null,
			$pending_cur_page = null, $pending_items_per_page = null, $denied_cur_page = null, $denied_items_per_page = null)
	{
		//set current page and items per page on the sub-tabs
		$data['active_cur_page'] = $active_cur_page;
		$data['active_items_per_page'] = $active_items_per_page;
		
		if(is_null($app_id)) { return $this->application_list(); } //if no id is set, go back to application list
		$data['title'] = 'Direct API: Application Web Service Access Edit';
		$data['active_tab'] = array('user_settings'=>true);
		
		//get current user id from session to get permissions
		$user_id = $this->user->id();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['api_admins'] = $permissions['API']['admins'];
		$app_permission = false;
		$data['app_permission'] =  $app_permission = isset($permissions['Application'][$app_id]) && 
													 ($permissions['Application'][$app_id][LDAP_APPLICATION_USER_GROUP_NAME] || 
													  $permissions['Application'][$app_id][LDAP_APPLICATION_ADMIN_GROUP_NAME]);

		//mailbox_settings_setup must happen before get_mailbox_settings_by_application
		if(empty($mailbox_name) || $mailbox_name === 'null') { $mailbox_name = $this->user->username; }
		$mailbox = $this->usersettingsmodel->get_mailbox_by_name($mailbox_name);
		$mailbox_id = $mailbox->id;
		$this->usersettingsmodel->mailbox_settings_setup($mailbox_id, $app_id, 'add');
		$data['mailbox_settings'] = $this->usersettingsmodel->get_mailbox_settings_by_application($mailbox_id, $app_id)->result();
		
		if($permissions['API']['admins'] || $app_permission) {
			if (isset($app_id) && is_numeric($app_id)){ //make sure its a valid id
				$app = $this->applicationmodel->get_application($app_id)->result();
				if($app) { //if there is a result, load the view
					$data['app'] = $app[0];
					$data['web_services'] = $this->usersettingsmodel->get_web_services()->result();
				}
				else { show_404(); } //if not valid id or no result, show 404
			}
			else { show_404(); }
			
			if($this->user->username !== $mailbox->name) {
				$data['mailbox_name'] = $mailbox->name;
				$data['view'] = 'webservice_access_edit';
				$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
				$data['active_tab'] = array('administration'=>true);
				if($mailbox->is_group) {
					$data['title'] = 'Direct API: Authorized Application List for Group';
					//get user id from session to get permissions
					$this->load->view('api/administration/manage_groups', $data);
				}
				else {
					$data['title'] = 'Direct API: Authorized Application List for Account';
					//get user id from session to get permissions
					$this->load->view('api/administration/manage_accounts', $data);
				}
			}
			else if($data['show']['user_settings']) {
				$this->load->view('api/user_settings/webservice_access_edit', $data);
			}
			else {  show_error('Forbidden',403);  }
		}
		else {  show_error('Forbidden',403); }
	}
	
	/*
	 * loads the application list view for the application user.
	 */
	public function application_list($name = null)
	{
		$data['title'] = 'Direct API: Authorized Application List';
		$data['active_tab'] = array('user_settings'=>true);
	
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }

		$mailbox = $this->usersettingsmodel->get_mailbox_by_name($name);

		//get current user id from session to get permissions
		$user_id = $this->user->id();
		$data['user_id'] = $user_id;
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;

		$application_list = array();
		if($mailbox && $name !== $this->user->username) {
			if($permissions['API']['admins']) {
				//if this is for group
				if($mailbox->is_group) {
					$this->can_edit_group($mailbox->name);
					$group = $this->groupsmodel->get_group_from_groupname($mailbox->name);
					if(count($group) === 0){
						$group = $this->groupsmodel->get_group_from_groupname($mailbox->name, false);
					}
					$application_names = $group[0]['applications'];
					$data['group'] = $group[0];
					$group_app_access = array();
					foreach($application_names as $name) {
						$app_id = $this->applicationmodel->get_application_id_by_name($name);
						array_push($group_app_access, $app_id);
					}
					$application_list = $this->applicationmodel->get_applications($group_app_access);
					$application_list_size = $this->applicationmodel->get_app_list_size($group_app_access);
				}
				else {
					//get mailbox user id from session to get permissions
					$user = User::find_one(array('username' => $mailbox->name));
					$user_permissions = $user->permissions;
					$data['account'] = $user;
					$app_access = $this->permissions->get_application_permission($user_permissions, 'users');
					if(!empty($app_access)) {
						$application_list = $this->applicationmodel->get_applications($app_access);
						$application_list_size = $this->applicationmodel->get_app_list_size($app_access);
					}
					else {
						$application_list = array();
						$application_list_size = 0;
					}
				}
			}
		}
		else {
			//grab a list of applications the user has access to
			$app_access = $this->permissions->get_application_permission($permissions, 'users');
			//if you have apps that you have access too
			if (isset($app_access) && count($app_access) > 0){
				$application_list = $this->applicationmodel->get_applications($app_access);
				$application_list_size = $this->applicationmodel->get_app_list_size($app_access);
			}
			else{
				//if current user has no app access send empty result
				$application_list = array();
				$application_list_size = 0;
			}
		}
	
		//the active applications list
		if($application_list) {	 $data['active_list'] = $application_list->result(); }
		else {  $data['active_list'] = array(); }
		
		if(isset($_POST['prefix'])) { $data['anchor'] = $_POST['prefix'] . 'link'; }

		//determine which view to display
		if($mailbox && $name !== $this->user->username) {
			if($mailbox && $mailbox->is_group) { 
				$data['title'] = 'Direct API: Authorized Application List for Group';
				$data['active_tab'] = array('administration'=>true);
				//get user id from session to get permissions
				$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
				$data['view'] = 'application_list';
				$this->load->view('api/administration/manage_groups', $data);
			}
			else {
				$data['title'] = 'Direct API: Authorized Application List for Account';
				$data['active_tab'] = array('administration'=>true);
				//get user id from session to get permissions
				$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
				$data['view'] = 'application_list';
				$this->load->view('api/administration/manage_accounts', $data);
			}
		}
		else { 
			$this->load->view('api/user_settings/application_list', $data); 
		}
	}
	
	/*
	 * Handles the storing of values for web service access into the database.
	*/
	public function webservice_access_save(){
		$this->load->library('form_validation');
	
		//push back the page number and items per page from the attempt to edit an application
		$this->session->set_flashdata('active_page_select_from_application_save',$this->input->post('active_page_select_from_application_save',TRUE));
		$this->session->set_flashdata('active_items_per_page_from_application_save',$this->input->post('active_items_per_page_from_application_save',TRUE));
	
		//retrieve the application id
		$id = $this->input->post('app_id',TRUE);
		$mailbox_name = $this->input->post('mailbox_name',TRUE);

		//if a mailbox is not included in the post data, assume it's for the current user
		#TODO: This should be refactored into a better system that has one view template for this and deals with everything the same way
		if(empty($mailbox_name) || $mailbox_name === FALSE) { $mailbox_name = $this->user->username; }

		//use permissions to determine whether to allow function call at all
		$cur_user_id = $this->user->id();
		$permissions = $this->account_permissions;
		$message = '';
		if($permissions['API']['admins'] || isset($permissions['Application'][$id])) {
			//test if the id has been passed and if it is a valid number
			if(empty($id) || !$this->is->nonzero_unsigned_integer($id)){
				$this->session->set_flashdata('error_message', 'No application id specified. To request a new application please follow the link on the onboarding tab.');
				redirect('user_settings/application_list');
			}
			else {
				//retrieve the application from the database from its id
				$app_arr = $this->applicationmodel->get_application($id)->result();
				//if the application exists
				if($app_arr) {
					$app = $app_arr[0];
					$mailbox = $this->usersettingsmodel->get_mailbox_by_name($mailbox_name);
					$mailbox_id = $mailbox->id;
						
					//no validation needed for now since there are only checkboxes in the form
					$mailbox_settings = $this->usersettingsmodel->get_mailbox_settings_by_application($mailbox_id, $id)->result();
					foreach($mailbox_settings as $setting) {
						$web_service_authorized = $this->input->post('ws'.$setting->id,TRUE);
						
						if($this->usersettingsmodel->save_application_web_service_access_by_setting_id($setting->id, $web_service_authorized)) {
							$message = 'Web service access of the application "'.$app->name.'" has been saved successfully.';
							$this->eventlog->create_event(2, $id, 3, $cur_user_id, "Edit web service access of the application", time(), 1);
						}
						else {
							$error_message = 'Web service access of the application "'.$app->name.'" failed to save.';
							$this->eventlog->create_event(2, $id, 3, $cur_user_id, "Edit web service access of the application", time(), 0);
						}
					}
				}
				//if no application exists in the database return to the edit screen
				else {
					$this->session->set_flashdata('error_message', 'No application exists for id '.$id.'. Please select another application to edit.');
					redirect('user_settings/application_list');
				}
			}
			$this->session->set_flashdata('success_message',$message);
			if(isset($error_message)) { $this->session->set_flashdata('error_message',$error_message); }
			
			if($mailbox_name) {
				redirect('administration/manage_groups/application_list/' . $mailbox_name);
			}
			else {
				redirect('user_settings/application_list');
			}
		}
		else { show_error('Forbidden', 403); }
	}
	
	/* 
	 * This function loads the edit account view and provides the data for the current user
	 */
	public function account_edit() {
		$user_org_id = User::organization_id_from_session();
		$user_id=$this->usersmodel->get_user_id_from_org_id($user_org_id);
		$data['title'] = 'Direct API: Edit Account';
		$data['view'] = 'account_edit';
		$data['active_tab'] = array('user_settings'=>true);
		
		//get user id from session to get permissions
		
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$data['user'] = $this->usersmodel->get_user($user_id);
		//get facilitiy list and the facility associated with the user if any
		$data['facility_select'] = $this->usersettingsmodel->get_facility_id_in_mailbox($data['user']->username, false);
		$data['facilities'] = $this->facilitymodel->get_facilities(true)->result();
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
		
		$this->load->view('api/user_settings/account_edit', $data);
	}
	
	/* Save account data from account edit form
	 */
	public function account_edit_save() {
		$this->load->library('form_validation');
		//get user id from session to get permissions
		$app_id = $this->input->post('app_id',TRUE);
		$fac_id = $this->input->post('facility_select',TRUE);
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$cur_user= $this->user->id();
		$login_status = $this->session->userdata('is_loggedin');
		if(isset($login_status) && $login_status == 'true') {
			$first = $this->input->post('first_name', TRUE);
			$middle = $this->input->post('middle_name', TRUE);
			$last = $this->input->post('last_name', TRUE);
			$ext_mail = $this->input->post('ext_mail', TRUE);
			$title = $this->input->post('title', TRUE);
			$department = $this->input->post('department', TRUE);
			$organization = $this->input->post('organization', TRUE);
			$telephone = $this->input->post('telephone', TRUE);
			$mobile = $this->input->post('mobile', TRUE);
			$location = $this->input->post('location', TRUE);
			$user_id = $this->input->post('user_id', TRUE);
			$facility_id = $this->input->post('facility_select', TRUE);
			
			$this->form_validation->set_rules('first_name','First Name','required');
			$this->form_validation->set_rules('last_name','Last Name','required');
			$this->form_validation->set_rules('facility_select','Facility','required|valid_facility');
			$this->form_validation->set_rules('ext_mail','Email','required|va_email');
			$this->form_validation->set_rules('telephone','Telehone','validate_phone');
			$this->form_validation->set_rules('mobile','Mobile','validate_phone');
				
			if($this->form_validation->run() === TRUE) {
				if(is_numeric($user_id)) {
					$username = $this->usersmodel->get_username_from_id($user_id);
					if($username) {
						$attributes = array(
								'cn' => $first . ' ' . $last,
								'givenName' => $first,
								'initials' => $middle,
								'sn' => $last,
								'title' => $title,
								'departmentNumber' => $department,
								'o' => $organization,
								'telephoneNumber' => $telephone,
								'mobile' => $mobile,
								'physicalDeliveryOfficeName' => $location,
								'facility_select' => $facility_id
						);
						//set optional attributes / attributes that depend on optional attributes
						if(isset($middle) && !empty(trim($middle))) {
							$attributes['initials'] = $middle;
							$attributes['displayName'] = $last.', '.$first.' '.$middle;
						}
						else { $attributes['displayName'] = $last.', '.$first; }
						$result = $this->usersmodel->update_user($user_id,$ext_mail,$facility_id,$attributes);
						
						if(!$result || in_array(FALSE,$result)) {
							$this->session->set_flashdata('error_message','Account information failed to saved properly.');
							$this->eventlog->create_event( 3,$user_id,3 ,$cur_user, "Edit user", time(), 0);
						}
						else { $this->session->set_flashdata('success_message','Account information saved.');  $this->eventlog->create_event( 3,$user_id,3 ,$cur_user, "Edit user", time(), 1); }
					}
				}
			}
			else{
				$this->session->set_flashdata('error_message',validation_errors());
				$this->session->set_flashdata('first_name', $first);
				$this->session->set_flashdata('middle_name', $middle);
				$this->session->set_flashdata('last_name', $last);
				$this->session->set_flashdata('ext_mail', $ext_mail);
				$this->session->set_flashdata('title', $title);
				$this->session->set_flashdata('department', $department);
				$this->session->set_flashdata('organization', $organization);
				$this->session->set_flashdata('telephone', $telephone);
				$this->session->set_flashdata('mobile', $mobile);
				$this->session->set_flashdata('location', $location);
				$this->session->set_flashdata('facility_select', $facility_id);
			}
			redirect('user_settings/account_edit/');
		}
		else {
			show_error('Forbidden',403);
		}
	}
	
	public function getData() {
		echo $this->json->encode($this->applicationmodel->get_applications());
			
	}
	
	private function can_edit_group($group_name) {
		if($this->has_access('manage_groups_all')) { return; }
		else if($this->has_access('manage_groups_lead')){
			if(!$this->groupsmodel->user_is_member($group_name,$this->user->dn())){ show_404(); }
			else { return; }
		}
		else { show_404(); }
	}

/*	//this method existed on multiple controllers - moved this to the form validation library extension to avoid duplicate code -- MG 2014-05-22	
/*		
	public function va_email($email) {
		$valid = (preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@+((.*(\.va\.gov))|va\.gov)$/ix", $email)) ? TRUE : FALSE;
		if($valid) { return TRUE; }
		$this->form_validation->set_message('va_email', 'The %s field must contain a valid domain email address.');
		return FALSE;
	} */
}