<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
 

// This can be removed if you use Modular Extensions
require_once APPPATH.'libraries/REST_Controller.php';
require_once APPPATH.'third_party/Paginator.php';
require_once APPPATH.'third_party/WkHtmlToPdf.php';
require_once APPPATH.'controllers/admin/admin_controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Reports extends Admin_controller
{
    var $report_tabs = array("requests"=>"Requests", "events"=>"Events","logins"=>"Logins","mail"=>"Mail","user_activity_summary"=>"User Summary","group_activity_summary"=>"Group Summary","facility"=>"Facility","hisp"=>"HISP","points_of_origin"=>"Points of Origin", "adhoc_reports"=>"Ad-hoc Reports");

    public function __construct(){
        parent::__construct();
        $this->load->library(array('session','encrypt','eventlog','permissions','auth','locale'));
        $models = array('applicationmodel','applicationrequestmodel','facilitymodel','requestmodel','usersmodel','loginsmodel','mailmodel','ticketsmodel','pointsoforiginmodel','hispmodel','useractivitysummarymodel','ticketcategorymodel', 'adhocreportsmodel', 'groupsmodel');
        foreach($models as $model) {
            $this->load->model($model);
        }
        
        date_default_timezone_set(ENVIRONMENT_TIMEZONE);
    }
    
    public function index() {
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $show = $this->show;
        foreach ($this->report_tabs as $key=>$value){
            if($this->has_access($key."_report")){
                $report = "report_".$key;
                $this->$report('');
                return;
            }
        }
        redirect('onboarding');
    }
    
    /* -----------------------------*
     *  REPORTS TAB FUNCTIONS       *
     * -----------------------------*/

    public function report_requests($adhoc_report_id){
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data = array(
            'title' => 'Direct API: Reports',
            'active_tab' => array('reports'=>true),
            'timezone_abbr' => $this->locale->timezone_abbr_from_name(date_default_timezone_get()),
            'tabs' => $this->create_tabs('requests_report'),
            'report_name' => 'requests',
            'show' => $this->show,
            'time' => date('m/d/Y h:i:s A', time()),
            'user' => $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'],
        );
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $selected = null;
        $responses_list = $response_export_list = array();
        //show forbidden if the user does not have permission to be here
        if(!$data['show']['reports']) { show_error('Forbidden',403);  }
        //gets selected application
        $app_select = $this->input->post('whichapp',TRUE); 
        $export_file_name = $this->input->post('export_file_name',TRUE);
        //if $adhoc_report_id is not empty, do adhoc report
        if($adhoc_report_id != ''){
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }    
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"requests")->result();
            //Diff time period
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;
        
            $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
            $time_start_check = $selected_filter_array['start_date'];
            $time_end_check = $selected_filter_array['end_date'];
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
        
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator = $adhoc_report[0]->report_query_generator;
                
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);    
                
                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
                
                //Date information
                $end_date = $selected_filter_array['end_date'];
                $start_date = $selected_filter_array['start_date'];
            }
            //Selector
            $selector = array(
                    'application_id' => ($selected_filter_array['whichapp']),
            );
            $items = array(
                'id' => $this->search_type($selected_filter_array['request_id'],$selected_filter_array['request_id_type']),
                'call' => $this->search_type($selected_filter_array['request_call'],$selected_filter_array['request_call_type']),
                'response_code' => $this->search_type($selected_filter_array['request_code'],$selected_filter_array['request_code_type']),
                'response' => $this->search_type($selected_filter_array['request_response'],$selected_filter_array['request_response_type']),
            );
            //Date Format
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
        
            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            /* if($export || $export_pdf || $print_page == 1) {
                $is_export = true;
            } */
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
        
            $between = array(
                'call_date' => $this->check_paired_dates($start_date,$end_date),
            );


            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
        
            //getting size number
            $size = $this->requestmodel->get_filted_size($sql)->result();
            $size = $size[0]->count;
            $destination_page = $selected_filter_array['adhoc_report_destination_page'];
            $items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
            $pages->items_per_page = $items_per_page;
            $start = (($destination_page-1)*$items_per_page)+1;
            
            if(string_contains('application_id', $order)){//if sorting by application_id
                $responses_list= $this->requestmodel->get_request_filter_app_order($sql,$order.' '.$dir,$this->db->escape($start),$items_per_page)->result();
            }
            else{
                $responses_list= $this->requestmodel->get_request_filter($sql,$order.' '.$dir,$this->db->escape($start),$items_per_page)->result();
            }
            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('request',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
        
            //ExportPDF-PRINT
            if($is_export) {
                $response_export = $this->reports_helper('request',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
            //set form data
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['whichapp'] = $selected_filter_array['whichapp'];
            $form_data['request_id'] = $selected_filter_array['request_id'];
            $form_data['request_id_type'] = $selected_filter_array['request_id_type'];
            $form_data['request_call'] = $selected_filter_array['request_call'];
            $form_data['request_call_type'] = $selected_filter_array['request_call_type'];
            $form_data['request_response'] = $selected_filter_array['request_response'];
            $form_data['request_response_type'] = $selected_filter_array['request_response_type'];
            $form_data['request_code'] = $selected_filter_array['request_code'];
            $form_data['request_code_type'] = $selected_filter_array['request_code_type'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }
            else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            $data['form_data'] = $form_data;
        }
        //checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
        else if($app_select) {
            //adds each component type into its own json
            $selector = array(
                'application_id' => ($app_select),
            );
            
            $items = array(
                'id' => $this->search_type($this->input->post('request_id',TRUE),$this->input->post('request_id_type',TRUE)),
                'call' => $this->search_type($this->input->post('request_call',TRUE),$this->input->post('request_call_type',TRUE)),
                'response_code' => $this->search_type($this->input->post('request_code',TRUE),$this->input->post('request_code_type',TRUE)),
                'response' => $this->search_type($this->input->post('request_response',TRUE),$this->input->post('request_response_type',TRUE)),
            );
            
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            
            $between = array(
                'call_date' => $this->check_paired_dates($start_date,$end_date),
            );

            //get direction (desc/asc)and if it is being exported
            $order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'name';
            $dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
            //calls helper to get data
            $response = $this->reports_helper('request',$items,$between,$selector,array(),$this->input->post('order',TRUE),$dir,$destination_page,$is_export,$items_per_page);
            $responses_list = $response['response'];
            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('request',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
                
            //set form data
            $form_data = $this->input->post(NULL,TRUE);

            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            
            $size = $response['size'];
            if(mb_strtolower($selector['application_id']) != '(all)') $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($selector['application_id'])->result()[0]->name;
            
            if($is_export == TRUE){
                //ExportPDF-PRINT
                $response_export = $this->reports_helper('request',$items,$between,$selector,array(),$this->input->post('order',TRUE),$dir,$destination_page,$is_export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
            
        
        }
        //if this is the first time you have loaded the page
        else {
            $responses_list = $this->requestmodel->get_first_responses($items_per_page)->result(); //gets first page
            //set defaults
            $form_data = array(
             'direction' => 'DESC',
             'order' => 'call_date',
             'cur_page' => '1',
            );
            //get number of items in log
            $size = $this->requestmodel->get_size()->result();
            $size = $size[0]->count;
            $export = false;
            $export_pdf = FALSE;
            $print_page = FALSE;
            //Adhoc Report
            $between = array ("call_date" => Array("start"=>"", "end" =>""));
            $response_adhoc_sql = " 0=0 AND id like '%' ";
            $dir = "DESC";
            $order = "call_date";
            //initiate form data for adhoc report
            $form_data['whichapp'] = '(ALL)';
            $form_data['request_id'] = '';
            $form_data['request_id_type'] = '';
            $form_data['request_call'] = '';
            $form_data['request_call_type'] = '';
            $form_data['request_response'] = '';
            $form_data['request_response_type'] = '';
            $form_data['request_code'] = '';
            $form_data['request_code_type'] = '';
            $form_data['start_date'] = '';
            $form_data['end_date'] = '';
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
            'equals' => 'Equals',
            'contains' => 'Contains',
            'starts' => 'Starts With',
            'ends' => 'Ends With'
        );
        
        //pagination setup
        $pages->items_total = $size;
        $pages->current_page = $destination_page;
        $pages->paginate();
        $form_data['pagination_bar'] = $pages->display_pages();
        $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
        
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
        else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
        
        $form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
        $form_data['items_per_page'] = $items_per_page;
        $form_data['pages'] = $pages;
        $data['form_data'] = $form_data;
        $data['apps'] = $this->applicationmodel->get_applications()->result(); //gets all applications available
        $data['request_list'] = $responses_list;
        
        $lists = array($responses_list, $response_export_list);
        foreach($lists as $list) {
            if(isset($list)) {
                foreach($list as $result) {
                    //converts application's numbers into their names
                    $name = $this->id_to_name(2,$result->application_id);
                    $result->application_id=$name['id'];
                    //hide PII in response if it's a Disclosure::audit_get() call
                    if(string_begins_with('/disclosure', $result->call) && !string_begins_with('/disclosure/summary', $result->call) && $result->response_code == 200) { 
                    	$result->response=$this->json->encode(array('request_id'=>$this->json->decode($result->response)->request_id));
                    }
                    //check for ssn in any query string and ensure it doesn't display SSN
                    $parts = parse_url(strtok(strtolower($result->call),' '));
                    if(!empty($parts['query'])) {
                        parse_str($parts['query'], $query_str);
                        if(!empty($query_str) && is_array($query_str)) {
                            if(array_key_exists('ssn', $query_str)) {
                                $sanitized_ssn = '';
                                for($i = 0; $i < strlen($query_str['ssn']); $i++) {
                                    if($i < (strlen($query_str['ssn']) - 4)) { $sanitized_ssn .= '*'; }
                                    else { $sanitized_ssn .= $query_str['ssn'][$i]; }
                                }
                                $result->call = str_replace($query_str['ssn'], $sanitized_ssn, $result->call);
                            }
                        }
                    }
                    if(!empty($parts['path'])) {
                         //check if query string is being passed the CodeIgniter way and so the same thing if so
                            $parts = explode('/', $parts['path']);
                            array_change_key_case($parts, CASE_LOWER);
                            $ssn_index = array_search('ssn', $parts);
                            if($ssn_index) {
                                $ssn = $parts[$ssn_index+1];
                                if(is_numeric($ssn)) {
                                    $sanitized_ssn = '';
                                    for($i = 0; $i < strlen($ssn); $i++) {
                                        if($i < (strlen($ssn) - 4)) { $sanitized_ssn .= '*'; }
                                        else { $sanitized_ssn .= $ssn[$i]; }
                                    }
                                    $result->call = str_replace($ssn, $sanitized_ssn, $result->call);
                                }
                            }
                    }
                    //set time in more readable format 
                    if($result->call_date){ $result->call_date = date('m/d/Y h:i:s A',$result->call_date); }
                }
            }
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc_sql;
        $data['adhoc_report_type'] = "Requests";
        $data['adhoc_report_destination_page'] = $destination_page;
        $data['adhoc_report_items_per_page'] = $items_per_page;
        
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        //if exported
        if ($export){ 
            if (!empty($response_export)){ $responses_list = $response_export_list; }
            else { $responses_list = $responses_list; }
            //Remove Row value from export
            foreach ($responses_list as $key) {
                unset($key->row);
            }
            $this->export(array('ID','Application','Call','Date ('.$data['timezone_abbr'].')','Response Code','Response'),$responses_list,$export_file_name,$items,$between,$selected,null); 
        }
        else if($export_pdf) {
            if(!empty($response_export)) { $data['export_request_list'] = $response_export_list; }
            else { $data['request_list'] = $responses_list; }
            $html = $this->load->view('api/reports/result_tables/result_requests', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        }
        else if($print_page == 1) {
            if (!empty($response_export)){ 
                $data['export_request_list'] = $response_export_list; 
            } 
            $this->clear_cache();
            $data['print_page'] = true;
            $form_data['page_select'] = $destination_page;
            $this->load->view('api/reports/requests', $data);
        } 
        //display on page
        else { $this->load->view('api/reports/requests', $data); }
    }
    
    //function for tickets report
    public function report_tickets($adhoc_report_id){
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("tickets_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected=null;
    
        if(!$data['show']['reports']) { show_error('Forbidden',403);  }
        $category = $this->input->post('ticket_category',TRUE);//gets select ticket category
        $export_file_name = $this->input->post('export_file_name',TRUE);
        
        if($category){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                    'category_id' => ($category),
            );
                
            $items = array(
                    'id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                    'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                    'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
            );
            $extra_items = array(
                    'id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                    'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                    'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
                    'user_id' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
            );
            $open_start_date = $this->input->post('open_start_date',TRUE);
            $open_end_date = $this->input->post('open_end_date',TRUE);
            $close_start_date = $this->input->post('close_start_date',TRUE);
            $close_end_date = $this->input->post('close_end_date',TRUE);
            //$date_array = array($open_start_date, $open_end_date, $close_start_date, $close_end_date);
            //$date_warning_message = $this->get_date_filter_validation_message($date_array);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($open_start_date, $open_end_date);
            $date_warning_message .= $this->get_paired_dates_filter_validation_message($close_start_date, $close_end_date);

            $between = array(
                    'open_date' => $this->check_paired_dates($open_start_date,$open_end_date),
                    'close_date' => $this->check_paired_dates($close_start_date,$close_end_date),
            );

            $typesearch = array (
                    'user_id' => array(
                            'typesql' => null,
                            'name' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
                            'type' => 3
                    )
            );
            
            //get direction (desc/asc)and if it is being exported
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = 0;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
            $order = $this->input->post('order',TRUE);
            
            //calls helper to get data
            $response = $this->reports_helper('tickets',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
            $responses_list = $response['response'];
            
            //Adhoc_Report
            $response_adhoc = $this->reports_helper_adhoc('tickets',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            
            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['open_end_date'] = $this->reports_correct_out_of_bound_date($open_end_date);
            $form_data['open_start_date'] = $this->reports_correct_out_of_bound_date($open_start_date);
            $form_data['close_end_date'] = $this->reports_correct_out_of_bound_date($close_end_date);
            $form_data['close_start_date'] = $this->reports_correct_out_of_bound_date($close_start_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
        
            
            if($selector['category_id'] != '(ALL)') $selected = 'Category: ' . $this->ticketcategorymodel->get_category($selector['category_id'])->result()[0]->category;
            //ExportPDF-PRINT
            $response_export = $this->reports_helper('tickets',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$size);
            $response_export_list = $response_export['response'];
            $data['filters'] = $this->export_info($extra_items,$between,$selected,null);
        
        } else if($adhoc_report_id != ''){
            /*Adhoc Reports Starts Here....*/
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }    
            /*Adhoc Reports Starts Here....*/
            $adhoc_report_data = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"tickets")->result();
        
            //Diff time period
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report_data[0]->report_time_field;
            
            $time_start_check = $adhoc_report_data[0]->report_start_date;
            $time_end_check = $adhoc_report_data[0]->report_end_date;
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;

            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report_data[0]->report_query_generator;
                
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);    
                
                //Date information
                $items = array();
                $open_start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $open_end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report_data[0]->report_query_generator;
                
                //Date information
                $items = array();
                $open_end_date = $adhoc_report_data[0]->report_end_date;
                $open_start_date = $adhoc_report_data[0]->report_start_date;
            }
            //Selector
            $selector = array(
                    'category_id' => ($adhoc_report_data[0]->report_selector),
            );

            $between = array(
                    'open_date' => $this->check_paired_dates($open_start_date,$open_end_date)
            );
            
            if($adhoc_report_data[0]->report_selector != '(all)'){
                $form_data['ticket_category'] = $adhoc_report_data[0]->report_selector;
            } else {
                $form_data['ticket_category'] = "";
            }

            //Date Format
            //$date_array = array($open_end_date, $open_start_date);
            $date_warning_message = get_paired_dates_filter_validation_message($open_start_date, $open_end_date);

            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report_data[0]->report_order_by;
            $dir = $adhoc_report_data[0]->report_order_by_direction;
    
            $items = array(
                    'id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                    'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                    'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
            );
            $extra_items = array(
                    'id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                    'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                    'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
                    'user_id' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
            );
            
            $typesearch = array (
                    'user_id' => array(
                            'typesql' => null,
                            'name' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
                            'type' => 3
                    )
            );
            
            //calls helper to get data
            $size = $this->ticketsmodel->get_filtered_size($sql)->result();
            $size = $size[0]->count;
            $response = $this->ticketsmodel->get_tickets_filter_export($sql,$order)->result();
            
            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['open_end_date'] = $this->reports_correct_out_of_bound_date($open_end_date);
            $form_data['open_start_date'] = $this->reports_correct_out_of_bound_date($open_start_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = 1;
            $form_data['date_warning_message'] = $date_warning_message;
            $response_adhoc = $response;
            
            
            $data['filters'] = $this->export_info($extra_items,$between,$selected,null);
            
            $responses_list = $response;
            
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = 0;
            
            $data['is_export'] = $is_export;
            
            $response_export_list = $this->ticketsmodel->get_tickets_filter_export($sql,$order)->result();
            
            if($selector['category_id'] != '(all)') $selected = 'Category: ' . $this->ticketcategorymodel->get_category($selector['category_id'])->result()[0]->category;
            $data['filters'] = $this->export_info($extra_items,$between,$selected,null);
        } else {
        //if this is the first time you have loaded the page
            $responses_list = $this->ticketsmodel->get_first_responses($items_per_page)->result();//gets first page
            //set defaults
            $form_data = array(
                 'direction' => 'DESC',
                 'order' => 'open_date',
                 'cur_page' => '1',
            );
            //get number of items in log
            $size = $this->ticketsmodel->get_size()->result();
            $size = $size[0]->count;
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            
        //Adhoc Report
            $between = "";
            $response_adhoc = "";
            $dir = "DESC";    
            $order = "open_date";
            $data['filters'] = ' ';
        }
        
        //Adhoc Report
        $data['adhoc_report_between'] = array($between);
        $data['adhoc_report_order'] = $order;            
        $data['adhoc_report_direction'] = $dir; 
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "Tickets";
        
        //set options for comparing
        $data['compare'] = array(
                'equals' => 'Equals',
                'contains' => 'Contains',
                'starts' => 'Starts With',
                'ends' => 'Ends With'
        );
    
        //pagination setup
        $pages->items_total = $size;
        $pages->current_page = $destination_page;
        $pages->paginate();
        $form_data['pagination_bar'] = $pages->display_pages();
        $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
    
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
        else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
    
        $form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
        $form_data['items_per_page'] = $items_per_page;
        $form_data['pages'] = $pages;
        $data['form_data'] = $form_data;
        $data['categories'] = $this->ticketcategorymodel->get_categories()->result(); //gets all categories available
        $data['ticket_list'] = $responses_list;
        
        foreach($responses_list as $result) {
            
            //pull username from system (user type is 3)
            if ($result->user_id){
                $value = $this->id_to_name(3,$result->user_id);
                $result->user_id = $value['id'];
            }
            
            //pull category name from system (category type is is 5)
            if ($result->category_id){
                $value = $this->id_to_name(5,$result->category_id);
                $result->category_id = $value['id'];
            }
            
            //set time in more readable format
            if($result->open_date){ $result->open_date = date('m/d/Y h:i:s A',$result->open_date); }
            if($result->close_date){ $result->close_date = date('m/d/Y h:i:s A',$result->close_date); }
        }
        
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        //if export
        if($export){
            $this->export(array('ID','Parent','User','Message','Open Date ('.$data['timezone_abbr'].')','Close Date ('.$data['timezone_abbr'].')','Category'),$responses_list,$export_file_name,$extra_items,$between,$selected,null); 
        }
        else if($export_pdf) {
            if (!empty($response_export)){
                $data['ticket_list'] = $response_export_list;
            } else {
                $data['ticket_list'] = $responses_list;
            }
            foreach($data['ticket_list'] as $result) {
            //pull username from system (user type is 3)
            if ($result->user_id){
                $value = $this->id_to_name(3,$result->user_id);
                $result->user_id = $value['id'];
            }
            //pull category name from system (category type is is 5)
            if ($result->category_id){
                $value = $this->id_to_name(5,$result->category_id);
                $result->category_id = $value['id'];
            }
            //set time in more readable format
            if($result->open_date){ $result->open_date = date('m/d/Y h:i:s A',$result->open_date); }
            if($result->close_date){ $result->close_date = date('m/d/Y h:i:s A',$result->close_date); }
            }
            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_tickets', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        }
        /* else if($print_page) {
            $this->clear_cache();
            if (!empty($response_export)){
                $data['ticket_list'] = $response_export_list;
            } else {
                $data['ticket_list'] = $responses_list;
            }
            foreach($data['ticket_list'] as $result) {
            //pull username from system (user type is 3)
            if ($result->user_id){
                $value = $this->id_to_name(3,$result->user_id);
                $result->user_id = $value['id'];
            }
            //pull category name from system (category type is is 5)
            if ($result->category_id){
                $value = $this->id_to_name(5,$result->category_id);
                $result->category_id = $value['id'];
            }
            //set time in more readable format
            if($result->open_date){ $result->open_date = date('m/d/y h:i:s A',$result->open_date); }
            if($result->close_date){ $result->close_date = date('m/d/y h:i:s A',$result->close_date); }
            }
            $data['print_page'] = true;
            $this->load->view('api/reports/result_tables/result_tickets', $data);
        } */
        else{
            $this->load->view('api/reports/tickets', $data);
        }
    }
    
    //function for events report
    public function report_events($adhoc_report_id){
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("events_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $response_export_list = $event_list = array();
        $selected = array();
        
        if(!$data['show']['reports']) { show_error('Forbidden',403); }
        $target_type = $this->input->post('target_type',TRUE);//gets selected 
        $export_file_name = $this->input->post('export_file_name',TRUE);
        //if $adhoc_report_id is not empty, do adhoc report
        if($adhoc_report_id != ''){
        /*Adhoc Reports Starts Here....*/
        //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"events")->result();
            //Diff time period
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;
            $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
            $time_start_check = $selected_filter_array['start_date'];
            $time_end_check = $selected_filter_array['end_date'];
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
        
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator = $adhoc_report[0]->report_query_generator;
        
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
        
                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
        
                //Date information
                $end_date = $selected_filter_array['end_date'];
                $start_date = $selected_filter_array['start_date'];
            }
            //Selector
            $selector = array(
                'success' =>  $selected_filter_array['successful'],
            );
            
            $items = array(
                'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
                'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
            );
            $extra_items = array(
                'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
                'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
                'actor' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
                'target' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
            );
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            
            $between = array(
                'event_date' => $this->check_paired_dates($start_date,$end_date),
            );
            
            $typesearch = array (
                'actor_id'    => array (
                    'typesql' => 'actor_type',
                    'name' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
                    'type' => $selected_filter_array['acting_type'],        
                ),
                'target_id' => array(
                    'typesql' => 'target_type',
                    'name' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
                    'type' => $selected_filter_array['target_type'],
                ),
            );
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
                
            //get direction and if it is supported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;
            $page = 1;
            $destination_page = $selected_filter_array['adhoc_report_destination_page'];
            $items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
            $pages->items_per_page = $items_per_page;
            //$start = (($destination_page-1)*$items_per_page)+1;
            
            //Get Size    
            $size = $this->eventmodel->get_filted_size($sql)->result();
            $size = $size[0]->count;
            
            //Get Event List    
            $event_list = $this->eventmodel->get_event_filter($sql,$order,$page,$items_per_page)->result();

            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('event',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,$export,$items_per_page);
            //For ExportPDF, PRINT
            if($is_export === 'print' || $is_export === 'pdf') {
                $response_export = $this->reports_helper('event',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($extra_items, $between, $selected, null);
            }
            
            //set form data
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $form_data['successful'] = $selected_filter_array['successful'];
            $form_data['event_id'] = $selected_filter_array['event_id'];
            $form_data['event_id_type'] = $selected_filter_array['event_id_type'];
            $form_data['action'] = $selected_filter_array['action'];
            $form_data['action_type'] = $selected_filter_array['action_type'];
            $form_data['acting_type'] = $selected_filter_array['acting_type'];
            $form_data['target_type'] = $selected_filter_array['target_type'];
            $form_data['acting_user'] = $selected_filter_array['acting_user'];
            $form_data['acting_user_type'] = $selected_filter_array['acting_user_type'];
            $form_data['target_user'] = $selected_filter_array['target_user'];
            $form_data['target_user_type'] = $selected_filter_array['target_user_type'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
        }
        else if($target_type){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                'success' =>  $this->input->post('successful',TRUE),
            );
            
            $items = array(
                'id' => $this->search_type($this->input->post('event_id',TRUE),$this->input->post('event_id_type',TRUE)),
                'action' => $this->search_type($this->input->post('action',TRUE),$this->input->post('action_type',TRUE)),
            );
            $extra_items = array(
                'id' => $this->search_type($this->input->post('event_id',TRUE),$this->input->post('event_id_type',TRUE)),
                'action' => $this->search_type($this->input->post('action',TRUE),$this->input->post('action_type',TRUE)),
                'actor' => $this->search_type($this->input->post('acting_user',TRUE),$this->input->post('acting_user_type',TRUE)),
                'target' => $this->search_type($this->input->post('target_user',TRUE),$this->input->post('target_user_type',TRUE)),
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date= $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            
            $between = array(
                'event_date' => $this->check_paired_dates($start_date,$end_date),
            );
            
            $typesearch = array (
                'actor_id'    => array (
                    'typesql' => 'actor_type',
                    'name' => $this->search_type($this->input->post('acting_user',TRUE),$this->input->post('acting_user_type',TRUE)),
                    'type' => $this->input->post('acting_type',TRUE),        
                ),
                'target_id' => array(
                    'typesql' => 'target_type',
                    'name' => $this->search_type($this->input->post('target_user',TRUE),$this->input->post('target_user_type',TRUE)),
                    'type' => $this->input->post('target_type',TRUE),
                ),
            );
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
            //get direction and if it is supported
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $order = $this->input->post('order',TRUE);
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;
            
            //get data
            $response = $this->reports_helper('event',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,$export,$items_per_page);
            $event_list = $response['response'];
            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('event',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,$export,$items_per_page);
            
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
            if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
            else if(mb_strtoupper($selector['success']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Success: False'); }
            if(isset($typesearch['actor_id']['type']) && mb_strtoupper($typesearch['actor_id']['type']) == '(ALL)') array_push($selected, null);
            else { array_push($selected, 'Actor Type: '. $this->get_type($typesearch['actor_id']['type'])); }
            if(isset($typesearch['target_id']['type']) && mb_strtoupper($typesearch['target_id']['type']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Target Type: '. $this->get_type($typesearch['target_id']['type'])); }
            
            //For ExportPDF, PRINT
            if($is_export === 'print' || $is_export === 'pdf') {
                $response_export = $this->reports_helper('event',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($extra_items, $between, $selected, null);
            }
        }
        else { //if this is the first time you have loaded the page (ie no filters have fields)
            $event_list = $this->eventmodel->get_first_events($items_per_page)->result();
            //set defaults
            $form_data = array(
             'direction' => 'DESC',
             'order' => 'event_date',
             'cur_page' => '1',
            );
            //get number of items in log
            $size = $this->eventmodel->get_size()->result();
            $size = $size[0]->count;
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            //Adhoc Report
            $between = array ("event_date" => Array("start"=>"", "end" =>""));
            $response_adhoc_sql = " 0=0 AND id like '%' ";
            $dir = "DESC";
            $order = "event_date";
            //initiate form data for adhoc report
            $form_data['successful'] = '(ALL)';
            $form_data['event_id'] = '';
            $form_data['event_id_type'] = '';
            $form_data['action'] = '';
            $form_data['action_type'] = '';
            $form_data['target_user'] = '';
            $form_data['target_user_type'] = '';
            $form_data['acting_user'] = '';
            $form_data['acting_user_type'] = '';
            $form_data['target_type'] = '(ALL)';
            $form_data['acting_type'] = '(ALL)';
            $form_data['start_date'] = '';
            $form_data['end_date'] = '';
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
            'equals' => 'Equals',
            'contains' => 'Contains',
            'starts' => 'Starts With',
            'ends' => 'Ends With'
        );
        
        //pagination setup
        $pages->items_total = $size;
        $pages->current_page = $destination_page;
        $pages->paginate();
        $form_data['pagination_bar'] = $pages->display_pages();
        $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
        
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
        else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
        
        $form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
        $form_data['items_per_page'] = $items_per_page;
        $form_data['pages'] = $pages;
        $data['form_data'] = $form_data;
        $data['event_list'] = $event_list;
        
        //loop through both export and normal responses to report query to convert values as needed
        $lists = array($event_list, $response_export_list);
        foreach($lists as $list) {
            if(isset($list)) {
                foreach($list as $event) {
                    //converts actor and target ids into their display names
                    $value = $this->id_to_name($event->actor_type,$event->actor_id);
                    $event->actor_type=$value['type'];
                    $event->actor_id=$value['id'];
                    $value = $this->id_to_name($event->target_type,$event->target_id);
                    $event->target_type=$value['type'];
                    $event->target_id=$value['id'];
                    //changes success integer into true, false or unauth
                    if($event->success === 1) { $event->success = 'TRUE'; }
                    else if($event->success === 2){ $event->success = 'UNAUTH'; }
                    else{ $event->success = 'FALSE'; }
                    
                    //change date into readable
                    $event->event_date = date('m/d/Y h:i:s A',$event->event_date);
                }
            }
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc_sql;
        $data['adhoc_report_type'] = "Events";
        $data['adhoc_report_destination_page'] = $destination_page;
        $data['adhoc_report_items_per_page'] = $items_per_page;
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        //if export
        if($export){
            $this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$event_list,$export_file_name,$extra_items,$between,$selected,null);
        }
        else if($export_pdf) {
            if (!empty($response_export)) { 
                $data['export_event_list'] = $response_export_list; 
            } 
            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_events', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        } 
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($response_export)){ 
                $data['export_event_list'] = $response_export_list;
            }
            $data['print_page'] = true;
            $form_data['page_select'] = $destination_page;
            $this->load->view('api/reports/events', $data);
        } 
        else{
            $this->load->view('api/reports/events', $data);
        }

    }
    
    
    //function for mail report
    public function report_mail($adhoc_report_id){
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("mail_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $response_list = $response_export_list = array();
        $selected = array();
        
        if(!$data['show']['reports']) { show_error('Forbidden',403); }
        $successful = $this->input->post('sender_type',TRUE);//gets selected 
        $export_file_name = $this->input->post('export_file_name',TRUE);
        
        if($successful){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                'success' =>  $this->input->post('successful',TRUE),
                'mdn' =>  $this->input->post('mdn',TRUE),
                'inbound_outbound' => $this->input->post('bound',TRUE),
                'protected_data' => $this->input->post('protected_data',TRUE),
                
            );
            
            $items = array(
                'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
                'size'=>$this->search_type($this->input->post('file_size',TRUE),$this->input->post('file_size_type',TRUE)),
                'attachment_types'=>$this->search_type($this->input->post('attachment_type',TRUE),$this->input->post('attachment_type_type',TRUE)),
                'sender'=>$this->search_type($this->input->post('sender',TRUE),$this->input->post('sender_type',TRUE)),
                'recipient'=>$this->search_type($this->input->post('recipient',TRUE),$this->input->post('recipient_type',TRUE)),
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            
            $between = array(
                'time' => $this->check_paired_dates($start_date,$end_date)
            );

            $typesearch = array (
            );
            
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;
            
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $order = $this->input->post('order',TRUE);
            $response = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,$export,$items_per_page);
            //Set new Adhoc query with new filters
            $response_adhoc = $this->reports_helper_adhoc('mail',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
            $event_list = $response['response'];
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
            if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
            else if($selector['success'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Success: False'); }
            if($selector['mdn'] == 1) { array_push($selected, 'MDN: True'); }
            else if($selector['mdn'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'MDN: False'); }
            if($selector['protected_data'] == 1) { array_push($selected, '7332 Protected Data: True'); }
            else if($selector['protected_data'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, '7332 Protected Data: False'); }
            if($selector['inbound_outbound'] == 1) { array_push($selected, 'Direction: Inbound'); }
            else if($selector['inbound_outbound'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Direction: Outbound'); }
            //For ExportPDF, PRINT
            if($is_export) {
                $response_export = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
        } else if ($adhoc_report_id != ''){
            /*Adhoc Report - Starts Here*/
            
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "mail")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = str_replace('%', '###', $adhoc_report[0]->report_selector);
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);
            $successful = $filters_used['successful'];
        
            //Different time perios for adhoc report
            $diff_time_period =  $this->input->post('time_period',TRUE);
            
            //Get Date information
            $time_period_field = $adhoc_report[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
            
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;
                
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);    
                
                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
                
                //Date information
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
            }
            
            //Assign data to report fields 
            $selector = array(
                'success' =>  $filters_used['successful'],
                'mdn' =>  $filters_used['mdn'],
                'inbound_outbound' => $filters_used['bound'],
                'protected_data' =>  $filters_used['protected_data'],
            );
            
            $items = array(
                'id' => $this->search_type($filters_used['id'],$filters_used['id_type']),
                'size'=>$this->search_type($filters_used['file_size'],$filters_used['file_size_type']),
                'attachment_types'=>$this->search_type($filters_used['attachment_type'],$filters_used['attachment_type_type']),
                'sender'=>$this->search_type($filters_used['sender'],$filters_used['sender_type']),
                'recipient'=>$this->search_type($filters_used['recipient'],$filters_used['recipient_type']),
            );
            
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            
            $between = array(
                'time' => $this->check_paired_dates($start_date,$end_date)
            );
            
            $typesearch = array (
            );
            
            $items_per_page = $filters_used['items_per_page'];
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            
            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;
            
            $dir = $adhoc_report[0]->report_order_by_direction; 
            $export = false;
            $order = $adhoc_report[0]->report_order_by;
            $page=1;
            $responses_list = $this->mailmodel->get_mail_filter($sql,$adhoc_report[0]->report_order_by . " " . $dir,$this->db->escape($page),$items_per_page)->result();    
            $event_list = $responses_list;                
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            
            $size = $this->mailmodel->get_filted_size($sql)->result();
            $size = $size[0]->count;
            if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
            else if(mb_strtoupper($selector['success']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Success: False'); }
            if($selector['mdn'] == 1) { array_push($selected, 'MDN: True'); }
            else if(mb_strtoupper($selector['mdn']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'MDN: False'); }
            if($selector['inbound_outbound'] == 1) { array_push($selected, 'Direction: Inbound'); }
            else if(mb_strtoupper($selector['inbound_outbound']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Direction: Outbound'); }
            
            //For ExportPDF, PRINT
            if($is_export) {
                $response_export = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$adhoc_report[0]->report_order_by,$dir,$destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
            $response_adhoc = $this->reports_helper_adhoc('mail',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
            $form_data['order'] = $order;
            //set form filters
            $form_data['id'] = $filters_used['id'];        
            $form_data['successful'] = $filters_used['successful'];
            $form_data['mdn'] = $filters_used['mdn'];
            $form_data['id_type'] = $filters_used['id_type'];
            $form_data['bound'] = $filters_used['bound'];
            $form_data['protected_data'] = $filters_used['protected_data'];
            $form_data['sender'] = $filters_used['sender'];
            $form_data['recipient_type']= $filters_used['recipient_type'];
            $form_data['recipient']= $filters_used['recipient'];
            $form_data['sender_type'] = $filters_used['sender_type'];
            $form_data['file_size'] = $filters_used['file_size'];
            $form_data['file_size_type'] = $filters_used['file_size_type'];
            $form_data['attachment_type'] =$filters_used['attachment_type'];
            $form_data['attachment_type_type'] = $filters_used['attachment_type_type'];
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] =  $start_date;
            $data['form_data'] = $form_data;
            
            
        } else{//if this is the first time you have loaded the page (ie no filters have fields)
            $event_list = $this->mailmodel->get_first_mail($items_per_page)->result();
            //set defaults
            $form_data = array(
             'direction' =>'DESC',
             'order'=>'time',
             'cur_page'=>'1',
             'bound'=>'(ALL)',
             'success'=>'(ALL)',
            );
            $dir = "DESC";
            $order = "time";
            //get number of items in log
            $size = $this->mailmodel->get_size()->result();
            $size = $size[0]->count;
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            
            //Adhoc Report
            $between = array ("time" => Array("start"=>"", "end" =>""));
            $response_adhoc = "0=0";

            //set blank filters    
            $form_data['mdn'] = "(ALL)";
            $form_data['id'] = "";            
            $form_data['id_type'] = "";
            $form_data['bound'] = "(ALL)";
            $form_data['protected_data'] = "(ALL)";
            $form_data['sender'] = "";
            $form_data['recipient_type']= "";
            $form_data['recipient']= "";
            $form_data['sender_type'] = "";
            $form_data['file_size'] = "";
            $form_data['file_size_type'] = "";
            $form_data['attachment_type'] = "";
            $form_data['attachment_type_type'] = "";
            $form_data['start_date'] = "";
            $form_data['end_date'] = "";
            $form_data['successful'] = "(ALL)";
            $data['form_data'] = $form_data;
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
            'equals' => 'Equals',
            'contains' => 'Contains',
            'starts' => 'Starts With',
            'ends' => 'Ends With'
        );
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;            
        $data['adhoc_report_direction'] = $order; 
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "mail";
        
        //pagination setup
        $pages->items_total = $size;
        $pages->current_page = $destination_page;
        $pages->paginate();
        $form_data['pagination_bar'] = $pages->display_pages();
        $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
        
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
        }
        
        $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
        $form_data['items_per_page'] = $items_per_page;
        $form_data['pages'] = $pages;
        $data['form_data'] = $form_data;
        $data['event_list'] = $event_list;

        //converts application's numbers into their names
        $lists = array($event_list, $response_export_list);
        foreach($lists as $list) {
            if(isset($list)) {
                foreach($list as $event) {
                    //get the recipients and convert to array
                    $event->recipient=$this->json->decode($event->recipient);
                    $recip = '';
                    if(isset($event->recipient)){
                        foreach($event->recipient as $key =>$value){
                            //for all items after the first
                            if($key > 0) {
                                //if export make them comma separated 
                                if($export) { $recip .= ', '; }
                                //else when in view make each email on a line
                                else { $recip.= "\n"; }
                            }
                            $recip .= $value; //add email
                        }
                    }
                    $event->recipient = nl2br(htmlentities($recip));
                    $event->sender = htmlentities($event->sender);
                    
                    //binary true/false into text
                    if($event->success) { $event->success = 'TRUE'; }
                    else { $event->success = 'FALSE'; }
                    
                    //binary mdn into text
                    if($event->mdn) { $event->mdn = 'TRUE'; }
                    else { $event->mdn = 'FALSE'; }
                    
                    //binary 7332 into text
                    if($event->protected_data) { $event->protected_data = 'TRUE'; }
                    else if($event->protected_data === 0) { $event->protected_data = 'FALSE'; }
                    else{ $event->protected_data = 'N/A'; }
                    
                    //binary inbound/outbound into text
                    if($event->inbound_outbound){ $event->inbound_outbound = 'Inbound'; }
                    else { $event->inbound_outbound = 'Outbound'; }
                    //print_r ($event->time);
                    //time in readable format
                    $event->time = date("m/d/Y h:i:s A",$event->time);
                }
            }
        }
        
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        if($export){
            #TODO - This horrible, horrible hack is necessary because the export function exports columns based on the order they exist in the object
            #so we have to reorder the event_list objects using a copy of the list that puts the columns in the right order. FIX THIS EVENTUALLY!
            for($i = 0; $i < count($event_list); $i++) {
                $event_list_copy = new StdClass();
                $event_list_copy->id = $event_list[$i]->id;
                $event_list_copy->sender = $event_list[$i]->sender;
                $event_list_copy->recipient = $event_list[$i]->recipient;
                $event_list_copy->size = $event_list[$i]->size;
                $event_list_copy->attachment_types = $event_list[$i]->attachment_types;
                $event_list_copy->time = $event_list[$i]->time;
                $event_list_copy->inbound_outbound = $event_list[$i]->inbound_outbound;
                $event_list_copy->mdn = $event_list[$i]->mdn;
                $event_list_copy->success = $event_list[$i]->success;
                $event_list_copy->protected_data= $event_list[$i]->protected_data;
                $event_list[$i] = $event_list_copy;
            }
            $this->export(array('ID','Sender','Recipient','Size(KB)','Attachment Type','Date ('.$data['timezone_abbr'].')','Direction', 'MDN','Success', '7332'),$event_list,$export_file_name,$items,$between,$selected,null);
        } 
        else if($export_pdf){
            if (!empty($response_export)){ $data['export_mail_list'] = $response_export_list; } 
            $report_content = $this->input->post('report_content',FALSE);
            $html = $this->load->view('api/reports/result_tables/result_mail', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        } 
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($response_export)){ 
                $data['export_mail_list'] = $response_export_list; 
            }
            $data['print_page'] = true;
            $form_data['page_select'] = $destination_page;
            $this->load->view('api/reports/mail', $data);
        } 
        else {
            $this->load->view('api/reports/mail', $data);
        }

    }

    //function for logins report
    public function report_logins($adhoc_report_id){
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("logins_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected = null;
    
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $id_type = $this->input->post('id_type',TRUE); //gets selected
        $export_file_name = $this->input->post('export_file_name',TRUE);
        
        if($id_type) { // This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                    'success' =>  $this->input->post('successful',TRUE),
            );
                
            $items = array(
                    'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
                    'session_id'=>$this->search_type($this->input->post('session_id',TRUE),$this->input->post('session_id_type',TRUE)),
                    'ip_address'=>$this->search_type($this->input->post('ip_address',TRUE),$this->input->post('ip_address_type',TRUE)),
                    'error_msg'=>$this->search_type($this->input->post('message',TRUE),$this->input->post('message_type',TRUE)),
                    'org_id'=>$this->search_type($this->input->post('org_id',TRUE),$this->input->post('org_id_type',TRUE)),
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
                
            $between = array(
                    'login_time' => $this->check_paired_dates($start_date,$end_date)
            );


            $typesearch = array (
                    'org_id' => array(
                            'typesql' => '',
                            'name' => $this->search_type($this->input->post('username',TRUE),$this->input->post('username_type',TRUE)),
                            'type' => 5
                    )
            );
            //get direction and if exported
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $order = $this->input->post('order',TRUE);
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
    
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
                
            //get data
            $response = $this->reports_helper('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
            $login_list = $response['response'];
            $response_adhoc = $this->reports_helper_adhoc('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$items_per_page);
                
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
            if ($selector['success']==1) $selected='Success: True';
            elseif ($selector['success']!='(ALL)') $selected='Success: False';
                
            //ExportPDF-PRINT
            if($is_export) {
                $response_export = $this->reports_helper('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
        } else if ($adhoc_report_id != ''){
            /*Adhoc Report - Starts Here*/
            
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "logins")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = str_replace('%', '###', $adhoc_report[0]->report_selector);
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);
    
            $successful = $filters_used['successful'];
    
            //From Adhoc Form
            $diff_time_period =  $this->input->post('time_period',TRUE);
                
            //Get Date information
            $time_period_field = $adhoc_report[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];
                
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
    
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;
    
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
    
                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
    
                //Date information
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
            }
            //adds each component type into its own json
            $selector = array(
                    'success' =>  $filters_used['successful'],
            );
                
            $items = array(
                    'id' => $this->search_type($filters_used['id'],$filters_used['id_type']),
                    'session_id'=>$this->search_type($filters_used['session_id'],$filters_used['session_id_type']),
                    'ip_address'=>$this->search_type($filters_used['ip_address'],['ip_address_type']),
                    'error_msg'=>$this->search_type($filters_used['message'],$filters_used['message_type']),
                    'org_id'=>$this->search_type($filters_used['org_id'],$filters_used['org_id_type']),
            );
                
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
                
            $between = array(
                    'login_time' => $this->check_paired_dates($start_date,$end_date)
            );
            $typesearch = array (
                    'org_id' => array(
                            'typesql' => '',
                            'name' => $this->search_type($filters_used['username'],$filters_used['username_type']),
                            'type' => 5
                    )
            );
            //get direction and if exported
            $dir = $adhoc_report[0]->report_order_by_direction;
            $order = $adhoc_report[0]->report_order_by;
                
                
            $items_per_page = $filters_used['items_per_page'];
    
            $page = 1;
    
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
    
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export; 
                
            //get data
            $size = $this->loginsmodel->get_filted_size($sql)->result();
            $size = $size[0]->count;
    
                
            if(string_contains('user_id', $order)){//ordered by user id
                $responses_list= $this->loginsmodel->get_login_filter_user_order($sql,$order.' '.$dir,$this->db->escape($page),$items_per_page)->result();
            }
            else{
                $responses_list= $this->loginsmodel->get_login_filter($sql,$order.' '.$dir,$this->db->escape($page),$items_per_page)->result();
            }
                
            $login_list = $responses_list;
            $response_adhoc = $sql;
                
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['id'] = $filters_used['id'];
            $form_data['id_type'] = $filters_used['id_type'];
            $form_data['username'] = $filters_used['username'];
            $form_data['username_type'] = $filters_used['username_type'];
            $form_data['session_id']= $filters_used['session_id'];
            $form_data['session_id_type']= $filters_used['session_id_type'];
            $form_data['ip_address'] = $filters_used['ip_address'];
            $form_data['ip_address_type'] = $filters_used['ip_address_type'];
            $form_data['message'] = $filters_used['message'];
            $form_data['message_type'] = $filters_used['message_type'];
            $form_data['org_id'] = $filters_used['org_id'];
            $form_data['org_id_type'] = $filters_used['org_id_type'];
            $form_data['start_date'] = $start_date;
            $form_data['end_date'] = $end_date;
            $form_data['successful'] = $filters_used['successful'];
                
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
                
            //ExportPDF-PRINT
            if($is_export) {
                $response_export = $this->reports_helper('login',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items, $between, $selected, null);
            }
            $data['form_data'] = $form_data;
            
            if ($selector['success']==1) $selected='Success: True';
            elseif ($selector['success']!='(ALL)') $selected='Success: False';
    
        } else { //if this is the first time you have loaded the page (ie no filters have fields)
            $login_list = $this->loginsmodel->get_first_logins($items_per_page)->result();
            //set defaults
            $form_data = array(
                 'direction' => 'DESC',
                 'order' => 'login_time',
                 'cur_page' => '1'
            );
            //get number of items in log
            $size = $this->loginsmodel->get_size()->result();
            $size = $size[0]->count;
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
                
            //Adhoc Report
            $between = array ("login_time" => Array("start"=>"", "end" =>""));
            $response_adhoc = "0=0";
            $dir = "DESC";
            $order = "login_time";
            //set blank filters
            $form_data['id'] = "";
            $form_data['id_type'] = "";
            $form_data['username'] = "";
            $form_data['username_type'] = "";
            $form_data['session_id']= "";
            $form_data['session_id_type']= "";
            $form_data['ip_address'] = "";
            $form_data['ip_address_type'] = "";
            $form_data['message'] = "";
            $form_data['message_type'] = "";
            $form_data['org_id'] = "";
            $form_data['org_id_type'] = "";
            $form_data['start_date'] = "";
            $form_data['end_date'] = "";
            $form_data['successful'] = "(ALL)";
            $data['form_data'] = $form_data;
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
                'equals' => 'Equals',
                'contains' => 'Contains',
                'starts' => 'Starts With',
                'ends' => 'Ends With',
        );
    
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "logins";
    
        //pagination setup
        $pages->items_total = $size;
        $pages->current_page = $destination_page;
        $pages->paginate();
        $form_data['pagination_bar'] = $pages->display_pages();
        $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
    
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>';
        }
    
        $form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
        $form_data['items_per_page'] = $items_per_page;
        $form_data['pages'] = $pages;
        $data['form_data'] = $form_data;
        $data['login_list'] = $login_list;
        //converts application's numbers into their names
        foreach($login_list as $login) {
            //convert org id to username
            $login->username=$this->usersmodel->get_username_from_org_id($login->org_id);
            //get binary true/false into text
            if($login->success === 1) { $login->success = 'TRUE'; }
            else { $login->success = 'FALSE'; }
            //convert data into readable formant.
            $login->login_time = date('m/d/Y h:i:s A',$login->login_time);
                
        }
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        
        //if export
        if($export){    
            $this->export(array('ID','Username','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Message','Org ID','Success'),$login_list,$export_file_name,$items,$between,$selected,null);
        }else if($export_pdf) {
            if (!empty($response_export)){
                $data['export_login_list'] = $response_export_list;
            } /* else {
                $data['login_list'] = $login_list;
            } */
            foreach($data['export_login_list'] as $login) {
                //convert org id to username
                $login->username = $this->usersmodel->get_username_from_org_id($login->org_id);
                //get binary true/false into text
                if($login->success === 1) { $login->success = 'TRUE'; }
                else { $login->success = 'FALSE'; }
                //convert data into readable formant.
                $login->login_time = date('m/d/Y h:i:s A',$login->login_time);
            }
            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_logins', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        }
        /* else if($print_page) {
            $this->clear_cache();
            if (!empty($response_export)){
                $data['login_list'] = $response_export_list;
            } else {
                $data['login_list'] = $login_list;
            }
            foreach($data['login_list'] as $login) {
                //convert org id to username
                $login->user_id=$this->usersmodel->get_username_from_org_id($login->org_id);
                //get binary true/false into text
                if($login->success === 1) { $login->success = 'TRUE'; }
                else { $login->success = 'FALSE'; }
                //convert data into readable formant.
                $login->login_time = date('m/d/y h:i:s A',$login->login_time);
            }
            $data['print_page'] = true;
            //$this->load->view('api/reports/result_tables/result_logins', $data);
            $this->load->view('api/reports/logins', $data);
        } */ 
        else if($print_page == 1) {
                $this->clear_cache();
                if (!empty($response_export)){
                    $data['export_login_list'] = $response_export_list;
                } 
                //$data['login_list'] = $login_list;
                
                foreach($data['export_login_list'] as $login) {
                    //convert org id to username
                    $login->username=$this->usersmodel->get_username_from_org_id($login->org_id);
                    //get binary true/false into text
                    if($login->success === 1) { $login->success = 'TRUE'; }
                    else { $login->success = 'FALSE'; }
                    //convert data into readable formant.
                    $login->login_time = date('m/d/Y h:i:s A',$login->login_time);
                }
                $data['print_page'] = true;
                $form_data['page_select'] = $destination_page;
                $this->load->view('api/reports/logins', $data);
        } 
        else{
            $this->load->view('api/reports/logins', $data);
        }
    }

    public function report_facility($adhoc_report_id) {
        //page set up
        $all_report = FALSE;
        if($this->has_access("facility_report_all")){
            $all_report = TRUE;
            $facility_id = null;
        }else{
            $mailbox = Mailbox::find_one(array("name"=>$this->user->username));
            $facility_id = $mailbox->facility_id;
        }
        $data['all_report'] = $all_report;
        $data['facility_id'] = $facility_id;
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        $selected = null;
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("facility_report");
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
    
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
    
        $is_active = null;
        //gets selected facility
        $facility_selected = $this->input->post('whichfacility',TRUE);
        if(!$all_report){
            $facility_selected = $facility_id;
        }
        $export_file_name = $this->input->post('export_file_name',TRUE);
        
        if($adhoc_report_id != ''){
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }        
            /*Adhoc Report Starts Here*/
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "facility")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = $adhoc_report[0]->report_selector;
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);
                
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
                
            //Diff time period
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;
        
            $time_start_check = $filters_used['start_date'];
            $time_end_check = $filters_used['end_date'];
        
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;
        
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
        
                //Date information
                $items = array();
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
        
                //Date information
                $items = array();
                $end_date = $filters_used['end_date'];
                $start_date = $filters_used['start_date'];
        
            }
            //Selector
            $selector = array(
                'facility.id' => ($filters_used['facility_id']),
            );
        
            //Date Format
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
                
            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
        
            $between = array(
                    'messages.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
        
            //getting size number
            $size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result();
            $size = $size[0]->count;
            $page = 1;
            $items = array();
            $destination_page = $page;
            $items_per_page = 100;
            $facility_list= $this->facilitymodel->get_request_filter_facility_order($sql,$order,$this->db->escape($page),$this->db->escape($items_per_page))->result();
            //Adhoc_Report
            if(($filters_used['facility_id'] == '' || mb_strtoupper($filters_used['facility_id']) == '(ALL)') && empty($start_date) && empty($end_date)) {
                $response_adhoc = "0=0 AND (facility.id like '%' OR facility.id IS NULL)";
            }
            else {
                $response_adhoc = $this->reports_helper_adhoc('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            }
            //ExportPDF-PRINT
            if($is_export) {
                $response_export = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
                //ExportPDF-PRINT
                $response_export_list = $facility_list;
            }
            //Getting_totals
            $facility_list_totals = $facility_list;
            //set form data
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $form_data['whichfacility'] = $filters_used['facility_id'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
        
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }
            else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
        
            //set form data and send form_data
            $form_data['items_per_page'] = $items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            $form_data['pages'] = $pages;
            $data['form_data'] = $form_data;
            $data['facility_list'] = $facility_list;
        
            //pagination setup
            $pages->items_total = $size;
            $pages->current_page = $destination_page;
            $pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }else{
                    $data['facility'] = "No facility set";
                }
            }
        }
        //checks to see if there is an facility selected.  This shows whether or not this is the first time the page has loaded.
        else if($facility_selected || !$all_report && $adhoc_report_id == ''){
            $selector = array(
                    'facility.id' => ($facility_selected),
            );
    
            //POST information
            $items = array();
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            
            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
    
            $between = array(
                    'messages.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );

            //get direction (desc/asc)and if it is being exported
            $order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'name';
            $dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
    
            //calls helper to get data
            $response = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            $facility_list = $response['response'];
            
            //Adhoc_Report
            $response_adhoc = $this->reports_helper_adhoc('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            
            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
    
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }
            else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
    
            //set form data and send form_data
            $form_data['items_per_page'] = $items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            $form_data['pages'] = $pages;
            $data['form_data'] = $form_data;
            $data['facility_list'] = $facility_list;
    
            //pagination setup
            $pages->items_total = $size;
            $pages->current_page = $destination_page;
            $pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }else{
                    $data['facility'] = "No facility set";
                }
            }
            if(mb_strtoupper($selector['facility.id']) != '(ALL)') $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['facility.id'])->result()[0]->name;
            //Export PDF or Print
            if($is_export == 'pdf' || $is_export == 'print') {
                $response_export = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
            //Getting_totals
            $size_all = $this->facilitymodel->get_facility_list_size_reports()->result();
            $response_total = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$size_all[0]->count);
            $facility_list_totals = $response_total['response'];
        } 
        else {
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $facility_list = $this->facilitymodel->get_first_facilities($items_per_page)->result();
            $size = $this->facilitymodel->get_facility_list_size_reports()->result();
            $size = $size[0]->count;
            $export = FALSE;
            $form_data = array(
                    'direction' => 'ASC',
                    'order' => 'name',
                    'cur_page' => '1',
            );
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            //pagination setup
            $pages->items_total = $size;
            $pages->current_page = $destination_page;
            $pages->paginate();
            $form_data['pagination_bar'] = $pages->display_pages();
            $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            $form_data['items_per_page'] = $items_per_page;
            $form_data['pages'] = $pages;
            $data['form_data'] = $form_data;
            $data['facility_list'] = $facility_list;
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
            //Settings Exports
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            //Getting app Totals
            $facility_list_totals = $this->facilitymodel->get_first_facilities($size)->result();
            //Adhoc Report
            $between = array ("messages.timestamp" => Array("start"=>"", "end" =>""));
            $response_adhoc = "0=0 AND (facility.id like '%' OR facility.id IS NULL)";
            $dir = "ASC";    
            $order = "name";
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;            
        $data['adhoc_report_direction'] = $order; 
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "Facility";

        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        $va_totals = new StdClass;
        $va_totals->totalUsers = 0;
        $va_totals->totalGroup = 0;
        $va_totals->totalSent = 0;
        $va_totals->totalMessages = 0;
        $va_totals->totalReceived = 0;

        foreach( $facility_list_totals as $requests ) {
            $va_totals->totalUsers      += $requests->Number_of_users;
            $va_totals->totalGroup      += $requests->Number_in_group;
            $va_totals->totalSent       += $requests->Number_of_sent;
            $va_totals->totalMessages   += $requests->Total_messages - $requests->Number_of_drafts;
        }
        $va_totals->totalReceived   = $va_totals->totalMessages - $va_totals->totalSent;

        $data['va_totals'] = $va_totals ; 

        //Set view or export view
        if($export){
            //Setting Totals for Excel Export
            $totalCount = count((array)$facility_list);
            //Unset Row Number for Export $totalCount = count((array)$facility_list);
            for ($i = 0; $i < $totalCount; $i++) {
                unset($facility_list[$i]->row);
                unset($facility_list[$i]->id);
            }

            // prepare data so that the numbers are calculated the same way in HTML view, print view, and PDF export
            $facility_list = $this->reports_facility_excel_data_alt($facility_list);

            $this->export(array('VA Facility','Number of Users','Number of Groups', 'Total Messages Sent','Total Messages Received','Total Messages'),$facility_list,$export_file_name,$items,$between,$selected,null);
        } 
        else if($export_pdf) {
            if (!empty($response_export)){
                $data['export_facility_list'] = $response_export_list;
            } /* else {
                $data['facility_list'] = $responses_list;
            } */
            $html = $this->load->view('api/reports/result_tables/result_facility', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        } 
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($response_export)){
                $data['export_facility_list'] = $response_export_list;
            } /* else {
                $data['facility_list'] = $responses_list;
            } */
            $data['print_page'] = true;
            $form_data['page_select'] = $destination_page;
            $data['facility_list_totals'] = $facility_list_totals;

            $this->load->view('api/reports/facility', $data);
        } 
        else {
            $data['facility_list_totals'] = $facility_list_totals;
            $this->load->view('api/reports/facility', $data);
        }
    }
    
    //function for hisp report
    public function report_hisp($adhoc_report_id){
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("hisp_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected = null;
    
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $selected_domain = $this->input->post('selected_domain',TRUE);//gets selected
        $data['domains'] = $this->hispmodel->get_domains();
        $export_file_name = $this->input->post('export_file_name',TRUE);
        
        if($adhoc_report_id != '') {
            /*Adhoc Report - Starts Here*/
            
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "hisp")->result();
            //Diff time period
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;
            
            $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
            $time_start_check = $selected_filter_array['start_date'];
            $time_end_check = $selected_filter_array['end_date'];
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
            
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator = $adhoc_report[0]->report_query_generator;
            
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
            
                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
                $between = array(
                        'time' => $this->check_paired_dates($start_date,$end_date),
                );
                
                
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
            
                //Date information
                $end_date = $selected_filter_array['end_date'];
                $start_date = $selected_filter_array['start_date'];
                $between = array(
                        'time' => $this->check_paired_dates($start_date,$end_date),
                );
            }
            //Selector
            $selector = array(
                    'selected_domain' => ($selected_filter_array['selected_domain']),
            );
            $items = array();
            //Date Format
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
            $data['filters'] = $this->export_info($items,$between,$selected,null);
            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
            
            $destination_page = $selected_filter_array['adhoc_report_destination_page'];
            $items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
            $pages->items_per_page = $items_per_page;
            $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_filter_array['selected_domain'], $between, $order, $dir, $destination_page, $items_per_page, $is_export);
                
            //set form data
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $form_data['selected_domain'] = $selected_filter_array['selected_domain'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }
            else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            
        }
        else if($selected_domain){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $items = array();
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    
            $between = array(
                    'time' => $this->check_paired_dates($start_date,$end_date)
            );

            $order = $this->input->post('order',TRUE);
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            if (mb_strtoupper($selected_domain) !='(ALL)') $selected = 'HISP: ' . $selected_domain;
            $data['is_export'] = $is_export;

            $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_domain, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
            
            $size = $message_counts['total_size'];
            //getting app totals
            //$message_counts_totals = $this->hispmodel->get_message_counts_grouped_by_domain($application_id, $between, $order, $dir, $destination_page, $size, $is_export);
            
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $data['filters'] = $this->export_info($items,$between,$selected,null);
            
        }
        else{//if this is the first time you have loaded the page (ie no filters have fields)
            //$message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, null, null, null, $destination_page, $items_per_page, null, null);
            $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_domain, null, null, null, $destination_page, $items_per_page, false);
            
            //set defaults
            $form_data = array(
                    'direction' =>'ASC',
                    'order'=>'domain_name',
                    'cur_page'=>'1',
            );
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;

            //Adhoc Report
            $between = array ("time" => Array("start"=>"", "end" =>""));
            //$response_adhoc_sql  = " 0=0 ";
            $dir = "ASC";
            $order = "domain_name";
            //initiate form data for adhoc report
            $form_data['selected_domain'] = '(ALL)';
            $form_data['start_date'] = '';
            $form_data['end_date'] = '';
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        $size = $message_counts['total_size'];
        //set options for available applications
        //$data['apps'] = $this->applicationmodel->get_applications()->result();
    
        //pagination setup
        $pages->items_total = $size;
        $pages->current_page = $destination_page;
        $pages->paginate();
        $form_data['pagination_bar'] = $pages->display_pages();
        $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
    
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
        }
    
        $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
        $form_data['items_per_page'] = $items_per_page;
        $form_data['pages'] = $pages;
        $data['form_data'] = $form_data;
        $data['message_counts'] = $message_counts['list'];
        
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_type'] = "Hisp";
        $data['adhoc_report_destination_page'] = $destination_page;
        $data['adhoc_report_items_per_page'] = $items_per_page;
        
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        //export
        if($export){
            $this->export(array('Domain Name','Total Messages Sent', 'Total Messages Received','Total Messages'),$message_counts['list'],$export_file_name,$items,$between,$selected,null);
        }
        else if($export_pdf) {
            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_hisp', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            $data['print_page'] = true;
            $this->load->view('api/reports/hisp', $data);
        }
        else{
            //$data['message_counts_totals'] = $message_counts_totals;
            $this->load->view('api/reports/hisp', $data);
        }
    }
    
    //function for points of origin report
    public function report_points_of_origin($adhoc_report_id){
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("points_of_origin_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected = null;
        
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $application_id = $this->input->post('application_id',TRUE);//gets selected
        $export_file_name = $this->input->post('export_file_name',TRUE);
        
        if($application_id){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);

            // $date_warning_message = $this->get_date_filter_validation_message($date_array);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            $between = array(
                    'call_date' => $this->check_paired_dates($start_date,$end_date)

            );

            $order = $this->input->post('order',TRUE);
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            
            if ($application_id!='(ALL)') $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
            $data['is_export'] = $is_export;
            
            $message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);

            $form_data = $this->input->post(NULL,TRUE);

            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $data['filters'] = $this->export_info(null,$between,$selected,null);
        } else if ($adhoc_report_id != ''){
            /*Adhoc Report - Starts Here*/
            
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            //Adhoc Report start here
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "points_of_origin")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = $adhoc_report[0]->report_selector;
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);

            $application_id = $filters_used['application_id'];
        
            //From Adhoc Form
            $diff_time_period =  $this->input->post('time_period',TRUE);
            
            //Get Date information
            $time_period_field = $adhoc_report[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];
            
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;
                
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);    
                
                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
                
                //Date information
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
    
            }
            //Set Date information
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                    'call_date' => $this->check_paired_dates($start_date,$end_date)
            );
            
            $destination_page = $filters_used['adhoc_report_destination_page'];
            $items_per_page = $filters_used['adhoc_report_items_per_page'];
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
            //Export variables
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
    
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export; 
            
            if (mb_strtoupper($application_id)!='(ALL)'){
                $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
            } else {
                $application_id ="";
            }

            $message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['application_id'] = $application_id;
            $form_data['order'] = $order;
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $data['filters'] = $this->export_info(null,$between,$selected,null);
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
            $data['form_data'] = $form_data;
            
        } else {//if this is the first time you have loaded the page (ie no filters have fields)
            $message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, null, null, null, $destination_page, $items_per_page, false);
            //set defaults
            $form_data = array(
                 'direction' =>'ASC',
                 'order'=>'application_name',
                 'cur_page'=>'1',
            );
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
        
        //Adhoc Report
            $dir = "ASC";    
            $order = "application_name";
            $between = array ("call_date" => Array("start"=>"", "end" =>""));
            $form_data['application_id'] = "(all)";
            $data['is_export'] = FALSE;
            $data['filters'] = ' ';
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;            
        $data['adhoc_report_direction'] = $order; 
        $data['adhoc_report_type'] = "points_of_origin";
        $data['adhoc_report_destination_page'] = $destination_page;
        $data['adhoc_report_items_per_page'] = $items_per_page;
        $data['time_field'] = "call_date";
        
        $size = $message_counts['total_size'];
        
        //set options for available applications
        $data['apps'] = $this->applicationmodel->get_applications()->result();
    
        //pagination setup
        $pages->items_total = $size;
        $pages->current_page = $destination_page;
        $pages->paginate();
        $form_data['pagination_bar'] = $pages->display_pages();
        $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
    
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
        }
    
        $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
        $form_data['items_per_page'] = $items_per_page;
        $form_data['pages'] = $pages;
        $data['form_data'] = $form_data;
        $data['message_counts'] = $message_counts['list'];
        
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        if($export){
            $this->export(array('Originating Application','Total Messages Sent'),$message_counts['list'],$export_file_name,null,$between,$selected,null);
        }
        else if($export_pdf) {
            $html = $this->load->view('api/reports/result_tables/result_points_of_origin', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            $data['print_page'] = true;
            $form_data['page_select'] = $destination_page;
            $this->load->view('api/reports/points_of_origin', $data);
        } 
        else{
            $this->load->view('api/reports/points_of_origin', $data);
        }
    }
    
    //function for Group Activity Summary
    public function report_group_activity_summary($adhoc_report_id){
        //page set up
        $all_report = FALSE;
        if($this->has_access('group_activity_summary_report_all')){
            $all_report = TRUE;
            $facility_id = null;
        }
        else {
            $mailbox = Mailbox::find_one(array('name'=>$this->user->username));
            $facility_id = $mailbox->facility_id;
            $data['facility_id'] = $facility_id;
        }
        $data['all_report'] = $all_report;
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        $selected = null;
    
        //Declaring Summary Array
        $SummaryListing =  array();
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("group_activity_summary_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $is_active = null;
        $default_active = 1;
        //gets selected facility
        $facility_selected = $this->input->post('whichfacility',TRUE);
        $export_file_name = $this->input->post('export_file_name',TRUE);
    
        if(!$all_report){
            $facility_selected = $facility_id;
        }
        //checks to see if there is an facility selected.  This shows whether or not this is the first time the page has loaded.
        if(($facility_selected || !$all_report)  && $adhoc_report_id == ''){
            $is_group_active = $this->input->post('group_status_type',TRUE);
            //if user_status_type has no value or false, assign (ALL)
            if($is_group_active === false) {
                $is_group_active = '(ALL)';
            }
    
            $selector = array(
                    'F.id' => ($facility_selected),
                    'M.is_active' => $is_group_active,
            );
            //POST information
            $items = array(
                    'M.name' => $this->search_type($this->input->post('text_group_name',TRUE),$this->input->post('group_name_type',TRUE)),
                    //'user_ext_mail' => $this->search_type($this->input->post('txtDirectAddress',TRUE),$this->input->post('direct_address_type',TRUE)),
            );
                
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
    
            $between = array(
                    'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            //get direction (desc/asc)and if it is being exported
            $order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'facilityName';
            $dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            //calls helper to get data
            $response = $this->reports_helper('group_activity_summary',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            $size = $response['size'];
            $group_activity_list = $response['response'];
            $counter = 0;
            //merge arrays
            foreach ($group_activity_list as $group_info){
                
                $groupName = $group_info->group_name;
                $groupID = $group_info->id;
                $groupFacilityName = $group_info->Name;
                $groupNumber_of_sent = $group_info->Number_of_sent;
                $groupNumber_of_seen = $group_info->Number_of_seen;
                $groupTotal_of_messages = $group_info->Total_messages;
                $groupRow = $group_info->row;
                $groupIsActive = $group_info->is_active;
                //Get LDAP Information
                $resultArray = $this->groupsmodel->get_ldap_request($group_info->group_name);
                
                //checking that LDAP Results are not null
                
                if (isset ($resultArray[0]['mail'][0])){
                    $groupMail = $resultArray[0]['mail'][0];
                }
                else{ $groupMail = ''; }
                
                if (isset ($resultArray[0]['cn'][0])){
                    $groupDisplayName = $resultArray[0]['cn'][0];
                }
                else{ $groupDisplayName = ''; }
                    
                if($groupIsActive == 1){
                    $groupActiveText = 'Active';
                } else {
                    $groupActiveText = 'Inactive';
                }
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->groupName = $groupName;
                $SummaryListingObjects->displayName = $groupDisplayName;
                $SummaryListingObjects->groupMail = $groupMail;
                $SummaryListingObjects->facilityName = $groupFacilityName;
                $SummaryListingObjects->groupStatus = $groupActiveText;
                $SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
                $SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
                $SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
                array_push($SummaryListing, $SummaryListingObjects);
    
                
    
            }
            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['order'] = $order;
            //$form_data['group_status_type'] = $is_group_active;
            if(!$all_report){
                $form_data['group_name'] =   $this->input->post('text_group_name',TRUE);
                
                $form_data['text_group_name'] =   $this->input->post('text_group_name',TRUE);
                $form_data['group_name_type'] =   $this->input->post('group_name_type',TRUE);
                $form_data['txtDirectAddress'] =   $this->input->post('txtDirectAddress',TRUE);
                $form_data['direct_address_type'] =  $this->input->post('direct_address_type',TRUE);
                $form_data['group_status_type'] = $is_group_active;
                $form_data['whichfacility'] = $facility_id;
                //$form_data['end_date'] =   $this->input->post('end_date',TRUE);
                //$form_data['start_date'] =   $this->input->post('start_date',TRUE);
            }

            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);
    
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            //set form data and send form_data
            $form_data['items_per_page'] = $items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            $form_data['pages'] = $pages;
            $data['form_data'] = $form_data;
                
            //Sorting Array
            $ldapfilters = array();
            //Converting to array for sorting
            $new_array = $this->object_to_array($SummaryListing);
            //filter_sn
            $sn_filter = $this->input->post('txtSN',TRUE);
            if($sn_filter != ""){
                $sn_filter_type = $this->input->post('last_name_type',TRUE);
                array_push($ldapfilters, 'Last Name ' . mb_strtolower($data['compare'][$sn_filter_type]). ': ' . $sn_filter);
                //setting filter type
                $search_sn = $this->search_type_for_array($sn_filter,$sn_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userSN', $search_sn);
            }
            //filter_given_name
            $givenname_filter = $this->input->post('txtGivenname',TRUE);
            if($givenname_filter != ""){
                $givenname_filter_type = $this->input->post('first_name_type',TRUE);
                array_push($ldapfilters, 'First Name ' . mb_strtolower($data['compare'][$givenname_filter_type]). ': ' . $givenname_filter);
                //setting filter type
                $search_givenname = $this->search_type_for_array($givenname_filter,$givenname_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userGivenname', $search_givenname);
            }
            //filter_va_address
            $direct_address_filter = $this->input->post('txtDirectAddress',TRUE);
            if($direct_address_filter != ""){
                    
                $direct_address_filter_type = $this->input->post('direct_address_type',TRUE);
                array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_type]). ': ' . $direct_address_filter);
    
                //setting filter type
                $search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'groupMail', $search_direct_address);
            }
            
            $SummaryListingExport = new stdClass;
            $SummaryListingExport = $this->array_to_object($SummaryListing);
                
            unset($SummaryListing);
            $SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $items_per_page));
            $data['summary_list'] = $SummaryListing;
                
            $SummaryListingExport_2 = new stdClass;
            $SummaryListing_2 = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $SummaryListingExport_2 = $this->array_to_object($SummaryListing_2);
                
    
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
            
            if($selector['M.is_active'] == '(ALL)'){
                $selected = '';
            }
            else if($selector['M.is_active'] == '1'){
                $selected = 'Group Status: Active, ';
            }
            else {
                $selected = 'Group Status: Inactive, ';
            }
            if($selector['F.id'] != '(ALL)') {
                 $selected .= 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name;
            }
            //pagination setup
            $pages->items_total = count($new_array);
            $pages->current_page = $destination_page;
            $pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }
                else { $data['facility'] = 'No facility set'; }
            }
            $data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
            //Adhoc_Report
            $response_adhoc = $this->reports_helper_adhoc('group_activity_summary',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
        } else if (!empty($adhoc_report_id)){
            /*Adhoc Report - Starts Here*/
                
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            $adhoc_report_data = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"group_activity_summary")->result();
            //Filters and Data from db
            if(!isset($adhoc_report_data[0])){
                show_404();
            }
            $report_selector = $adhoc_report_data[0]->report_selector;
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);
            
            $facility_selected = $filters_used['facility_id'];
            if (mb_strtolower ($facility_selected) == "(all)"){
                $facility_selected ="";
            }
            $selector = array(
                    'F.id' => ($facility_selected),
            );
            
            //Date information
            $is_group_active =  $filters_used['group_status_type'];
            if(mb_strtolower($is_group_active) == "(all)"){
                $items = array(
                        'M.name' => $this->search_type( $filters_used['group_name'], $filters_used['group_name_type']),
                        //'group_ext_mail' => $this->search_type ($filters_used['txtvaemailaddress'], $filters_used['va_email_type']),
                );
            } else {
                $items = array(
                        'M.name' => $this->search_type( $filters_used['group_name'], $filters_used['group_name_type']),
                        //'group_ext_mail' => $this->search_type( $filters_used['txtvaemailaddress'], $filters_used['va_email_type']),
                        'M.is_active' =>  $filters_used['group_status_type'],
                );
            }
            
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
            //From Adhoc Form
            $diff_time_period =  $this->input->post('time_period',TRUE);
            
            //Get Date information
            $time_period_field = $adhoc_report_data[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];
            
            if(!empty($diff_time_period)){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report_data[0]->report_query_generator;
            
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
            
                //Date information
                $items = array();
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report_data[0]->report_query_generator;
            
                //Date information
                $items = array();
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
            
            }
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            //Setting exports
            
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
            $page =1;
            $items_per_page = 10;
            $between = array(
                    'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            
            //get direction (desc/asc)and if it is being exported
            
            $order_search = $adhoc_report_data[0]->report_order_by ." " .$adhoc_report_data[0]->report_order_by_direction.",id ".$adhoc_report_data[0]->report_order_by_direction;
            $order = $adhoc_report_data[0]->report_order_by;
            $dir = $adhoc_report_data[0]->report_order_by_direction;
            
            //calls helper to get data
            //Checking role permissions
            if(!$all_report){
                $sql_permission = '';
                $i = 0;
                $sql_queries_by_part = explode("AND", $sql);
                foreach ($sql_queries_by_part as $id){
                    if ($i > 0){
                        $sql_permission .=" AND ";
                    }
                    if (string_contains('F.id', $id)) {
                        $sql_permission .= "(F.id like '%".$facility_id."%')";
                    } else {
                        $sql_permission .= $id;
                    }
                    $i++;
                }
                //assigning new query to $sql
                $sql = $sql_permission;
            }
            //sql query that excludes the date filter to include groups who had no acitivity during the time period specified
#TODO - this is unnecessarily complicated.  at some point when we refactor this code, we should make sure that we have a more straightforward way of getting this data.
            $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
            $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
            
            $size = $this->groupsmodel->get_group_list_size($sql_date_filter_excluded)->result();
            $size = $size[0]->count;
            $groups_facility_list = $this->groupsmodel->get_request_filter_group_activities($sql,$sql_date_filter_excluded,$order_search,$this->db->escape($page),$items_per_page);
            //Adhoc_Report
            if(!$facility_selected) {
                $response_adhoc = "0=0 AND (F.id like '%' OR F.id IS NULL)";
            } else {
                $response_adhoc = $this->reports_helper_adhoc('group_activity_summary',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            }
            $counter = 0;
            //merge arrays
            foreach ($groups_facility_list as $group_info){
                //print_r($group_info);
            
                $group_name = $group_info->group_name;
                $groupID = $group_info->id;
                $groupFacilityName = $group_info->Name;
                $groupNumber_of_sent = $group_info->Number_of_sent;
                $groupNumber_of_seen = $group_info->Number_of_seen;
                $groupTotal_of_messages = $group_info->Total_messages;
                $groupRow = $group_info->row;
                $groupIsActive = $group_info->is_active;
                //Get LDAP Information
                $resultArray = $this->groupsmodel->get_ldap_request($group_info->group_name);
            
                //checking that LDAP Results are not null
            
                if (isset ($resultArray[0]['cn'][0])){
                    $displayName = $resultArray[0]['cn'][0];
                }else { $displayName = ''; }
            
                if (isset ($resultArray[0]['mail'][0])){
                    $groupMail = $resultArray[0]['mail'][0];
                }else{
                    $groupMail = "not found";
                }
            
                if($groupIsActive == 1){ $groupActiveText = 'Active'; }
                else { $groupActiveText = 'Inactive'; }
            
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->groupName = $group_name;
                $SummaryListingObjects->displayName = $displayName;
                $SummaryListingObjects->groupMail = $groupMail;
                $SummaryListingObjects->facilityName = $groupFacilityName;
                $SummaryListingObjects->groupStatus = $groupActiveText;
                $SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
                $SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
                $SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
                array_push($SummaryListing, $SummaryListingObjects);
            
            }
            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['order'] = $order;
            
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            //set form data and send form_data
            $form_data['items_per_page'] = $items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            
            //Form Data from DB
            $form_data['txtDirectAddress'] =   $filters_used['txtdirectaddress'];
            $form_data['direct_address_type'] =   $filters_used['direct_address_type'];
            $form_data['text_group_name'] =   $filters_used['group_name'];
            $form_data['group_name_type'] =   $filters_used['group_name_type'];
            $form_data['group_status_type'] =   $filters_used['group_status_type'];
            $form_data['whichfacility'] =   $filters_used['facility_id'];
            $form_data['end_date'] =  $end_date;
            $form_data['start_date'] =  $start_date;
            $form_data['facility_id'] = $facility_id;
            $form_data['pages'] = $pages;
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report_data[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report_data[0]->report_name;
            $form_data['report_description'] = $adhoc_report_data[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report_data[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
            $data['form_data'] = $form_data;
            
            //Sorting Array
            $ldapfilters = array();
            //Converting to array for sorting
            $new_array = $this->object_to_array($SummaryListing);
            
            //filter_va_address
            $direct_address_filter =  $filters_used['txtdirectaddress'];
            if($direct_address_filter != ""){
                $direct_address_filter_Type =  $filters_used['direct_address_type'];
                array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_Type]). ': ' . $direct_address_filter);
                //setting filter type
                $search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_Type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'groupMail', $search_direct_address);
            }
            
            unset($SummaryListing);
            $SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $items_per_page));
            $data['summary_list'] = $SummaryListing;
            
            $SummaryListingExport = $SummaryListing;
            $SummaryListingExport_2 = $SummaryListing;
            
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
            
            
            if(mb_strtolower ($selector['F.id']) != "(all)" && $selector['F.id'] != ''){ $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name; }
            //pagination setup
            $pages->items_total = count($new_array);
            $pages->current_page = $destination_page;
            $pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }
                else { $data['facility'] = 'No facility set'; }
            }
            $data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
    
        } else {
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
                
            $group_activity_list = $this->groupsmodel->get_first_group_activities($items_per_page)->result();
            foreach ($group_activity_list as $group_info){
                $groupName = $group_info->group_name;
                $groupID = $group_info->id;
                $groupFacilityName = $group_info->Name;
                $groupNumber_of_sent = $group_info->Number_of_sent;
                $groupNumber_of_seen = $group_info->Number_of_seen;
                $groupTotal_of_messages = $group_info->Total_messages;
                $groupRow = $group_info->row;
                $groupIsActive = $group_info->is_active;
                //Get LDAP Information
                $resultArray = $this->groupsmodel->get_ldap_request($group_info->group_name);
                //checking that LDAP Results are not null
                if (isset ($resultArray[0]['cn'][0])){
                    $groupDisplayName = $resultArray[0]['cn'][0];
                }
    
                if (isset ($resultArray[0]['mail'][0])){
                    $groupMail = $resultArray[0]['mail'][0];
                }
                else { $groupMail = 'not found'; }
    
                if($groupIsActive == 1){ $groupActiveText = 'Active'; }
                else { $groupActiveText = 'Inactive'; }
    
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->groupName = $groupName;
                $SummaryListingObjects->displayName = $groupDisplayName;
                $SummaryListingObjects->groupMail = $groupMail;
                $SummaryListingObjects->facilityName = $groupFacilityName;
                $SummaryListingObjects->groupStatus = $groupActiveText;
                $SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
                $SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
                $SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
    
                array_push($SummaryListing, $SummaryListingObjects);
                    
            }
                
            $size = $this->groupsmodel->get_first_group_activities_list_size()->result();
            $size =  count((array)$size);
            $form_data = array(
                    'direction' => 'DESC',
                    'order' => 'facilityName',
                    'cur_page' => '1',
            );
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
            //Adhoc Report
            $between = array ("ms.timestamp" => Array("start"=>"", "end" =>""));
            $response_adhoc = "0=0 AND (F.id like '%' OR F.id IS NULL)";
            $dir = "DESC";
            $order = "facilityName";
            //set blank filters
            $form_data['txtDirectAddress'] = "";
            $form_data['direct_address_type'] = "";
            $form_data['text_group_name'] =  "";
            $form_data['group_name_type'] = "";
            $form_data['group_status_type'] = "(ALL)";
            $form_data['whichfacility'] = "(ALL)";
            $form_data['end_date'] = "";
            $form_data['start_date'] = "";
            $data['form_data'] = $form_data;
            $data['filters'] = ' ';
                
            //pagination setup
            $pages->items_total = $size;
            $pages->current_page = $destination_page;
            $pages->paginate();
            $form_data['pagination_bar'] = $pages->display_pages();
            $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            $form_data['items_per_page'] = $items_per_page;
            $data['items_per_page'] = $items_per_page;
            $form_data['pages'] = $pages;
            $data['form_data'] = $form_data;
            $data['summary_list'] = $SummaryListing;
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            //Export Settings
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            $data['is_export'] = FALSE;
            //Adding VA Totals
            $users_facility_list_totals = $this->groupsmodel->get_first_group_activities($pages->items_total)->result();
            $summary_listing_totals = array();
                
            foreach ($users_facility_list_totals as $group_info_total){
                $group_number_of_sent = $group_info_total->Number_of_sent;
                $group_number_of_seen = $group_info_total->Number_of_seen;
                $group_total_of_messages = $group_info_total->Total_messages;
                $summary_listing_objects_totals = new stdClass;
                //Adding to Original Array
                $summary_listing_objects_totals->groupNumber_of_sent = $group_number_of_sent;
                $summary_listing_objects_totals->groupNumber_of_seen = $group_number_of_seen;
                $summary_listing_objects_totals->groupTotal_of_messages = $group_total_of_messages;
                array_push($summary_listing_totals, $summary_listing_objects_totals);
            }
            //Adding to SummaryListing_Totals
            $new_summary_array = array();
            $new_summary_array = $summary_listing_totals;
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_summary_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
        }
    
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "group_activity_summary";
        //set form data and send form_data
        //$form_data['items_per_page'] = $items_per_page;
        $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
        //$form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
    
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        //Set view or export view
        if($export){
            //Setting Excel
            if (!empty($SummaryListingExport_2)){
                $SummaryListingExport = $SummaryListingExport_2;
            }else{
                $SummaryListingExport = $SummaryListingExport;
            }
            $totalCount = count((array)$SummaryListingExport);
            $newRowNumber = $totalCount + 1;
            $SummaryListingExport->$totalCount = new StdClass;
            $SummaryListingExport->$totalCount->groupName = '';
            $SummaryListingExport->$totalCount->groupMail = '';
            $SummaryListingExport->$totalCount->facilityName = '';
            $SummaryListingExport->$totalCount->groupStatus = '';
            $SummaryListingExport->$totalCount->group_ext_mail = 'VA Total:';
            $SummaryListingExport->$totalCount->groupNumber_of_sent = $this->sum_by_object_name((array)$SummaryListingExport, 'groupNumber_of_sent');
            $SummaryListingExport->$totalCount->groupNumber_of_seen = $this->sum_by_object_name((array)$SummaryListingExport, 'groupNumber_of_seen');
            $SummaryListingExport->$totalCount->groupTotal_of_messages = $this->sum_by_object_name((array)$SummaryListingExport, 'groupTotal_of_messages');
            $this->export(array('Group Name', 'Display Name','Direct Address','VA Facility','Group Status', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListingExport,$export_file_name,$items,$between,$selected,$ldapfilters);
        }
        else if($export_pdf) {
            if (!empty($SummaryListingExport_2)){
                $data['export_summary_list'] = $SummaryListingExport_2;
            }
            $html = $this->load->view('api/reports/result_tables/result_group_activity_summary', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($SummaryListingExport_2)){
                $data['export_summary_list'] = $SummaryListingExport_2;
            }
            $data['print_page'] = true;
            $this->load->view('api/reports/group_activity_summary', $data);
        }
        else{
            $data['summary_list_totals'] = $summary_listing_totals;
            $this->load->view('api/reports/group_activity_summary', $data);
        }
    
    }
    
    //function for User Activity Summary
    public function report_user_activity_summary($adhoc_report_id){
        //page set up
        $all_report = FALSE;
        if($this->has_access('user_activity_summary_report_all')){
            $all_report = TRUE;
            $facility_id = null;
        }
        else {
            $mailbox = Mailbox::find_one(array('name'=>$this->user->username));
            $facility_id = $mailbox->facility_id;
            $data['facility_id'] = $facility_id;
        }
        $data['all_report'] = $all_report;
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        $selected = null;
        
        //Declaring Summary Array
        $SummaryListing =  array();
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("user_activity_summary_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $is_active = null;
        $default_active = 1;
        //gets selected facility
        $facility_selected = $this->input->post('whichfacility',TRUE);
        $export_file_name = $this->input->post('export_file_name',TRUE);
        
        if(!$all_report){
            $facility_selected = $facility_id;
        }
        //checks to see if there is an facility selected.  This shows whether or not this is the first time the page has loaded.
        if(($facility_selected || !$all_report)  && $adhoc_report_id == ''){
            $is_user_active = $this->input->post('user_status_type',TRUE);
            //if user_status_type has no value or false, assign (ALL)
            if($is_user_active === false) {
                $is_user_active = '(ALL)';
            }
                
            $selector = array(
                    'F.id' => ($facility_selected),
                    'is_active' => $is_user_active,
            );
            //POST information
            $items = array(
                    'U.username' => $this->search_type($this->input->post('txtUserName',TRUE),$this->input->post('userName_type',TRUE)),
                    'user_ext_mail' => $this->search_type($this->input->post('txtVAEmailAddress',TRUE),$this->input->post('va_email_type',TRUE)),
            );
            
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );    
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
    
            $between = array(
                'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            //get direction (desc/asc)and if it is being exported
            $order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'facilityName';
            $dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            //calls helper to get data
            $response = $this->reports_helper('user_activity_summary',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            $users_facility_list = $response['response'];
            $counter = 0;
            //merge arrays
            foreach ($users_facility_list as $userInfo){
                $userUsername = $userInfo->Username;
                $userID = $userInfo->id;
                $userFacilityName = $userInfo->Name;                
                $userNumber_of_sent = $userInfo->Number_of_sent;
                $userNumber_of_seen = $userInfo->Number_of_seen;
                $userTotal_of_messages = $userInfo->Total_messages;
                $user_ext_mail = $userInfo->user_ext_mail;
                $userRow = $userInfo->row;
                $userIsActive = $userInfo->is_active;
                //Get LDAP Information
                $resultArray = $this->useractivitysummarymodel->get_ldap_request($userInfo->Username);
                
                //checking that LDAP Results are not null
                if (isset ($resultArray[0]['givenname'][0])){
                    $userGivenname = $resultArray[0]['givenname'][0];
                }
                else{ $userGivenname = ''; }
                
                if (isset ($resultArray[0]['sn'][0])){
                    $userSN = $resultArray[0]['sn'][0];
                }
                else{ $userSN = ''; }
                
                if (isset ($resultArray[0]['mail'][0])){
                    $userMail = $resultArray[0]['mail'][0];
                }
                else{ $userMail = ''; }
            
                if($userIsActive == 1){
                    $userActiveText = 'Active';
                } else {
                    $userActiveText = 'Inactive';
                }
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->userSN = $userSN;
                $SummaryListingObjects->userGivenname = $userGivenname;                    
                $SummaryListingObjects->username = $userUsername;
                $SummaryListingObjects->userMail = $userMail;
                $SummaryListingObjects->facilityName = $userFacilityName;
                $SummaryListingObjects->userStatus = $userActiveText;
                $SummaryListingObjects->user_ext_mail = $user_ext_mail;
                $SummaryListingObjects->userNumber_of_sent = $userNumber_of_sent;
                $SummaryListingObjects->userNumber_of_seen = $userNumber_of_seen;            
                $SummaryListingObjects->userTotal_of_messages = $userTotal_of_messages;
                array_push($SummaryListing, $SummaryListingObjects);
                
            }
            //set form data
            $form_data = $this->input->post(NULL,TRUE);        
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['order'] = $order;
            
            if(!$all_report){
                $form_data['txtGivenname'] =  $this->input->post('txtGivenname',TRUE);
                $form_data['first_name_type'] =   $this->input->post('first_name_type',TRUE);
                $form_data['txtVAEmailAddress'] =   $this->input->post('txtVAEmailAddress',TRUE);
                $form_data['va_email_type']  =   $this->input->post('va_email_type',TRUE);
                $form_data['txtSN'] =   $this->input->post('txtSN',TRUE);
                $form_data['last_name_type'] =   $this->input->post('last_name_type',TRUE);
                $form_data['txtDirectAddress'] =   $this->input->post('txtDirectAddress',TRUE);
                $form_data['direct_address_type'] =  $this->input->post('direct_address_type',TRUE);
                $form_data['txtUserName']  =   $this->input->post('txtUserName',TRUE);
                $form_data['userName_type'] =   $this->input->post('userName_type',TRUE);
                $form_data['user_status_type'] = $is_user_active;
                $form_data['whichfacility'] = $facility_id;
                //$form_data['end_date'] =   $this->input->post('end_date',TRUE);
                //$form_data['start_date'] =   $this->input->post('start_date',TRUE);
            }

            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);
        
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            //set form data and send form_data
            $form_data['items_per_page'] = $items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['pages'] = $pages;
            
            //Sorting Array 
            $ldapfilters = array();
            //Converting to array for sorting
            $new_array = $this->object_to_array($SummaryListing);
            //filter_sn
            $sn_filter = $this->input->post('txtSN',TRUE);
            if($sn_filter != ""){
                $sn_filter_type = $this->input->post('last_name_type',TRUE);
                array_push($ldapfilters, 'Last Name ' . mb_strtolower($data['compare'][$sn_filter_type]). ': ' . $sn_filter);
                //setting filter type
                $search_sn = $this->search_type_for_array($sn_filter,$sn_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userSN', $search_sn);
            }
            //filter_given_name
            $givenname_filter = $this->input->post('txtGivenname',TRUE);
            if($givenname_filter != ""){
                $givenname_filter_type = $this->input->post('first_name_type',TRUE);
                array_push($ldapfilters, 'First Name ' . mb_strtolower($data['compare'][$givenname_filter_type]). ': ' . $givenname_filter);
                //setting filter type
                $search_givenname = $this->search_type_for_array($givenname_filter,$givenname_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userGivenname', $search_givenname);
            }
            //filter_va_address
            $direct_address_filter = $this->input->post('txtDirectAddress',TRUE);
            if($direct_address_filter != ""){
            
            $direct_address_filter_type = $this->input->post('direct_address_type',TRUE);
            array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_type]). ': ' . $direct_address_filter);

            //setting filter type
            $search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_type);    
            //Search on array for true values
            $new_array = $this->array_multi_search_filter($new_array, 'userMail', $search_direct_address);    
            }            
            $size = count($new_array);        
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            $data['form_data'] = $form_data;
            
            $SummaryListingExport = new stdClass;
            $SummaryListingExport = $this->array_to_object($SummaryListing);
            
            unset($SummaryListing);
            $SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $items_per_page));
            $data['summary_list'] = $SummaryListing;
            
            $SummaryListingExport_2 = new stdClass;
            $SummaryListing_2 = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $SummaryListingExport_2 = $this->array_to_object($SummaryListing_2);
            
                
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);

            if($selector['F.id'] != '(ALL)') $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name;
            //pagination setup
            $pages->items_total = count($new_array);
            $pages->current_page = $destination_page;
            $pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }
                else { $data['facility'] = 'No facility set'; }
            }
            $data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
            //Adhoc_Report
            $response_adhoc = $this->reports_helper_adhoc('user_activity_summary',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
        } else if (!empty($adhoc_report_id)){
            /*Adhoc Report - Starts Here*/
            
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            $adhoc_report_data = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"user_activity_summary")->result();
            //Filters and Data from db
            if(!isset($adhoc_report_data[0])){
                show_404();
            }
            $report_selector = $adhoc_report_data[0]->report_selector;
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);

            $facility_selected = $filters_used['facility_id'];
            if (mb_strtolower ($facility_selected) == "(all)"){
                $facility_selected ="";
            }
            $selector = array(
                    'F.id' => ($facility_selected),
            );
        
            //Date information
            $is_user_active =  $filters_used['user_status_type'];
            if(mb_strtolower($is_user_active) == "(all)"){
                $items = array(
                    'U.username' => $this->search_type( $filters_used['txtusername'], $filters_used['username_type']),
                    'user_ext_mail' => $this->search_type ($filters_used['txtvaemailaddress'], $filters_used['va_email_type']),
                );
            } else {
                $items = array(
                    'U.username' => $this->search_type( $filters_used['txtusername'], $filters_used['username_type']),
                    'user_ext_mail' => $this->search_type( $filters_used['txtvaemailaddress'], $filters_used['va_email_type']),
                    'is_active' =>  $filters_used['user_status_type'],
                );
            }

            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );    
            //From Adhoc Form
            $diff_time_period =  $this->input->post('time_period',TRUE);
            
            //Get Date information
            $time_period_field = $adhoc_report_data[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];
                    
            if(!empty($diff_time_period)){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report_data[0]->report_query_generator;
                
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);    

                //Date information
                $items = array();
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report_data[0]->report_query_generator;
                
                //Date information
                $items = array();
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
    
            }
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            //Setting exports
            
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
            $page =1;
            $items_per_page = 10;
            $between = array(
                'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            
            //get direction (desc/asc)and if it is being exported
            
            $order_search = $adhoc_report_data[0]->report_order_by ." " .$adhoc_report_data[0]->report_order_by_direction.",id ".$adhoc_report_data[0]->report_order_by_direction;
            $order = $adhoc_report_data[0]->report_order_by;
            $dir = $adhoc_report_data[0]->report_order_by_direction;
            
            //calls helper to get data
            //Checking role permissions
            if(!$all_report){
                $sql_permission = '';
                $i = 0;
                $sql_queries_by_part = explode("AND", $sql);
                foreach ($sql_queries_by_part as $id){
                if ($i > 0){
                    $sql_permission .=" AND ";
                 }
                if (string_contains('F.id', $id)) {
                        $sql_permission .= "(F.id like '%".$facility_id."%')";
                    } else {
                        $sql_permission .= $id;
                    }
                $i++;    
                }
                //assigning new query to $sql
                $sql = $sql_permission;
            }
            
            //sql query that excludes the date filter to include users who had no acitivity during the time period specified
            $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
            $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
            
            $size = $this->useractivitysummarymodel->get_user_list_size($sql_date_filter_excluded)->result();
            $size = $size[0]->count;
            $users_facility_list = $this->useractivitysummarymodel->get_request_filter_user_activities($sql,$sql_date_filter_excluded,$order_search,$this->db->escape($page),$items_per_page);
            
            //Adhoc_Report
            if(!$facility_selected) {
                $response_adhoc = "0=0 AND (F.id like '%' OR F.id IS NULL)";
            } else {
                $response_adhoc = $this->reports_helper_adhoc('user_activity_summary',$items,$between,$selector,array(),$order,$dir,$destination_page,$export,$items_per_page);
            }
            $counter = 0;
            //merge arrays
            foreach ($users_facility_list as $userInfo){
                //print_r($userInfo);
                
                $userUsername = $userInfo->Username;
                $userID = $userInfo->id;
                $userFacilityName = $userInfo->Name;                
                $userNumber_of_sent = $userInfo->Number_of_sent;
                $userNumber_of_seen = $userInfo->Number_of_seen;
                $userTotal_of_messages = $userInfo->Total_messages;
                $user_ext_mail = $userInfo->user_ext_mail;
                $userRow = $userInfo->row;
                $userIsActive = $userInfo->is_active;
                //Get LDAP Information
                $resultArray = $this->useractivitysummarymodel->get_ldap_request($userInfo->Username);
                
                //checking that LDAP Results are not null
                if (isset ($resultArray[0]['givenname'][0])){
                    $userGivenname = $resultArray[0]['givenname'][0];
                } else { $userGivenname = '';}

                
                if (isset ($resultArray[0]['sn'][0])){
                    $userSN = $resultArray[0]['sn'][0];
                }else { $userSN = ''; }
                
                if (isset ($resultArray[0]['mail'][0])){
                    $userMail = $resultArray[0]['mail'][0];
                }else{
                    $userMail = "not found";
                }
                
                if($userIsActive == 1){ $userActiveText = 'Active'; }
                else { $userActiveText = 'Inactive'; }
                
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->userSN = $userSN;
                $SummaryListingObjects->userGivenname = $userGivenname;                    
                $SummaryListingObjects->username = $userUsername;
                $SummaryListingObjects->userMail = $userMail;
                $SummaryListingObjects->facilityName = $userFacilityName;
                $SummaryListingObjects->userStatus = $userActiveText;
                $SummaryListingObjects->user_ext_mail = $user_ext_mail;
                $SummaryListingObjects->userNumber_of_sent = $userNumber_of_sent;
                $SummaryListingObjects->userNumber_of_seen = $userNumber_of_seen;            
                $SummaryListingObjects->userTotal_of_messages = $userTotal_of_messages;
                array_push($SummaryListing, $SummaryListingObjects);
                
            }
            //set form data
            $form_data = $this->input->post(NULL,TRUE);        
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['order'] = $order;
            
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            //set form data and send form_data
            $form_data['items_per_page'] = $items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            
            //Form Data from DB            
            $form_data['txtGivenname'] =   $filters_used['txtgivenname'];
            $form_data['first_name_type'] =   $filters_used['first_name_type'];
            $form_data['txtVAEmailAddress'] =   $filters_used['txtvaemailaddress'];
            $form_data['va_email_type'] =   $filters_used['va_email_type'];
            $form_data['txtSN'] =   $filters_used['txtsn'];
            $form_data['last_name_type'] =   $filters_used['last_name_type'];
            $form_data['txtDirectAddress'] =   $filters_used['txtdirectaddress'];
            $form_data['direct_address_type'] =   $filters_used['direct_address_type'];
            $form_data['txtUserName'] =   $filters_used['txtusername'];
            $form_data['userName_type'] =   $filters_used['username_type'];
            $form_data['user_status_type'] =   $filters_used['user_status_type'];
            $form_data['whichfacility'] =   $filters_used['facility_id'];
            $form_data['end_date'] =  $end_date;
            $form_data['start_date'] =  $start_date;
            $form_data['facility_id'] = $facility_id;
            $form_data['pages'] = $pages;
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report_data[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report_data[0]->report_name;
            $form_data['report_description'] = $adhoc_report_data[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report_data[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
            $data['form_data'] = $form_data;
            
            //Sorting Array 
            $ldapfilters = array();
            //Converting to array for sorting
            $new_array = $this->object_to_array($SummaryListing);
            //filter_sn
            $sn_filter =  $filters_used['txtsn'];
            if($sn_filter != ""){
                $sn_filter_type =  $filters_used['last_name_type'];
                array_push($ldapfilters, 'Last Name ' . mb_strtolower($data['compare'][$sn_filter_type]). ': ' . $sn_filter);
                //setting filter type
                $search_sn = $this->search_type_for_array($sn_filter,$sn_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userSN', $search_sn);
            }
            //filter_given_name
            $givenname_filter =  $filters_used['txtgivenname'];
            if($givenname_filter != ""){
                $givenname_filter_type =  $filters_used['first_name_type'];
                array_push($ldapfilters, 'First Name ' . mb_strtolower($data['compare'][$givenname_filter_type]). ': ' . $givenname_filter);
                //setting filter type
                $search_givenname = $this->search_type_for_array($givenname_filter,$givenname_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userGivenname', $search_givenname);
            }
            //filter_va_address
            $direct_address_filter =  $filters_used['txtdirectaddress'];
            if($direct_address_filter != ""){
                 $direct_address_filter_Type =  $filters_used['direct_address_type'];
                array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_Type]). ': ' . $direct_address_filter);
                //setting filter type
                $search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_Type);    
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userMail', $search_direct_address);    
            }                                
            
            unset($SummaryListing);
            $SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $items_per_page));
            $data['summary_list'] = $SummaryListing;
            
            $SummaryListingExport = $SummaryListing;
            $SummaryListingExport_2 = $SummaryListing;
            
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
            
            
            if(mb_strtolower ($selector['F.id']) != "(all)" && $selector['F.id'] != ''){ $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name; }
            //pagination setup
            $pages->items_total = count($new_array);
            $pages->current_page = $destination_page;
            $pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }
                else { $data['facility'] = 'No facility set'; }
            }
            $data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);

        } else {
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            
            $users_facility_list = $this->useractivitysummarymodel->get_first_user_activities($items_per_page)->result();
            foreach ($users_facility_list as $userInfo){
                //print_r($userInfo);
                $userUsername = $userInfo->Username;
                $userID = $userInfo->id;
                $userFacilityName = $userInfo->Name;                
                $userNumber_of_sent = $userInfo->Number_of_sent;
                $userNumber_of_seen = $userInfo->Number_of_seen;
                $userTotal_of_messages = $userInfo->Total_messages;
                $userRow = $userInfo->row;
                $userIsActive = $userInfo->is_active;
                $user_ext_mail = $userInfo->user_ext_mail;
                //Get LDAP Information
                $resultArray = $this->useractivitysummarymodel->get_ldap_request($userInfo->Username);
                //checking that LDAP Results are not null
                if (isset ($resultArray[0]['givenname'][0])){
                    $userGivenname = $resultArray[0]['givenname'][0];
                }
                else { $userGivenname = 'not found';}
                
                if (isset ($resultArray[0]['sn'][0])){
                    $userSN = $resultArray[0]['sn'][0];
                }
                else { $userSN = 'not found'; }
                
                if (isset ($resultArray[0]['mail'][0])){
                    $userMail = $resultArray[0]['mail'][0];
                }
                else { $userMail = 'not found'; }
                
                if($userIsActive == 1){ $userActiveText = 'Active'; }
                else { $userActiveText = 'Inactive'; }
                
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->userSN = $userSN;
                $SummaryListingObjects->userGivenname = $userGivenname;                    
                $SummaryListingObjects->username = $userUsername;
                $SummaryListingObjects->userMail = $userMail;
                $SummaryListingObjects->facilityName = $userFacilityName;
                $SummaryListingObjects->user_ext_mail = $user_ext_mail;
                $SummaryListingObjects->userStatus = $userActiveText;
                $SummaryListingObjects->userNumber_of_sent = $userNumber_of_sent;
                $SummaryListingObjects->userNumber_of_seen = $userNumber_of_seen;            
                $SummaryListingObjects->userTotal_of_messages = $userTotal_of_messages;
                
                array_push($SummaryListing, $SummaryListingObjects);
            
            }
            
            $size = $this->useractivitysummarymodel->get_first_user_activities_list_size()->result();
            $size =  count((array)$size);
            $form_data = array(
                    'direction' => 'DESC',
                    'order' => 'facilityName',
                    'cur_page' => '1',
            );
            //set options for comparing
                $data['compare'] = array(
                        'equals' => 'Equals',
                        'contains' => 'Contains',
                        'starts' => 'Starts With',
                        'ends' => 'Ends With'
                );
            //Adhoc Report
            $between = array ("ms.timestamp" => Array("start"=>"", "end" =>""));
            $response_adhoc = "0=0 AND (F.id like '%' OR F.id IS NULL)";
            $dir = "DESC";    
            $order = "facilityName";
            //set blank filters    
            $form_data['txtGivenname'] = "";
            $form_data['first_name_type'] = "";
            $form_data['txtVAEmailAddress'] ="";
            $form_data['va_email_type'] = "";
            $form_data['txtSN'] = "";
            $form_data['last_name_type'] = "";
            $form_data['txtDirectAddress'] = "";
            $form_data['direct_address_type'] =  "";
            $form_data['txtUserName'] = "";
            $form_data['userName_type'] = "";
            $form_data['user_status_type'] = "(ALL)";
            $form_data['whichfacility'] = "(ALL)";
            $form_data['end_date'] = "";
            $form_data['start_date'] = "";
            $data['form_data'] = $form_data;
            $data['filters'] = ' ';
            
            //pagination setup
            $pages->items_total = $size;
            $pages->current_page = $destination_page;
            $pages->paginate();
            $form_data['pagination_bar'] = $pages->display_pages();
            $form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
            $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
            $form_data['items_per_page'] = $items_per_page;
            $data['items_per_page'] = $items_per_page;
            $form_data['pages'] = $pages;
            $data['form_data'] = $form_data;
            $data['summary_list'] = $SummaryListing;
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            //Export Settings
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            $data['is_export'] = FALSE;
            //Adding VA Totals
            $users_facility_list_totals = $this->useractivitysummarymodel->get_first_user_activities($pages->items_total)->result();
            $summary_listing_totals = array();
            
            foreach ($users_facility_list_totals as $user_info_total){
                $user_number_of_sent = $user_info_total->Number_of_sent;
                $user_number_of_seen = $user_info_total->Number_of_seen;
                $user_total_of_messages = $user_info_total->Total_messages;
                $summary_listing_objects_totals = new stdClass;
                //Adding to Original Array
                $summary_listing_objects_totals->userNumber_of_sent = $user_number_of_sent;
                $summary_listing_objects_totals->userNumber_of_seen = $user_number_of_seen;            
                $summary_listing_objects_totals->userTotal_of_messages = $user_total_of_messages;
                array_push($summary_listing_totals, $summary_listing_objects_totals);
            }
            //Adding to SummaryListing_Totals
            $new_summary_array = array();
            $new_summary_array = $summary_listing_totals;
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_summary_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
        }
        
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;            
        $data['adhoc_report_direction'] = $order; 
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "user_activity_summary";
        //set form data and send form_data
        $form_data['items_per_page'] = $items_per_page;
        $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
        $form_data['num_pages'] = ceil($size/$items_per_page);//num of log pages
        
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        //Set view or export view
        if($export){
        //Setting Excel
        if (!empty($SummaryListingExport_2)){
                $SummaryListingExport = $SummaryListingExport_2;
            }else{
                $SummaryListingExport = $SummaryListingExport;
            }
            $totalCount = count((array)$SummaryListingExport);
            $newRowNumber = $totalCount + 1;
            $SummaryListingExport->$totalCount = new StdClass;
            $SummaryListingExport->$totalCount->userSN = '';
            $SummaryListingExport->$totalCount->userGivenname = '';
            $SummaryListingExport->$totalCount->username = '';
            $SummaryListingExport->$totalCount->userMail = '';
            $SummaryListingExport->$totalCount->facilityName = '';
            $SummaryListingExport->$totalCount->userStatus = '';
            $SummaryListingExport->$totalCount->user_ext_mail = 'VA Total:';
            $SummaryListingExport->$totalCount->userNumber_of_sent = $this->sum_by_object_name((array)$SummaryListingExport, 'userNumber_of_sent');
            $SummaryListingExport->$totalCount->userNumber_of_seen = $this->sum_by_object_name((array)$SummaryListingExport, 'userNumber_of_seen');
            $SummaryListingExport->$totalCount->userTotal_of_messages = $this->sum_by_object_name((array)$SummaryListingExport, 'userTotal_of_messages');
            $this->export(array('Last Name', 'First Name','Username','Direct Address','VA Facility','User Status', 'VA email Address', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListingExport,$export_file_name,$items,$between,$selected,$ldapfilters);
        }
        else if($export_pdf) {
            if (!empty($SummaryListingExport_2)){
                $data['export_summary_list'] = $SummaryListingExport_2;
            }
            /* else{
                $data['summary_list'] = $SummaryListingExport;
            } */
            $html = $this->load->view('api/reports/result_tables/result_user_activity_summary', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html);
        } 
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($SummaryListingExport_2)){
                $data['export_summary_list'] = $SummaryListingExport_2;
            }
            //else { $data['summary_list'] = $SummaryListingExport; }
            $data['print_page'] = true;
            $this->load->view('api/reports/user_activity_summary', $data);
        }
        else{
            $data['summary_list_totals'] = $summary_listing_totals;
            $this->load->view('api/reports/user_activity_summary', $data);
        }
    
    }

    //converts the id into the name based on what type it is
    protected function id_to_name($type,$id){
        $this->load->model('accountrequestmodel');
        $data=array();
        switch ($type){
            case 3://a user
                //suppress warning in case user id isn't provided
                $name = @$this->usersmodel->get_username_from_id($id);
                if($name){
                    $data['id'] = $name;
                }
                else{
                    $data['id'] = "N/A";
                }
                $data['type']="User";
                break;
            case 2://an application
                $name = $this->applicationmodel->get_application($id)->result();
                if($name){
                    $data['id'] = $name[0]->name;
                }
                else{
                    $data['id'] = "N/A";
                }
                $data['type'] = "Application";
                break;
            case 1://an application request
                $data['type'] = "App Request";
                $request = $this->applicationrequestmodel->get_request($id);
                if($request) {
                    $name = $request->result();
                    if($name){ $data['id'] = $name[0]->name; }
                }
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 4://user request
                $data['type'] = "User Request";
                $request = $this->accountrequestmodel->get_request($id);
                if($request) {
                    $name = $request->result();
                    if($name){ $data['id'] = $name[0]->user_org_id; }
                }
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 5://category
                $data['type'] = "Category";
                $request = $this->ticketcategorymodel->get_category($id);
                if($request) {
                    $name = $request->result();
                    if($name){ $data['id'] = $name[0]->category; }
                }
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 6://group
                $data['type'] = "Group";
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 7://facility
                $request = $this->facilitymodel->get_facility($id);
                $data['type'] = "Facility";
                if($request) {
                    $name = $request->result();
                    if($name){ $data['id'] = $name[0]->name; }
                }
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 8://Message
                $data['type'] = "Search";
                if($id){
                    $data['id'] = $id;
                }
                else { $data['id'] = 'N/A'; }
                break;
        }
        return $data;
    }
    
    protected function get_type($id) {
        switch ($id){
            case 3:
                return "User";
            case 2://an application
                return "Application";
            case 1://an application request
                return "App Request";
            case 4://user request
                return "User Request";
            case 5://category
                return "Category";
            case 6://group
                return "Group";
            case 7://facility
                return "Facility";
            case 8://Message
                return "Search";
        }
    }
    
    //chooses which (asc or desc) the table should be
    protected function direction_check($order,$lastorder,$direction,$change){
        //reloaded by filter and not clicking to change direction.  also make sure that it was not changed by user
        if ($change == 'false' && ($direction == "DESC" || $direction == "ASC")){
            return $direction;
        }
        //colum selected is same as last
        if($order == $lastorder){
            if($direction == 'DESC'){
                return 'ASC';
            }
            else{
                return "DESC";
            }
        }
        //clicked on new colum
        else{ 
            return "DESC";
        }
    }
    /* This function returns the values of sum */
    function sum_by_object_name(array $arr, $property) {
        $sum = 0;  
        foreach($arr as $object) {
            $sum += isset($object->{$property}) ? $object->{$property} : 0;
        }
        return $sum;
    }     

    /**
    * Ensures that a date is not a future date, i.e. a date later than the current time.
    * Future dates will be replaced with the current date in the given format.
    *
    * We're currently not prepared to deal with dates prior to 1901, which is well before the start of the Direct
    * project and shouldn't come up in the reports anyway.  To be safe, we'll make sure that a date is not earlier than 01/01/2000 12:00:00 am Eastern Time.
    * Dates will be replaced with 01/01/2000 12:00:00 am Easter Time if they're earlier than that.
    *
    * Created for issue VAD-749, VAD-807, and VAD-812.
    * @author Harry Guo <guo_haoyu@ne.bah.com>
    */
    protected function reports_correct_out_of_bound_date($date_string) {
        
        $date = $this->parse_date($date_string);
        
        if ( $date ) {
            if ( new DateTime() < $date ) {
                $date_string = date('m/d/Y h:i a T');
            } 
            else if ( $date < new DateTime('01/01/2000 12:00 AM EST') ) {
                $date_string = '01/01/2000 12:00 AM EST';
            }   
        }
        
        return $date_string;
    }
    /**
    * Check whether a pair of dates (a start date and an end date) are valid.
    * Return null value for any date that's either invalid or of unacceptable format. 
    * Alter dates that are out of pre-defined boundaries.
    * Return UNIX timestamp for any accepted and/or altered date.
    * 
    * A date here is referring to a date/time string.
    *
    * A date in considered valid here only if it can be parsed by parse_date() method.
    *
    * Accepted format string pattern is defined in get_date_pattern() method, such as 
    * M/D/YYYY, M/D/YYYY hh:mm:ss, with optional am/pm, and/or an optional time zone abbreviation code.
    * Such format restriction was the results of requiring a 4 digits year, instead of allowing 2 digits.
    *
    * If a date is earlier than 01/01/2000 12:00:00 AM EST, it will be altered to this date.
    *
    * If a date is later than Tue, 19 Jan 2038 03:14:07 UTC, it will be altered to this date.
    * 
    * If a date is a future date, it will be altered to the current time.
    *
    * Modstly of such restrictions are set due to the limitated date range of PHP:
    *    Fri, 13 Dec 1901 20:45:54 UTC to Tue, 19 Jan 2038 03:14:07 UTC.
    *    (http://php.net/manual/en/function.strtotime.php)
    * 
    * Created for issue VAD-749, VAD-807, and VAD-812.
    * @author Harry Guo <guo_haoyu@ne.bah.com>
    */    
    protected function check_paired_dates($start, $end) {

        // Criteria consistent with function get_paired_dates_filter_validation_message.

        $timestamps = array();

        foreach(array('start' => trim($start), 'end' => trim($end)) as $description => $date_string){
            $date = $this->parse_date($date_string);
            
            $timestamp = null;

            if ( $date && $this->is_a_report_filter_date($date_string) ) {
                // date valid and in acceptable format

                $date_high_bound = new DateTime('01/19/2038 03:14:07 UTC');
                $now = new DateTime();

                // A future date is changed to current time
                if ( $date > $now ) {
                    $date = $now;
                }
                // A current time later than 1/19/2038 03:14:07 UTC
                // is changed to 1/19/2038 03:14:07 UTC
                if ( $date > $date_high_bound ) {
                    $date = $date_high_bound;
                }
                // Old date before 01/01/2000 12:00 AM EST is changed to 
                // 01/01/2000 12:00 AM EST
                $date_low_bound  = new DateTime('01/01/2000 12:00 AM EST');
                if ( $date < $date_low_bound ) {
                    $date = $date_low_bound;
                }
                $timestamp = $date->getTimestamp();
            }
            $timestamps[$description] = $timestamp;
        }
        return $timestamps;
    }



    //sets value of search based on what type of comparison
    protected function search_type($value,$type){
        
        if($value == ''){//if no value ignore type
            return "%";
        }
        
        switch ($type){
            case 'equals':
                return $value;
                break;
            case 'contains':
                return "%".$value."%";
                break;
            case 'starts':
                return $value."%";
                break;
            case 'ends':
                return "%".$value;
                break;
            default:
                return $value;
                break;
        }
    }
    
    //sets value of search based on what type of comparison
    protected function search_type_for_array($value,$type){
        
        if($value == ''){//if no value ignore type
            return "%";
        }
        
        switch ($type){
            case 'equals':
                return "/^".$value."$/i";
                break;
            case 'contains':
                return "/".$value."/i";
                break;
            case 'starts':
                return "/^".$value."/i";
                break;
            case 'ends':
                return "/".$value."$/i";
                break;
            default:
                return "/^".$value."$/i";
                break;
        }
    }
    //gets the ids from each of the tabels to add  them to the query
    protected function names_to_ids($idsql,$typesql,$name,$type){
        $type = mb_strtoupper($type);
        $this->load->model('accountrequestmodel');
        $sql = "";
        if($type == "3" || $type == "(ALL)"){//if it is a user
            if($typesql){
                $sql .= "(".$typesql." = 3 AND (";
            }
            else{
                $sql .= "((";
            }
            $add = "(2=1)";
            if($name=='%'){//if blank dont even search
                $add .= " OR (1 = 1)";
            }
            else{
                $results=$this->usersmodel->get_ids_from_username($name)->result();//search for ids like name
                foreach($results as $result){//add each username to     
                    $add .= " OR (".$idsql." = ". $result->user_id.")";
                }
            }
            $sql .=$add."))";
        }
        if($type == "2" || $type == "(ALL)"){//if application
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                $sql .= "(".$typesql." = 2 AND (";
            }
            else{
                $sql .= "((";
            }
            $add = "(2=1)";
            if($name=='%'){
                $add .= " OR (1 = 1)";
            }
            else{
                $results=$this->applicationmodel->get_ids($name)->result();
                foreach($results as $result){    
                    $add .= " OR (".$idsql." = ". $result->id.")";
                }
            }
            $sql .=$add."))";
        }
        if($type == "1" || $type == "(ALL)"){//if application request
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                $sql .= "(".$typesql." = 1 AND (";
            }
            else{
                $sql .= "((";
            }
            $add = "(2=1)";
            if($name=='%'){
                $add .= " OR (1 = 1)";
            }
            else{
                $results=$this->applicationrequestmodel->get_ids($name)->result();
                foreach($results as $result){
                    $add .= " OR (".$idsql." = ". $result->id.")";
                }
            }
            $sql .=$add."))";
            
        }
        if($type == "4" || $type == "(ALL)"){//if user request
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                $sql .= "(".$typesql." = 4 AND (";
            }
            else{
                $sql .= "((";
            }
            $add = "(2=1)";
            if($name=='%'){
                $add .= " OR (1 = 1)";
            }
            else{
                $results=$this->accountrequestmodel->get_ids($name)->result();
                foreach($results as $result){
                    $add .= " OR (".$idsql." = ". $result->id.")";
                }
            }
            $sql .=$add."))";
            
        }
        if($type == "6" || $type == "(ALL)"){//groups
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                if($name == '%'){
                    $sql .= "(".$typesql." = 6)";
                }
                else{
                    $sql .= "(".$typesql." = 6 AND ".$idsql." like ".$this->db->escape($name).")";
                }
            }
                
        }
        if($type == "8" || $type == "(ALL)"){//messages
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                if($name == '%'){
                    $sql .= "(".$typesql." = 8)";
                }
                else{
                    $sql .= "(".$typesql." = 8 AND ".$idsql." like ".$this->db->escape($name).")";
                }
            }
        
        }
        if($type == "5"){//if user using org id
            if($name=='%'){
                $sql .='(1=1)';
            }
            else{
                $results=$this->usersmodel->get_orgs_from_username($name)->result();
                $sql.= "(2=1)";
                foreach($results as $result){    
                    $sql .= " OR (".$idsql." = ". $result->user_org_id.")";
                }
            }
        }
        return $sql;
    }
    
    //generates and returns respose for filtered query
    protected function reports_helper($table,$items,$between,$selector,$typesearch,$order,$dir,$page,$export,$items_per_page) {
        $sql = '0=0';//always true statment to start query
        //add each item to query
        foreach ($items as $key => $value){//this if for search field
            if($value!="%"){
                $sql = $sql." AND (". $key ." like ". $this->db->escape($value).")";
            }
        }
        foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
            if($value['end']){
                $sql = $sql." AND (". $key ." <= ".$this->db->escape($value['end']).")";
            }
            if($value['start']){
                $sql = $sql." AND (". $key ." >= ".$this->db->escape($value['start']).")";
            }
        }
        foreach ($selector as $key => $value){//this if for ones with a drop down menu
            if(mb_strtoupper($value) == "(ALL)"){
                $sql = $sql." AND (". $key ." like '%' OR ".$key." IS NULL)";
            }
            else{
                $sql = $sql." AND (". $key ." like ". $this->db->escape($value).")";
            }
        }
                
        foreach($typesearch as $key => $value){//this if for inputs that have different types and their ids refer to different entries on different tables
            if(!(mb_strtoupper($value['type'])=="(ALL)" && $value['name']=="%")){
                $sql = $sql." AND (". $this->names_to_ids($key,$value['typesql'],$value['name'],$value['type']) .")";
            }
        }
        if($order != 'id') {
            $order = str_replace("'","",$order). " ". $dir. ",id ". $dir ;//what to order values into
        }
        //get starting point based on page number
        if(!$page){
            $page = 1;
        }
        $page = (($page-1)*$items_per_page)+1;
        switch($table){//choose what reports you are looking at
            case 'request':
                //get size
                $size = $this->requestmodel->get_filted_size($sql)->result();
                $size = $size[0]->count;
                if($export){//if export get all pages
                    if(string_contains('application_id', $order)){//if sorting by application_id
                        $responses_list = $this->requestmodel->get_request_filter_export_app_order($sql,$order)->result();
                        //$responses_list= $this->requestmodel->get_request_filter_app_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    
                    }
                    else{
                        $responses_list = $this->requestmodel->get_request_filter_export($sql,$order)->result();
                        //$responses_list= $this->requestmodel->get_request_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    
                    }
                }
                else{
                    //if you are on a page larger then what the size will be go back to first page
                    if($size<$page){
                        $page = 1;
                    }
                    if(string_contains('application_id', $order)){//if sorting by application_id
                        $responses_list= $this->requestmodel->get_request_filter_app_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                    else{
                        $responses_list= $this->requestmodel->get_request_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                }
                break;
            case 'event':
                $size = $this->eventmodel->get_filted_size($sql)->result();
                $size = $size[0]->count;
                if($export){//if export get all pages
                    $responses_list = $this->eventmodel->get_event_filter_export($sql,$order)->result();
                }
                else{
                    if($size<$page){//if you are on a page larger then what the size will be go back to first page
                        $page = 1;
                    }
                    $responses_list= $this->eventmodel->get_event_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
                }
                break;
            case 'login':
                $size = $this->loginsmodel->get_filted_size($sql)->result();
                $size = $size[0]->count;
                
                if($export){//export get all pages
                    if(string_contains('user_id', $order)){//ordered by user id
                        $responses_list = $this->loginsmodel->get_login_filter_export_user_order($sql,$order)->result();
                    }
                    else{
                        $responses_list = $this->loginsmodel->get_login_filter_export($sql,$order)->result();
                    }
                }
                else{
                    if($size < $page){//if you are on a page larger then what the size will be go back to first page
                        $page = 1;
                    }
                    if(string_contains('user_id', $order)){//ordered by user id
                        $responses_list= $this->loginsmodel->get_login_filter_user_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                    else{
                        $responses_list= $this->loginsmodel->get_login_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                }
                break;
            case 'mail':
                $size = $this->mailmodel->get_filted_size($sql)->result();
                $size = $size[0]->count;
                if($export){ //export get all pages
                    $responses_list = $this->mailmodel->get_mail_filter_export($sql,$order)->result();
                }
                else{
                    if($size<$page){//if you are on a page larger then what the size will be go back to first page
                        $page = 1;
                    }
                    $responses_list= $this->mailmodel->get_mail_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
                }
                break;    
            case 'tickets':
                $size = $this->ticketsmodel->get_filtered_size($sql)->result();
                $size = $size[0]->count;
                if($export){ //export get all pages
                    if(string_contains('user_id', $order)){
                        $responses_list = $this->ticketsmodel->get_tickets_filter_export_user_order($sql,$order)->result();
                    }elseif(string_contains('category_id', $order)){
                        $responses_list = $this->ticketsmodel->get_tickets_filter_export_category_order($sql,$order)->result();
                    }else{
                        $responses_list = $this->ticketsmodel->get_tickets_filter_export($sql,$order)->result();
                    }
                }
                else{
                    if($size<$page){//if you are on a page larger then what the size will be go back to first page
                        $page = 1;
                    }
                    if(string_contains('user_id', $order)){
                        $responses_list= $this->ticketsmodel->get_tickets_filter_user_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }elseif(string_contains('category_id', $order)){
                        $responses_list= $this->ticketsmodel->get_tickets_filter_category_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }else{
                        $responses_list= $this->ticketsmodel->get_tickets_filter($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                }
                break;
            case 'facility':
                //getting size number
                $size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result();
                $size = $size[0]->count;
                if($export){//if export get all pages
                    $responses_list= $this->facilitymodel->get_request_filter_facility_order_export($sql,$order,$this->db->escape($page),$items_per_page)->result();
                } else { //if you are on a page larger then what the size will be go back to first page
                    if($size<$page){
                        $page = 1;
                    }
                    if(string_contains('name', $order)){//if sorting by name
                        $responses_list= $this->facilitymodel->get_request_filter_facility_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                    else{
                        $responses_list= $this->facilitymodel->get_request_filter_facility($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                }
                break;
            case 'user_activity_summary':
                //sql query that excludes the date filter to include users who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
                    
                //getting size number
                $size = $this->useractivitysummarymodel->get_user_list_size($sql_date_filter_excluded)->result();
                $size = $size[0]->count;
                if($export){//if export get all pages
                    $responses_list= $this->useractivitysummarymodel->get_request_filter_user_activities_export($sql,$sql_date_filter_excluded,$order,$this->db->escape($page),$items_per_page);
                } else { //if you are on a page larger then what the size will be go back to first page
                    if($size<$page){
                        $page = 1;
                    }
                    $responses_list = $this->useractivitysummarymodel->get_request_filter_user_activities($sql,$sql_date_filter_excluded,$order,$this->db->escape($page),$items_per_page);
                }
                
                break;    
            case 'group_activity_summary':
                //sql query that excludes the date filter to include groups who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
                
                //getting size number
                $size = $this->groupsmodel->get_group_list_size($sql_date_filter_excluded)->result();
                $size = $size[0]->count;
                if($export){//if export get all pages
                    $responses_list= $this->groupsmodel->get_request_filter_group_activities_export($sql,$sql_date_filter_excluded,$order,$this->db->escape($page),$items_per_page);
                } else { //if you are on a page larger then what the size will be go back to first page
                    if($size<$page){
                        $page = 1;
                    }
                    $responses_list= $this->groupsmodel->get_request_filter_group_activities($sql,$sql_date_filter_excluded,$order,$this->db->escape($page),$items_per_page);
                }
                break;
            default: //tries to call a bad reports table
	    	$this->error->should_be_a_known_report($table);
                break;
        }
        $response=array(
            'size'=>$size,
            'response'=>$responses_list
        );
        return $response;
        
    }
    
    /*
     * export is used for exporting the results to excel 
     */
#TODO - this is too many parameters for a function - if you need this many, it's a sign that this should be a configurable class/library. (Keep in mind when refactoring).     
	protected function export($header,$results,$name,$items,$between,$selected,$ldap,$report_id = null,$result_set_size = null, $save_to_file = null){
		if($report_id != null) {
			$token_name = 'fileDownloadToken' . $report_id;
		}
		else {
			$token_name = 'fileDownloadToken';
		}
		//set fileDownloadToken, so the system is able to detect when the file downloading window for pdf export returns
		setcookie($token_name, true, time() + 3600, '/reports/', false, false);
		setcookie('resultSetSize' . $report_id, $result_set_size, time() + 3600, '/reports/', false, false);
		
		if($save_to_file) {
			$path_to_temp_file = sys_get_temp_dir() . '\\' . time() . $report_id . '.csv';
			$fp = fopen($path_to_temp_file, 'w');
		}
		else {
			header('Content-Type: application/download');
			header('Content-Transfer-Encoding: binary');
			header('Content-Disposition: attachment; filename="'.$name.'.csv"');
			$fp = fopen('php://output', 'w');
		}
		
		
		$date = date('m/d/Y h:i:s A', time());
		$date = ' ' . (string)$date;
		fputcsv($fp,  array('FOR OFFICIAL USE ONLY', '', '', 'Report generated by '.$this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'], '', '', '', $date, '', ''));
		$activeFilters = array($this->export_info($items,$between,$selected,$ldap), '', '', '');
		fputcsv($fp, $activeFilters);
		fputcsv ($fp, $header);
		foreach($results as $result) {
			$row=array();
			foreach($result as $part) {
				array_push($row,$part);
			}
			fputcsv ($fp, $row);
		}
		fclose($fp);
		
		if($save_to_file) {
			$export_array['report_id'] = $report_id;
			$export_array['report_name'] = $name;
			$export_array['path_to_temp_file'] = $path_to_temp_file;
			
			return $export_array;
		}
	}

    protected function reports_facility_excel_data_alt( $facility_list ) { 

        $max = count($facility_list);
        $facility_list_alt = array();
        for($i = 0; $i < $max; $i++) {
            $facility = new StdClass;
            
            // 4: drafts, 6: total, 3: sent
            $number_of_total = $facility_list[$i]->Total_messages - $facility_list[$i]->Number_of_drafts;
            $number_of_sent  = $facility_list[$i]->Number_of_sent;
            $facility->name             = $facility_list[$i]->name;
            $facility->Number_of_users  = $facility_list[$i]->Number_of_users;
            $facility->Number_in_group  = $facility_list[$i]->Number_in_group;
            $facility->Number_of_sent   = $number_of_sent;
            $facility->Number_received  = $number_of_total - $number_of_sent;
            $facility->Total_messages   = $number_of_total;

            $facility_list_alt[] = $facility;
        }

        $facility_list_alt['totalCount'] = new StdClass;
        $facility_list_alt['totalCount']->name = 'VA Total:';
        $facility_list_alt['totalCount']->Number_of_users = $this->sum_by_object_name((array)$facility_list_alt, 'Number_of_users');
        $facility_list_alt['totalCount']->Number_in_group = $this->sum_by_object_name((array)$facility_list_alt, 'Number_in_group');
        $facility_list_alt['totalCount']->Number_of_sent  = $this->sum_by_object_name((array)$facility_list_alt, 'Number_of_sent');
        //have to do this because for some reason the export function is processing where to put the data based on the order these classes are added to the facility_list parent class
        #TODO: Fix export function to do this in a more sane way
        $Total_Messages = $this->sum_by_object_name((array)$facility_list_alt, 'Total_messages');
        $facility_list_alt['totalCount']->Number_received = $Total_Messages - $facility_list_alt['totalCount']->Number_of_sent;
        $facility_list_alt['totalCount']->Total_messages  = $Total_Messages;

        return $facility_list_alt;
    }
    //Prep SQL for Adhoc Reports
    protected function reports_helper_adhoc($table,$items,$between,$selector,$typesearch,$order,$dir,$page,$export,$items_per_page) {
        $sql = '0=0';//always true statment to start query
        //add each item to query
        foreach ($items as $key => $value){//this if for search field
            if($value!="%"){
                $sql = $sql." AND (". $key ." like ". $this->db->escape($value).")";
            }
        }
        foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
            if($value['end']){
                $sql = $sql." AND (". $key ." <= ".$this->db->escape($value['end']).")";
            }
            if($value['start']){
                $sql = $sql." AND (". $key ." >= ".$this->db->escape($value['start']).")";
            }
        }
        
        foreach ($selector as $key => $value){//this if for ones with a drop down menu
            if(strtoupper($value) == "(ALL)"){
                $sql = $sql." AND (". $key ." like '%' OR ".$key." IS NULL)";
            }
            else{
                $sql = $sql." AND (". $key ." like ". $value.")";
            }
        }
                
        foreach($typesearch as $key => $value){//this if for inputs that have different types and their ids refer to different entries on different tables
            if(!(strtoupper($value['type'])=="(ALL)"&&$value['name']=="%")){
                $sql = $sql." AND (". $this->names_to_ids($key,$value['typesql'],$value['name'],strtoupper($value['type'])) .")";
            }
        }
        
        return $sql;
    }
    
    protected function export_pdf($file_name, $html, $report_id = null, $result_set_size = null) {
        if($report_id != null) {
            $token_name = 'fileDownloadToken' . $report_id;
        }
        else {
            $token_name = 'fileDownloadToken';
        }
        $pdf = new WkHtmlToPdf(array(
                'binPath' => WKHTMLTOPDF_EXE_PATH
        ));
        // Add a HTML string
        $pdf->addPage($html);
        //set fileDownloadToken, so the system is able to detect when the file downloading window for pdf export returns
        setcookie($token_name, true, time() + 3600, '/reports/', false, false);
        setcookie('resultSetSize' . $report_id, $result_set_size, time() + 3600, '/reports/', false, false);
        
        if(!$pdf->send($file_name))
            throw new Exception('Could not create PDF: '.$pdf->getError());
        
    }
    
	public function export_all_in_zip() {
		$report_ids = $this->input->post('report_ids',TRUE);
		$export_type = $this->input->post('export_type',TRUE);
		$zip = new ZipArchive();
		$pdf = new WkHtmlToPdf(array('binPath' => WKHTMLTOPDF_EXE_PATH));
		$zip_name = time() . hexdec(bin2hex(openssl_random_pseudo_bytes(4))) . '.zip';
		$path_to_zip = $pdf->getTmpDir() . '\\' . $zip_name;
		$res = $zip->open($path_to_zip, ZipArchive::CREATE);
		$report_ids = explode(',', $report_ids);
		$temp_pdf_names = [];
		for($i = 0; $i < count($report_ids) - 1; $i++) {
			
			if($export_type === 'pdf') {
				$export_array = $this->adhoc_export($report_ids[$i], 'html');
				$pdf = new WkHtmlToPdf(array('binPath' => WKHTMLTOPDF_EXE_PATH));
				// Add a HTML string
				$pdf->addPage($export_array['html']);
				$path_to_temp_file = $pdf->getPdfFilename();
				$pdf->saveAs($path_to_temp_file.'.pdf');
				$temp_pdf_names[$i] = $path_to_temp_file.'.pdf';
				if ($res === TRUE) {
					$zip->addFile($path_to_temp_file.'.pdf', $export_array['report_name'] . '.pdf');
				}
				else {
					error_log('failed to add pdf file to the zip file.');
				}
			}
			else {
				$export_array = $this->adhoc_export($report_ids[$i], 'excel_to_file');
				$temp_pdf_names[$i] = $export_array['path_to_temp_file'];
				if ($res === TRUE) {
					$zip->addFile($export_array['path_to_temp_file'], $export_array['report_name'] . '.csv');
				}
				else {
					error_log('failed to add excel file to the zip file.');
				}
			}
		}
		
		//set fileDownloadAllToken, so the system is able to detect when the file downloading window for pdf export returns
		setcookie('fileDownloadAllToken', true, time() + 3600, '/reports/', false, false);
		if ($res === TRUE) {
			$zip->close();
		} else {
			error_log('failed to close the zip file.');
		}
	
		//delete temp pdf files
		foreach($temp_pdf_names as $pdf_name) {
			if(!unlink($pdf_name)) {
				error_log('failed to delete temp export files.');
			}
		}

		//the clean is necessary to keep returned zip file valid
		ob_clean();
		ob_end_flush();
		//return zip file to user
		header($_SERVER["SERVER_PROTOCOL"] . " 200 OK");
		header("Cache-Control: public"); // needed for i.e.
		header("Content-Type: application/zip");
		header("Content-Transfer-Encoding: Binary");
		header("Content-Length:".filesize($path_to_zip));
		header("Content-Disposition: attachment; filename=export_" . $export_type . ".zip");
		readfile($path_to_zip);
		//delete zip file
		if(!unlink($path_to_zip)) {
			error_log('failed to delete zip file.');
		}
		exit;
	}
    
    protected function export_info($items,$between,$selected,$ldap) {
        
        $filters = '';
        if ($items != null) {
            foreach ($items as $key => $value){
                if($value!="%" && $value != '(ALL)'){
                    if ($value[0]=='%' && mb_substr($value, -1)=='%') $value = 'contains: ' . trim($value, '%');
                    elseif ($value[0]=='%') $value = 'ends with: ' . trim($value, '%');
                    elseif (mb_substr($value,-1)=='%') $value = 'starts with: ' . trim($value, '%');
                    else {
                        $value = 'equals: ' . $value;
                    }
                    if($key=='id') $pair = 'ID ' . $value;
                    if($key=='session_id') $pair = 'Session ID ' . $value;
                    if($key=='name') $pair = 'Name ' . $value;
                    if($key=='message') $pair = 'Message ' . $value;
                    if($key=='org_id') $pair = 'Org ID ' . $value;
                    if($key=='call') $pair = 'Call ' . $value;
                    if($key=='response') $pair = 'Response ' . $value;
                    if($key=='response_code') $pair = 'Response Code ' . $value;
                    if($key=='parent_id') $pair = 'Parent ID ' . $value;
                    if($key=='action') $pair = 'Action ' . $value;
                    if($key=='ip_address') $pair = 'IP Address ' . $value;
                    if($key=='error_msg') $pair = 'Error Message ' . $value;
                    if($key=='size') $pair = 'Size ' . $value;
                    if($key=='attachment_types') $pair = 'Attachment Types ' . $value;
                    if($key=='sender') $pair = 'Sender ' . $value;
                    if($key=='recipient') $pair = 'Recipient ' . $value;
                    if($key=='U.username') $pair = 'Username ' . $value;
                    if($key=='M.name' || $key=='group_name') $pair = 'Group Name ' . $value;
                    if($key=='user_ext_mail') $pair = 'VA Email Address ' . $value;
                    if($key=='actor') $pair = 'Actor ' . $value;
                    if($key=='target') $pair = 'Target ' . $value;
                    if($key=='user_id') $pair = 'User ' . $value;
                    if($key=='is_active') {
                        if ($value == 'equals: 1') $pair = 'User Status: Active';
                        else $pair = 'User Status: Inactive';
                    }
                    $filters = $filters . ' ' . $pair . ', ';
                }
            }
        }
        if ($ldap!=null) {
            foreach ($ldap as $filter) {
                $filters = $filters . ' ' . $filter . ', ';
            }
        }
        foreach ($between as $key => $value){
            if($value['start']){
                $pair = 'Start date: ' . date('m/d/Y h:i:s A', $value['start']);
                $filters = $filters . ' ' . $pair . ', ';
            }
            if($value['end']){
                $pair = 'End date: ' . date('m/d/Y h:i:s A', $value['end']);
                $filters = $filters . ' ' . $pair . ', ';
            }
        }
        if($selected!=null){
            if (is_array($selected) && count($selected)>0) {
                foreach ($selected as $choice) {
                    if ($choice != null) {
                        $filters = $filters . ' ' . $choice . ', ';
                    }
                }
            }
            else {
                $filters = $filters . ' ' . $selected;
            }
        }
        if (mb_substr($filters, -2) ==", ") {
            $filters = mb_substr($filters, 0, -2);
        }
        
        if ($filters != ''){
            $filters_result = 'Active Filters: '.$filters;
            return $filters_result;
        } else {
            return $filters;
        }

        if (mb_strlen($filters) === 16){
            $filters = $filters.'None';
        }
        return $filters;

    }
    
    /**
    * Generate warning messages to be presented to users, based on the results of date validation.
    * 
    * Messsages fall into the following categories:
    *
    * 1. Either input date string is not considered valid by PHP function strtotime(). 
    * 2. Either input date string is not formatted as desired.
    * 3. Either input date string is valid and formatted well, but is either later than the current date/time, 
    *    or earlier than 01/01/2000 12:00:00 am EST.
    *
    * HTML list tags are added to warning messages.
    * 
    * Created for issue VAD-749, VAD-807 and VAD-812.
    * @author Harry Guo <guo_haoyu@ne.bah.com>
    */
    protected function get_paired_dates_filter_validation_message($start, $end) {
        $start = trim($start);
        $end = trim($end);
        $feedback_messages = array();
        
        if(empty($start) and empty($end)) return ''; //user isn't filtering by date; no validation message needed.
        
        foreach(array('start' => $start, 'end' => $end) as $field => $date_string) {
            //use the label for this field as the description
            $description = ucfirst($field).' Date'; 

            if(empty($date_string)){ 
                // Blank date provided. Report will be generated  without such date criteria.
                continue;
            }
            
            // Date not blank
            $date = $this->parse_date($date_string);

            if ( !$date || !$this->is_a_report_filter_date($date_string) ) {
                // Not blank but invalid or of unacceptable format
                // This includes the case that a year doesn't have 4 digits.
                $feedback_messages[] = 
                    'The value for the ' . $description .' field (' .$date_string . ') is invalid and will be ignored.  '     . 
                    'Dates should be formatted as MM/DD/YYYY or MM/DD/YYYY hh:mm:ss am/pm.  An optional U.S. '  .
                    'timezone abbreviation may be included (for example, EST).';
            }
            else {
                // Not blank and valid
                if ( $date < new DateTime('01/01/2000 12:00 AM EST') ) {
                    // Date before 01/01/2000 12:00 AM EST are changed to 
                    // 01/01/2000 12:00 AM EST
                    $feedback_messages[] = 
                        'The date provided for the '.$description.' field predates the Direct project.  01/01/2000 will be used instead.';                        
                }
                else if ( $date > new DateTime() ) {
			//If a future date is given for the start date, report will be generated with current date instead.  
			//Since we're actually changing the value in the form fields now, we'll display this message for end dates as well as start dates to prevent confusion.
			$feedback_messages[] = 'A future date was provided for the ' . $description . ' field. The current date will be used instead.';	
		}
            }
        }
   
	if(empty($feedback_messages)) return '';
        return ul_if_multiple($feedback_messages);        
    }
    
    //Setting Object to Array
    protected function object_to_array($object)
     {
      if (is_object($object))
      {
       // Gets the properties of the given object with get_object_vars function
       $object = get_object_vars($object);
      }
     
       return (is_array($object)) ? array_map(array($this,__FUNCTION__), $object) : $object;
     }
    //Setting Array to Object
    protected function array_to_object($array)
     {
      return (is_array($array)) ? (object) array_map(array($this,__FUNCTION__), $array) : $array;
     }

    protected function array_multi_search_filter( $array, $index, $pattern, $invert = FALSE ){
        $output = array();
        foreach ( $array as $i => $arr ){
            // The index must exist and match the pattern
            if ( isset( $arr[ $index ] ) && ( bool ) $invert !== ( bool ) preg_match( $pattern, $arr[ $index ] ) ){
                $output[ $i ] = $arr;
            }
        }
        return $output;
    }
    
#TODO - this should be a partial instead of a controller method	
    protected function create_tabs($selected){
        $this->verify_access($selected);
        $html = '<a class="hidden_context hidden_link" id="skipReportMenu" href="#reportFilter" style="font-weight: normal;">Skip Report Menu</a>';
        $html .= '<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">';
        foreach ($this->report_tabs as $key => $value){
            if($this->has_access($key."_report")){
                if(($key."_report") === $selected){
                    $html.= '<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/reports/'.$key.'">'.$value.'</a></li>';
                }else{
                    $html .= '<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/'.$key.'">'.$value.'</a></li>';
                }
                
            }
        }    
        $html .= '</ul>';
        $html .= '<a name="reportFilter" id="reportFilter" class="hidden_context hidden_link" style="font-weight: normal;">Report Filter</a>';
        $html .= '<a class="hidden_context hidden_link" id="skipReportFilter" href="#reportContent" style="font-weight: normal;">Skip Report Filter</a>';
        return $html;
    }
    
    protected function clear_cache() {
        header("Expires: ".gmdate("D, d M Y H:i:s", time())." GMT");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
    }
    
    /**
     * Save Adhoc Report
     */
    public function save_adhoc_report(){
    
        //Selecting Post Data
        $report_name = $this->input->post('report_name',TRUE);
        $report_description = $this->input->post('report_description',TRUE);
        $report_access = $this->input->post('report_access',TRUE);
        $adhoc_report_between = $this->input->post('adhoc_report_between',TRUE);
        $adhoc_report_selector = str_replace('###', '%', $this->input->post('adhoc_report_selector',TRUE));
        //$adhoc_report_selector = $this->json->decode($adhoc_report_selector);
        $adhoc_report_order = $this->input->post('adhoc_report_order',TRUE);
        $adhoc_report_direction = $this->input->post('adhoc_report_direction',TRUE);
        $adhoc_report_type = $this->input->post('adhoc_report_type',TRUE);
        $adhoc_report_start_date = $this->input->post('adhoc_report_start_date',TRUE);
        $adhoc_report_end_date = $this->input->post('adhoc_report_end_date',TRUE);
        $adhoc_report_selector_option = $this->input->post('adhoc_report_selector_option',TRUE);            
        $adhoc_report_time_field = $this->input->post('adhoc_report_time_field',TRUE);    
        $adhoc_report_id = $this->input->post('adhoc_report_id',TRUE);    
        //Setting view name to lower cases
        $view_result = mb_strtolower ($adhoc_report_type);
        
        //Getting username data
        $id = User::organization_id_from_session();
        $report_creator_id = $this->usersmodel->get_user_id_from_org_id($id); 
        $report_status = 0;
        if($this->is->nonzero_unsigned_integer($adhoc_report_id) && $this->adhoc_report_security_check($adhoc_report_id) !== FALSE){//if copied from another report
            $add_report = $this->adhocreportsmodel->copy_adhoc_report($adhoc_report_id ,$report_name, $report_description, $report_access, $report_creator_id, $report_status);
        }
        else{
            $add_report = $this->adhocreportsmodel->create_adhoc_report($report_name,$report_description,$report_access,$adhoc_report_between,$adhoc_report_selector,$adhoc_report_order,$adhoc_report_direction,$adhoc_report_type, $report_creator_id, $report_status, $adhoc_report_start_date, $adhoc_report_end_date, $adhoc_report_selector_option, $adhoc_report_time_field);
        }
        if($report_access == 'shared') {
            $report_id = $this->adhocreportsmodel->get_latest_report_id();
            $selected_group_names = $this->input->post('selected_group_names',TRUE);
            $selected_user_ids = $this->input->post('selected_user_ids',TRUE);
            
            $group_name_array = array();
            if($selected_group_names != null && $selected_group_names != '') {
                $group_name_array = explode(',', $selected_group_names);
            }
            $user_id_array = array();
            if($selected_user_ids != null && $selected_user_ids != '') {
                $user_id_array = explode(',', $selected_user_ids);
            }
            
            //add members in the groups in $user_id_array
            foreach($group_name_array as $group_name) {
                $members = $this->groupsmodel->get_members($group_name);
                foreach($members as $member) {
                    $member_id = $this->usersmodel->get_user_id_from_user_name($member);
                    array_push($user_id_array, $this->usersmodel->get_user_id_from_user_name($member));
                }
            }
            $has_report_been_shared_with_creator = false;
            $user_id_array = array_unique($user_id_array);
            foreach($user_id_array as $user_id) {
                $this->adhocreportsmodel->share_report($report_id, $user_id);
                if($report_creator_id == $user_id) {
                    $has_report_been_shared_with_creator = true;
                }
            }
            if(!$has_report_been_shared_with_creator) {
                $this->adhocreportsmodel->share_report($report_id, $report_creator_id);
            }
        }
        if($add_report == '1'){ 
            redirect('/reports/adhoc_reports/'.$report_access);
        }
        
    }
    /**
     * Create Adhoc Report List
     */
    public function adhoc_reports($show_report, $reports_id = null, $show_download = null, $export_type = null){
        //page set up
        $pages = new Paginator('');
        $pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        //Show Download Dialog
        $data['show_download'] = $show_download;
        if($show_download) {
            $warning_messages = '';
            foreach($reports_id as $id) {
                $info = $this->get_adhoc_export_size(intval($id), false);
                if($info['size'] > 1000) {
                    $warning_messages .= $info['report_name'] . ' contains ' . $info['size'] . ' records. ';
                }
            }
            if(!empty($warning_messages)) {
                $warning_messages .= 'This will take a few minutes. Are you sure you want to proceed?';
            }
            $data['warning_messages'] = $warning_messages;
        }
        
        //Pass ids to create links
        $data['reports_id'] = $reports_id;
        //Pass type of export
        $data['export_type'] = $export_type;
        
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("adhoc_reports_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
    
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        
        //Getting Username
        $id = User::organization_id_from_session();
        $user_id = $this->usersmodel->get_user_id_from_org_id($id); 
    
        //Show Reports Info
        $all_report = FALSE;
        if($this->has_access('user_activity_summary_report_all')){
            $all_report = TRUE;
        }
        //Report Display type
        switch ($show_report) {
            case 'personal':
                //Private  -  Personal Report List
                $private_reports = $this->adhocreportsmodel->get_private_reports($user_id, $all_report)->result();
                $data['report_list'] = $private_reports;
                $data['show_report'] = $show_report;
                break;
            case 'shared':
                //Shared Report List
                $shared_reports = $this->adhocreportsmodel->get_shared_reports($user_id, $all_report)->result();
                $data['report_list'] = $shared_reports;
                $data['show_report'] = $show_report;
                break;
            case 'everyone':
                //Global  -  Everyone Report List
                $global_reports = $this->adhocreportsmodel->get_global_reports($all_report)->result();
                $data['report_list'] = $global_reports;
                $data['show_report'] = $show_report;
                break;
            default:
                //Private  -  Personal Report List -  default
                $private_reports = $this->adhocreportsmodel->get_private_reports($user_id, $all_report)->result();
                $data['report_list'] = $private_reports;
                $data['show_report'] = 'personal';
        }
        
        $this->load->view('api/reports/adhoc_reports', $data);
    }
    
    public function get_adhoc_export_size($report_id = null, $is_ajax = null){
        if(empty($report_id)) {
            $report_id = $this->input->get('report_id',TRUE);
        }
        if(empty($is_ajax)) {
            $is_ajax = $this->input->get('is_ajax',TRUE);
        }
        $result_security = $this->adhoc_report_security_check($report_id);
        if($result_security === FALSE){
            show_404();
            return;
        }
        if(isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'onboarding/banner') !== false) {
            redirect('reports/adhoc_reports');
        }
        //Select Report Information
        $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($report_id)->result();
        //Report type
        if(!isset($adhoc_report[0])){
            show_404();
        }
        $report_type =  $adhoc_report[0]->report_type;
        $report_name =  $adhoc_report[0]->report_name;
        $timezone = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        //Filters
        $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
        //Diff time period
        $diff_time_period =  $this->input->post('time_period',TRUE);
        $time_period_field = $adhoc_report[0]->report_time_field;
        $time_start_check =  $selected_filter_array['start_date'];
        $time_end_check =  $selected_filter_array['end_date'];
    
        if($diff_time_period != ''){
            //Calculate_new_dates
            $diff_period_start = $this->return_different_start_date($diff_time_period);
            $diff_period_end = $this->return_different_end_date($diff_time_period);
            $sql_query_generator_array = $adhoc_report[0]->report_query_generator;
    
            //Create new Query based on the different time selected
            $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
    
            //Date information
            $items = array();
            $start_date = date('m/d/Y h:i:s A',$diff_period_start);
            $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
        } else {
            //calls helper to get data
            $sql = $adhoc_report[0]->report_query_generator;
    
            //Data information
            $items = array();
            $end_date =  $selected_filter_array['end_date'];
            $start_date =  $selected_filter_array['start_date'];
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
        }
            
        //get direction (desc/asc)and if it is being exported
        $order = $adhoc_report[0]->report_order_by;
        $dir = $adhoc_report[0]->report_order_by_direction;
    
        //set options for comparing
        $data['compare'] = array(
                'equals' => 'Equals',
                'contains' => 'Contains',
                'starts' => 'Starts With',
                'ends' => 'Ends With'
        );
        //Set Export Data
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $data['is_export'] = true;
        //Report Display type
        $size = 0;
        switch ($report_type) {
            case 'requests':
                $size = $this->requestmodel->get_filted_size($sql)->result()[0]->count;
                break;
            case 'events':
                $size = $this->eventmodel->get_filted_size($sql)->result()[0]->count;
                break;
            case 'logins':
                $size = $this->loginsmodel->get_filted_size($sql)->result()[0]->count;
                break;
            case 'mail':
                $size = $this->mailmodel->get_filted_size($sql)->result()[0]->count;
                break;
            case 'user_activity_summary':
                //sql query that excludes the date filter to include users who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
                    
                $size = $this->useractivitysummarymodel->get_user_list_size($sql_date_filter_excluded)->result()[0]->count;
                break;
            case 'group_activity_summary':
                //sql query that excludes the date filter to include users who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
                    
                $size = $this->groupsmodel->get_group_list_size($sql_date_filter_excluded)->result()[0]->count;
                break;
            case 'facility':
                //getting size number
                $size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result()[0]->count;
                break;
            case 'hisp':
                $between = array(
                'time' => $this->check_paired_dates($start_date,$end_date)
                );
                $items = array();
                $selected_domain = $selected_filter_array['selected_domain'];
                if (mb_strtolower($selected_domain) != "(ALL)"){
                    $selected = 'Domain: ' . $selected_domain;
                }else {
                            $selected =null;
                }
                $destination_page = $selected_filter_array['adhoc_report_destination_page'];
                $items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
                $is_export = true;
    
                $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_filter_array['selected_domain'], $between, $order, $dir, $destination_page, $items_per_page, $is_export);
                $size = count($message_counts);
                break;
            case 'points_of_origin':
                $between = array(
                        'call_date' => $this->check_paired_dates($start_date,$end_date)
                        );
                $application_id = $selected_filter_array['application_id'];
                $destination_page = $selected_filter_array['adhoc_report_destination_page'];
                $items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
                $order = $adhoc_report[0]->report_order_by;
                $dir = $adhoc_report[0]->report_order_by_direction;
                $is_export = true;

                if ($application_id != "(all)"){
                    $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
                }else {
                    $selected =null;
                    $application_id ="";
                }
                $message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
                $size = count($message_counts['list']);
                break;
            }
        $size_array = array('size'=>$size, 'report_name'=>$report_name);
        if($is_ajax == 'true' || $is_ajax == true) {
            echo $this->json->encode($size_array);
        }
        else {
            return $size_array;
        }
    }
        
    /**
     * Export Adhoc Report to PDF, Excel, and print
     */
    public function adhoc_export($report_id, $export_type){
    	$result_security = $this->adhoc_report_security_check($report_id);
    	if($result_security === FALSE){
    		show_404();
    		return;
    	}
    	if(isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'onboarding/banner') !== false) {
    		redirect('reports/adhoc_reports');
    	}
    	//Select Report Information
    	$adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($report_id)->result();
    	//Report type
    	if(!isset($adhoc_report[0])){
    		show_404();
    	}
    	$report_type =  $adhoc_report[0]->report_type;
    	$report_name =  $adhoc_report[0]->report_name;
    	$timezone = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    	//Filters
    	$selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
    	//Diff time period
    	$diff_time_period =  $this->input->post('time_period',TRUE);
    	$time_period_field = $adhoc_report[0]->report_time_field;
    	$time_start_check =  $selected_filter_array['start_date'];
    	$time_end_check =  $selected_filter_array['end_date'];
    
    	if($diff_time_period != ''){
    		//Calculate_new_dates
    		$diff_period_start = $this->return_different_start_date($diff_time_period);
    		$diff_period_end = $this->return_different_end_date($diff_time_period);
    		$sql_query_generator_array = $adhoc_report[0]->report_query_generator;
    
    		//Create new Query based on the different time selected
    		$sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
    
    		//Date information
    		$items = array();
    		$start_date = date('m/d/Y h:i:s A',$diff_period_start);
    		$end_date = date('m/d/Y h:i:s A',$diff_period_end);
    		//$date_array = array($end_date, $start_date);
    		$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    	} else {
    		//calls helper to get data
    		$sql = $adhoc_report[0]->report_query_generator;
    
    		//Data information
    		$items = array();
    		$end_date =  $selected_filter_array['end_date'];
    		$start_date =  $selected_filter_array['start_date'];
    		//$date_array = array($end_date, $start_date);
    		$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    	}
    		
    	//get direction (desc/asc)and if it is being exported
    	$order = $adhoc_report[0]->report_order_by;
    	$dir = $adhoc_report[0]->report_order_by_direction;
    
    	//set options for comparing
    	$data['compare'] = array(
    			'equals' => 'Equals',
    			'contains' => 'Contains',
    			'starts' => 'Starts With',
    			'ends' => 'Ends With'
    	);
    	//Set Export Data
    	$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    	$data['time'] = date('m/d/Y h:i:s A', time());
    	$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    	$data['is_export'] = true;
    
    	//Report Display type
    	switch ($report_type) {
    		case 'requests':
    			$selector = array(
    			'application_id' => $selected_filter_array['whichapp'],
    			);
    			$items = array(
    					'id' => $this->search_type($selected_filter_array['request_id'],$selected_filter_array['request_id_type']),
    					'call' => $this->search_type($selected_filter_array['request_call'],$selected_filter_array['request_call_type']),
    					'response_code' => $this->search_type($selected_filter_array['request_code'],$selected_filter_array['request_code_type']),
    					'response' => $this->search_type($selected_filter_array['request_response'],$selected_filter_array['request_response_type']),
    			);
    			$between = array(
    					'call_date' => $this->check_paired_dates($start_date,$end_date),
    			);
    			$selected = '';
    			if(strtoupper($selector['application_id']) != '(ALL)' && $selector['application_id'] != ''){
    				$selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($selected_filter_array['whichapp'])->result()[0]->name;
    			}
    
    			$data['filters'] = $this->export_info($items,$between,$selected,null);
    
    			$size = $this->requestmodel->get_filted_size($adhoc_report[0]->report_query_generator)->result()[0]->count;
    				
    			if(string_contains('application_id', $order)){//if sorting by application_id
    				$responses_list= $this->requestmodel->get_request_filter_export_app_order($sql,$order.' '.$dir,1,$size)->result();
    			}
    			else{
    				$responses_list= $this->requestmodel->get_request_filter_export($sql,$order.' '.$dir,1,$size)->result();
    			}
    				
    			foreach($responses_list as $result) {
    				//converts application's numbers into their names
    				$name = $this->id_to_name(2,$result->application_id);
    				$result->application_id=$name['id'];
    
    				//set time in more readable format
    				if($result->call_date){ $result->call_date = date('m/d/Y h:i:s A',$result->call_date); }
    			}
    			$data['export_request_list'] = $responses_list;
    			break;
    		case 'events':
    			$selector = array(
    			'success' =>  $selected_filter_array['successful'],
    			);
    				
    			$items = array(
    					'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
    					'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
    			);
    			$extra_items = array(
    					'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
    					'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
    					'actor' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
    					'target' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
    			);
    			//$date_array = array($end_date, $start_date);
    			$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    				
    			$between = array(
    					'event_date' => $this->check_paired_dates($start_date,$end_date),
    			);
    				
    			$typesearch = array (
    					'actor_id'	=> array (
    							'typesql' => 'actor_type',
    							'name' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
    							'type' => $selected_filter_array['acting_type'],
    					),
    					'target_id' => array(
    							'typesql' => 'target_type',
    							'name' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
    							'type' => $selected_filter_array['target_type'],
    					),
    			);
    			$destination_page = $selected_filter_array['adhoc_report_destination_page'];
    			$items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
    				
    			$order = $adhoc_report[0]->report_order_by;
    			$dir = $adhoc_report[0]->report_order_by_direction;
    			$selected = array();
    			if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
    			else if(strtoupper($selector['success']) == '(ALL)') { array_push($selected, null); }
    			else { array_push($selected, 'Success: False'); }
    			if(isset($typesearch['actor_id']['type']) && strtoupper($typesearch['actor_id']['type']) == '(ALL)') array_push($selected, null);
    			else { array_push($selected, 'Actor Type: '. $this->get_type($typesearch['actor_id']['type'])); }
    			if(isset($typesearch['target_id']['type']) && strtoupper($typesearch['target_id']['type']) == '(ALL)') { array_push($selected, null); }
    			else { array_push($selected, 'Target Type: '. $this->get_type($typesearch['target_id']['type'])); }
    				
    			$data['filters'] = $this->export_info($extra_items, $between, $selected, null);
    			$data['is_export'] = true;
    			$size = $this->eventmodel->get_filted_size($adhoc_report[0]->report_query_generator)->result()[0]->count;
    				
    			$response_export = $this->reports_helper('event',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,true,$size);
    			$response_export_list = $response_export['response'];
    			foreach($response_export_list as $event) {
    				//converts actor and target ids into their display names
    				$value = $this->id_to_name($event->actor_type,$event->actor_id);
    				$event->actor_type=$value['type'];
    				$event->actor_id=$value['id'];
    				$value = $this->id_to_name($event->target_type,$event->target_id);
    				$event->target_type=$value['type'];
    				$event->target_id=$value['id'];
    				//changes success integer into true, false or unauth
    				if($event->success === 1) { $event->success = 'TRUE'; }
    				else if($event->success === 2){ $event->success = 'UNAUTH'; }
    				else{ $event->success = 'FALSE'; }
    				//change date into readable
    				$event->event_date = date('m/d/Y h:i:s A',$event->event_date);
    			}
    			$data['export_event_list'] = $response_export_list;
    			break;
    		case 'logins':
    			//adds each component type into its own json
    			$selector = array(
    			'success' =>  $selected_filter_array['successful'],
    			);
    				
    			$items = array(
    					'id' => $this->search_type($selected_filter_array['id'],$selected_filter_array['id_type']),
    					'session_id'=>$this->search_type($selected_filter_array['session_id'],$selected_filter_array['session_id_type']),
    					'ip_address'=>$this->search_type($selected_filter_array['ip_address'],['ip_address_type']),
    					'error_msg'=>$this->search_type($selected_filter_array['message'],$selected_filter_array['message_type']),
    					'org_id'=>$this->search_type($selected_filter_array['org_id'],$selected_filter_array['org_id_type']),
    			);
    				
    			//Date Date
    			$between = array(
    					'login_time' => $this->check_paired_dates($start_date,$end_date)
    			);
    				
    			//$date_array = array($end_date, $start_date);
    			$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    			$size = $this->loginsmodel->get_filted_size($sql)->result();
    			$size = $size[0]->count;
    			//get direction and orders
    			//$dir = $adhoc_report[0]->report_order_by_direction;
    			//$order = $adhoc_report[0]->report_order_by;
    			//get export data
    			if(string_contains('user_id', $order)){//ordered by user id
    				$responses_list = $this->loginsmodel->get_login_filter_export_user_order($sql,$order.' '.$dir)->result();
    			}else{
    				$responses_list = $this->loginsmodel->get_login_filter_export($sql,$order.' '.$dir)->result();
    			}
    			//Export Variables
    			$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    			$data['time'] = date('m/d/Y h:i:s A', time());
    			$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    			$data['is_export'] =  TRUE;
    
    			if(strtoupper($selected_filter_array['successful'])=='(ALL)') {
    				$selected = '';
    			}
    			else if($selected_filter_array['successful']==1) {
    				$selected='Success: True';
    			}
    			else {
    				$selected='Success: False';
    			}
    			$data['filters'] = $this->export_info($items,$between,$selected,null);
    			#TODO - why do we even put this in the $data array if we don't use it except for this next loop?
    			$data['export_login_list'] = $responses_list;
    				
    			foreach($data['export_login_list'] as $login) {
    				//convert org id to username
    				$login->username=$this->usersmodel->get_username_from_org_id($login->org_id);
    				//get binary true/false into text
    				if($login->success === 1) { $login->success = 'TRUE'; }
    				else { $login->success = 'FALSE'; }
    				//convert data into readable formant.
    				$login->login_time = date('m/d/Y h:i:s A',$login->login_time);
    			}
    			#TODO - This horrible, horrible hack is necessary because the export function exports columns based on the order they exist in the object
    			#so we have to reorder the event_list objects using a copy of the list that puts the columns in the right order. FIX THIS EVENTUALLY!
    			$login_list = $responses_list;
    			for($i = 0; $i < count($login_list); $i++) {
    			$login_list_copy = new StdClass();
    			$login_list_copy->id = $login_list[$i]->id;
    			$login_list_copy->username = $login_list[$i]->username;
    			$login_list_copy->session_id = $login_list[$i]->session_id;
    			$login_list_copy->ip_address = $login_list[$i]->ip_address;
    			$login_list_copy->login_time = $login_list[$i]->login_time;
    			$login_list_copy->error_msg = $login_list[$i]->error_msg;
    			$login_list_copy->org_id = $login_list[$i]->org_id;
    			$login_list_copy->success = $login_list[$i]->success;
    			$login_list[$i] = $login_list_copy;
    			}
    			$responses_list = $login_list;
    			$report_content = $this->input->post('report_content',TRUE);
    			break;
			case 'mail':
    			$selector = array(
    					'success' =>  $selected_filter_array['successful'],
    					'mdn' =>  $selected_filter_array['mdn'],
    					'inbound_outbound' => $selected_filter_array['bound'],
    					'protected_data' => $selected_filter_array['protected_data']
    					);
			
				$items = array(
    					'id' => $this->search_type($selected_filter_array['id'],$selected_filter_array['id_type']),
    					'size'=>$this->search_type($selected_filter_array['file_size'],$selected_filter_array['file_size_type']),
    					'attachment_types'=>$this->search_type($selected_filter_array['attachment_type'],$selected_filter_array['attachment_type_type']),
    					'sender'=>$this->search_type($selected_filter_array['sender'],$selected_filter_array['sender_type']),
    					'recipient'=>$this->search_type($selected_filter_array['recipient'],$selected_filter_array['recipient_type']),
    					);
    						
				//$date_array = array($end_date, $start_date);
    					$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    						
    					$between = array(
    					'time' => $this->check_paired_dates($start_date,$end_date)
    					);
    					$typesearch = array (
    					);
    					$items_per_page = $selected_filter_array['items_per_page'];
    					$export_pdf = $this->input->post('export_pdf',TRUE);
    					$print_page = $this->input->post('print_page',TRUE);
				$is_export = TRUE;
    						
    					$data['is_export'] = $is_export;
    								
    					$dir = $adhoc_report[0]->report_order_by_direction;
    					$order = $adhoc_report[0]->report_order_by;
    					$page=1;
    					$responses_list = $this->mailmodel->get_mail_filter($sql,$adhoc_report[0]->report_order_by . " " . $dir,$this->db->escape($page),$items_per_page)->result();
    					$mail_list = $responses_list;
    					$form_data['direction'] = $dir;
    					$form_data['date_warning_message'] = $date_warning_message;
    						
    					$size = $this->mailmodel->get_filted_size($sql)->result();
    					$size = $size[0]->count;
    					$destination_page = 1;
    					$response_export = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$adhoc_report[0]->report_order_by,$dir,$destination_page,$is_export,$size);
    					$response_export_list = $response_export['response'];
    					$selected ="";
    					$data['filters'] = $this->export_info($items,$between,$selected,null);
    					$response_adhoc = $responses_list;
    					$form_data['order'] = $order;
    					//converts application's numbers into their names
    					$lists = array($mail_list, $response_export_list);
    					foreach($lists as $list) {
    						if(isset($list)) {
    							foreach($list as $event) {
    								//get the recipients and convert to array
    								$event->recipient=$this->json->decode($event->recipient);
    								$recip = '';
    								if(isset($event->recipient)){
    									foreach($event->recipient as $key =>$value){
    										//for all items after the first
    										if($key > 0) {
    											//if export make them comma separated
    											if($is_export) { $recip .= ', '; }
    											//else when in view make each email on a line
    											else { $recip.= '<br/>'; }
    										}
    										$recip .= $value; //add email
    									}
    								}
    								$event->recipient = $recip;
    
    								//binary true/false into text
    								if($event->success) { $event->success = 'TRUE'; }
    								else { $event->success = 'FALSE'; }
    
    								//binary mdn into text
    								if($event->mdn) { $event->mdn = 'TRUE'; }
    								else { $event->mdn = 'FALSE'; }
    
    								//binary inbound/outbound into text
    								if($event->inbound_outbound){ $event->inbound_outbound = 'Inbound'; }
    								else { $event->inbound_outbound = 'Outbound'; }
    								$event->time = date("m/d/Y h:i:s A",$event->time);
    									
    								//binary 7332 into text
    								if($event->protected_data) { $event->protected_data = 'TRUE'; }
    								else if($event->protected_data === 0) { $event->protected_data = 'FALSE'; }
    								else{ $event->protected_data = 'N/A'; }
    							}
    						}
    					}
    					//Export Variables
    					$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    					$data['time'] = date('m/d/Y h:i:s A', time());
    					$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    					$data['form_data'] = $form_data;
    					$data['event_list'] = $response_export_list;
    					#TODO - This horrible, horrible hack is necessary because the export function exports columns based on the order they exist in the object
    					#so we have to reorder the event_list objects using a copy of the list that puts the columns in the right order. FIX THIS EVENTUALLY!
    					$event_list = $data['event_list'];
    					for($i = 0; $i < count($event_list); $i++) {
    						$event_list_copy = new StdClass();
    						$event_list_copy->id = $event_list[$i]->id;
    						$event_list_copy->sender = $event_list[$i]->sender;
    						$event_list_copy->recipient = $event_list[$i]->recipient;
    						$event_list_copy->size = $event_list[$i]->size;
    						$event_list_copy->attachment_types = $event_list[$i]->attachment_types;
    						$event_list_copy->time = $event_list[$i]->time;
    						$event_list_copy->inbound_outbound = $event_list[$i]->inbound_outbound;
    						$event_list_copy->mdn = $event_list[$i]->mdn;
    						$event_list_copy->success = $event_list[$i]->success;
    						$event_list_copy->protected_data = $event_list[$i]->protected_data;
    						$event_list[$i] = $event_list_copy;
    					}
    					$data['export_mail_list'] = $event_list;
    					$report_content = $this->input->post('report_content',FALSE);
    					break;
    			case 'user_activity_summary':
    				//sql query that excludes the date filter to include users who had no acitivity during the time period specified
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
    				//Set Variables
    				$page = 1;
    				$items_per_page =  $selected_filter_array['items_per_page'];
    				$order_search = $adhoc_report[0]->report_order_by ." " .$adhoc_report[0]->report_order_by_direction.",id ".$adhoc_report[0]->report_order_by_direction;
    				$order = $adhoc_report[0]->report_order_by;
    				$dir = $adhoc_report[0]->report_order_by_direction;
    				//Get Data
    				$size = $this->useractivitysummarymodel->get_user_list_size($sql_date_filter_excluded)->result();
    				$size = $size[0]->count;
    				$users_facility_list = $this->useractivitysummarymodel->get_request_filter_user_activities($sql,$sql_date_filter_excluded,$order_search,$this->db->escape($page),$items_per_page);
    				//Get LDAP Information
    				$counter = 0;
    				$SummaryListing = array();
    				//merge arrays
    				foreach ($users_facility_list as $userInfo){
    					//print_r($userInfo);
    					$userUsername = $userInfo->Username;
    					$userID = $userInfo->id;
    					$userFacilityName = $userInfo->Name;
    					$userNumber_of_sent = $userInfo->Number_of_sent;
    					$userNumber_of_seen = $userInfo->Number_of_seen;
    					$userTotal_of_messages = $userInfo->Total_messages;
    					$user_ext_mail = $userInfo->user_ext_mail;
    					$userRow = $userInfo->row;
    					$userIsActive = $userInfo->is_active;
    					//Get LDAP Information
    					$resultArray = $this->useractivitysummarymodel->get_ldap_request($userInfo->Username);
    
    					//checking that LDAP Results are not null
    					if (isset ($resultArray[0]['givenname'][0])){
    						$userGivenname = $resultArray[0]['givenname'][0];
    					}else{
    						$userGivenname = "not found";
    					}
    
    					if (isset ($resultArray[0]['sn'][0])){
    						$userSN = $resultArray[0]['sn'][0];
    					}else{
    						$userSN = "not found";
    					}
    
    					if (isset ($resultArray[0]['mail'][0])){
    						$userMail = $resultArray[0]['mail'][0];
    					}else{
    						$userMail = "not found";
    					}
    
    					if($userIsActive == 1){
    						$userActiveText = 'Active';
    					} else {
    						$userActiveText = 'Inactive';
    					}
    					$SummaryListingObjects = new stdClass;
    					$SummaryListingObjects->userSN = $userSN;
    					$SummaryListingObjects->userGivenname = $userGivenname;
    					$SummaryListingObjects->username = $userUsername;
    					$SummaryListingObjects->userMail = $userMail;
    					$SummaryListingObjects->facilityName = $userFacilityName;
    					$SummaryListingObjects->userStatus = $userActiveText;
    					$SummaryListingObjects->user_ext_mail = $user_ext_mail;
    					$SummaryListingObjects->userNumber_of_sent = $userNumber_of_sent;
    					$SummaryListingObjects->userNumber_of_seen = $userNumber_of_seen;
    					$SummaryListingObjects->userTotal_of_messages = $userTotal_of_messages;
    					array_push($SummaryListing, $SummaryListingObjects);
    				}
    				//Sorting results
    				$ldapfilters = array();
    				//Converting to array for sorting
    				$new_array = $this->object_to_array($SummaryListing);
    				//filter_sn
    				$sn_filter =  $selected_filter_array['txtsn'];
    				if($sn_filter != ""){
    					$sn_filter_type =  $selected_filter_array['last_name_type'];
    					array_push($ldapfilters, 'Last Name ' . mb_strtolower($data['compare'][$sn_filter_type]). ': ' . $sn_filter);
    					//setting filter type
    					$search_sn = $this->search_type_for_array($sn_filter,$sn_filter_type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'userSN', $search_sn);
    				}
    				//filter_given_name
    				$givenname_filter =  $selected_filter_array['txtgivenname'];
    				if($givenname_filter != ""){
    					$givenname_filter_type =  $selected_filter_array['first_name_type'];
    					array_push($ldapfilters, 'First Name ' . mb_strtolower($data['compare'][$givenname_filter_type]). ': ' . $givenname_filter);
    					//setting filter type
    					$search_givenname = $this->search_type_for_array($givenname_filter,$givenname_filter_type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'userGivenname', $search_givenname);
    				}
    				//filter_va_address
    				$direct_address_filter =  $selected_filter_array['txtdirectaddress'];
    				if($direct_address_filter != ""){
    					$direct_address_filter_Type =  $selected_filter_array['direct_address_type'];
    					array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_Type]). ': ' . $direct_address_filter);
    					//setting filter type
    					$search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_Type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'userMail', $search_direct_address);
    				}
    
    				$destination_page = 1;
    				unset($SummaryListing);
    				$SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
    
    				//Export Variables
    				$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    				$data['time'] = date('m/d/Y h:i:s A', time());
    				$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    				$between = array(
    						'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
    				);
    				//$summary_listing_totals = $SummaryListing;
    				$selected = "";
    				if(mb_strtolower($selected_filter_array['facility_id']) != "(all)" &&  $selected_filter_array['facility_id'] != ''){
    					$selected = 'Facility: ' . $this->facilitymodel->get_facility( $selected_filter_array['facility_id'])->result()[0]->name;
    				}
    				//Set Export
    				$data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
    				$data['export_summary_list'] = $SummaryListing;
    				$data['is_export'] =  TRUE;
    				break;
    			case 'group_activity_summary':
    				//Set Variables
    				$page = 1;
    				$items_per_page =  $selected_filter_array['items_per_page'];
    				$order_search = $adhoc_report[0]->report_order_by ." " .$adhoc_report[0]->report_order_by_direction.",id ".$adhoc_report[0]->report_order_by_direction;
    				$order = $adhoc_report[0]->report_order_by;
    				$dir = $adhoc_report[0]->report_order_by_direction;
    				//Get Data
    				//sql query that excludes the date filter to include groups who had no acitivity during the time period specified
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
    
    				$size = $this->groupsmodel->get_group_list_size($sql_date_filter_excluded)->result();
    				$size = $size[0]->count;
    				$groups_activity_list = $this->groupsmodel->get_request_filter_group_activities($sql,$sql_date_filter_excluded,$order_search,$this->db->escape($page),$items_per_page);
    				//Get LDAP Information
    				$counter = 0;
    				$SummaryListing = array();
    				$items = array(
    						'group_name' => $this->search_type($selected_filter_array['group_name'],$selected_filter_array['group_name_type']),
    				);
    				//merge arrays
    				foreach ($groups_activity_list as $group_info){
    					//print_r($group_info);
    					$groupName = $group_info->group_name;
    					$groupID = $group_info->id;
    					$groupFacilityName = $group_info->Name;
    					$groupNumber_of_sent = $group_info->Number_of_sent;
    					$groupNumber_of_seen = $group_info->Number_of_seen;
    					$groupTotal_of_messages = $group_info->Total_messages;
    					$groupRow = $group_info->row;
    					$groupIsActive = $group_info->is_active;
    					//Get LDAP Information
    					$resultArray = $this->groupsmodel->get_ldap_request($groupName);
    						
    					//checking that LDAP Results are not null
    					if (isset ($resultArray[0]['cn'][0])){
    						$displayName = $resultArray[0]['cn'][0];
    					}else{
    						$displayName = "not found";
    					}
    						
    					if (isset ($resultArray[0]['mail'][0])){
    						$groupMail = $resultArray[0]['mail'][0];
    					}else{
    						$groupMail = "not found";
    					}
    						
    					if($groupIsActive == 1){
    						$groupActiveText = 'Active';
    					} else {
    						$groupActiveText = 'Inactive';
    					}
    					$SummaryListingObjects = new stdClass;
    					$SummaryListingObjects->groupName = $groupName;
    					$SummaryListingObjects->displayName = $displayName;
    					$SummaryListingObjects->groupMail = $groupMail;
    					$SummaryListingObjects->facilityName = $groupFacilityName;
    					$SummaryListingObjects->groupStatus = $groupActiveText;
    					$SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
    					$SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
    					$SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
    					array_push($SummaryListing, $SummaryListingObjects);
    				}
    				//Sorting results
    				$ldapfilters = array();
    				//Converting to array for sorting
    				$new_array = $this->object_to_array($SummaryListing);
    					
    				//filter_va_address
    				$direct_address_filter =  $selected_filter_array['txtdirectaddress'];
    				if($direct_address_filter != ""){
    					$direct_address_filter_Type =  $selected_filter_array['direct_address_type'];
    					array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_Type]). ': ' . $direct_address_filter);
    					//setting filter type
    					$search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_Type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'groupMail', $search_direct_address);
    				}
    
    				$destination_page = 1;
    				unset($SummaryListing);
    				$SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
    					
    				//Export Variables
    				$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    				$data['time'] = date('m/d/Y h:i:s A', time());
    				$data['group'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    				$between = array(
    						'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
    				);
    
    				if(mb_strtolower($selected_filter_array['group_status_type']) == '(all)'){
    					$selected = "";
    				}
    				if($selected_filter_array['group_status_type'] == '1'){
    					$selected = 'Group Status: Active, ';
    				}
    				else {
    					$selected = 'Group Status: Inactive, ';
    				}
    
    				if(mb_strtolower($selected_filter_array['facility_id']) != "(all)" &&  $selected_filter_array['facility_id'] != ''){
    					$selected .= 'Facility: ' . $this->facilitymodel->get_facility( $selected_filter_array['facility_id'])->result()[0]->name;
    				}
    				//Set Export
    				$data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
    				$data['export_summary_list'] = $SummaryListing;
    				$data['is_export'] =  TRUE;
    				break;
    			case 'facility':
    				//getting size number
    				$size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result();
    				$size = $size[0]->count;
    				$page = 1;
    				$items = array();
    				$destination_page = $page;
    				$items_per_page = $size;
    					
    				// Generating PDF Data
    				$facility_list = $this->facilitymodel->get_request_filter_facility_order($sql,$order,$this->db->escape($page),$this->db->escape($items_per_page))->result();
    				//$facility_list = $response_export_list;
    				$selector = $selected_filter_array['facility_id'];
    
    				//Setting Extra Export Info
    				$between = array(
    						'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
    				);
    				if($selector != '(all)' && $selector != ''){
    					$selected = 'Facility: ' . $this->facilitymodel->get_facility( $selected_filter_array['facility_id'])->result()[0]->name;
    				} else {
    					$selected = 'Facility: (ALL)';
    				}
    				$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    				$data['time'] = date('m/d/Y h:i:s A', time());
    				$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    				$data['filters'] = $this->export_info($items,$between,$selected,null);
    					
    				//Getting_totals
    				$data['export_facility_list'] = $facility_list;
    				$data['is_export'] =  TRUE;
    				break;
    			case 'hisp':
    				$between = array(
    				'time' => $this->check_paired_dates($start_date,$end_date)
    				);
    				$items = array();
    				$selected_domain = $selected_filter_array['selected_domain'];
    				if (mb_strtolower($selected_domain) != "(ALL)"){
    					$selected = 'Domain: ' . $selected_domain;
    				}else {
    					$selected =null;
    				}
    				$destination_page = $selected_filter_array['adhoc_report_destination_page'];
    				$items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
    				$is_export = true;
    				if($export_type == 'excel') {
    					$is_export = 'excel';
    				}
    				$message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_filter_array['selected_domain'], $between, $order, $dir, $destination_page, $items_per_page, $is_export);
    					
    				$data['is_export'] = $is_export;
    				$data['message_counts'] = $message_counts['list'];
    				$size = count($message_counts['list']);
    				$data['filters'] = $this->export_info(null,$between,$selected,null);
    				break;
    			case 'points_of_origin':
    				$between = array(
    				'call_date' => $this->check_paired_dates($start_date,$end_date)
    				);
    				$application_id = $selected_filter_array['application_id'];
    				$destination_page = $selected_filter_array['adhoc_report_destination_page'];
    				$items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
    				$order = $adhoc_report[0]->report_order_by;
    				$dir = $adhoc_report[0]->report_order_by_direction;
    				$is_export = true;
    
    				if ($application_id != "(all)"){
    					$selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
    				}else {
    					$selected =null;
    					$application_id ="";
    				}
    
    				$message_counts = $this->pointsoforiginmodel->get_message_counts_grouped_by_application($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
    				$size = count($message_counts['list']);
    				$data['filters'] = $this->export_info(null,$between,$selected,null);
    				$data['is_export'] =  TRUE;
    				$data['message_counts'] = $message_counts['list'];
    				break;
    			}
    			if($export_type === 'pdf') {
    				$html = $this->load->view('api/reports/result_tables/result_' . $report_type, $data, true);
    				$this->export_pdf($report_name.'.pdf', $html, $report_id, $size);
    			}
    			else if($export_type === 'html') {
    				$export_array = ['html' => $this->load->view('api/reports/result_tables/result_' . $report_type, $data, true),
    				'report_id' => $report_id,
    				'report_name'=> $report_name];
    				return $export_array;
    			}
    			else if($export_type === 'excel' || $export_type === 'excel_to_file') {
    				switch($report_type) {
    					case 'requests':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Application','Call','Date ('.$timezone.')','Response Code','Response'),$responses_list,$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('ID','Application','Call','Date ('.$timezone.')','Response Code','Response'),$responses_list,$report_name,$items,$between,$selected,null,$report_id,$size, true);
    						}
    					case 'events':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$data['export_event_list'],$report_name,$extra_items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$data['export_event_list'],$report_name,$extra_items,$between,$selected,null,$report_id,$size,true);
    						}
    					case 'mail':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Sender','Recipient','Size(KB)','Attachment Type','Date ('.$data['timezone_abbr'].')','Direction', 'MDN', 'Success','7332'),$data['export_mail_list'],$report_name,$items,$between,null,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('ID','Sender','Recipient','Size(KB)','Attachment Type','Date ('.$data['timezone_abbr'].')','Direction', 'MDN', 'Success','7332'),$data['export_mail_list'],$report_name,$items,$between,null,null,$report_id,$size,true);
    						}
    					case 'logins':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Username','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Message','Org ID','Success'),$responses_list,$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('ID','Username','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Message','Org ID','Success'),$responses_list,$report_name,$items,$between,$selected,null,$report_id,$size,true);
    						}
    					case 'user_activity_summary':
    						$totalCount = count((array)$SummaryListing);
    						$newRowNumber = $totalCount + 1;
    						$SummaryListing->$totalCount = new StdClass;
    						$SummaryListing->$totalCount->userSN = '';
    						$SummaryListing->$totalCount->userGivenname = '';
    						$SummaryListing->$totalCount->username = '';
    						$SummaryListing->$totalCount->userMail = '';
    						$SummaryListing->$totalCount->facilityName = '';
    						$SummaryListing->$totalCount->userStatus = '';
    						$SummaryListing->$totalCount->user_ext_mail = 'VA Total:';
    						$SummaryListing->$totalCount->userNumber_of_sent = $this->sum_by_object_name((array)$SummaryListing, 'userNumber_of_sent');
    						$SummaryListing->$totalCount->userNumber_of_seen = $this->sum_by_object_name((array)$SummaryListing, 'userNumber_of_seen');
    						$SummaryListing->$totalCount->userTotal_of_messages = $this->sum_by_object_name((array)$SummaryListing, 'userTotal_of_messages');
    
    						if($export_type === 'excel') {
    							$this->export(array('Last Name', 'First Name','Username','Direct Address','VA Facility','User Status', 'VA email Address', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Last Name', 'First Name','Username','Direct Address','VA Facility','User Status', 'VA email Address', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size,true);
    						}
    					case 'group_activity_summary':
    						$totalCount = count((array)$SummaryListing);
    						$newRowNumber = $totalCount + 1;
    						$SummaryListing->$totalCount = new StdClass;
    						$SummaryListing->$totalCount->groupName = '';
    						$SummaryListing->$totalCount->displayName = '';
    						$SummaryListing->$totalCount->groupMail = '';
    						$SummaryListing->$totalCount->facilityName = '';
    						$SummaryListing->$totalCount->groupStatus = 'VA Total:';
    						$SummaryListing->$totalCount->groupNumber_of_sent = $this->sum_by_object_name((array)$SummaryListing, 'groupNumber_of_sent');
    						$SummaryListing->$totalCount->groupNumber_of_seen = $this->sum_by_object_name((array)$SummaryListing, 'groupNumber_of_seen');
    						$SummaryListing->$totalCount->groupTotal_of_messages = $this->sum_by_object_name((array)$SummaryListing, 'groupTotal_of_messages');
    
    						if($export_type === 'excel') {
    							$this->export(array('Group Name','Display Name','Direct Address','VA Facility','Group Status', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Group Name','Display Name','Direct Address','VA Facility','Group Status', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size,true);
    						}
    					case 'facility':
    						// Generating Excel Data
    						//$response_export_list = $this->facilitymodel->get_request_filter_facility_order($sql,$order.' '.$dir,$this->db->escape($page),$this->db->escape($items_per_page))->result();
    						//$facility_list = $response_export_list;
    						//Setting Totals for Excel Export
    						$totalCount = count((array)$facility_list);
    						//Unset Row Number for Export $totalCount = count((array)$facility_list);
    						for ($i = 0; $i < $totalCount; $i++) {
    							unset($facility_list[$i]->row);
    							unset($facility_list[$i]->id);
    						}
    						//Setting Totals for Excel Export
    						$facility_list[$totalCount] = new StdClass;
    						$facility_list[$totalCount]->name = 'VA Total:';
    						$facility_list[$totalCount]->Number_of_users = $this->sum_by_object_name((array)$facility_list, 'Number_of_users');
    						$facility_list[$totalCount]->Number_in_group = $this->sum_by_object_name((array)$facility_list, 'Number_in_group');
    						$facility_list[$totalCount]->Number_of_sent = $this->sum_by_object_name((array)$facility_list, 'Number_of_sent');
    						$facility_list[$totalCount]->Number_of_seen = $this->sum_by_object_name((array)$facility_list, 'Number_of_seen');
    						$facility_list[$totalCount]->Total_messages = $this->sum_by_object_name((array)$facility_list, 'Total_messages');
    
    						if($export_type === 'excel') {
    							$this->export(array('VA Facility','Number of Users','Number of Groups', 'Total Messages Sent','Total Messages Received','Total Messages'),$facility_list,$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('VA Facility','Number of Users','Number of Groups', 'Total Messages Sent','Total Messages Received','Total Messages'),$facility_list,$report_name,$items,$between,$selected,null,$report_id,$size, true);
    						}
    							
    					case 'hisp':
    						if($export_type === 'excel') {
    							$this->export(array('Domain Name','Total Messages Sent', 'Total Messages Received','Total Messages'),$message_counts['list'],$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Domain Name','Total Messages Sent', 'Total Messages Received','Total Messages'),$message_counts['list'],$report_name,$items,$between,$selected,null,$report_id,$size, true);
    						}
    					case 'points_of_origin':
    						if($export_type === 'excel') {
    							$this->export(array('Originating Application','Total Messages Sent'),$message_counts['list'],$report_name,null,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Originating Application','Total Messages Sent'),$message_counts['list'],$report_name,null,$between,$selected,null,$report_id,$size,true);
    						}
    				}
    			}
    			else {
    				$data['adhoc_print_page'] = true;
    				$this->load->view('api/reports/result_tables/result_' . $report_type, $data);
    			}
    	}
    
    /**
     * Delete Adhoc Report
     */
    public function adhoc_export_delete($report_id){
        //Delete Report
        $delete_report = $this->adhocreportsmodel->delete_adhoc_report($report_id);
        //Redirect to the correct adhoc report section
        $report_access = $this->adhocreportsmodel->get_report_type_by_id($report_id)->result();    
        
        redirect('/reports/adhoc_reports/'.$report_access[0]->report_access_type);
    }
    /**
     * Multiple Delete Adhoc Report
     */
    public function adhoc_report_delete_multiple($report_selection){
        //Get ids to delete
        $reports_id_array = $_POST['report_ids_delete'];
        $reports_id = explode(",", $reports_id_array);

        //Delete reports
        if ($reports_id){
            foreach ($reports_id as $id){
                if($id){
                    $this->adhocreportsmodel->delete_adhoc_report($id);
                }
            } 
        }    
        //Send back to report
        redirect('/reports/adhoc_reports/'.$report_selection);
    } 
    
    /**
     * Multiple Export PDF Adhoc Report
     */
    public function adhoc_report_export_to_pdf_multiple($report_selection){
        //Get ids to export to pdf array
        $reports_id_array = $this->input->post('report_ids_pdf', TRUE);
        $reports_id = explode(',', $reports_id_array);
        //filter out empty values in report id array
        $reports_id = array_values(array_filter($reports_id));
        //Set variables to create link
        $show_download = TRUE;
        $export_type = "adhoc_export_pdf";
        //Checking that array is not null or empty
        if(!empty($reports_id_array)) {
            $this->adhoc_reports($report_selection, $reports_id, $show_download, $export_type);
        } else {
            redirect('/reports/adhoc_reports/'.$report_selection);
        }    

    } 
        
    /**
     * Multiple Export Excel Adhoc Report
     */
    public function adhoc_report_export_to_excel_multiple($report_selection){
        //Get ids to export to excel array
        $reports_id_array = $this->input->post('report_ids_excel', TRUE);
        $reports_id = explode(',', $reports_id_array);
        //filter out empty values in report id array
        $reports_id = array_values(array_filter($reports_id));
        //Set variables to create link
        $show_download = TRUE;
        $export_type = "adhoc_export_excel";
        //Checking that array is not null or empty
        if(!empty($reports_id_array)) {
            $this->adhoc_reports($report_selection, $reports_id, $show_download, $export_type);
        } else {
            redirect('/reports/adhoc_reports/'.$report_selection);
        }        
    }     
        
    /**
     * ajax call to return groups
     */
    public function get_groups_to_share_report(){
        $which_report = $this->input->get('which_report',TRUE);
        $groups = $this->groupsmodel->get_groups();
        $group_array = array();
        foreach($groups as $group) {
            $members = $this->groupsmodel->get_members($group['ou']);
            foreach($members as $member) {
                $user_id = $this->usersmodel->get_user_id_from_user_name($member);
                $accessible_groups = $this->usersmodel->get_user($user_id)->groups;
                if($which_report === 'facility' || $which_report === 'user_activity_summary') {
                    if(in_array('API Admins', $accessible_groups) || in_array('Facility Leader', $accessible_groups)) {
                        $group_array[$group['ou']] = $group['cn'];
                        break;
                    }
                }
                else {
                    if(in_array('API Admins', $accessible_groups)) {
                        $group_array[$group['ou']] = $group['cn'];
                    }
                }
            }
        }
        echo $this->json->encode($group_array);
    }
    
    /**
     * ajax call to return users
     */
    public function get_users_to_share_report(){
        $current_user_id = $this->user->id();
        $which_report = $this->input->get('which_report',TRUE);
        $users = $this->usersmodel->get_users();
        $user_array = array();
        foreach($users as $user) {
            if($current_user_id != $user->user_id) {
                $accessible_groups = $this->usersmodel->get_user($user->user_id)->groups;
                if($which_report === 'facility' || $which_report === 'user_activity_summary') {
                    if(in_array('API Admins', $accessible_groups) || in_array('Facility Leader', $accessible_groups)) {
                        $user_array[$user->user_id] = $user->cn;
                    }
                }
                else {
                    if(in_array('API Admins', $accessible_groups)) {
                        $user_array[$user->user_id] = $user->cn;
                    }
                }
            }
        }
        echo $this->json->encode($user_array);
    }
    /**
     * ajax call to return report names
     */
    public function get_report_names_for_mutliple_downloads(){
        $export_type = $this->input->get('reportType',TRUE);
        if($export_type =="adhoc_export_pdf") { $export_image = 'pdf'; } 
        else { $export_image = 'excel'; }
        
        $which_report = $this->input->get('which_report_id',TRUE);
        $reports_id = explode(",", $which_report);
        $report_names = array();
        foreach ($reports_id as $id) {
            $result_security = $this->adhoc_report_security_check($id);
            if($result_security !== FALSE){
                $name_report = $this->adhocreportsmodel->get_report_name_by_id($id)->result()[0]->report_name;
                if (!empty($name_report)) {
                    $report_names[$id]= $name_report;
                }
            }
        }
        echo $this->json->encode($report_names);
    }
    
    /**
     * convert date time
     */
    protected function get_utf_time($date_time){
        $date = new DateTime($date_time);
        $date->format("U");
        return $date->getTimestamp();
    }
    
    /**
     * convert date to a new time period
     */
    protected function return_different_start_date($diff_time_period){
        //Date Settings    
        switch ($diff_time_period) {
            case 'seven_days':
                //Seven Days
                $diff_period_start = $this->get_utf_time(date('m/d/Y 00:00:00', strtotime('-7 days')));
                break;
            case 'thirty_days':
                //Thirty Days
                $diff_period_start = $this->get_utf_time(date('m/d/Y 00:00:00', strtotime('-30 days')));
                break;
            case 'last_month':
                //Last Month
                $diff_period_start = $this->get_utf_time(date('m/d/Y 00:00:00', strtotime('first day of last month')));
                break;
            }
        return $diff_period_start;
    }
    
    /**
     * convert date to a new time period
     */
    protected function return_different_end_date($diff_time_period){
        //Date Settings    
        switch ($diff_time_period) {
            case 'seven_days':
                //Seven Days
                $diff_period_end = time('m/d/Y 23:59:59', strtotime(time()));
                break;
            case 'thirty_days':
                //Thirty Days
                $diff_period_end = time('m/d/Y 23:59:59', strtotime(time())); 
                break;
            case 'last_month':
                //Last Month
                $diff_period_end = $this->get_utf_time(date('m/d/Y 23:59:59', strtotime('last day of last month')));
                break;
            }
        return $diff_period_end;    
    }
    
    /**
     * Create new SQL based on the different time selected
     */
    protected function create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end){
        $sql = '';
        $i = 0;
        $sql_queries_by_part = explode('AND', $sql_query_generator_array);
        //Loop throughout the query array to edit dates
        if(!empty($time_start_check) && !empty($time_end_check)) {
            foreach($sql_queries_by_part as $id) {
                if($i == 0) { $sql .= ''; } 
                else { $sql .= ' AND '; }
                if (string_contains('time', $id) || string_contains('call_date', $id) /*request table time stamp*/) {
                        if (string_contains('<=', $id)) {
                            $sql .= '('.$time_period_field. ' >= ' . $diff_period_start . ')';
                        }
                        if (string_contains('>=', $id)) {
                            $sql .= '('.$time_period_field. ' <= ' . $diff_period_end . ')';    
                        } 
                } 
                else { $sql .= $id; }
                $i++;    
            }
        } 
        else {
            $sql .= '('.$time_period_field. ' <= ' . $diff_period_end . ') AND ('.$time_period_field. ' >= ' . $diff_period_start . ') AND ';    
            foreach ($sql_queries_by_part as $id){
                if($i === 0) { //theoretically there should be no reason to have this if you take the last AND off the query above
                    $sql .= ''; 
                    $sql .= $id; 
                }
                //if the query already has something limiting the time period
                else if(string_contains($time_period_field, $id)) {  $sql .= ''; }
                else { $sql .= ' AND '; $sql .= $id; }
                
                $i++;    
            }
        }
        //Return New SQL Query
        return $sql;
    }
    
    /**
     * Copy Adhoc Report to private reports
     */
    public function copy_adhoc_report($report_id){
        
        //Select Report Information
        $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($report_id)->result();    
        $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
        
        //Report type
        if(!isset($adhoc_report[0])){
            show_404();
        }
        $report_type =  $adhoc_report[0]->report_type;
        $report_name =  $adhoc_report[0]->report_name;
        
        //Adding Report Created from
        $report_selector_extra_options = $adhoc_report[0]->report_selector . "<=>copy_from>>".$report_id;
        
        //Selecting Post Data
        $report_name = 'Copy: '. $adhoc_report[0]->report_name;
        $report_description = $adhoc_report[0]->report_description;
        $report_access = 'private';
        $adhoc_report_between = $adhoc_report[0]->report_time_period;
        $adhoc_report_selector = $adhoc_report[0]->report_query_generator;
        $adhoc_report_order = $adhoc_report[0]->report_order_by_direction; 
        $adhoc_report_direction = $adhoc_report[0]->report_order_by;
        $adhoc_report_type = $adhoc_report[0]->report_type;
        $adhoc_report_start_date = $adhoc_report[0]->report_start_date;
        $adhoc_report_end_date = $adhoc_report[0]->report_end_date;
        $adhoc_report_selector_option = $report_selector_extra_options;            
        $adhoc_report_time_field = $adhoc_report[0]->report_time_field;
        
        //Getting username data
        $id = User::organization_id_from_session();
        $user_id = $this->usersmodel->get_user_id_from_org_id($id); 
        $report_status = 0;

        $add_report = $this->adhocreportsmodel->create_adhoc_report($report_name,$report_description,$report_access,$adhoc_report_between,$adhoc_report_selector,$adhoc_report_order,$adhoc_report_direction,$adhoc_report_type, $user_id, $report_status, $adhoc_report_start_date, $adhoc_report_end_date, $adhoc_report_selector_option, $adhoc_report_time_field);
        
        redirect('/reports/adhoc_reports/'.$report_access);
    }
    
    /**
     * ajax call to edit report attributes
     */
    public function edit_report_attributes() {
        $report_id = $this->input->get('report_id',TRUE);
        $report_name = $this->input->get('report_name',TRUE);
        $report_description = $this->input->get('report_description',TRUE);
        $data = $this->adhocreportsmodel->edit_adhoc_report_attributes($report_id, $report_name);
        echo $this->json->encode($data);
    }
    
    /**
     * ajax call to delete users
     */
    public function get_share_user_to_delete(){
        $report_id = $this->input->get('report_id',TRUE);
        $user_id = $this->input->get('user_id',TRUE);
        //Deleting User
        $data = $this->adhocreportsmodel->delete_user_access_to_report($report_id, $user_id);
        echo $this->json->encode($data);
    }
    
    public function save_objects_for_sharing_report() {
        $report_id = $this->input->get('report_id',TRUE);
        $selected_items = $this->input->get('selected_items',TRUE);
        $data = $this->adhocreportsmodel->add_user_access_to_report($report_id, $selected_items);
        echo $this->json->encode($data);
    }
    /**
     * Adhoc Report Security Check
     */

	protected function adhoc_report_security_check($report_id){
        
        //Get userID
        $session_id = User::organization_id_from_session();
        $userID = $this->usersmodel->get_user_id_from_org_id($session_id); 
        
        //Get Report Type
        $report_access = $this->adhocreportsmodel->get_report_type_by_id($report_id)->result();    
        if(!isset($report_access[0])){
            return false;
        }
        if (!$this->user->is_admin()){
            //Check Current if on Shared report list
            if($report_access[0]->report_access_type == "shared"){
                $report_security_check = $this->adhocreportsmodel->security_check($report_id, $userID)->result();    
                if (isset($report_security_check[0]->report_access_id)){ $result  = true; } else { $result = false; }
            } elseif($report_access[0]->report_access_type == "private"){
                $report_security_check = $this->adhocreportsmodel->security_check_private($report_id, $userID)->result();    
                if (isset($report_security_check[0]->report_id)){ $result  = true;    } else { $result = false; }
            } else {
                $result  = true;
            }
        } else {
            $result  = true;
        }
        return $result;
    }

    protected function parse_date($date_string) {
        try {
            $date = new DateTime($date_string);
            return $date;
        }
        catch ( Exception $ex ) {
            return false;
        }
    }

    protected function is_a_report_filter_date($date_string) {
        $pattern_date = '((0{0,1}[1-9])|(1[0-2]))\/((0{0,1}[1-9])|([1-2][0-9])|(3[0-1]))\/([0-9]{4})';
        //$pattern_time = '(((0{0,1}[0-9])|(1[0-2]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2}[[:space:]]+(am|pm))|(((0{0,1}[0-9])|(1[0-9])|(2[0-4]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2})';
        // regex only works at certain levels of nested parentheses. Looks like this is the limit. 
        $pattern_time[0] = '(((0{0,1}[0-9])|(1[0-2]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2}[[:space:]]+(am|pm))';
        $pattern_time[1] = '(((0{0,1}[0-9])|(1[0-9])|(2[0-4]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2})';

        // Based on time zone abbreviations from NIST website 
        $pattern_time_zone = '(AST|EST|CST|MST|PST|AKST|HST|SST|ChST|ADT|EDT|CDT|MDT|PDT|AKDT|HDT)';
        // This pattern is almost there, but doesn't cover all the scenarios!
        $patterns = array();
        for ( $i = 0; $i < 2; $i++ ) {
            $patterns[] = '/^' . $pattern_date . '([[:space:]]+' . $pattern_time[$i] . '){0,1}([[:space:]]+' . $pattern_time_zone . '){0,1}$/i';
        }

        if ( preg_match($patterns[0], $date_string) ||  preg_match($patterns[1], $date_string)) {
            return true;
        }
        
        return false;
    }
}