<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Install extends CI_Controller {
	var $title = 'Configuration Script';
	
	//these are set in the constructor
	var $databases = array();
	var $database_schema = array();
	var $mail_database_schema = array();
	var $nhindconfig_database_schema = array();
	var $database_queries = array();
	var $database_table_queries = array();
	var $ldap_schema = array();
	var $ldap_base_domain = '';
	
	//we pull our database configuration from constants and use it like CI would,
	//but we don't use the CI Database class in this install script due to the difficulty
	//in getting useful error messages when running multiple queries, which is necessary for creating the tables
	var $db_required_permissions = array('db_datareader' => FALSE, 'db_datawriter' => FALSE);
	var $database_servername = DATABASE_HOSTNAME;
	var $database_config = array (
									'UID'				=> DATABASE_USERNAME,
									'PWD'				=> DATABASE_PASSWORD,
									'Database'			=> 'master',
									'ConnectionPooling' => 0,
									'ReturnDatesAsStrings' => 1,
									'LoginTimeout' => 5,
								  );
								  
	public function __construct(){
		global $installer;
		$installer = TRUE;
		parent::__construct();
		
		require_models('mailbox');
	
		$this->config->set_item('sess_use_database', FALSE);
		$this->config->set_item('sess_encrypt_cookie', FALSE);
		$this->load->library(array('session','encrypt'));
		$this->load->helper('url');
		
		//for now the tables will be created in the order they are put in this array,
		//keep that in mind when setting up foreign key relations, etc.
		//TO-DO: Include array sorting function for preferred creation order
		$this->database_schema =  array( 
									'users' =>	array(
													'user_id' => 'bigint',
													'username' => 'nvarchar(50)',
													'user_org_id' => 'bigint',
													'user_created_time' => 'bigint',
													'user_ext_mail' => 'nvarchar(max)',
													'user_ep' => 'nvarchar(max)',
												),
									'account_request' => array(
													'id' => 'bigint',
													'username' => 'nvarchar(100)',
													'user_org_id' => 'bigint',
													'first_name' => 'nvarchar(100)',
													'middle_name' => 'nvarchar(100)',
													'last_name' => 'nvarchar(100)',
													'ext_mail' => 'nvarchar(200)',
													'title' => 'nvarchar(300)',
													'department' => 'nvarchar(300)',
													'organization' => 'nvarchar(300)',
													'location' => 'nvarchar(500)',
													'facility_id' => 'bigint',
													'telephone' => 'nvarchar(100)',
													'mobile' => 'nvarchar(100)',
													'request_date' => 'bigint',
													'approved_date' => 'bigint',
													'justification' => 'nvarchar(4000)',
													'denied' => 'tinyint',
												),
									'application' =>	array(
															'id' => 'bigint',
															'name' => 'nvarchar(100)',
															'public_key' => 'nvarchar(100)',
															'private_key' => 'nvarchar(100)',
															'url' => 'nvarchar(1000)',
															'description' => 'nvarchar(4000)',
															'poc_name' => 'nvarchar(500)',
															'poc_email' => 'nvarchar(100)',
															'poc_phone' => 'nvarchar(20)',
															'app_request_id' => 'bigint'
														),
									'application_account_link'	=>	array(
																		'id' => 'bigint',
																		'app_id' => 'bigint',
																		'unique_id' => 'nvarchar(64)',
																		'created_at' => 'bigint',
																		'org_id' => 'bigint',
																		'system_permissions' => 'nvarchar(100)'
																	),
									'application_request' =>	array(
																	'id' => 'bigint',
																	'name' => 'nvarchar(100)',
																	'requestor' => 'bigint',
																	'url' => 'nvarchar(1000)',
																	'description' => 'nvarchar(4000)',
																	'poc_name' => 'nvarchar(500)',
																	'poc_email' => 'nvarchar(100)',
																	'poc_phone' => 'nvarchar(20)',
																	'requested_date' => 'bigint',
																	'approved_date' => 'bigint',
																	'justification' => 'nvarchar(4000)',
																	'denial_reason' => 'nvarchar(4000)',
																	'denied' => 'tinyint',
																),
									'event_log'	=>	array(
														'id' => 'bigint',
														'target_type' => 'int',
														'target_id' => 'bigint',
														'actor_type' => 'int',
														'actor_id' => 'bigint',
														'action' => 'nvarchar(max)',
														'event_date' => 'bigint',
														'success' => 'tinyint',
													),
									'facility' =>	array(
														'id' => 'bigint',
														'name' => 'nvarchar(400)',
														'active' => 'tinyint',
													),
									'logins' =>	array(
													'id' => 'bigint',
													'session_id' => 'nvarchar(50)',
													'ip_address' => 'nvarchar(50)',
													'login_time' => 'bigint',
													'success' => 'tinyint',
													'error_msg' => 'nvarchar(max)',
													'org_id' => 'bigint',
												),
									'mail_log' =>	array(
														'id' => 'bigint',
														'time' => 'bigint',
														'size' => 'bigint',
														'sender' => 'nvarchar(max)',
														'recipient' => 'nvarchar(max)',
														'attachment_types' => 'nvarchar(max)',
														'success' => 'tinyint',
														'inbound_outbound' => 'tinyint',
														'mdn' => 'tinyint',
														'protected_data' => 'tinyint',
														'storage_id' => 'bigint',
													),
									'mailbox_settings' =>	array(
																'id' => 'bigint',
																'mailbox_id' => 'bigint',
																'application_id' => 'bigint',
																'web_service_id' => 'bigint',
																'authorized' => 'tinyint',
															),
									'request' =>	array(
														'id' => 'bigint',
														'application_id' => 'bigint',
														'call' => 'nvarchar(max)',
														'call_date' => 'bigint',
														'response_code' => 'int',
														'response' => 'nvarchar(max)',
													),
									'ticket_category' =>	array(
																'id' => 'bigint',
																'category' => 'nvarchar(200)',
															),
									'tickets' =>	array(
														'id' => 'bigint',
														'parent_id' => 'bigint',
														'user_id' => 'bigint',
														'message' => 'nvarchar(4000)',
														'open_date' => 'bigint',
														'close_date' => 'bigint',
														'category_id' => 'bigint',
													),
									'web_services' =>	array(
															'id' => 'bigint',
															'name' => 'nvarchar(200)',
															'description' => 'nvarchar(4000)',
														),
									'role_permissions' =>	array(
																'id' => 'bigint',
																'role_name' => 'nvarchar(150)',
																'permission_id' => 'bigint',
														),
									'permissions' =>	array(
																'id' => 'bigint',
																'name' => 'nvarchar(100)',
																'parent_id' => 'bigint',
														),
									'adhoc_reports' => 	array(
															'report_id' => 'bigint',
															'report_type' => 'nvarchar(100)',
															'report_name' => 'nvarchar(50)',
															'report_description' => 'nvarchar(max)',
															'report_created_by' => 'nvarchar(max)',
															'report_access_type' => 'nvarchar(50)',
															'report_created_time' => 'bigint',
															'report_query_generator' => 'nvarchar(max)',
															'report_order_by' => 'nvarchar(max)',
															'report_order_by_direction' => 'nvarchar(100)',
															'report_time_period' => 'nvarchar(200)',
															'report_status' => 'nvarchar(max)',
															'report_end_date' => 'nvarchar(max)',
															'report_start_date' => 'nvarchar(max)',
															'report_selector' => 'nvarchar(max)',
															'report_time_field' => 'nvarchar(200)',
														),
									'adhoc_reports_access' =>	array(
																	'report_access_id' => 'bigint',
																	'report_id' => 'bigint',
																	'user_id' => 'bigint',
																	'time' => 'bigint',
																),
									);
		$this->mail_database_schema =  array(
											'mailboxes' => array(
												'id' => 'bigint',
												'name' => 'nvarchar(100)',
												'is_group' => 'tinyint',
												'is_active' => 'tinyint',
												'facility_id' => 'bigint',
											),
											'folders' => array(
												'id' => 'bigint',
												'name' => 'nvarchar(200)',
												'mailbox_id' => 'bigint',
												'parent_id' => 'bigint',
											),
											'messages' => array(
												'id' => 'bigint',
												'recipients' => 'nvarchar(max)',
												'sender' => 'nvarchar(max)',
												'original_sender_id' => 'bigint',
												'to' => 'nvarchar(max)',
												'cc' => 'nvarchar(max)',
												'bcc' => 'nvarchar(max)',
												'attachments' => 'nvarchar(max)',
												'subject' => 'nvarchar(max)',
												'plain' => 'nvarchar(max)',
												'html' => 'nvarchar(max)',
												'timestamp' => 'bigint',
												'folder_id' => 'bigint',
												'size' => 'bigint',
												'flags' => 'nvarchar(max)',
												'headers' => 'nvarchar(max)',
												'raw_mime' => 'nvarchar(max)',
												'seen' => 'tinyint',
												'sent' => 'tinyint',
												'archived' => 'tinyint',
												'message_id' => 'nvarchar(max)',
												'mailbox_id' => 'bigint',
												'mailtype' => 'nvarchar(4)',
												'priority' => 'tinyint',
												'protected_data' => 'tinyint',
											),
											'message_status' => array(
												'id' => 'bigint',
												'message_id' => 'nvarchar(max)',
												'status_code' => 'tinyint',
												'recipient' => 'nvarchar(max)',
												'timestamp' => 'bigint',
											),
											'patients' => array(
												'id' => 'bigint',
												'message_id' => 'bigint',
												'given_name' => 'nvarchar(max)',
												'family_name' => 'nvarchar(max)',
												'date_of_birth' => 'bigint',
												'title' => 'nvarchar(max)',
												'organization' => 'nvarchar(max)',
												'file_hash' => 'nvarchar(60)',
												
											),
											'accounting_disclosure' => array(
													'id' => 'bigint',
													'messages_table_id' => 'bigint',
													'message_id' => 'nvarchar(max)',
													'recipient' => 'nvarchar(max)',
													'first' => 'nvarchar(max)',
													'last' => 'nvarchar(max)',
													'disclosed' => 'bigint',
													'received' => 'bigint',
													'title' => 'nvarchar(max)',
													'sent_to' => 'nvarchar(max)',
													'received_from' => 'nvarchar(max)',
													'username' => 'nvarchar(100)',
													'facility' => 'nvarchar(max)',
													'purpose' => 'nvarchar(max)',
													'ssn' => 'bigint',
													'hash' => 'nchar(40)',
													'patient_id' => 'nvarchar(50)',
													
											),
										);
		$this->nhindconfig_database_schema = array (
												'mailet_properties' => array(
																			'name' => 'varchar(50)',
																			'value' => 'varchar(max)',
																		),
											);
		$this->database_queries = array(
									'create_' . DATABASE_NAME => 	"
																	USE [master];
																	IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'api')
																	BEGIN
																	CREATE DATABASE [api]
																	ALTER DATABASE [api] SET COMPATIBILITY_LEVEL = 100

																	IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
																	BEGIN
																	EXEC [api].[dbo].[sp_fulltext_database] @action = 'enable'
																	END
																	ALTER DATABASE [api] SET ANSI_NULL_DEFAULT OFF 
																	ALTER DATABASE [api] SET ANSI_NULLS OFF 
																	ALTER DATABASE [api] SET ANSI_PADDING OFF 
																	ALTER DATABASE [api] SET ANSI_WARNINGS OFF 
																	ALTER DATABASE [api] SET ARITHABORT OFF 
																	ALTER DATABASE [api] SET AUTO_CLOSE OFF 
																	ALTER DATABASE [api] SET AUTO_CREATE_STATISTICS ON 
																	ALTER DATABASE [api] SET AUTO_SHRINK OFF 
																	ALTER DATABASE [api] SET AUTO_UPDATE_STATISTICS ON 
																	ALTER DATABASE [api] SET CURSOR_CLOSE_ON_COMMIT OFF 
																	ALTER DATABASE [api] SET CURSOR_DEFAULT  GLOBAL 
																	ALTER DATABASE [api] SET CONCAT_NULL_YIELDS_NULL OFF 
																	ALTER DATABASE [api] SET NUMERIC_ROUNDABORT OFF 
																	ALTER DATABASE [api] SET QUOTED_IDENTIFIER OFF 
																	ALTER DATABASE [api] SET RECURSIVE_TRIGGERS OFF 
																	ALTER DATABASE [api] SET  DISABLE_BROKER 
																	ALTER DATABASE [api] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
																	ALTER DATABASE [api] SET DATE_CORRELATION_OPTIMIZATION OFF 
																	ALTER DATABASE [api] SET TRUSTWORTHY OFF 
																	ALTER DATABASE [api] SET ALLOW_SNAPSHOT_ISOLATION OFF 
																	ALTER DATABASE [api] SET PARAMETERIZATION SIMPLE 
																	ALTER DATABASE [api] SET READ_COMMITTED_SNAPSHOT OFF 
																	ALTER DATABASE [api] SET HONOR_BROKER_PRIORITY OFF 
																	ALTER DATABASE [api] SET  READ_WRITE 
																	ALTER DATABASE [api] SET RECOVERY FULL 
																	ALTER DATABASE [api] SET  MULTI_USER
																	ALTER DATABASE [api] SET PAGE_VERIFY CHECKSUM  
																	ALTER DATABASE [api] SET DB_CHAINING OFF
																	END
																	",
									'create_' . MAIL_DATABASE_NAME => "
																	USE [master];
																	IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'mail')
																	BEGIN
																	CREATE DATABASE [mail]
																	ALTER DATABASE [mail] SET COMPATIBILITY_LEVEL = 100

																	IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
																	BEGIN
																	EXEC [mail].[dbo].[sp_fulltext_database] @action = 'enable'
																	END
																	ALTER DATABASE [mail] SET ANSI_NULL_DEFAULT OFF 
																	ALTER DATABASE [mail] SET ANSI_NULLS OFF 
																	ALTER DATABASE [mail] SET ANSI_PADDING OFF 
																	ALTER DATABASE [mail] SET ANSI_WARNINGS OFF 
																	ALTER DATABASE [mail] SET ARITHABORT OFF 
																	ALTER DATABASE [mail] SET AUTO_CLOSE OFF 
																	ALTER DATABASE [mail] SET AUTO_CREATE_STATISTICS ON 
																	ALTER DATABASE [mail] SET AUTO_SHRINK OFF 
																	ALTER DATABASE [mail] SET AUTO_UPDATE_STATISTICS ON 
																	ALTER DATABASE [mail] SET CURSOR_CLOSE_ON_COMMIT OFF 
																	ALTER DATABASE [mail] SET CURSOR_DEFAULT  GLOBAL 
																	ALTER DATABASE [mail] SET CONCAT_NULL_YIELDS_NULL OFF 
																	ALTER DATABASE [mail] SET NUMERIC_ROUNDABORT OFF 
																	ALTER DATABASE [mail] SET QUOTED_IDENTIFIER OFF 
																	ALTER DATABASE [mail] SET RECURSIVE_TRIGGERS OFF 
																	ALTER DATABASE [mail] SET  DISABLE_BROKER 
																	ALTER DATABASE [mail] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
																	ALTER DATABASE [mail] SET DATE_CORRELATION_OPTIMIZATION OFF 
																	ALTER DATABASE [mail] SET TRUSTWORTHY OFF 
																	ALTER DATABASE [mail] SET ALLOW_SNAPSHOT_ISOLATION OFF 
																	ALTER DATABASE [mail] SET PARAMETERIZATION SIMPLE 
																	ALTER DATABASE [mail] SET READ_COMMITTED_SNAPSHOT OFF 
																	ALTER DATABASE [mail] SET HONOR_BROKER_PRIORITY OFF 
																	ALTER DATABASE [mail] SET  READ_WRITE 
																	ALTER DATABASE [mail] SET RECOVERY FULL 
																	ALTER DATABASE [mail] SET  MULTI_USER
																	ALTER DATABASE [mail] SET PAGE_VERIFY CHECKSUM  
																	ALTER DATABASE [mail] SET DB_CHAINING OFF
																	END
																	",
									'encrypt_'.MAIL_DATABASE_NAME => 	"
																		USE [master]
																		IF (select Count(*) from sys.symmetric_keys where name like '%DatabaseMasterKey%') = 0
																		BEGIN
																		create master key encryption by password = '".$this->config->item('encryption_key')."';
																		END

																		IF (select Count(*) from sys.certificates where name = 'TDE_Certificate') = 0
																		BEGIN
																		create certificate TDE_Certificate with subject = 'Database TDE certificate';
																		END

																		IF (select Count(*) from sys.certificates where name = 'TDE_Certificate') > 0
																		BEGIN
																		USE [mail]
																		CREATE DATABASE ENCRYPTION KEY
																		WITH ALGORITHM = AES_256
																		ENCRYPTION BY SERVER CERTIFICATE TDE_Certificate
																		ALTER DATABASE mail SET ENCRYPTION ON
																		END
																		",
									'create_nhindconfig' => 	"
																	USE [master];
																	IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'nhindconfig')
																	BEGIN
																	CREATE DATABASE [nhindconfig]
																	ALTER DATABASE [nhindconfig] SET COMPATIBILITY_LEVEL = 100

																	IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
																	BEGIN
																	EXEC [nhindconfig].[dbo].[sp_fulltext_database] @action = 'enable'
																	END
																	ALTER DATABASE [nhindconfig] SET ANSI_NULL_DEFAULT OFF 
																	ALTER DATABASE [nhindconfig] SET ANSI_NULLS OFF 
																	ALTER DATABASE [nhindconfig] SET ANSI_PADDING OFF 
																	ALTER DATABASE [nhindconfig] SET ANSI_WARNINGS OFF 
																	ALTER DATABASE [nhindconfig] SET ARITHABORT OFF 
																	ALTER DATABASE [nhindconfig] SET AUTO_CLOSE OFF 
																	ALTER DATABASE [nhindconfig] SET AUTO_CREATE_STATISTICS ON 
																	ALTER DATABASE [nhindconfig] SET AUTO_SHRINK OFF 
																	ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS ON 
																	ALTER DATABASE [nhindconfig] SET CURSOR_CLOSE_ON_COMMIT OFF 
																	ALTER DATABASE [nhindconfig] SET CURSOR_DEFAULT  GLOBAL 
																	ALTER DATABASE [nhindconfig] SET CONCAT_NULL_YIELDS_NULL OFF 
																	ALTER DATABASE [nhindconfig] SET NUMERIC_ROUNDABORT OFF 
																	ALTER DATABASE [nhindconfig] SET QUOTED_IDENTIFIER OFF 
																	ALTER DATABASE [nhindconfig] SET RECURSIVE_TRIGGERS OFF 
																	ALTER DATABASE [nhindconfig] SET  DISABLE_BROKER 
																	ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
																	ALTER DATABASE [nhindconfig] SET DATE_CORRELATION_OPTIMIZATION OFF 
																	ALTER DATABASE [nhindconfig] SET TRUSTWORTHY OFF 
																	ALTER DATABASE [nhindconfig] SET ALLOW_SNAPSHOT_ISOLATION OFF 
																	ALTER DATABASE [nhindconfig] SET PARAMETERIZATION SIMPLE 
																	ALTER DATABASE [nhindconfig] SET READ_COMMITTED_SNAPSHOT OFF 
																	ALTER DATABASE [nhindconfig] SET HONOR_BROKER_PRIORITY OFF 
																	ALTER DATABASE [nhindconfig] SET  READ_WRITE 
																	ALTER DATABASE [nhindconfig] SET RECOVERY FULL 
																	ALTER DATABASE [nhindconfig] SET  MULTI_USER
																	ALTER DATABASE [nhindconfig] SET PAGE_VERIFY CHECKSUM  
																	ALTER DATABASE [nhindconfig] SET DB_CHAINING OFF
																	END
																	",
								 );
		$this->database_table_queries = array(
									DATABASE_NAME => array(
										'create_users' =>	"
															USE [".DATABASE_NAME."]
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[users]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[users](
																[user_id] [bigint] IDENTITY(1,1) NOT NULL,
																[username] [varchar](50) NOT NULL,
																[user_org_id] [bigint] NOT NULL,
																[user_created_time] [bigint] NOT NULL,
																[user_ext_mail] [nvarchar](max) NULL,
																[user_ep] [nvarchar](max) NOT NULL,
															PRIMARY KEY CLUSTERED ([user_id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]			
															ALTER TABLE [dbo].[users] ADD CONSTRAINT [unique_user_org_id] UNIQUE NONCLUSTERED ([user_org_id])
															END
															",
										'create_application_request' => 	"
																		USE [".DATABASE_NAME."]
																		IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[application_request]') AND type in (N'U'))
																		CREATE TABLE [dbo].[application_request](
																			[id] [bigint] IDENTITY(1,1) NOT NULL,
																			[name] [varchar](100) NULL,
																			[requestor] [bigint] NOT NULL,
																			[url] [varchar](1000) NULL,
																			[description] [varchar](4000) NULL,
																			[poc_name] [varchar](500) NULL,
																			[poc_email] [varchar](100) NULL,
																			[poc_phone] [varchar](20) NULL,
																			[requested_date] [bigint] NULL,
																			[approved_date] [bigint] NULL,
																			[justification] [varchar](4000) NULL,
																			[denial_reason] [varchar](4000) NULL,
																			[denied] [tinyint] NULL,
																		PRIMARY KEY CLUSTERED ([id] ASC)
																		WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

																		IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_application_request_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[application_request]'))
																		BEGIN
																		ALTER TABLE [dbo].[application_request]  WITH CHECK ADD CONSTRAINT [FK_application_request_users] FOREIGN KEY([requestor])
																		REFERENCES [dbo].[users] ([user_id])
																		END
																		",
										'create_application' =>	"
																USE [".DATABASE_NAME."]
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[application]') AND type in (N'U'))
																CREATE TABLE [dbo].[application](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[name] [varchar](100) NULL,
																	[public_key] [varchar](100) NULL,
																	[private_key] [varchar](100) NULL,
																	[url] [varchar](1000) NULL,
																	[description] [varchar](4000) NULL,
																	[poc_name] [varchar](500) NULL,
																	[poc_email] [varchar](100) NULL,
																	[poc_phone] [varchar](20) NULL,
																	[app_request_id] [bigint] NULL,
																PRIMARY KEY CLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]

																IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_application_application_reques]') AND parent_object_id = OBJECT_ID(N'[dbo].[application]'))
																BEGIN
																ALTER TABLE [dbo].[application]  WITH CHECK ADD CONSTRAINT [FK_application_application_request] FOREIGN KEY([app_request_id])
																REFERENCES [dbo].[application_request] ([id])
																END
																",
										'create_application_account_link' => 	"
																				USE [".DATABASE_NAME."]
																				SET ANSI_NULLS ON
																				SET QUOTED_IDENTIFIER ON
																				SET ANSI_PADDING ON

																				IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[application_account_link]') AND type in (N'U'))
																				BEGIN
																				CREATE TABLE [dbo].[application_account_link](
																					[id] [bigint] IDENTITY(1,1) NOT NULL,
																					[app_id] [bigint] NOT NULL,
																					[unique_id] [nvarchar](64) NOT NULL,
																					[created_at] [bigint] NOT NULL,
																					[org_id] [bigint] NULL,
																					[system_permissions] [nvarchar](100) NULL,
																				 CONSTRAINT [PK_application_account_link] PRIMARY KEY CLUSTERED ([id] ASC)
																				WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																				END
																				SET ANSI_PADDING OFF

																				IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_application_account_link_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[application_account_link]'))
																				BEGIN
																				ALTER TABLE [dbo].[application_account_link]  WITH CHECK ADD CONSTRAINT [FK_application_account_link_application] FOREIGN KEY([app_id])
																				REFERENCES [dbo].[application] ([id])
																				END
																				",
										'create_account_request' =>	"
																	USE [".DATABASE_NAME."]
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[account_request]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[account_request](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[username] [varchar](100) NULL,
																		[user_org_id] [bigint] NOT NULL,
																		[first_name] [nvarchar](100) NOT NULL,
																		[middle_name] [nvarchar](100) NULL,
																		[last_name] [nvarchar](100) NOT NULL,
																		[ext_mail] [nvarchar](200) NULL,
																		[title] [nvarchar](300) NULL,
																		[department] [nvarchar](300) NULL,
																		[organization] [nvarchar](300) NULL,
																		[location] [nvarchar](500) NULL,
																		[facility_id] [bigint] NULL,
																		[telephone] [nvarchar](100) NULL,
																		[mobile] [nvarchar](100) NULL,
																		[request_date] [bigint] NOT NULL,
																		[approved_date] [bigint] NULL,
																		[justification] [varchar](4000) NULL,
																		[denied] [tinyint] NOT NULL,
																	PRIMARY KEY CLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	",
										'create_event_log' =>	"
																USE [".DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[event_log]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[event_log](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[target_type] [int] NOT NULL,
																	[target_id] [bigint] NOT NULL,
																	[actor_type] [int] NOT NULL,
																	[actor_id] [bigint] NOT NULL,
																	[action] [nvarchar](max) NOT NULL,
																	[event_date] [bigint] NOT NULL,
																	[success] [tinyint] NOT NULL,
																 CONSTRAINT [PK_event_log] PRIMARY KEY CLUSTERED ([id] ASC)
																 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																",
										'create_facility' =>	"
																USE [".DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[facility]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[facility](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[name] [varchar](400) NOT NULL,
																	[active] [tinyint] NOT NULL,
																PRIMARY KEY CLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																SET ANSI_PADDING OFF
																END
																",
										'create_logins' =>	"
															USE [".DATABASE_NAME."]
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[logins]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[logins](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[session_id] [nvarchar](50) NOT NULL,
																[ip_address] [nvarchar](50) NOT NULL,
																[login_time] [bigint] NOT NULL,
																[success] [tinyint] NOT NULL,
																[error_msg] [nvarchar](max) NOT NULL,
																[org_id] [bigint] NOT NULL,
															 CONSTRAINT [PK_logins] PRIMARY KEY CLUSTERED ([id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															END
															",
										'create_mail_log' =>	"
																USE [".DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mail_log]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[mail_log](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[time] [bigint] NOT NULL,
																	[size] [bigint] NOT NULL,
																	[sender] [varchar](max) NOT NULL,
																	[recipient] [varchar](max) NOT NULL,
																	[attachment_types] [nvarchar](max) NOT NULL,
																	[success] [tinyint] NOT NULL,
																	[inbound_outbound] [tinyint] NOT NULL,
																	[mdn] [tinyint] NULL,
																	[protected_data] [tinyint] NULL,
																	[storage_id] [bigint] NULL,
																 CONSTRAINT [PK_mail_log] PRIMARY KEY CLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																SET ANSI_PADDING OFF
																",
										'create_mailbox_settings' =>	"
																		USE [".DATABASE_NAME."]
																		IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailbox_settings]') AND type in (N'U'))
																		BEGIN
																		CREATE TABLE [dbo].[mailbox_settings](
																			[id] [bigint] IDENTITY(1,1) NOT NULL,
																			[mailbox_id] [bigint] NOT NULL,
																			[application_id] [bigint] NOT NULL,
																			[web_service_id] [bigint] NOT NULL,
																			[authorized] [tinyint] NOT NULL,
																		PRIMARY KEY CLUSTERED([id] ASC)
																		WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																		END

																		IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_mailbox_settings_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[mailbox_settings]'))
																		BEGIN
																		ALTER TABLE [dbo].[mailbox_settings]  WITH CHECK ADD CONSTRAINT [FK_mailbox_settings_application] FOREIGN KEY([application_id])
																		REFERENCES [dbo].[application] ([id])
																		END

																		IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_mailbox_settings_web_services]') AND parent_object_id = OBJECT_ID(N'[dbo].[mailbox_settings]'))
																		BEGIN
																		ALTER TABLE [dbo].[mailbox_settings]  WITH CHECK ADD CONSTRAINT [FK_mailbox_settings_web_services] FOREIGN KEY([web_service_id])
																		REFERENCES [dbo].[web_services] ([id])
																		END
																		",
										'create_request' =>	"
															USE [".DATABASE_NAME."]
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[request]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[request](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[application_id] [bigint] NULL,
																[call] [varchar](max) NULL,
																[call_date] [bigint] NULL,
																[response_code] [int] NULL,
																[response] [varchar](max) NULL,
															PRIMARY KEY CLUSTERED ([id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_request_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[request]'))
															BEGIN
															ALTER TABLE [dbo].[request]  WITH CHECK ADD CONSTRAINT [FK_request_application] FOREIGN KEY([application_id])
															REFERENCES [dbo].[application] ([id])
															END
															",
										'create_ticket_category' => "
																	USE [".DATABASE_NAME."]
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ticket_category]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[ticket_category](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[category] [varchar](200) NULL,
																	PRIMARY KEY CLUSTERED
																	([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	
																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ticket_category]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[web_services] ON
																	INSERT [dbo].[ticket_category] ([id], [category]) VALUES (1, N'Contact')
																	SET IDENTITY_INSERT [dbo].[web_services] OFF
																	END
																	",
										'create_tickets' =>	"
															USE [".DATABASE_NAME."]
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[tickets]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[tickets](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[parent_id] [bigint] NULL,
																[user_id] [bigint] NULL,
																[message] [varchar](4000) NULL,
																[open_date] [bigint] NULL,
																[close_date] [bigint] NULL,
																[category_id] [bigint] NULL,
															PRIMARY KEY CLUSTERED ([id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_tickets_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[tickets]'))
															BEGIN
															ALTER TABLE [dbo].[tickets]  WITH CHECK ADD CONSTRAINT [FK_tickets_users] FOREIGN KEY([user_id])
															REFERENCES [dbo].[users] ([user_id])
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_tickets_tickets]') AND parent_object_id = OBJECT_ID(N'[dbo].[tickets]'))
															BEGIN
															ALTER TABLE [dbo].[tickets]  WITH CHECK ADD CONSTRAINT [FK_tickets_tickets] FOREIGN KEY([parent_id])
															REFERENCES [dbo].[tickets] ([id])
															END

															IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_tickets_ticket_category]') AND parent_object_id = OBJECT_ID(N'[dbo].[tickets]'))
															BEGIN
															ALTER TABLE [dbo].[tickets]  WITH CHECK ADD CONSTRAINT [FK_tickets_ticket_category] FOREIGN KEY([category_id])
															REFERENCES [dbo].[ticket_category] ([id])
															END
															",
										'create_web_services' =>	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[web_services]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[web_services](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[name] [varchar](200) NOT NULL,
																		[description] [varchar](4000) NULL,
																	 CONSTRAINT [PK_web_services] PRIMARY KEY NONCLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	SET ANSI_PADDING OFF

																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[web_services]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[web_services] ON
																	INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (1, N'send', N'Allows application to send a direct message on your behalf')
																	INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (2, N'retrieve', N'Allows application to retrieve your messages')
																	INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (3, N'manage', N'Allows application to manage messages and folders')
																	SET IDENTITY_INSERT [dbo].[web_services] OFF
																	END
																	",
											'create_permissions' =>	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[permissions]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[permissions](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[name] [varchar](100) NOT NULL,
																		[parent_id] bigint NULL,
																	 CONSTRAINT [PK_permissions] PRIMARY KEY NONCLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	SET ANSI_PADDING OFF
											
																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[permissions]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[permissions] ON
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (1, N'reports', NULL)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (2, N'user_activity_summary_report', 1)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (3, N'facility_report', 1)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (4, N'adhoc_reports_report', 1)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (5, N'administration', NULL)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (6, N'manage_groups', 5)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (7, N'manage_groups_lead', 6)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (8,  ' n b e_group', 6)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (9, N'disable_group', 6)
																	INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (10, N'group_permissions', 6)
																	SET IDENTITY_INSERT [dbo].[permissions] OFF
																	END
																	",
											'create_role_permissions' =>	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[role_permissions]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[role_permissions](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[role_name] [varchar](150) NOT NULL,
																		[permission_id] bigint NOT NULL,
																	 CONSTRAINT [PK_role_permissions] PRIMARY KEY NONCLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	END
																	SET ANSI_PADDING OFF
						
																	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[role_permissions]') AND type in (N'U'))
																	BEGIN
																	SET IDENTITY_INSERT [dbo].[role_permissions] ON
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (1, N'facilityleader', 1)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (2, N'facilityleader', 2)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (3, N'facilityleader', 3)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (4, N'facilityleader', 3)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (5, N'groupleader', 4)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (6, N'groupleader', 5)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (7, N'groupleader', 6)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (8, N'groupleader', 7)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (9, N'groupleader', 8)
																	INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (10, N'groupleader', 9)
																	
																	SET IDENTITY_INSERT [dbo].[role_permissions] OFF
																	END
																	",
										'create_adhoc_reports' => 	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	CREATE TABLE [dbo].[adhoc_reports](
																		[report_id] [bigint] IDENTITY(1,1) NOT NULL,
																		[report_type] [nvarchar](100) NULL,
																		[report_name] [nvarchar](50) NULL,
																		[report_description] [nvarchar](max) NULL,
																		[report_created_by] [nvarchar](max) NULL,
																		[report_access_type] [nvarchar](50) NULL,
																		[report_created_time] [bigint] NOT NULL,
																		[report_query_generator] [nvarchar](max) NULL,
																		[report_order_by] [nvarchar](max) NULL,
																		[report_order_by_direction] [nvarchar](100) NULL,
																		[report_time_period] [nvarchar](200) NULL,
																		[report_status] [nvarchar](max) NULL,
																		[report_end_date] [nvarchar](max) NULL,
																		[report_start_date] [nvarchar](max) NULL,
																		[report_selector] [nvarchar](max) NULL,
																		[report_time_field] [nvarchar](200) NULL
																	) ON [PRIMARY]
																	",
										'create_adhoc_reports_access' => 	"
																			USE [".DATABASE_NAME."]
																			SET ANSI_NULLS ON
																			SET QUOTED_IDENTIFIER ON
																			CREATE TABLE [dbo].[adhoc_reports_access](
																				[report_access_id] [bigint] IDENTITY(1,1) NOT NULL,
																				[report_id] [bigint] NOT NULL,
																				[user_id] [bigint] NOT NULL,
																				[time] [bigint] NOT NULL
																			) ON [PRIMARY]
																			",
									),
									MAIL_DATABASE_NAME => array(
										'create_folders' =>	"
															USE [".MAIL_DATABASE_NAME."]
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															SET ANSI_PADDING ON
															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[folders]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[folders](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[name] [varchar](200) NOT NULL,
																[mailbox_id] [bigint] NOT NULL,
																[parent_id] [bigint] NULL,
															 CONSTRAINT [PK_folders] PRIMARY KEY NONCLUSTERED ([id] ASC)
															 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															SET ANSI_PADDING OFF
															END
															IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[folders]') AND type in (N'U'))
															BEGIN
															ALTER TABLE [dbo].[folders]  WITH CHECK ADD  CONSTRAINT [FK_folder_mailbox2] FOREIGN KEY([mailbox_id])
															REFERENCES [dbo].[mailboxes] ([id])
															ON DELETE CASCADE
															ALTER TABLE [dbo].[folders] CHECK CONSTRAINT [FK_folder_mailbox2]
															END
															",
										'create_messages' => 	"
																USE [".MAIL_DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[messages]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[messages](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[recipients] [varchar](max) NULL,
																	[sender] [varchar](max) NOT NULL,
																	[original_sender_id] [bigint] NULL,
																	[to] [varchar](max) NULL,
																	[cc] [varchar](max) NULL,
																	[bcc] [varchar](max) NULL,
																	[attachments] [varchar](max) NULL,
																	[subject] [varchar](max) NULL,
																	[plain] [varchar](max) NULL,
																	[html] [varchar](max) NULL,
																	[timestamp] [bigint] NOT NULL,
																	[folder_id] [bigint] NULL,
																	[size] [bigint] NULL,
																	[flags] [varchar](max) NULL,
																	[headers] [varchar](max) NOT NULL,
																	[raw_mime] [varchar](max) NULL,
																	[seen] [tinyint] NULL,
																	[draft] [tinyint] NULL,
																	[sent] [tinyint] NULL,
																	[archived] [tinyint] NULL,
																	[message_id] [varchar](max) NULL,
																	[mailbox_id] [bigint] NOT NULL,
																	[mailtype] [varchar](4) NOT NULL,
																	[priority] [tinyint] NOT NULL,
																	[protected_data] [tinyint] NULL,
																 CONSTRAINT [PK_mailbox_username] PRIMARY KEY NONCLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																SET ANSI_PADDING OFF
																IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[messages]') AND type in (N'U'))
																BEGIN
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [seen]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [draft]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [sent]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [archived]
																ALTER TABLE [dbo].[messages] ADD  DEFAULT ('html') FOR [mailtype]
																ALTER TABLE [dbo].[messages]  WITH CHECK ADD  CONSTRAINT [FK_message_mailbox] FOREIGN KEY([mailbox_id])
																REFERENCES [dbo].[mailboxes] ([id])
																ALTER TABLE [dbo].[messages] CHECK CONSTRAINT [FK_message_mailbox]
																ALTER TABLE [dbo].[messages]  WITH CHECK ADD  CONSTRAINT [FK_messages_folder] FOREIGN KEY([folder_id])
																REFERENCES [dbo].[folders] ([id])
																ON DELETE SET NULL
																ALTER TABLE [dbo].[messages] CHECK CONSTRAINT [FK_messages_folder]
																END
																",
										'create_mailboxes' =>	"
																USE [".MAIL_DATABASE_NAME."]
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailboxes]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[mailboxes](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[name] [varchar](100) NOT NULL,
																	[is_group] [tinyint] NULL,
																	[is_active] [tinyint] NULL,
																	[facility_id] [bigint] NULL,
																 CONSTRAINT [PK_mailboxes] PRIMARY KEY NONCLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
																UNIQUE NONCLUSTERED ([name] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																SET ANSI_PADDING OFF
																IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailboxes]') AND type in (N'U'))
																BEGIN
																ALTER TABLE [dbo].[mailboxes] ADD  DEFAULT ((0)) FOR [is_group]
																ALTER TABLE [dbo].[mailboxes] ADD  DEFAULT ((0)) FOR [is_active]
																END
																",
										'create_message_status' => 	"
																	USE [".MAIL_DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	CREATE TABLE [dbo].[message_status](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[message_id] [varchar](max) NOT NULL,
																		[status_code] [tinyint] NOT NULL,
																		[recipient] [varchar](max) NOT NULL,
																		[timestamp] [bigint] NOT NULL,
																	 CONSTRAINT [PK_message_status] PRIMARY KEY CLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	SET ANSI_PADDING OFF
																	",
											'create_patients'=>
											"USE [".MAIL_DATABASE_NAME."]
											GO
											
											/****** Object:  Table [dbo].[patients]    Script Date: 11/03/2014 13:03:39 ******/
											SET ANSI_NULLS ON
											GO
											
											SET QUOTED_IDENTIFIER ON
											GO
											
											CREATE TABLE [dbo].[patients](
													[id] [bigint] IDENTITY(1,1) NOT NULL,
													[message_id] [bigint] NOT NULL,
													[given_name] [nvarchar](max) NULL,
													[family_name] [nvarchar](max) NULL,
													[date_of_birth] [bigint] NULL,
													[title] [nvarchar](max) NULL,
													[organization] [nvarchar](max) NULL,
													[file_hash] [nvarchar](60) NULL,
													CONSTRAINT [PK_patients] PRIMARY KEY NONCLUSTERED
													(
															[id] ASC
													)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
											) ON [PRIMARY]
											
											GO
											
											ALTER TABLE [dbo].[patients]  WITH CHECK ADD  CONSTRAINT [FK_patients_messages] FOREIGN KEY([message_id])
											REFERENCES [dbo].[messages] ([id])
											GO
											
											ALTER TABLE [dbo].[patients] CHECK CONSTRAINT [FK_patients_messages]
											GO
											",
												
										'create_accounting_disclosure' =>
																	"
																	USE [".MAIL_DATABASE_NAME."]
																	SET ANSI_NULLS ON	
																	SET QUOTED_IDENTIFIER ON	
																	SET ANSI_PADDING ON
																	CREATE TABLE [dbo].[accounting_disclosure](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[messages_table_id] [bigint] NOT NULL,
																		[message_id] [nvarchar](max) NULL,
																		[recipient] [nvarchar](max) NULL,
																		[first] [nvarchar](max) NULL,
																		[last] [nvarchar](max) NULL,
																		[disclosed] [bigint] NOT NULL,
																		[received] [bigint] NULL,
																		[title] [nvarchar](max) NULL,
																		[sent_to] [nvarchar](max) NULL,
																		[received_from] [nvarchar](max) NULL,
																		[username] [nvarchar](100) NOT NULL,
																		[facility] [nvarchar](max) NULL,
																		[purpose] [nvarchar](max) NULL,
																		[ssn] [bigint] NULL,
																		[hash] [nchar](40) NOT NULL,
																		[patient_id] [nvarchar](50) NULL,
																	 CONSTRAINT [PK_accounting_disclosures] PRIMARY KEY CLUSTERED ([id] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	SET ANSI_PADDING OFF
																	ALTER TABLE [dbo].[accounting_disclosure]  WITH CHECK ADD  CONSTRAINT [FK_accounting_disclosures_mailboxes] FOREIGN KEY([username]) REFERENCES [dbo].[mailboxes] ([name])
																	ALTER TABLE [dbo].[accounting_disclosure] CHECK CONSTRAINT [FK_accounting_disclosures_mailboxes]
																	ALTER TABLE [dbo].[accounting_disclosure]  WITH CHECK ADD  CONSTRAINT [FK_accounting_disclosures_messages] FOREIGN KEY([messages_table_id]) REFERENCES [dbo].[messages] ([id])
																	ALTER TABLE [dbo].[accounting_disclosure] CHECK CONSTRAINT [FK_accounting_disclosures_messages]									
																	",
									),
									'nhindconfig' => array(
										'create_mailet_properties' =>	"
																		USE [nhindconfig]
																		SET ANSI_NULLS ON
																		SET QUOTED_IDENTIFIER ON
																		SET ANSI_PADDING ON
																		IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailet_properties]') AND type in (N'U'))
																		BEGIN
																		CREATE TABLE [dbo].[mailet_properties](
																			[name] [varchar](50) NOT NULL,
																			[value] [varchar](max) NULL,
																		 CONSTRAINT [PK_mailet_properties] PRIMARY KEY CLUSTERED ([name] ASC)
																		WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																		END
																		SET ANSI_PADDING OFF
																		IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailet_properties]') AND type in (N'U'))
																		BEGIN
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.smtp.host', N'localhost')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.smtp.port', N'587')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.transport.protocol', N'smtp')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apiname', N'".DATABASE_NAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apipassword', N'".DATABASE_USERNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apiusername', N'".DATABASE_PASSWORD."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.encrypt', N'true')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.hostname', N'".first_element(explode('\\',DATABASE_HOSTNAME))."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.instance', N'".first_element(explode(',',last_element(explode('\\',DATABASE_HOSTNAME))))."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailname', N'".MAIL_DATABASE_NAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailpassword', N'".DATABASE_USERNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailusername', N'".DATABASE_PASSWORD."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.port', N'1433')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webname', N'direct')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webpassword', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webusername', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.domain', N'".DIRECT_DOMAIN."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.folder', N'/u01/app/james-2.3.2/store/')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.keypass', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.keystore', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.private', N'1')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.public', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.refresh', N'5')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.storepass', N'')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.api', N'dc=api')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.domain', N'".str_replace('dc=api','',LDAP_BASE_RDN)."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.host', N'".LDAP_HOSTNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.password', N'".LDAP_ANON_ADMIN_PASSWORD."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.port', N'".LDAP_PORT."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.protocol', N'".((LDAP_PORT === '636') ? 'ldaps' : 'ldap')."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.user_dn', N'".LDAP_ANON_ADMIN_USERNAME."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.notification.sender', N'notifications@".DIRECT_DOMAIN."')
																		INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.supportEmail', N'austinhelpdesk.domain')
																		END
																		",
									),
								);
		$this->databases = array(DATABASE_NAME => $this->database_schema, MAIL_DATABASE_NAME => $this->mail_database_schema, 'nhindconfig' => $this->nhindconfig_database_schema);
		$api_dn = ldap_explode_dn(LDAP_BASE_RDN, 0);
		unset($api_dn['count']);
		unset($api_dn[0]);
		$this->ldap_base_domain = implode(',',$api_dn);
		$this->ldap_schema = array(
								LDAP_BASE_RDN => array('objectClass' => array('dcObject','organization','top'),'dc'=>'api','o'=>'nodomain'),
								'ou=admin_api_apps,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames', 'cn' => 'Admin API Enabled Applications', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'admin_api_apps'),
								'ou=api_admins,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames', 'cn' => 'API Admins', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'api_admins'),
								'ou=direct_api_apps,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames', 'cn' => 'Direct API Enabled Applications', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'direct_api_apps'),
								'ou=disclosure_api_apps,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames', 'cn' => 'Disclosure API Enabled Applications', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'disclosure_api_apps'),
								'ou=disabled_accounts,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'disabled_accounts'),
								'ou=disabled_applications,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'disabled_applications'),
								'ou=disabled_groups,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'disabled_groups'),
								'ou=accounts,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'accounts'),
								'ou=applications,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'applications'),
								'ou=groups,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'groups'),
								'ou=roles,'.LDAP_BASE_RDN => array('objectClass' => array('organizationalUnit','top'), 'ou' => 'roles'),
								'ou=facilityleader,ou=roles,'.LDAP_BASE_RDN =>  array('objectClass' => 'groupOfNames','cn' => 'Facility Leader', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'facilityleader'),
								'ou=groupleader,ou=roles,'.LDAP_BASE_RDN => array('objectClass' => 'groupOfNames','cn' => 'Group Leader', 'member' => 'cn=admin,'.$this->ldap_base_domain, 'ou' => 'groupleader'),
							);
	}
	
	public function index() {
		$this->load_install_view();
	}
	public function ldap() {
		$this->load_install_view('ldap');
	}
	public function database() {
		$this->load_install_view('database');
	}
	public function create_user() {
		$this->load_install_view('create_user');
	}
	public function create_application() {
		$this->load_install_view('create_application');
	}
	
	public function create_db($database = DATABASE_NAME) {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$query = $this->database_queries['create_'.$database];
			$stmt = sqlsrv_query($conn, $query);
			$errors = array();
			if($stmt) {
				//check the entire query for errors, since it has multiple parts
				while(!is_null(sqlsrv_next_result($stmt))) {
					$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
					if(is_array($sql_errors)) {
						foreach($sql_errors as $error) {
							array_push($errors, $error);
						}
					}
				}
			}
			else { $errors = sqlsrv_errors(SQLSRV_ERR_ERRORS); }
			$this->session->set_flashdata('create_db_errors', $errors);
		}
		if($conn && $stmt && empty($errors)) {
			foreach($this->databases[$database] as $table => $columns) {
				$this->_create_db_table($table, $database);
			}
		}
		redirect('install/database');
	}
	
	public function create_db_table($table, $database = DATABASE_NAME) {
		$this->_create_db_table($table, $database);
		redirect('install/database');
	}
	
	public function encrypt_db($database = MAIL_DATABASE_NAME) {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		$key = $this->input->post('en_key');
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$query = $this->database_queries['encrypt_'.$database];
			$query = str_replace($this->config->item('encryption_key'), $key, $query);
			$stmt = sqlsrv_query($conn, $query);
			$errors = array();
			if($stmt) {
				//check the entire query for errors, since it has multiple parts
				while(!is_null(sqlsrv_next_result($stmt))) {
					$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
					if(is_array($sql_errors)) {
						foreach($sql_errors as $error) {
							array_push($errors, $error);
						}
					}
				}
			}
			else { $errors = sqlsrv_errors(SQLSRV_ERR_ERRORS); }
			$this->session->set_flashdata('encrypt_db_errors', $errors);
		}
		redirect('install/database');
	}
	
	public function regenerate_passwords(){
		$this->load->database();
		$query = $this->db->get('users');
		if($query){
			$users = $query->result();
			echo "<h3>Regenerate Passwords</h3>";
			foreach ($users as $user){
	
				$uid = $user->username;
				$ep = $this->random_password();
	
				echo "$uid: ";
				if($this->is_ascii($ep)){
					echo "Updating Database";
					$query = $this->db->query("UPDATE users SET user_ep=".$this->db->escape($this->encrypt->encode($ep))." WHERE username=" . $this->db->escape($uid));
					echo "...";
					if($query) {
						echo '<span style="color:green">OK</span>';
						echo '...Updating LDAP...';
						$ldap_conn = $this->prepare_ldap_conn();
						$ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
						if($ldap_bind) {
							$dn = 'uid='.$uid.','.LDAP_ACCOUNT_GROUP;
							if($this->ldap_entry_exists($ldap_conn, $dn)) {
								$success = ldap_modify($ldap_conn, $dn, array('userPassword' => $this->encrypt->ssha256_encode($ep)));
								if($success) {
									echo '<span style="color:green">OK</span>';
								}
								else {
									echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
								}
							}
							else {
								echo '<span style="color:red">Error: Unable to locate LDAP account</span>';
							}
						}
						else {
							echo '<span style="color:red">Error: Unable to bind to LDAP</span>';
						}
					}
					else {
						echo '<span style="color:red">Error: Unable to find user in database</span>';
					}	
				}
				echo "<br/>";
			}
		}
		else{
			echo "Could not get users";
		}
		echo '<br/><a href="/install/regenerate_passwords">Refresh</a>';
		echo '<br/><a href="/install">Back</a>';
	}
	
	private function _create_db_table($table, $database) {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		if(array_key_exists($table, $this->databases[$database])) {
			$conn = sqlsrv_connect($this->database_servername, $this->database_config);
			if($conn) {
				$query = $this->database_table_queries[$database]['create_'.$table];
				$stmt = sqlsrv_query($conn, $query);
				$errors = array();
				if($stmt) {
					//check the entire query for errors, since it has multiple parts
					while(!is_null(sqlsrv_next_result($stmt))) {
						$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
						if(is_array($sql_errors)) {
							foreach($sql_errors as $error) {
								array_push($errors, $error);
							}
						}
					}
					
				}
				else {
					$errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
				}
				//if we found errors
				if(!empty($errors)) {
					$this->session->set_flashdata($table.'_errors',$errors);
					$this->session->set_flashdata($table.'_query',$query);
				}
			}
			else {
				$this->session->set_flashdata($table.'_errors',sqlsrv_errors());
				$this->session->set_flashdata($table.'_query',$query);
			}
		}
		else {
			$this->session->set_flashdata($table.'_errors','This table does not exist in the configured schema.');
			$this->session->set_flashdata($table.'_query',$query);
		}
	}
	
	private function load_install_view($page = 'database') {
		$this->load->helper('form_helper');
		$this->output->append_output('
			<!doctype html>
			<html>
				<head>
					<title>'.$this->title.'</title>
				</head>
				<body>
					<div class="wrapper">
						<div class="nav">
							<a href="/install/database">Database</a>
							<a href="/install/ldap">LDAP</a>
							<a href="/install/create_user">Create User</a>
							<a href="/install/create_application">Create Application</a>
							<a href="/install/utf8_conversion">UTF8 Conversion</a>
							<a href="/install/regenerate_passwords">Regenerate Passwords</a>
							<a href="/install/populate_patients_for_messages">Populate Patients</a>
						</div>
						<div>
		');
		if($page === 'database') { 
			$this->output->append_output('<h2>Database</h2>');
			foreach($this->databases as $database => $schema) {
				$this->output->append_output($this->db_configuration_table($database));
			}
		}
		else if($page === 'ldap') {
			$this->output->append_output('<h2>LDAP</h2>');
			$this->output->append_output($this->ldap_configuration_table());
		}
		else if($page === 'create_user'){
			$this->output->append_output('<h2>Create User</h2>');
			$this->output->append_output($this->create_user_form());
		}
		else if($page === 'create_application'){
			$this->output->append_output('<h2>Create Application</h2>');
			$this->output->append_output($this->create_application_form());
		}
		else if($page === 'utf8_conversion'){
			$this->utf8_conversion();
		}
		$this->output->append_output('
						</div>
					</div>
				</body>
			</html>
		');
	}
	private function create_user_form() {
		$output = '';
		$this->load->helper('form');
		$output .= form_open('install/create_user_submit');
		$output .= '<table>';
		$output .= '<tr><td>'.form_label('Username','username').'</td>';
		$output .= '<td>'.form_input(array('id'=>'username','name'=>'username')).'</td>';
		$output .= '<td>'.form_label('ID','user_id').'</td>';
		$output .= '<td>'.form_input(array('id'=>'user_id','name'=>'user_id')).'</td></tr>';
		$output .= '<tr><td>'.form_label('First Name','first_name').'</td>';
		$output .= '<td>'.form_input(array('id'=>'first_name','name'=>'first_name')).'</td>';
		$output .= '<td>'.form_label('Last Name','last_name').'</td>';
		$output .= '<td>'.form_input(array('id'=>'last_name','name'=>'last_name')).'</td></tr>';
		$output .= '<tr><td>'.form_label('Middle Name','middle_name').'</td>';
		$output .= '<td>'.form_input(array('id'=>'middle_name','name'=>'middle_name')).'</td>';
		$output .= '<td>'.form_label('Email Address','user_email').'</td>';
		$output .= '<td>'.form_input(array('id'=>'user_email','name'=>'user_email')).'</td></tr>';
		$output .= '</table>';
		$output .= form_submit('create_user_submit','Create User');
		$output .= form_close();
		$this->change_database('api');
		$this->load->model('usersmodel');
		$users = $this->usersmodel->get_users();
		$output .= '<table border="1" style="border-collapse:collapse;">';
		$output .= '<tr><th>Database ID</th><th>Username</th><th>Org ID</th></tr>';
		foreach ($users as $user){
			$output .= '<tr><td>'.$user->user_id.'</td><td>'.$user->username.'</td><td>'.$user->user_org_id.'</td></tr>';
		}
		return $output;
	}
	private function create_application_form() {
		$output = '';
		$this->load->helper('form');
		$output .= form_open('install/create_application_submit');
		$output .= '<table>';
		$output .= '<tr><td>'.form_label('Name','name').'</td>';
		$output .= '<td>'.form_input(array('id'=>'name','name'=>'name')).'</td>';
		$output .= '<td>'.form_label('URL','url').'</td>';
		$output .= '<td>'.form_input(array('id'=>'url','name'=>'url')).'</td></tr>';
		$output .= '<tr><td>'.form_label('Description','description').'</td>';
		$output .= '<td colspan="3">'.form_input(array('id'=>'description','name'=>'description','style'=>'width:99%')).'</td></tr>';
		$output .= '<tr><td>'.form_label('Justification','just').'</td>';
		$output .= '<td colspan="3">'.form_input(array('id'=>'just','name'=>'just','style'=>'width:99%')).'</td></tr>';
		$output .= '<tr><td>'.form_label('POC Name','poc_name').'</td>';
		$output .= '<td>'.form_input(array('id'=>'poc_name','name'=>'poc_name')).'</td>';
		$output .= '<td>'.form_label('POC Email','poc_email').'</td>';
		$output .= '<td>'.form_input(array('id'=>'poc_email','name'=>'poc_email')).'</td></tr>';
		$output .= '<tr><td>'.form_label('POC Phone','poc_phone').'</td>';
		$output .= '<td>'.form_input(array('id'=>'poc_phone','name'=>'poc_phone')).'</td>';
		$output .= '<td>'.form_label('Admin DB ID','uid').'</td>';
		$output .= '<td>'.form_input(array('id'=>'uid','name'=>'uid')).'</td></tr>';
		$output .= '</table>';
		$output .= form_submit('create_application_submit','Create Application');
		$output .= form_close();
		$this->change_database('api');
		$this->load->model('applicationmodel');
		$applications = $this->applicationmodel->get_applications();
		if($applications){
			$applications = $applications->result();
			$output .= '<table border="1" style="border-collapse:collapse;">';
			$output .= '<tr><th>ID</th><th>Name</th><th>Public Key</th><th>Private Key</th></tr>';
			foreach ($applications as $application){
				$output .= '<tr style="white-space: nowrap;"><td>'.$application->id.'</td><td>'.$application->name.'</td><td>'.$application->public_key.'</td><td>'.$application->private_key.'</td></tr>';
			}
		}
		
		return $output;
	}
	public function create_application_submit() {
		$name = $this->input->post('name', TRUE);
		$url = $this->input->post('url', TRUE);
		$desc = $this->input->post('description', TRUE);
		$just = $this->input->post('just', TRUE);
		$poc_name = $this->input->post('poc_name', TRUE);
		$poc_email = $this->input->post('poc_email', TRUE);
		$poc_phone = $this->input->post('poc_phone', TRUE);
		$uid = $this->input->post('uid', TRUE);
		$this->load->model('applicationmodel');
		$this->load->model('applicationrequestmodel');
		$public = hash('sha256', openssl_random_pseudo_bytes(32));
		$private = hash('sha256', openssl_random_pseudo_bytes(32));
		$this->applicationrequestmodel->create_request($name, $uid, $url, $desc, $just, $poc_name, $poc_email, $poc_phone);
		$ids = $this->applicationrequestmodel->get_ids($name);
		if($ids){
			$ids = $ids->result();
			$this->applicationrequestmodel->approve_request($ids[0]->id);
			if($this->applicationmodel->create_application($public, $private, $name, $uid, $url, $desc, $poc_name, $poc_email, $poc_phone, $ids[0]->id)){
				$id = $this->applicationmodel->get_application_id_by_name($name);
				if($id){
					$ldap_conn = $this->prepare_ldap_conn();
					$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
					ldap_mod_add($ldap_conn,LDAP_ADMIN_API_PERMISSIONS_GROUP,array('member' => $this->applicationmodel->get_dn_from_app_id($id)));
					$this->session->set_flashdata('messages','Successfully created application.');
				}else{
					$this->session->set_flashdata('errors','Failed to get application id.');
				}
			}
			else {
				$this->session->set_flashdata('errors','Failed to create application.');
			}
		}
		else{
			$this->session->set_flashdata('errors','Failed to create application.');
		}
		redirect('install/create_application');
	}
	public function create_user_submit() {
		$username = $this->input->post('username', TRUE);
		$id = $this->input->post('user_id', TRUE);
		$first = $this->input->post('first_name', TRUE);
		$last = $this->input->post('last_name', TRUE);
		$middle = $this->input->post('middle_name', TRUE);
		$mail = $this->input->post('user_email', TRUE);
		$this->load->model('usersmodel');
		$ldap_attributes = array(
				'givenName' => $first,
				'sn' => $last,
				'cn' => $first.' '.$last,
		);
		if(!empty($middle)) {
			$ldap_attributes['initials'] = $middle;
			$ldap_attributes['displayName'] = $last.', '.$first.' '.$middle;
		}
		$default_ldap_attributes = array( 'objectClass' => array('posixAccount', 'top', 'person', 'organizationalPerson', 'inetOrgPerson'),
				'gidNumber' => '5000',
				'uidNumber' => '5000',
				'cn' => $ldap_attributes['givenName'].' '.$ldap_attributes['sn']); //uid, homeidrectory, & mail will be added once we've successfully saved the user
		$ldap_attributes = array_merge($ldap_attributes, $default_ldap_attributes);
		if(!array_key_exists('displayName', $ldap_attributes))
			$ldap_attributes['displayName'] = $ldap_attributes['sn'].', '.$ldap_attributes['givenName'];
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if(!$ldap_bind)	return $this->error->warning("I couldn't create user ".$this->error->describe($username)." because I couldn't connect to LDAP; please check your config file");
		
		//create the user, now that we know we have the right set-up
		$this->load->library('encrypt');
		$password = $this->random_password();
		$ldap_attributes['userPassword'] = $this->ssha256_encode($password);
		$this->change_database('api');
		$user = User::create( array('username' => $username,
				'user_org_id' => $id,
				'user_ext_mail' => $mail,
				'user_ep' => $this->encrypt->encode($password)));
		
		if(!User::is_an_entity($user)){ //the User class will trigger an error as needed.  Mailbox creation/cleanup will be handled by the User class as needed.
			$this->session->set_flashdata('errors', 'Could not create user');
			return false;
		}
		//set up the remainder of our ldap_attributes
		$ldap_attributes['uid'] = $user->username;
		$ldap_attributes['homeDirectory'] = '/var/mailboxes/'.$user->username;
		$ldap_attributes['mail'] = $user->mailbox->email_address();
		
		$success = ldap_add($ldap_conn, $this->usersmodel->get_dn_from_username($username),$ldap_attributes);
		if(!$success){
			$this->session->set_flashdata('errors', 'Could not create LDAP entry for '.$user->describe());
			if(!User::delete($user->id)) $this->error->warning('Could not remove '.$user->describe().' from the database; please manually remove the user and mailbox entries from the database as needed.');
		}
		else{
			$this->load->model('accountrequestmodel');
			$this->accountrequestmodel->create_request($first, $middle, $last, $mail, null, null, null, null, null, null , null, $id);
			$r_id=$this->accountrequestmodel->get_ids($id);
			if($r_id){
				$r_id = $r_id->result();
				$this->accountrequestmodel->approve_request($r_id[0]->id);
			}
			$this->usersmodel->change_group_membership('add',$user->id,"API Admins");
			$this->session->set_flashdata('messages','Successfully created user with id $user->id().');
		}
		
		
		
		redirect('install/create_user');
	}
	
	private function ldap_configuration_table() {
		$this->load->helper('form');
		$output = '';
		$ldap_dns = array();
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = @ldap_list($ldap_conn, $base_dn, '(objectClass=*)');
			$result = @ldap_get_entries($ldap_conn, $search);
			$output .= '<table style="border: solid black 1px;">';
			$output .= '<tr><th>Required LDAP Schema</th><th>Status</th></tr>';
			foreach($this->ldap_schema as $dn => $values) {
				if($this->ldap_entry_exists($ldap_conn, $dn)) {
					$output .= '<tr><td style="color: green;">'.$dn.'<td><td style="color: green;">&#x2714;</td></tr>';
				}
				else { $output .= '<tr><td style="color: red;">'.$dn.'<td><td style="color: red;">&#x2717;</td><td>'.form_open('/install/create_ldap_entry/'.rawurlencode(base64_encode($dn))).form_submit('create','Create').form_close().'</td></tr>'; }
			}
			$output .= '</table>';
		}
		else { $output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.ldap_error($ldap_conn).'</div>'; }
		return $output;
	}
	
	private function load_ldap_view() {
		$this->output->append_output('<div>');
		$this->output->append_output('<h2>LDAP</h2>');
		$ldap_status = $this->check_ldap_configuration();
		if($ldap_status['status'] === FALSE) {
			$this->output->append_output('<div>'.$ldap_status['message'].'</div>');
			$this->output->append_output(form_open('/install/create_ldap'));
			$this->output->append_output('<div class="form" style="float: none;">');
			$this->output->append_output('<label for="sa_name">LDAP admin password</label><input type="password" id="ldap_pwd" name="ldap_pwd" /><br /><br />');
			$this->output->append_output('</div>');
			$this->output->append_output('<div class="center"><input type="submit" value="Create LDAP Entry"/></div>');
			$this->output->append_output(form_close());
		}
		else{
			$this->output->append_output('<h2>LDAP <span style="color: green;">&#x2713;</span></h2>');
		}
		$this->output->append_output('</div>');
	}
	
	private function _db_connects() {
		$connects = FALSE;
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) { 
			$connects = TRUE; 
			sqlsrv_close($conn);
		}
		else {
			if(sqlsrv_errors()) {
				$this->session->set_flashdata('db_connects_errors', sqlsrv_errors());
			}
		}
		return $connects;
	}
	
	private function _db_exists($database = DATABASE_NAME) {
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$db_exist_query = "SELECT name FROM master.sys.databases WHERE name = N'".$database."'";
			$stmt = sqlsrv_query($conn, $db_exist_query, array(), array('Scrollable'=>'buffered'));
			if($stmt) {
				$num_rows = sqlsrv_num_rows($stmt);
				if($num_rows && ($num_rows > 0)) { return TRUE; }
				//db does not exist yet, or possibly we don't have permissions to see it
				else { return FALSE; }
			}
			else {
				$errors = array();
				foreach(sqlsrv_errors() as $error) {
					array_push($errors, $error);
				}
				$this->session->set_flashdata('db_exists_errors', $errors);
			}
		}
		return FALSE;
	}
	
	private function _db_permissions_set($database = DATABASE_NAME, $user = DATABASE_USERNAME, $permissions = NULL) {
		//if permissions to check are not provided by the function call, set them from defaults
		$required_permissions = empty($permissions) ? $this->db_required_permissions : $permissions;
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$permission_query = "USE [".$database."]; EXEC sp_helprolemember";
			$stmt = sqlsrv_query($conn, $permission_query);
			if($stmt) {
				do {
					while($row = sqlsrv_fetch_array($stmt)) {
						if($row['MemberName'] === $user) {
							if(array_key_exists($row['DbRole'], $required_permissions)) {
								$required_permissions[$row['DbRole']] = TRUE;
							}
						}
					}
				}
				while(sqlsrv_next_result($stmt));
			}
			else {
				$this->session->set_flashdata('db_permissions_set_errors', sqlsrv_errors());
			}
		}
		//if permissions are missing, set which ones are missing in flashdata to display
		if((in_array(FALSE, $required_permissions))) {
			$missing_permissions = array();
			foreach($required_permissions as $key => $permission) {
				if(!$permission) { array_push($missing_permissions, $key); }
			}
			$this->session->set_flashdata('db_permissions_missing', $missing_permissions);
		}
		return !(in_array(FALSE, $required_permissions));
	}
	
	private function _db_encrypted($database = MAIL_DATABASE_NAME) {
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$db_encrypted_query = "SELECT sys.databases.name, sys.dm_database_encryption_keys.database_id, encryption_state  FROM sys.dm_database_encryption_keys JOIN sys.databases ON (sys.dm_database_encryption_keys.database_id = sys.databases.database_id) WHERE sys.dm_database_encryption_keys.encryption_state = 3 AND sys.databases.name = '".$database."'";
			$stmt = sqlsrv_query($conn, $db_encrypted_query, array(), array('Scrollable'=>'buffered'));
			if($stmt) {
				$num_rows = sqlsrv_num_rows($stmt);
				if($num_rows && ($num_rows > 0)) { return TRUE; }
				//db is not encrypted yet, or possibly we don't have permissions to see if it is
				else { return FALSE; }
			}
			else {
				$errors = array();
				foreach(sqlsrv_errors() as $error) {
					array_push($errors, $error);
				}
				$this->session->set_flashdata('db_encrypted_errors', $errors);
			}
		}
		return FALSE;
	}
	
	public function db_configuration_table($database = DATABASE_NAME) {
		$this->load->helper('form');
		$output = '';
		//check database permissions / connection / database existence
		$db_connected = $this->_db_connects();
		$db_exists = $this->_db_exists($database);
		$db_encrypted = $this->_db_encrypted($database);
		$permissions_set = $this->_db_permissions_set($database);
		
		$output .= '<h3>'.$database.'</h3>';
		//if connection calls fails
		if(!$db_connected) {
			$errors = $this->session->flashdata('db_connects_errors');
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						//orig. code looking for the entire message within a substring of the message - I'm assuming this was a mistake -- MG 2014-05-21
						if(string_contains('is not able to access the database "master" under the current security context', $error['message'])) { $permission_issue = TRUE; }
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			//if errors are missing (and there had to be some if we are here), flashdata is full
			else {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">Connection errors encountered. Refresh page for more details.</div>';
			}
			//if there is a permissions error with the master db, we can't do anything really, give all the 
			//queries necessary to set up the database as raw text for manual set-up
			if(isset($permission_issue) && $permission_issue) {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">
							A permissions issue is preventing retrieval of information from the master database that will allow this script to determine if the required database, tables, and permissions
							exist for the configured user. This is most likely due to security restrictions that have been purposefully set in place. 
							However, it is not possible for this script to proceed with automated set-up of the database. The queries required to set up
							the database have been provided below for a database administrator to set up manually.
							</div>';
				$output .= '<h3>Create required databases</h3>';
				foreach($this->database_queries as $key => $query) {
					if(string_contains($key, 'create')) {
						$output .= '<pre>'.preg_replace('/[\t]+/',' ',$query).'</pre>';
					}
				}
				$output .= '<h3>Create required tables</h3>';
				foreach($this->database_table_queries[$database] as $key => $query) {
					if(string_contains($key, 'create')) {
						$output .= '<pre>'.preg_replace('/[\t]+/',' ',$query).'</pre>';
					}
				}
			}
		}
		//if db existence call fails
		if($db_connected && !$db_exists) {
			$errors = $this->session->flashdata('db_exists_errors') ? $this->session->flashdata('db_exists_errors') : array();
			$create_errors = $this->session->flashdata('create_db_errors') ? $this->session->flashdata('create_db_errors') : array();
			$errors = array_merge($errors, $create_errors);
			$errors = empty($errors) ? FALSE : $errors;
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						//orig. code was looking for the error message in 'permission_denied', figured that was a mistake -- MG 2014-05-20
						if(string_contains('permission_denied', mb_strtolower($error['message']))) {
							$permissions_issue = TRUE;
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			//if there was a permissions issue when creating the database, allow user to try other credentials
			if(isset($permissions_issue) && $permissions_issue) {
				$output .= form_open('install/create_db/'.$database)
							.form_label('Privileged SQL User: ','sa_name')
							.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
							.form_label('Privileged SQL User Password: ','sa_pwd')
							.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
							.form_submit('create_db','Create Database')
							.form_close();
				$output .= '<div>To manually create database <span style="font-weight: bold;">'.$database.'</span> run the following query: <br />';
				$output .= '<pre>'.preg_replace('/[\t]+/',' ',$this->database_queries['create_'.$database]).'</pre></div>';
			}
			else {
				$output .= form_open('install/create_db/'.$database).form_submit('create_db','Create Database').form_close();
			}
		}
		//if the database server connects, we know the database exists, but the permissions the configured user has
		//aren't configured correctly
		if($db_connected && $db_exists && !$permissions_set) {
			$errors = $this->session->flashdata('db_permissions_set_errors');
			$missing_permissions = $this->session->flashdata('db_permissions_missing');
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						//orig. code looking for the entire message within a substring of the message - I'm assuming this was a mistake -- MG 2014-05-21
						if(string_contains('not able to access database "'.$database.'"',$error['message'])) {
							$add_user_query = 'USE ['.$database.']; CREATE USER ['.DATABASE_USERNAME.'] FROM LOGIN ['.DATABASE_USERNAME.'] WITH DEFAULT_SCHEMA=[dbo];';
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
						if(isset($add_user_query)) {
							$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'
										.'An error has been detected that may indicate the configured user login has not yet been added to the ' . DATABASE_NAME . ' as a user. '
										.'Use the following query to add the configured login user to the database: <br/>'
										.'<pre>'.$add_user_query.'</pre>'
										.'</div>';
						}
					}
				}
			}
			//if errors are missing (and there had to be some if we are here), flashdata is full
			else {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">Permissions errors encountered. Refresh page for more details.</div>';
			}
			if(!empty($missing_permissions) && $missing_permissions) {
				foreach($missing_permissions as $permission) {
					$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">
								The configured user: '.DATABASE_USERNAME.' is missing the '.$permission.' role.
								Use the following query to grant the required role to this user:<br/>
								<pre>USE ['.$database.']; EXEC sp_addrolemember \'db_datareader\', \''.DATABASE_USERNAME.'\';</pre>
								</div>';
				}
			}
		}
		
		if($database === MAIL_DATABASE_NAME && !$db_encrypted) {
			$errors = $this->session->flashdata('db_encrypted_errors') ? $this->session->flashdata('db_encrypted_errors') : array();
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						//orig. code was looking for the error message in 'permission_denied', figured that was a mistake -- MG 2014-05-20
						if(string_contains('permission_denied', mb_strtolower($error['message']))) { 
							$permissions_issue = TRUE;
						}
						if(isset($permissions_issue) && $permissions_issue) {
							$output .= '<h4>Database Encryption Status: Unknown</h4>';
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			if(isset($permissions_issue) && $permissions_issue) {
				$output .= form_open('install/encrypt_db/'.$database)
							.form_label('Encryption Key','en_key')
							.form_input(array('name'=>'en_key','id'=>'en_key')).'<br/>'
							.form_label('Privileged SQL User: ','sa_name')
							.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
							.form_label('Privileged SQL User Password: ','sa_pwd')
							.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
							.form_submit('encrypt_db','Encrypt Database')
							.form_close();
			}
			else { //database is not encrypted
				$output .= '<h4>Database Encryption Status: Unknown / Not Encrypted</h4>';
				$output .= form_open('install/encrypt_db/'.$database)
						.form_label('Encryption Key','en_key')
						.form_input(array('name'=>'en_key','id'=>'en_key')).'<br/>'
						.form_submit('encrypt_db','Encrypt Database')
						.form_close();
			}
		}
		else if($database === MAIL_DATABASE_NAME && $db_encrypted){
			$output .= '<h4>Database Encryption Status: Encrypted</h4>';
		}
		
		//if the database already exists, and the configured user has permissions needed for running the app 
		//NOTE: permissions checking checks roles only, not all permissions, user may still not be able to create tables
		if($db_connected && $db_exists && $permissions_set) {
			$this->change_database($database);
			foreach($this->databases[$database] as $table => $columns) {
				$errors = $this->session->flashdata($table.'_errors');
				$query = $this->session->flashdata($table.'_query');
				if($errors) {
					if(is_array($errors)) {
						foreach($errors as $error) {
							$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
						}
					}
				}
				//TABLE START
				$output .= '<table style="border: solid black 1px; border-collapse: collapse; margin-right: 15px; margin-bottom: 15px; width: 400px;">';
				
				$tbl_check_query = 'SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE='.$this->db->escape('BASE TABLE').' AND TABLE_NAME='.$this->db->escape($table);
				$tbl_check = $this->db->query($tbl_check_query);
				//query to check table existence works
				if($tbl_check) {
					//if the table does not exist
					if($tbl_check->num_rows() <= 0) {
						//check for errors from a previously run query
						if(isset($errors) && (is_array($errors) || is_object($errors)) && $errors) {
							$permission_issue = FALSE;
							foreach($errors as $error) {
								//orig. code looking for the entire message within a substring of the message - I'm assuming this was a mistake -- MG 2014-05-21
								if(string_contains('permission denied', $error['message'])) { $permission_issue = TRUE; }
							}
							//if there was a permissions issue, offer a way to enter better credentials
							if($permission_issue) {
								$output .= '<tr><td>A permissions issue was detected with the query, if more privileged credentials are available, enter them below.'
												.form_open('install/create_db_table/'.$table.'/'.$database)
												.form_label('Privileged SQL User: ','sa_name')
												.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
												.form_label('Privileged SQL User Password: ','sa_pwd')
												.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
												.form_submit('create_'.$table,'Create '.$table)
												.form_close().'</td></tr>';
							}
							//but also give the query to run manually through SQL Management Studio
							//should pull query from flashdata if possible to ensure it is the right one, but if that isn't possible use the hardcoded one for create table
							if(!isset($query) || !$query) {
								$query = $this->database_table_queries[$database]['create_'.$table];
							}
							$output .= '<tr><td>To manually create table <span style="font-weight: bold;">' . $table . '</span> table use the following query:</td></tr>';
							$output .= '<tr><td><pre style="background: #eee; width: 1000px; word-wrap: break-word;">' . preg_replace('/[\t]+/',' ',$query) . '</pre></td></tr>';
						}
						else {
							$output .= '<tr><th title="'.$table.' does not exist" style="color: red;">' . $table . '</th></tr>';
							$output .= '<tr><td style="text-align: center;">'.form_open('install/create_db_table/'.$table.'/'.$database).form_submit('create_'.$table,'Create '.$table).form_close().'</td></tr>';
						}
					}
					//if it does exist
					else {
						$output .= '<tr><th style="color: green;">' . $table . '</th><th>Status</th></tr>';
						foreach($columns as $column => $type) {
							$col_check_query = 'SELECT * FROM sys.columns WHERE [name] = '.$this->db->escape($column).' AND object_id = OBJECT_ID('.$this->db->escape($table).')';
							$col_check = $this->db->query($col_check_query);
							if($col_check) {
								$output .= '<tr>';
								if($col_check->num_rows() <= 0) {
									$output .= '<td style="color: red;">'.$column.' ['.$type.']</td>';
									$output .= '<td style="color: red; text-align: center;">&#x2717;</td>';
								}
								else {
									$output .= '<td style="color: green;">'.$column.' ['.$type.']</td>';
									$data_type_query = 'SELECT DATA_TYPE, CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS IC WHERE TABLE_NAME='.$this->db->escape($table).' AND COLUMN_NAME='.$this->db->escape($column);
									$data_type_check = $this->db->query($data_type_query);
									if($data_type_check) {
										if($col_check->num_rows() <= 0) {
										
										}
										else {
											$result = $data_type_check->result_array(0);
											$data_type = $result[0]['DATA_TYPE'];
											$max_length = ($result[0]['CHARACTER_MAXIMUM_LENGTH'] === -1) ? 'max' : $result[0]['CHARACTER_MAXIMUM_LENGTH'];
											if($data_type === $type || $data_type.'('.$max_length.')' === $type) {
												$output .= '<td style="color: green; text-align: center;">&#x2713;</td>';
											}
											else {
												$fix_col_query = 'ALTER TABLE '.$table.' ALTER COLUMN '.$column.' '.$type;
												$output .= '<td title="Data Type Mismatch. Click for alter column query." onclick="alert(&quot;'.$fix_col_query.'&quot;);" style="text-align: center; background: #fee; border: solid #f00 1px;"><span style="color: red;">&#x2717;</span></td>';
											}
										}
									}
								}
							}
							else { 
								$output .= '<td style="color: gold;">'.$column.' ['.$type.']</td>';
								$output .= '<td title="Click for manual column existence check query." onclick="alert(&quot;'.$col_check_query.'&quot;);" style="text-align: center; cursor: pointer;"><span style="color: gold;">&#x26a0;</span> Query Failed</td>'; 
							}
							$output .= '</tr>';
						}
					}
				}
				//if query fails, may not have the proper permissions
				else {
					$output .= '<tr><th style="color: gold; text-align: center;">&#x26a0; Database Check Failed</th></tr>';
					$output .= '<tr><td>Manually execute query below to check existence of <span style="font-weight: bold;">'.$table.'</span> table:</td></tr>';
					$output .= '<tr><td><pre>'.$tbl_check_query.'</pre></td></tr>';
				}
				//TABLE END
				$output .= '</table>';
			}
		}
		return $output;
	}

	/**
	* Convert existing database fields that don't support UTF-8 characters to their multibyte equivalents (varchar to nvarchar, char to nchar, etc).
	* This script is safe to run more than once.  Note that the script will backup the database to the parent directory of the website; if this 
	* directory is web-accessible or not writeable, you should change the script location specified by $backup_path.
	*/
	function utf8_conversion(){
		$this->load->database();
		$this->load->helper('text_helper');
			
		echo '<html>
				<head>
					<title>Char and Varchar Conversio</title>
					<link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap.min.css" />
					<link rel="stylesheet" type="text/css" media="all" href="'.site_url('/css/grids.css').'" />
					<style>
						h2 {margin-top: 2em; }
						body { width: 80%; margin: 1em auto; }
						.alert-danger a, .alert-danger a:hover, .alert-danger:focus { color: #b94a48; text-decoration: underline; }
						.alert-danger table { color: #b94a48; }
						.alert-danger table th { text-align: right; }
					</style>
				</head>
				<body>';
		echo '<h1>Char and Varchar Conversion</h1>';
		
		if(empty($_POST)){
			echo '<p>This script will back up the database and convert the char, varchar, and text database fields for this application to fields that can support UTF-8 text.  Enter the database
			     admin credentials to begin.</p>';
			echo form_open();
			echo '<div class="form-group">'.form_label('Admin Username', 'sa_name').form_input('sa_name', '', 'class="form-control"').'</div>';
			echo '<div class="form-group">'.form_label('Admin Password', 'sa_pwd').form_password('sa_pwd', '', 'class="form-control"').'</div>';
			echo form_submit('submit', 'Submit', 'class="btn btn-default"');
			echo form_close().'</body><html>';
			return;	
		}
					 	
		$sa_name = $this->input->post('sa_name',TRUE);
		$sa_pwd = $this->input->post('sa_pwd',TRUE);

		$sa_db_config = array(
			'hostname' => DATABASE_HOSTNAME,
			'username' => $sa_name,
			'password' => $sa_pwd,
			'database' => 'master',
			'dbdriver' => DATABASE_DRIVER,
			'db_debug' => TRUE
		);
		$admin_db = $this->load->database($sa_db_config, TRUE);
		$queries = array();
				
		foreach(array(User::db(), Message::db()) as $db){
			echo '<h2>'.mb_strtoupper($db->database).' DATABASE</h2> ';
			$admin_db->query('USE '.$db->database);
			
			$nonsystem_tables = $db->list_tables();			
			$fields_to_alter = array(); 
			foreach(array('nchar', 'nvarchar', 'ntext') as $multibyte_type){
				$fields_to_alter[$multibyte_type] = $admin_db->query(   'SELECT OBJECT_NAME(c.OBJECT_ID) AS table_name, c.name column_name, c.is_nullable, k.name AS unique_constraint,
																				c.max_length, c.default_object_id AS constraint_id, 
																			   OBJECT_NAME(c.default_object_id) as default_constraint, OBJECT_DEFINITION(c.default_object_id) AS default_value
																		 FROM '.$db->database.'.sys.columns AS c
																		 JOIN '.$db->database.'.sys.types AS t ON c.user_type_id=t.user_type_id
																		 LEFT JOIN '.$db->database.'.sys.key_constraints AS k ON c.object_id=k.parent_object_id AND k.type=\'UQ\'
																		 WHERE t.name=\''.strip_from_beginning('n', $multibyte_type).'\' 
																			   AND OBJECT_NAME(c.object_id) IN (\''.implode("','", $nonsystem_tables).'\')
																		 ORDER BY c.OBJECT_ID;' )->result_array();
			}

			//if we don't have any fields to convert, stop before we do anything else
			if(empty(flatten_array($fields_to_alter))){
				echo '<p>There are no '.array_to_human_readable_list(array_keys($fields_to_alter), ' or ').' fields to convert for the '.$db->database.' database.</p>';
				continue;
			}
			
			//BACK UP THE DATABASE IN CASE THINGS GO TERRIBLY TERRIBLY WRONG
				
			//find a non-web-accessible place to back up the db
			$backup_path = strip_from_end('/system/', BASEPATH);
			$backup_path = mb_substr($backup_path, 0, mb_strrpos($backup_path, '/'));	
			
			//to back up the database, we need to make a temporary change to the PHP sqlsrver driver settings
			//see http://blogs.msdn.com/b/brian_swan/archive/2010/04/06/backup-and-restore-with-the-sql-server-driver-for-php.aspx for more info
			$original_config_value = ini_get('sqlsrv.WarningsReturnAsErrors');
			ini_set('sqlsrv.WarningsReturnAsErrors', 0);	
			
			echo '<h3>Backing up the '.$db->database.' database before altering column types ...</h3>';
			if(!$admin_db->query("BACKUP DATABASE [".$db->database."] TO disk='".$backup_path.'/'.$db->database.'.bak.'.strftime("%Y-%m-%d-%H-%M")."'")){
				echo '<h3>Unable to back up '.$db->database.'  Please check to make sure you have write permissions and that there is enough space on the disk.</h3>';
				return;	
			}
				
			//restore the original PHP sqlsrver driver setting before proceeding
			ini_set('sqlsrv.WarningsReturnAsErrors', $original_config_value);
			
			//MAKE THE CHANGES		
			echo '<h3>Beginning column conversions...</h3>';
			foreach($fields_to_alter as $new_type => $fields){
				foreach($fields as $field_info){
					if(in_array($field_info['table_name'], $nonsystem_tables)){
						
						echo '<h4>Changing '.$field_info['table_name'].'.'.$field_info['column_name'].' from '.strip_from_beginning('n', $new_type).' to '.$new_type.'... </h4>';
						
						$sql = '';

						//check to see if there's a unique constraint; remove the constraint if there is
						if(!empty($field_info['unique_constraint'])){
							$sql .= 'ALTER TABLE '.$db->database.'.dbo.'.$field_info['table_name'].' DROP CONSTRAINT '.$field_info['unique_constraint'].";\n";
						}

						//check to see if there's a default value; remove the constraint if there is						
						if(!empty($field_info['default_constraint']) && !empty($field_info['default_value'])){
							$sql .= 'ALTER TABLE '.$db->database.'.dbo.'.$field_info['table_name'].' DROP CONSTRAINT '.$field_info['default_constraint'].";\n";
						}
							
						$sql .= 'ALTER TABLE '.$db->database.'.dbo.'.$field_info['table_name'].' ALTER COLUMN ['.$field_info['column_name'].'] '.$new_type;
						
						if($field_info['max_length'] < 0)
							$sql .= '(max)';
						else
							$sql .= '('.$field_info['max_length'].')';
							
						if(empty($field_info['is_nullable']))
							$sql .= ' NOT NULL';
						
						$sql .= ";\n";	
						
						//add the default value back in if we had one
						if(!empty($field_info['default_value']))
							$sql .= 'ALTER TABLE '.$db->database.'.dbo.'.$field_info['table_name'].' ADD CONSTRAINT DF_'.$field_info['table_name'].'_'.$field_info['column_name'].' '.
									'DEFAULT  N'.strip_from_beginning('(', strip_from_end(')', $field_info['default_value'])).' FOR ['.$field_info['column_name'].'];';
									
						//add the unique constraint back in if we had one
						if(!empty($field_info['unique_constraint'])){
							$sql .= 'ALTER TABLE '.$db->database.'.dbo.'.$field_info['table_name'].' ADD CONSTRAINT UQ_'.$field_info['table_name'].'_'.$field_info['column_name'].' '.
									'UNIQUE NONCLUSTERED ('.$field_info['column_name'].');';
						}			
						
						$queries[] = trim($sql);
						echo '<pre class="raw-output">'.highlight_code(trim($sql)).'</pre>';
														
						if(!$admin_db->query($sql)){
							//probably there's a constraint that this script can't cope with, or if you're seeing a message saying that the row size would be greater than
							//the allowable maximum row size of 8060, try running DBCC CLEANTABLE: http://msdn.microsoft.com/en-us/library/ms174418.aspx
							echo '<div class="alert alert-danger"><strong>QUERY FAILED</strong>. You may want to run this SQL manually to see what is causing the problem.</div>';
						}
					}
				}
			} 
		}
		if(!empty($queries)){
			$full_sql = implode("\n\n", $queries);
			$sql_script_destination = $backup_path.'/utf8_conversion_queries_'.strftime("%Y-%m-%d-%H-%M").'.sql';
			$success = file_put_contents($sql_script_destination, $full_sql);
			echo '<h2>ALL QUERIES</h2>';
			if($success) echo '<p>The queries performed by this script can be found here: '.$sql_script_destination.'</p>';
			echo '<pre class="raw-output">'.highlight_code(trim($full_sql)).'</pre>';
		}
		
		echo '</body><html>';
	}
	
	function populate_patients_for_messages(){
		set_time_limit(0); //this could take a while
		
		echo '<h1>Populate Patients for Messages</h1>';		
		echo '<p>This script will repopulate the patients table with the patients from all messages.</p>';
				
		require_model('message');
		$message_count = Message::count();
		
		echo '<h2>Populating Patients for '.$message_count.' Messages</h2>';
		log_message('error', 'Populating patients for '.$message_count.' messages');
		
		for($i=0; $i < $message_count; $i){
			Message::db()->order_by('id', 'ASC')->limit(10, ($i));
			$messages = Message::find();
			foreach($messages as $message){
				$i++;
				Patient::populate_for_message($message);
			}
			echo '<p>'.$i.' of '.$message_count.' complete ...</p>';
			log_message('error', $i.' of '.$message_count.' complete');
		}
		echo '<h2>Done!</h2>';
	}
	
	public function create_ldap() {
				
	}
	
	public function create_ldap_entry($dn) {
		$dn = base64_decode(rawurldecode($dn));
		if(array_key_exists($dn, $this->ldap_schema)) {
			$this->_create_ldap_entry($dn);
		}
		redirect('install/ldap');
	}
	
	private function _create_ldap_entry($dn) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
		if($ldap_bind) {
			ldap_add($ldap_conn, $dn, $this->ldap_schema[$dn]);
		}
		else {
		
		}
	}
	
	private function ldap_entry_exists($ldap_conn,$dn) {
		$search = @ldap_search($ldap_conn, $dn, '(objectClass=*)');
		$result = @ldap_get_entries($ldap_conn,$search);
		if($result['count'] > 0) { return TRUE; }
		return FALSE;
	}
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
	/* This function generates a 32 character random string for use as a password,
	 * utilizing a mix of lower and upper case, numbers, and special characters.
	*/
	private function random_password() {
		$chars = array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","1","2","3","4","5","6","7","8","9","0","!","@","#","$","%","^","&","*","(",")","{","}","?");
		$pass = "";
		$count = count($chars);
		for($i = 0; $i < 32; $i++) {
			$pass .= $chars[abs(hexdec(bin2hex(openssl_random_pseudo_bytes(6)))%$count)];
		}
		return $pass;
	}
	/* This function encodes the given text as a salted SHA string for use in OpenLDAP.
	 */
	private function ssha256_encode($text) {
		$salt = hash('sha256', openssl_random_pseudo_bytes(32));
		$hash = "{SSHA256}".base64_encode(pack("H*",hash('sha256',$text.$salt)).$salt);
		return $hash;
	}
	private function change_database($database){
		$this->load->database();
		if($this->db->database !== $database) {
			$config['hostname'] = DATABASE_HOSTNAME;
			$config['username'] = DATABASE_USERNAME;
			$config['password'] = DATABASE_PASSWORD;
			$config['database'] = $database;
			$config['dbdriver'] = DATABASE_DRIVER;
			$config['dbprefix'] = '';
			$config['pconnect'] = FALSE;
			$config['db_debug'] = FALSE;
			$config['cache_on'] = FALSE;
			$config['cachedir'] = '';
			$config['char_set'] = 'utf8';
			$config['dbcollat'] = 'utf8_general_ci';
			$config['swap_pre'] = '';
			$config['autoinit'] = FALSE;
			$config['stricton'] = FALSE;
			$db = $this->load->database($config,TRUE);
			$this->db = $db;
		}
	}
	private function decode_md5($data) {
		$data = base64_decode($data);
		$key = md5(config_item('encryption_key'));
	
		$data = $this->encrypt->remove_cipher_noise($data,$key);
	
		$init_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC);
		if ($init_size > strlen($data))
		{
			return FALSE;
		}
		$init_vect = substr($data, 0, $init_size);
		$data = substr($data, $init_size);
		return mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $data, MCRYPT_MODE_CBC, $init_vect);
	}
	private function  is_ascii( $string = '' ) {
		$num = 0;
		while( isset( $string[$num] ) ) {
			if( ord( $string[$num] ) & 0x80 ) {
				return false;
			}
			$num++;
		}
		return true;
	}
}
