<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
require_once APPPATH.'/libraries/DaaS_REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Authorize extends DaaS_REST_Controller
{
	public function __construct(){
		parent::__construct();
		if(isset($_SERVER['HTTP_CERT'])) {
			$this->load->library(array('session','encrypt','permissions','auth'));
			$this->auth->perform_auth();
		}
	}
	
	public function request_get() {
		$app_id = $this->get('id');
		$action = $this->get('action');
		$redirect_url = $this->get('redirect_url');
		if(isset($app_id)) {
			if(isset($_SERVER['HTTP_CERT'])) { //save some time and check if the server cert was even passed at all, if not assume its from API domain and give response
				$this->load->helper('form');
				$this->load->model('applicationmodel');
				if($this->session->userdata('user_id')) { //if this has been set we know they are logged in
					$org_id = User::organization_id_from_session();
					$permissions = $this->permissions->get_user_permissions($org_id);
					$app = $this->applicationmodel->get_application($app_id);
					if($app->num_rows() === 1) {
						$app_attributes = $app->result();
						$data['app_id'] = $app_attributes[0]->id;
						$data['app_name'] = $app_attributes[0]->name;
						$data['action'] = $action;
						$data['redirect_url'] = rawurldecode($redirect_url);
						$this->load->view('api/authorize/request',$data);
					}	
				}
			}
			else {
				$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
				$is_authorized = $this->request->direct_api_authorized; //authorize request
				if($is_authenticated && $is_authorized) {
					$this->load->model('applicationmodel');
					$app_id = $this->applicationmodel->get_application_id_from_public($this->request->public_key);
					$url = 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/request/id/' . $app_id;
					if(trim($action)) { $url .= '/action/'.$action; }
					$response = array(
						'authorize_url' => $url,
					);
					$this->response($response,404);
				}
			}
		}
		else { show_404(); }
	}
	public function register_get() {
		$this->load->helper('url');
		$app_id = $this->get('id');
		$unique = $this->get('unique');
		$redirect_url = $this->get('redirect_url');
		$this->load->model('applicationaccountlinkmodel');
		$this->load->model('accountrequestmodel');
		$this->load->model('facilitymodel');
		if(isset($app_id)) {
			if(isset($_SERVER['HTTP_CERT'])) { //save some time and check if the server cert was even passed at all, if not assume its from API domain and give response
				$this->load->helper('form');
				if($this->session->userdata('user_id')) { //if this has been set we know they are logged in
					$org_id = User::organization_id_from_session();
					if(!$this->applicationaccountlinkmodel->get_request_by_unique($app_id,$unique)){
						show_404();
					}
					$this->applicationaccountlinkmodel->add_org_id($app_id, $unique,$org_id);
					$request_status = $this->accountrequestmodel->request_status($org_id);
					if($request_status === 'No Requests' || $request_status === 'Denied'){
						$data = array();
						$data['redirect'] = $redirect_url;
						$data['status'] = $request_status;
						$data['title'] = 'Account Registration';
						$data['facilities'] = $this->facilitymodel->get_facilities(true)->result();
						$data['app_name'] = $this->applicationmodel->get_application_name_by_id($app_id)->result();
						$data['justification'] = $this->accountrequestmodel->get_justification($org_id);
						$this->load->view('api/onboarding/account_request',$data);
					}
					else { redirect(rawurldecode($redirect_url)); }
				}
			}
			else {
				$this->load->model('applicationmodel');
				$this->load->model('usersmodel');
				$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
				$is_authorized = $this->request->direct_api_authorized; //authorize request
				if($is_authenticated && $is_authorized) {
					$app = $this->applicationmodel->get_application_from_public($this->request->public_key);
					if($app){ $app = first_element($app->result()); }
					else { $status = 'error'; }
					$unique_hash = hash_hmac('sha256', $unique,$app->private_key);
					$request = $this->applicationaccountlinkmodel->get_request_by_unique($app->id,$unique_hash);
					$response = array();
					if($request === false){
						if($this->applicationaccountlinkmodel->create_request($app->id, $unique_hash)){
							$status = 'Unregistered';
						}
						else { $status = 'error'; }
					}
					else{
						if($request['org_id'] === null) { $status = 'Unregistered'; }
						else{
							$request_status = $this->accountrequestmodel->request_status($request['org_id']);
							if($request_status === null) { $status = 'error'; }
							else if($request_status === 'No Requests' || $request_status === 'Denied') { $status = 'Unregistered'; }
							else{ $status = $request_status; }
						}
					}
					if($status === 'Unregistered'){
						$response['authorize_url'] = 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/register/id/' . $app->id . "/unique/" .$unique_hash;
					}
					else if($status === 'Approved'){
						$data = $this->accountrequestmodel->get_account_request_data($request['org_id']);
						if($data){
							$response['username'] = $this->usersmodel->get_username_from_org_id($request['org_id']);
							
							$permissions = $this->usersmodel->get_user_permissions($response['username']);
							if(!($permissions && isset($permissions['Application'][$app->id]) && isset($permissions['Application'][$app->id]['users']))){
								$this->usersmodel->change_group_membership('add',$this->usersmodel->get_id_from_username($response['username']) ,$app->name." Authorized Users");
							}
							
							$data_remove = array('id', 'user_org_id','request_date','approved_date','justification','denied');
							foreach ($data_remove as $remove){
								unset($data[$remove]);
							}
							$response['data']= $data;	
						}
					}
					$response['status'] = $status;
					$this->response($response, 404);
				}
			}
		}
		else { show_404(); }
	}
	public function check_registration_post(){
		$this->load->helper('url');
		$this->load->library('form_validation');
		$this->load->model('accountrequestmodel');
		$this->load->model('applicationaccountlinkmodel');
		$this->load->model('facilitymodel');
		$this->load->library(array('encrypt','session','eventlog'));
		$first = $this->input->post('first_name', TRUE);
		$middle = $this->input->post('middle_name', TRUE);
		$last = $this->input->post('last_name', TRUE);
		$ext_mail = $this->input->post('ext_mail', TRUE);
		$title = $this->input->post('account_title', TRUE);
		$department = $this->input->post('department', TRUE);
		$organization = $this->input->post('organization', TRUE);
		$telephone = $this->input->post('telephone', TRUE);
		$mobile = $this->input->post('mobile', TRUE);
		$location = $this->input->post('location', TRUE);
		$facility_id = $this->input->post('facility_select', TRUE);
		$user_org_id = User::organization_id_from_session();
		$redirect = $this->input->post('redirect', TRUE);
		$this->form_validation->set_rules('first_name','First Name','required');
		$this->form_validation->set_rules('last_name','Last Name','required');
		$this->form_validation->set_rules('ext_mail','Email','required|va_email');
		$this->form_validation->set_rules('telephone','Telehone','validate_phone');
		$this->form_validation->set_rules('mobile','Mobile','validate_phone');
		$this->form_validation->set_rules('facility_select','Facility','required|valid_facility');
		//User Permission
		$sp_sent = $this->input->post('ws7', TRUE);
		$sp_receive = $this->input->post('ws8', TRUE);
		$sp_manage = $this->input->post('ws9', TRUE);
		
		$sp_sent == 'on' ? $sp_sent = 'on' : $sp_sent = 'false';
		$sp_receive == 'on' ? $sp_receive = 'on' : $sp_receive = 'false';
		$sp_manage == 'on' ? $sp_manage = 'on' : $sp_manage = 'false';
		
		$sp_array = array('send' => $sp_sent, 'retrieve' => $sp_receive, 'manage' => $sp_manage);
		$sp_user = $this->json->encode($sp_array);
		
		$request_status = $this->accountrequestmodel->request_status($user_org_id);
		if($request_status !== 'No Requests' && $request_status !== 'Denied'){
			if($redirect !== null){
				redirect(rawurldecode($redirect));
			}
			else{
				redirect('onboarding/request');
			}
		}
		$this->applicationaccountlinkmodel->add_permission_by_id($user_org_id, $sp_user);
		$data = array('redirect' => $redirect, 'status' => $request_status);
		$data['facilities'] = $this->facilitymodel->get_facilities(true)->result();
		$data['title'] = "Account Registration";
		if($this->form_validation->run() === TRUE) {
			$user_info = $this->session->userdata('user_info');
			$username = isset($user_info['uid']) ? first_element(explode('@',$user_info['uid'])) : null;
			$create = $this->accountrequestmodel->create_request($first, $middle, $last, $ext_mail, $title, $department, $organization, $telephone, $mobile, $location, $facility_id, $user_org_id, $username);
			if($create) {
				$request_id = $this->db->insert_id();
				$this->eventlog->create_event(4, $request_id, 4, $request_id, "Requested account", time(), 1);
				if($redirect !== null){
					redirect(rawurldecode($redirect));
				}
				else{
					redirect('onboarding/request');
				}
			}
			else {
				$data['error_message'] = 'Failed to submit request.';
				$this->eventlog->create_event(4, 0, 4, 0, "Requested account", time(), 0);
				$this->load->view('api/onboarding/account_request',$data);
			}
		}
		else {
			$data['error_message'] = validation_errors();
			$data['first_name'] = $first;
			$data['middle_name'] = $middle;
			$data['last_name'] = $last;
			//$data['user_name'] = $user_name;
			$data['user_org_id'] = $user_org_id;
			$data['ext_mail'] = $ext_mail;
			$data['account_title'] = $title;
			$data['department'] = $department;
			$data['organization'] = $organization;
			$data['telephone'] = $telephone;
			$data['mobile'] = $mobile;
			$data['location'] = $location;
			$this->load->view('api/onboarding/account_request',$data);
		}
	}
	
	public function username_get(){
		$app_id = $this->get('id');
		if(isset($app_id)){
			$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
			$is_authorized = $this->request->direct_api_authorized; //authorize request
			if($is_authenticated && $is_authorized) {
				$this->load->model('applicationmodel');
				$app_id = $this->applicationmodel->get_application_id_from_public($this->request->public_key);
				$url = 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/request/id/' . $app_id;
				if(trim($action)) { $url .= 'action/'.$action; }
				$response = array(
					'authorize_url' => $url,
				);
				$this->response($response,404);
			}
		}
		show_404();
	}
	public function submit_post() {
		$this->load->library(array('session','encrypt','auth','permissions'));
		$this->load->model('applicationmodel');
		$this->load->model('usersettingsmodel');
		$this->load->model('requestmodel');
		$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
		$is_authorized = $this->request->direct_api_authorized; //authorize request
		$redirect_url = $this->post('redirect_url',TRUE);
		
		if(isset($_SERVER['HTTP_CERT']) || ($is_authenticated && $is_authorized)) {
			if($this->session->userdata('user_id')) {
				//add user settings entries
				$app_id = $this->post('app_id',TRUE);
				$web_service_name = $this->post('action',TRUE);
				$org_id = User::organization_id_from_session();
				$user_id = $this->usersmodel->get_user_id_from_org_id($org_id);
				$web_service_id = $this->usersettingsmodel->get_web_service_id_by_name($web_service_name);
				$this->usersettingsmodel->save_user_settings_entry($user_id, $app_id, $web_service_id, 'on');
			}
		}
		$app = $this->applicationmodel->get_application($app_id)->result();
		
		$this->load->helper('url');
		//check redirect URL to make sure it is under the app's domain
		$app_url = $app[0]->url;
		if(string_contains(parse_url($app_url, PHP_URL_HOST), parse_url($redirect_url, PHP_URL_HOST))) {
			redirect($redirect_url);
		}
		else {
			show_404();
		}
	}
	
	public function get_webservice_permission_get() {
		$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
		$is_authorized = $this->request->direct_api_authorized; //authorize request
		
		if($is_authenticated && $is_authorized) {
			$this->load->library(array('session','encrypt','auth'));
			$this->load->model('applicationmodel');
			$this->load->model('usersmodel');
			$this->load->model('usersettingsmodel');
			$query = $this->applicationmodel->get_application_from_public($this->request->public_key);
			$query_array = $query->row_array();
			$app_id = $query_array['id'];
			$redirect_url = $this->get('redirect_url');
			$mailbox_name = $this->get('mailbox_name');
			$is_group = $this->get('is_group');
			$response = array(
					'permission_url' => 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/edit_webservice_permission/id/' . $app_id . '/mailbox_name/' . $mailbox_name . '/is_group/' . $is_group . '/redirect_url/' . $redirect_url,
			);
			$this->response($response,200);
		}
	}
	
	public function edit_webservice_permission_get() {
		$app_id = $this->get('id');
		if(!$this->is->nonzero_unsigned_integer($app_id)) show_404();

		$address = $this->get('address');
		$redirect_url = base64_decode(rawurldecode($this->get('redirect_url')));
		if(isset($_SERVER['HTTP_CERT'])) { //save some time and check if the server cert was even passed at all, if not assume its from API domain and give response
			if($this->session->userdata('user_id')) { //if this has been set we know they are logged in
				$this->load->model('applicationmodel');
				$this->load->model('usersettingsmodel');
				
				$user = User::find_from_session(); //fewer db queries than looking up org id, then user id, then username
				
				$mailbox_name = $this->get('mailbox_name');
				$is_group = $this->get('is_group');
				$data = compact('user', 'mailbox_group');
				
				$app = $this->applicationmodel->get_application($app_id);
				$app_attributes = $app->result();
				$app_url = $app_attributes[0]->url;
				$data['app_id'] = $app_attributes[0]->id;
				$data['app_name'] = $app_attributes[0]->name;
				$data['app'] = $app_attributes[0];
				$data['mailbox_name'] = $mailbox_name;
				$data['is_group'] = $is_group;
				$org_id = User::organization_id_from_session();
				$user_id = $this->usersmodel->get_user_id_from_org_id($org_id);
				$app = $this->applicationmodel->get_application($app_id);
				$app_attributes = $app->result();
				if($app->num_rows() === 1) {
					//check redirect URL to make sure it is under the app's domain
					$app_url = $app_attributes[0]->url;
					if(!string_contains(parse_url($app_url, PHP_URL_HOST), parse_url($redirect_url, PHP_URL_HOST))) {
						$redirect_url = 'nowhere';
					}
					$mailbox_id = $this->usersettingsmodel->get_mailbox_id_by_name($mailbox_name, $is_group);
					$data['permission_editor_name'] = $mailbox_name;
					
					if(!isset($mailbox_id) || !$mailbox_id) {
						$data['mailbox_id_not_found'] = true;
					}
					else {
						//set permission settings if there isn't any
						$this->usersettingsmodel->mailbox_settings_setup($mailbox_id, $app_attributes[0]->id, 'add');
						
						$web_services = $this->usersettingsmodel->get_web_services()->result();
						$user_settings = $this->usersettingsmodel->get_mailbox_settings_by_application($mailbox_id, $app_attributes[0]->id)->result();
						$data['app_id'] = $app_attributes[0]->id;
						$data['app_name'] = $app_attributes[0]->name;
						$data['redirect_url'] = $redirect_url;
						$data['user_settings'] = $user_settings;
					}
				}
					
				$this->load->view('api/authorize/edit_webservice_permission',$data);
			}
		}
		else {
			$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
			$is_authorized = $this->request->direct_api_authorized; //authorize request
			if($is_authenticated && $is_authorized) {
				$this->load->model('applicationmodel');
				$this->load->model('usersmodel');
				$org_id = User::organization_id_from_session();
				$user_id = $this->usersmodel->get_user_id_from_org_id($org_id);
				$app_id = $this->applicationmodel->get_application_id_from_public($this->request->public_key);
				$url = 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/edit_webservice_permission/';
				
				$response = array(
					'permission_url' => $url,
					'app_id' => $app_id,
					'user_id' => $user_id,
					'redirect_url' => $redirect_url,
				);
				$this->response($response,404);
			}
		}
	}
	
	
	public function save_webservice_permission_post() {
		$this->load->library(array('session','encrypt','auth','permissions'));
		$this->load->model('usersettingsmodel');
		$this->load->model('requestmodel');
		$this->load->model('usersmodel');
		$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
		$is_authorized = $this->request->direct_api_authorized; //authorize request
		$redirect_url = $this->post('redirect_url',TRUE);
		
		if(isset($_SERVER['HTTP_CERT'])) {
		
			if($this->session->userdata('user_id')) { //if this has been set we know they are logged in
				//add user settings entries
				$org_id = User::organization_id_from_session();
				$user_id = $this->usersmodel->get_user_id_from_org_id($org_id);
				$app_id = $this->post('id',TRUE);
				$user_name = $this->usersmodel->get_username_from_id($user_id);
				$mailbox_name = $this->post('mailbox_name',TRUE);
				$is_group = $this->post('is_group',TRUE);
				$mailbox_id = $this->usersettingsmodel->get_mailbox_id_by_name($mailbox_name, $is_group);
				$mailbox_settings = $this->usersettingsmodel->get_mailbox_settings_by_application($mailbox_id, $app_id)->result();
				foreach($mailbox_settings as $setting) {
					$authorized =  $this->post($setting->web_service_name,TRUE);
					$this->usersettingsmodel->save_mailbox_settings_entry($mailbox_id, $app_id, $setting->web_service_id, $authorized);
				}
			}
			$this->load->helper('url');
			redirect($redirect_url);
		}
		
	}

/*	//this method existed on multiple controllers - moved this to the form validation library extension to avoid duplicate code -- MG 2014-05-22		
	public function va_email($email) {
		$valid = (preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@+((.*(\.va\.gov))|va\.gov)$/ix", $email)) ? TRUE : FALSE;
		if($valid) { return TRUE; }
		$this->form_validation->set_message('va_email', 'The %s field must contain a valid domain email address.');
		return FALSE;
	} */
}