/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.codehaus.jackson.map.ObjectMapper;
import org.nhindirect.common.rest.UnsecuredServiceRequestBase;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;

public class TrackMessageRequest
extends UnsecuredServiceRequestBase<Object, RuntimeException> {
    private final Tx tx;

    protected static MimeMessage convertHeadersToMessage(InternetHeaders headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Invalid parameter received. Headers cannot be null.");
        }
        MimeMessage msg = new MimeMessage((Session)null);
        try {
            Enumeration henum = headers.getAllHeaderLines();
            while (henum.hasMoreElements()) {
                msg.addHeaderLine((String)henum.nextElement());
            }
            return msg;
        }
        catch (MessagingException e) {
            return null;
        }
    }

    protected static Tx convertMimeMessageToTx(MimeMessage msg, TxDetailParser parser) {
        if (msg == null) {
            throw new IllegalArgumentException("Invalid parameter received. Message cannot be null.");
        }
        Map<String, TxDetail> details = parser.getMessageDetails(msg);
        return new Tx(TxUtil.getMessageType(msg), details);
    }

    public TrackMessageRequest(HttpClient httpClient, String txServiceUrl, ObjectMapper jsonMapper, TxDetailParser parser, MimeMessage msg) {
        this(httpClient, txServiceUrl, jsonMapper, parser, TrackMessageRequest.convertMimeMessageToTx(msg, parser));
    }

    public TrackMessageRequest(HttpClient httpClient, String txServiceUrl, ObjectMapper jsonMapper, TxDetailParser parser, InternetHeaders headers) {
        this(httpClient, txServiceUrl, jsonMapper, parser, TrackMessageRequest.convertHeadersToMessage(headers));
    }

    public TrackMessageRequest(HttpClient httpClient, String txServiceUrl, ObjectMapper jsonMapper, TxDetailParser parser, Tx tx) {
        super(httpClient, txServiceUrl, jsonMapper);
        if (tx == null) {
            throw new IllegalArgumentException("Invalid parameter received. Tx cannot be null.");
        }
        this.tx = tx;
    }

    private String getRequestUri() {
        String theURI = this.serviceUrl.endsWith("/") ? this.serviceUrl : this.serviceUrl + "/";
        return theURI + "txs";
    }

    protected final HttpPost createRequest() throws IOException {
        HttpPost post = new HttpPost(this.getRequestUri());
        post.setHeader("Accept", "application/json");
        return this.buildEntityRequest(post, this.makeContent(), "application/json");
    }

    private byte[] makeContent() throws IOException {
        return this.jsonMapper.writeValueAsBytes((Object)this.tx);
    }

    @Override
    protected Object parseResponse(HttpEntity response) throws IOException {
        return null;
    }

    @Override
    public void destroy() {
    }
}

