/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.mail.dsn.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.nhindirect.common.mail.dsn.impl.NoEscapeXMLOutputter;
import org.nhindirect.common.mail.dsn.impl.UnescapedAwareXMLOutputter;
import org.nhindirect.common.mail.dsn.impl.UnescapedText;

public class HumanReadableTextAssembler {
    private String bounceHeader;
    private String bounceFooter;
    private String recipientsTitle;
    private String errorMessageTitle;
    private String errorMessageDefault;

    public HumanReadableTextAssembler(String bounceHeader, String bounceFooter, String recipientsTitle, String errorMessageTitle, String errorMessageDefault) {
        this.bounceHeader = bounceHeader;
        this.bounceFooter = bounceFooter;
        this.recipientsTitle = recipientsTitle;
        this.errorMessageTitle = errorMessageTitle;
        this.errorMessageDefault = errorMessageDefault;
    }

    public MimeBodyPart assemble(List<Address> rejectedRecipients) throws MessagingException {
        String errorMessage = null;
        return this.makeBodyPart(rejectedRecipients, errorMessage);
    }

    public MimeBodyPart assemble(List<Address> rejectedRecipients, Throwable throwable) throws MessagingException {
        return this.makeBodyPart(rejectedRecipients, throwable.getMessage());
    }

    public MimeBodyPart assemble(List<Address> rejectedRecipients, String errorMessage) throws MessagingException {
        return this.makeBodyPart(rejectedRecipients, errorMessage);
    }

    protected MimeBodyPart makeBodyPart(List<Address> rejectedRecipients, String errorMessage) throws MessagingException {
        String assembleHtmlBody;
        try {
            assembleHtmlBody = this.assembleHtmlBody(rejectedRecipients, errorMessage);
        }
        catch (IOException e) {
            throw new MessagingException("", (Exception)e);
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)assembleHtmlBody, "text/html");
        return mimeBodyPart;
    }

    protected String assembleHtmlBody(List<Address> rejectedRecipients, String errorMessage) throws IOException {
        ArrayList<UnescapedText> lstToUnescape = new ArrayList<UnescapedText>();
        Element html = new Element("html");
        Element body = new Element("body");
        html.addContent((Content)body);
        Element p = new Element("p");
        body.addContent((Content)p);
        UnescapedText text = new UnescapedText(this.bounceHeader);
        lstToUnescape.add(text);
        p.addContent((Content)text);
        p = new Element("p");
        body.addContent((Content)p);
        p.setText(this.recipientsTitle);
        Element ul = new Element("ul");
        p.addContent((Content)ul);
        for (Address address : rejectedRecipients) {
            Element li = new Element("li");
            ul.addContent((Content)li);
            li.addContent(address.toString());
        }
        p = new Element("p");
        body.addContent((Content)p);
        p.setText(this.errorMessageTitle);
        Element br = new Element("br");
        p.addContent((Content)br);
        if (errorMessage != null && errorMessage.length() > 0) {
            p.addContent(errorMessage);
        } else {
            UnescapedText text2 = new UnescapedText(this.errorMessageDefault);
            lstToUnescape.add(text2);
            p.addContent((Content)text2);
        }
        p = new Element("p");
        body.addContent((Content)p);
        text = new UnescapedText(this.bounceFooter);
        lstToUnescape.add(text);
        p.addContent((Content)text);
        Document document = new Document(html);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLOutputter outputter = new NoEscapeXMLOutputter(Format.getPrettyFormat());
        outputter.output(document, (OutputStream)byteArrayOutputStream);
        String htmlString = new String(byteArrayOutputStream.toByteArray());
        String randomStr = this.getUniqueString();
        while (htmlString.indexOf(randomStr) > -1) {
            randomStr = this.getUniqueString();
        }
        for (UnescapedText unescapedText : lstToUnescape) {
            unescapedText.setUnescapedIndicator(randomStr);
        }
        outputter = new UnescapedAwareXMLOutputter(Format.getPrettyFormat(), randomStr);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        outputter.output(document, (OutputStream)byteArrayOutputStream2);
        String htmlString2 = new String(byteArrayOutputStream2.toByteArray());
        return htmlString2;
    }

    protected String getUniqueString() {
        UUID randomUUID = UUID.randomUUID();
        return randomUUID.toString();
    }
}

