/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.mail.dsn;

import com.sun.mail.dsn.DeliveryStatus;
import javax.mail.internet.InternetHeaders;

public class DSNStandard {
    public static String getHeaderValueFromDeliveryStatus(DeliveryStatus status, String headerName) {
        String result = "";
        int cnt = status.getRecipientDSNCount();
        for (int i = 0; i < cnt; ++i) {
            String value;
            InternetHeaders recipHeaders = status.getRecipientDSN(i);
            if (recipHeaders == null || (value = recipHeaders.getHeader(headerName, ",")) == null || value.length() <= 0) continue;
            result = value;
            break;
        }
        return result;
    }

    public static String getFinalRecipients(DeliveryStatus status) {
        StringBuilder builder = new StringBuilder();
        int cnt = status.getRecipientDSNCount();
        int recipientCount = 0;
        for (int i = 0; i < cnt; ++i) {
            String recipient;
            String value;
            InternetHeaders recipHeaders = status.getRecipientDSN(i);
            if (recipHeaders == null || (value = recipHeaders.getHeader("Final-Recipient", ",")) == null || value.length() <= 0 || (recipient = value.substring(value.indexOf(";") + 1)) == null || recipient.length() <= 0) continue;
            if (recipientCount > 0) {
                builder.append(",");
            }
            builder.append(recipient.trim());
            ++recipientCount;
        }
        return builder.toString();
    }

    public static class DSNStatus {
        public static final int SUCCESS = 2;
        public static final int TRANSIENT = 4;
        public static final int PERMANENT = 5;
        public static final int UNDEFINED = 0;
        public static final String UNDEFINED_STATUS = "0.0";
        public static final int ADDRESS = 1;
        public static final String ADDRESS_OTHER = "1.0";
        public static final String ADDRESS_MAILBOX = "1.1";
        public static final String ADDRESS_SYSTEM = "1.2";
        public static final String ADDRESS_SYNTAX = "1.3";
        public static final String ADDRESS_AMBIGUOUS = "1.4";
        public static final String ADDRESS_VALID = "1.5";
        public static final String ADDRESS_MOVED = "1.6";
        public static final String ADDRESS_SYNTAX_SENDER = "1.7";
        public static final String ADDRESS_SYSTEM_SENDER = "1.8";
        public static final int MAILBOX = 2;
        public static final String MAILBOX_OTHER = "2.0";
        public static final String MAILBOX_DISABLED = "2.1";
        public static final String MAILBOX_FULL = "2.2";
        public static final String MAILBOX_MSG_TOO_BIG = "2.3";
        public static final String MAILBOX_LIST_EXPANSION = "2.4";
        public static final int SYSTEM = 3;
        public static final String SYSTEM_OTHER = "3.0";
        public static final String SYSTEM_FULL = "3.1";
        public static final String SYSTEM_NOT_ACCEPTING = "3.2";
        public static final String SYSTEM_NOT_CAPABLE = "3.3";
        public static final String SYSTEM_MSG_TOO_BIG = "3.4";
        public static final String SYSTEM_CFG_ERROR = "3.5";
        public static final int NETWORK = 4;
        public static final String NETWORK_OTHER = "4.0";
        public static final String NETWORK_NO_ANSWER = "4.1";
        public static final String NETWORK_CONNECTION = "4.2";
        public static final String NETWORK_DIR_SERVER = "4.3";
        public static final String NETWORK_ROUTE = "4.4";
        public static final String NETWORK_CONGESTION = "4.5";
        public static final String NETWORK_LOOP = "4.6";
        public static final String NETWORK_EXPIRED = "4.7";
        public static final int DELIVERY = 5;
        public static final String DELIVERY_OTHER = "5.0";
        public static final String DELIVERY_INVALID_CMD = "5.1";
        public static final String DELIVERY_SYNTAX = "5.2";
        public static final String DELIVERY_TOO_MANY_REC = "5.3";
        public static final String DELIVERY_INVALID_ARG = "5.4";
        public static final String DELIVERY_VERSION = "5.5";
        public static final int CONTENT = 6;
        public static final String CONTENT_OTHER = "6.0";
        public static final String CONTENT_UNSUPPORTED = "6.1";
        public static final String CONTENT_CONVERSION_NOT_ALLOWED = "6.2";
        public static final String CONTENT_CONVERSION_NOT_SUPPORTED = "6.3";
        public static final String CONTENT_CONVERSION_LOSS = "6.4";
        public static final String CONTENT_CONVERSION_FAILED = "6.5";
        public static final int SECURITY = 7;
        public static final String SECURITY_OTHER = "7.0";
        public static final String SECURITY_AUTH = "7.1";
        public static final String SECURITY_LIST_EXP = "7.2";
        public static final String SECURITY_CONVERSION = "7.3";
        public static final String SECURITY_UNSUPPORTED = "7.4";
        public static final String SECURITY_CRYPT_FAIL = "7.5";
        public static final String SECURITY_CRYPT_ALGO = "7.6";
        public static final String SECURITY_INTEGRITY = "7.7";

        public static String getStatus(int type, String detail) {
            return type + "." + detail;
        }

        public static String getStatus(int type, int subject, int detail) {
            return type + "." + subject + "." + detail;
        }
    }

    public static enum MtaNameType {
        DNS{

            public String toString() {
                return "dns";
            }
        };

    }

    public static enum DSNAction {
        FAILED{

            public String toString() {
                return "failed";
            }
        }
        ,
        DELAYED{

            public String toString() {
                return "delayed";
            }
        }
        ,
        DELIVERED{

            public String toString() {
                return "delivered";
            }
        }
        ,
        RELAYED{

            public String toString() {
                return "relayed";
            }
        }
        ,
        EXPANDED{

            public String toString() {
                return "expanded";
            }
        };

    }

    public static class Headers {
        public static final String FinalRecipient = "Final-Recipient";
        public static final String Action = "Action";
        public static final String Status = "Status";
        public static final String ReportingMTA = "Reporting-MTA";
        public static final String OriginalMessageID = "X-Original-Message-ID";
    }

    public static class MediaType {
        public static final String DSNDeliveryStatus = "message/delivery-status";
        public static final String ReportTypeValueDelivery = "delivery-status";
        public static final String ReportType = "report-type";
    }
}

