/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.json.simple.JSONObject;
import org.nhindirect.gateway.smtp.james.mailet.SendMail;

public class StoreMail
extends GenericMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(StoreMail.class);

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = null;
        String sender = null;
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        long size = 0L;
        Date date = null;
        long time = 0L;
        String subject = null;
        String attachments = null;
        String body = null;
        String html = null;
        Enumeration headers = null;
        String message_id = null;
        JSONObject header = new JSONObject();
        String to = null;
        String cc = null;
        String bcc = null;
        int priority = 3;
        String mailtype = "html";
        byte[] sermessage = null;
        try {
            message = mail.getMessage();
            recipients.addAll(mail.getRecipients());
            sender = mail.getSender().toString();
            size = mail.getMessageSize();
            date = mail.getLastUpdated();
            time = date != null ? date.getTime() / 1000L : new Date().getTime() / 1000L;
            subject = message.getSubject();
            attachments = this.parseAttachments(message);
            message_id = message.getHeader("message-id", null);
            headers = message.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header head = (Header)headers.nextElement();
                header.put((Object)head.getName(), (Object)head.getValue());
                if (head.getName().equalsIgnoreCase("to")) {
                    to = head.getValue();
                    continue;
                }
                if (head.getName().equalsIgnoreCase("cc")) {
                    cc = head.getValue();
                    continue;
                }
                if (head.getName().equalsIgnoreCase("bcc")) {
                    bcc = head.getValue();
                    continue;
                }
                if (head.getName().equalsIgnoreCase("X-Priority")) {
                    priority = Integer.parseInt(head.getValue().replaceAll("[\\D]", ""));
                    continue;
                }
                if (head.getName().equalsIgnoreCase("original-id")) {
                    message_id = head.getValue();
                    continue;
                }
                if (!head.getName().equalsIgnoreCase("mdn-message")) continue;
                LOGGER.info((Object)("message is an mdn with disposition " + head.getValue()));
                return;
            }
            try {
                body = this.parseBody(message.getContent(), message.getContentType(), "text/plain", 0);
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"Messaging execption while retrieving body.");
            }
            try {
                html = this.parseBody(message.getContent(), message.getContentType(), "text/html", 0);
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"Messaging execption while retrieving html.");
            }
            try {
                sermessage = this.serialize(message);
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"Failed to serizlize message");
            }
            if (html == null) {
                mailtype = "html";
            }
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while retrieving message.");
        }
        SendMail.sendMessage(recipients, sender, attachments, subject, body, html, time, size, header.toJSONString(), sermessage, message_id, to, cc, bcc, priority, mailtype, null);
    }

    private String parseAttachments(MimeMessage message) {
        JSONObject attachmentTypes;
        block9: {
            attachmentTypes = new JSONObject();
            try {
                if (message.getContentType().contains("text/plain")) break block9;
                MimeMultipart attachments = new MimeMultipart();
                try {
                    attachments = (MimeMultipart)message.getContent();
                }
                catch (ClassCastException ce) {
                    attachments = null;
                }
                catch (IOException ie) {
                    LOGGER.debug((Object)"IO Error while post-processing incoming message.");
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
                }
                if (attachments != null) {
                    int index = 0;
                    for (int i = 0; i < attachments.getCount(); ++i) {
                        BodyPart part = attachments.getBodyPart(i);
                        if (FilenameUtils.getExtension((String)part.getFileName()) == null) continue;
                        attachmentTypes.put((Object)index++, (Object)part.getFileName());
                    }
                }
            }
            catch (MessagingException me) {
                LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            }
        }
        if (attachmentTypes.isEmpty()) {
            return null;
        }
        return attachmentTypes.toJSONString();
    }

    private String parseBody(Object content, String type, String get, int depth) throws IOException {
        try {
            if (!type.contains(get)) {
                MimeMultipart attachments;
                if (type.contains("multipart") && depth < 5) {
                    try {
                        attachments = (MimeMultipart)content;
                    }
                    catch (ClassCastException ce) {
                        return null;
                    }
                } else {
                    return null;
                }
                for (int i = 0; i < attachments.getCount(); ++i) {
                    BodyPart part = attachments.getBodyPart(i);
                    String body = this.parseBody(part.getContent(), part.getContentType(), get, depth + 1);
                    if (body == null) continue;
                    return body;
                }
                return null;
            }
            return content.toString();
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            return null;
        }
    }

    private byte[] serialize(MimeMessage message) throws IOException, MessagingException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        message.writeTo((OutputStream)b);
        return b.toByteArray();
    }
}

