/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import com.google.inject.Module;
import com.google.inject.Provider;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.nhindirect.gateway.smtp.GatewayState;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.gateway.smtp.james.mailet.LogMessage;
import org.nhindirect.gateway.smtp.james.mailet.MailetProperties;
import org.nhindirect.gateway.smtp.james.mailet.NHINDSecurityAndTrustMailet;
import org.nhindirect.stagent.AddressSource;
import org.nhindirect.stagent.NHINDAddress;

public class LocalMailet
extends GenericMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(LocalMailet.class);
    protected SmtpAgent agent;

    public void init() throws MessagingException {
        System.setProperty("enableCBCProtection", "false");
        LOGGER.info((Object)"Initializing IncomingLocalMailet");
        String configURLParam = this.getInitParameter("ConfigURL");
        if (configURLParam == null || configURLParam.isEmpty()) {
            LOGGER.error((Object)"IncomingLocalMailet Configuration URL cannot be empty or null.");
            throw new MessagingException("IncomingLocalMailet Configuration URL cannot be empty or null.");
        }
        URL configURL = null;
        try {
            configURL = new URL(configURLParam);
        }
        catch (MalformedURLException ex) {
            LOGGER.error((Object)"Invalid configuration URL");
            throw new MessagingException("Incoming Configuration URL cannot be empty or null.", (Exception)ex);
        }
        LOGGER.info((Object)"IncomingLocalMailet initialization complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail mail) throws MessagingException {
        block31: {
            GatewayState.getInstance().lockForProcessing();
            try {
                LOGGER.trace((Object)"Entering service(Mail mail)");
                boolean notificationFlag = false;
                try {
                    if (mail.getSender().toString().equals(this.getMailetContext().getPostmaster().toString())) {
                        notificationFlag = true;
                    }
                    Enumeration headers = mail.getMessage().getAllHeaders();
                    while (headers.hasMoreElements()) {
                        Header h = (Header)headers.nextElement();
                        if (!h.getName().contains("DirectNotification")) continue;
                        notificationFlag = true;
                    }
                }
                catch (MessagingException e) {
                    LOGGER.debug((Object)"Messaging execption while trying to check notification and set flag.");
                }
                if (notificationFlag) break block31;
                InternetAddress senderAddr = NHINDSecurityAndTrustMailet.getSender((Mail)mail);
                if (senderAddr == null) {
                    throw new MessagingException("Failed to process message.  The sender cannot be null or empty.");
                }
                NHINDAddress sender = new NHINDAddress(senderAddr, AddressSource.From);
                Map<String, String> properties = MailetProperties.getPropertiesList();
                String db_hostname = properties.get("mailet.db.hostname");
                String db_port = properties.get("mailet.db.port");
                String db_apiname = properties.get("mailet.db.apiname");
                String db_webname = properties.get("mailet.db.webname");
                String db_instance = properties.get("mailet.db.instance");
                String db_apiuserid = properties.get("mailet.db.apiusername");
                String db_webuserid = properties.get("mailet.db.webusername");
                String db_apipassword = properties.get("mailet.db.apipassword");
                String db_webpassword = properties.get("mailet.db.webpassword");
                String notificationSender = properties.get("mailet.notification.sender");
                if (sender.toString().toLowerCase(Locale.getDefault()).equals(notificationSender.toLowerCase(Locale.getDefault()))) break block31;
                Connection connapi = null;
                Connection connweb = null;
                LOGGER.info((Object)("Logging local outgoing message from sender " + sender.toString()));
                try {
                    ArrayList<MailAddress> badaddress;
                    connapi = this.databaseConnect(db_hostname, db_port, db_apiname, db_instance, db_apiuserid, db_apipassword);
                    connweb = this.databaseConnect(db_hostname, db_port, db_webname, db_instance, db_webuserid, db_webpassword);
                    int log_success = 1;
                    if (this.hasOnlyLocalRecipients(mail)) {
                        LogMessage.logMessageToLog(mail, connweb, 1, 0, -1);
                        LogMessage.logMessageToLog(mail, connapi, 1, 0, 0);
                    }
                    if (!(badaddress = LogMessage.sendExternalNotification(connweb, mail)).isEmpty()) {
                        log_success = 0;
                    }
                    LogMessage.logMessageToLog(mail, connweb, log_success, 1, -1);
                    LogMessage.logMessageToLog(mail, connapi, log_success, 1, 0);
                    LogMessage.proccessMessagesStatus(mail, badaddress);
                }
                catch (SQLException sql_ex) {
                    LOGGER.trace((Object)"SQL Exception while sending external notifications and logging messages.");
                }
                finally {
                    try {
                        if (connweb != null) {
                            connweb.close();
                        }
                    }
                    catch (SQLException closeEx) {
                        LOGGER.debug((Object)"Failed to close SQL Database connection.");
                    }
                    try {
                        if (connapi != null) {
                            connapi.close();
                        }
                    }
                    catch (SQLException closeEx) {
                        LOGGER.debug((Object)"Failed to close SQL Database connection.");
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Failed to log message");
            }
            finally {
                GatewayState.getInstance().unlockFromProcessing();
            }
        }
    }

    protected Collection<Module> getInitModules() {
        return null;
    }

    protected Provider<SmtpAgentConfig> getConfigProvider() {
        return null;
    }

    public static InternetAddress getSender(Mail mail) {
        InternetAddress retVal;
        if (mail.getSender() != null) {
            retVal = mail.getSender().toInternetAddress();
        } else {
            Address[] senderAddr;
            try {
                if (mail.getMessage() == null) {
                    return null;
                }
                senderAddr = mail.getMessage().getFrom();
                if (senderAddr == null || senderAddr.length == 0) {
                    return null;
                }
            }
            catch (MessagingException e) {
                return null;
            }
            retVal = (InternetAddress)senderAddr[0];
        }
        return retVal;
    }

    public void shutdown() {
        GatewayState.getInstance().lockForUpdating();
        GatewayState.getInstance().unlockFromUpdating();
    }

    private Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_password) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_password);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            throw sqlException;
        }
        return conn;
    }

    private boolean hasOnlyLocalRecipients(Mail mail) {
        Map<String, String> properties = MailetProperties.getPropertiesList();
        String domainsProperty = properties.get("mailet.domain");
        String[] domainsList = domainsProperty.split(",");
        boolean onlyLocal = true;
        try {
            MimeMessage message = mail.getMessage();
            Address[] recipsAddr = message.getAllRecipients();
            if (recipsAddr != null) {
                for (Address addr : recipsAddr) {
                    boolean isLocal = false;
                    if (recipsAddr != null) {
                        InternetAddress inet_addr_recip = (InternetAddress)addr;
                        int atPosition = inet_addr_recip.getAddress().indexOf("@") + 1;
                        String currentdomain = inet_addr_recip.getAddress().substring(atPosition);
                        for (int c = 0; c < domainsList.length; ++c) {
                            if (!currentdomain.equals(domainsList[c])) continue;
                            isLocal = true;
                        }
                    }
                    if (isLocal) continue;
                    onlyLocal = false;
                }
            }
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while checking for external recipients in recipient list.");
        }
        return onlyLocal;
    }
}

