/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.MailAddress;
import org.nhindirect.gateway.smtp.james.mailet.MailetProperties;

public class AddressCheck {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(AddressCheck.class);
    private HashMap<MailAddress, Integer> mailbox;
    private HashMap<MailAddress, Integer> group;
    private ArrayList<MailAddress> badaddress;
    private boolean failed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressCheck(ArrayList<MailAddress> addresses, String[] Domains) {
        block26: {
            this.failed = true;
            HashMap<String, Integer> usernametoids = new HashMap<String, Integer>();
            HashMap<String, Integer> usernametogroup = new HashMap<String, Integer>();
            this.badaddress = new ArrayList();
            this.mailbox = new HashMap();
            this.group = new HashMap();
            Connection conn = null;
            try {
                Map<String, String> propertiesMap = MailetProperties.getPropertiesList();
                String db_hostname = propertiesMap.get("mailet.db.hostname");
                String db_port = propertiesMap.get("mailet.db.port");
                String db_name = propertiesMap.get("mailet.db.mailname");
                String db_instance = propertiesMap.get("mailet.db.instance");
                String db_userid = propertiesMap.get("mailet.db.mailusername");
                String db_password = propertiesMap.get("mailet.db.mailpassword");
                try {
                    conn = AddressCheck.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
                }
                catch (SQLException e) {
                    LOGGER.trace((Object)"Failed to connect to SQL Server");
                }
                Statement prepQuery = null;
                if (conn == null) break block26;
                try {
                    String sqlQuery = "SELECT id, name, is_group FROM mailboxes WHERE name in (" + StringUtils.repeat((String)"?,", (int)addresses.size());
                    sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 1) + ')';
                    prepQuery = conn.prepareStatement(sqlQuery);
                    for (int c = 0; c < addresses.size(); ++c) {
                        prepQuery.setString(c + 1, addresses.get(c).getLocalPart());
                    }
                    ResultSet rs = null;
                    try {
                        rs = prepQuery.executeQuery();
                        while (rs.next()) {
                            usernametoids.put(rs.getString("name"), rs.getInt("id"));
                            usernametogroup.put(rs.getString("name"), rs.getInt("is_group"));
                        }
                        List<String> domainSet = Arrays.asList(Domains);
                        for (MailAddress address : addresses) {
                            if (domainSet.contains(address.getDomain()) && usernametoids.containsKey(address.getLocalPart())) {
                                this.mailbox.put(address, (Integer)usernametoids.get(address.getLocalPart()));
                                this.group.put(address, (Integer)usernametogroup.get(address.getLocalPart()));
                                continue;
                            }
                            this.badaddress.add(address);
                        }
                        rs.close();
                        this.failed = false;
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (prepQuery != null) {
                        prepQuery.close();
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.debug((Object)"SQL Exception for bad query statement in users exists function.");
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        LOGGER.debug((Object)"Failed to close connection");
                    }
                }
            }
        }
    }

    public HashMap<MailAddress, Integer> getMailbox() {
        return this.mailbox;
    }

    public boolean isGroup(MailAddress address) {
        return this.group.get(address) == 1;
    }

    public ArrayList<MailAddress> getBadAddress() {
        return this.badaddress;
    }

    private static Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_prd) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_prd);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            return null;
        }
        return conn;
    }

    public void removeAddress(MailAddress address) {
        this.mailbox.remove(address);
        this.group.remove(address);
    }

    public boolean getFailed() {
        return this.failed;
    }
}

