/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.configkit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFilter;
import org.realityforge.configkit.IssueCollector;
import org.realityforge.configkit.ValidateException;
import org.realityforge.configkit.ValidationIssue;
import org.realityforge.configkit.ValidationResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ConfigValidator {
    private Schema m_schema;
    private EntityResolver m_resolver;

    ConfigValidator(Schema schema, EntityResolver resolver) {
        if (null == schema) {
            throw new NullPointerException("schema");
        }
        this.m_schema = schema;
        this.m_resolver = resolver;
    }

    public void validate(InputStream inputStream, ContentHandler contentHandler, ErrorHandler errorHandler) throws ValidateException {
        if (null == inputStream) {
            throw new NullPointerException("inputStream");
        }
        this.validate(new InputSource(inputStream), contentHandler, errorHandler);
    }

    public void validate(InputStream inputStream, ErrorHandler errorHandler) throws ValidateException {
        if (null == inputStream) {
            throw new NullPointerException("inputStream");
        }
        this.validate(new InputSource(inputStream), errorHandler);
    }

    public ValidationResult validate(InputStream inputStream) {
        if (null == inputStream) {
            throw new NullPointerException("inputStream");
        }
        return this.validate(new InputSource(inputStream));
    }

    public ValidationResult validate(InputStream inputStream, ContentHandler contentHandler) {
        if (null == inputStream) {
            throw new NullPointerException("inputStream");
        }
        return this.validate(new InputSource(inputStream), contentHandler);
    }

    public void validate(InputSource source, ErrorHandler errorHandler) throws ValidateException {
        if (null == source) {
            throw new NullPointerException("source");
        }
        this.doValidate((Object)source, errorHandler);
    }

    public void validate(InputSource source, ContentHandler contentHandler, ErrorHandler errorHandler) throws ValidateException {
        if (null == source) {
            throw new NullPointerException("source");
        }
        this.doValidate(source, contentHandler, errorHandler);
    }

    public ValidationResult validate(InputSource source) {
        if (null == source) {
            throw new NullPointerException("source");
        }
        return this.doValidate(source);
    }

    public ValidationResult validate(InputSource source, ContentHandler contentHandler) {
        if (null == source) {
            throw new NullPointerException("source");
        }
        return this.doValidate(source, contentHandler);
    }

    public void validate(Node node, ErrorHandler errorHandler) throws ValidateException {
        if (null == node) {
            throw new NullPointerException("node");
        }
        this.doValidate(node, errorHandler);
    }

    public ValidationResult validate(Node node) {
        if (null == node) {
            throw new NullPointerException("node");
        }
        return this.doValidate(node);
    }

    private ValidationResult doValidate(Object data) {
        ArrayList issueSet = new ArrayList();
        ValidateException exception = null;
        try {
            this.doValidate(data, new IssueCollector(issueSet));
        }
        catch (ValidateException ve) {
            exception = ve;
        }
        ValidationIssue[] issues = issueSet.toArray(new ValidationIssue[issueSet.size()]);
        return new ValidationResult(exception, issues);
    }

    private void doValidate(Object data, ErrorHandler errorHandler) throws ValidateException {
        try {
            boolean valid;
            Verifier verifier = this.m_schema.newVerifier();
            if (null != errorHandler) {
                verifier.setErrorHandler(errorHandler);
            }
            if (null != this.m_resolver) {
                verifier.setEntityResolver(this.m_resolver);
            }
            if (!(valid = data instanceof InputSource ? verifier.verify((InputSource)data) : verifier.verify((Node)data))) {
                String message = "Unable to validate input according to schema";
                throw new ValidateException("Unable to validate input according to schema");
            }
        }
        catch (VerifierConfigurationException vce) {
            String message = "Unable to locate verifier for schema";
            throw new ValidateException("Unable to locate verifier for schema", vce);
        }
        catch (SAXException se) {
            String message = "Malformed input XML.";
            throw new ValidateException("Malformed input XML.", se);
        }
        catch (IOException ioe) {
            String message = "Error reading input data XML.";
            throw new ValidateException("Error reading input data XML.", ioe);
        }
    }

    private ValidationResult doValidate(InputSource input, ContentHandler contentHandler) {
        ArrayList issueSet = new ArrayList();
        ValidateException exception = null;
        try {
            this.doValidate(input, contentHandler, new IssueCollector(issueSet));
        }
        catch (ValidateException ve) {
            exception = ve;
        }
        ValidationIssue[] issues = issueSet.toArray(new ValidationIssue[issueSet.size()]);
        return new ValidationResult(exception, issues);
    }

    private void doValidate(InputSource input, ContentHandler contentHandler, ErrorHandler errorHandler) throws ValidateException {
        if (null == contentHandler) {
            throw new NullPointerException("contentHandler");
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            Verifier verifier = this.m_schema.newVerifier();
            if (null != errorHandler) {
                verifier.setErrorHandler(errorHandler);
            }
            if (null != this.m_resolver) {
                verifier.setEntityResolver(this.m_resolver);
            }
            VerifierFilter filter = verifier.getVerifierFilter();
            filter.setParent(reader);
            filter.setContentHandler(contentHandler);
            if (null != errorHandler) {
                filter.setErrorHandler(errorHandler);
            }
            if (null != this.m_resolver) {
                filter.setEntityResolver(this.m_resolver);
            }
            filter.parse(input);
            if (!filter.isValid()) {
                String message = "Unable to validate input according to schema";
                throw new ValidateException("Unable to validate input according to schema");
            }
        }
        catch (VerifierConfigurationException vce) {
            String message = "Unable to locate verifier for schema";
            throw new ValidateException("Unable to locate verifier for schema", vce);
        }
        catch (SAXException se) {
            String message = "Malformed input XML.";
            throw new ValidateException("Malformed input XML.", se);
        }
        catch (IOException ioe) {
            String message = "Error reading input input XML.";
            throw new ValidateException("Error reading input input XML.", ioe);
        }
        catch (ParserConfigurationException pce) {
            String message = "Unable to get parser.";
            throw new ValidateException("Unable to get parser.", pce);
        }
    }
}

