/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.classman.builder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.avalon.excalibur.packagemanager.PackageManager;
import org.realityforge.classman.builder.SimpleLoaderResolver;
import org.realityforge.classman.util.PathMatcher;

public class DefaultLoaderResolver
extends SimpleLoaderResolver {
    public DefaultLoaderResolver(File baseDirectory, PackageManager manager) {
        super(baseDirectory, manager);
    }

    public URL[] resolveFileSet(String baseDirectory, String[] includes, String[] excludes) throws Exception {
        File base = this.getFileFor(".");
        return this.resolveFileSet(base, baseDirectory, includes, excludes);
    }

    protected final URL[] resolveFileSet(File base, String baseDirectory, String[] includes, String[] excludes) {
        String newBaseDirectory = DefaultLoaderResolver.normalize(baseDirectory);
        String[] newIncludes = this.prefixPatterns(newBaseDirectory, includes);
        String[] newExcludes = this.prefixPatterns(newBaseDirectory, excludes);
        PathMatcher matcher = new PathMatcher(newIncludes, newExcludes);
        ArrayList urls = new ArrayList();
        this.scanDir(base, matcher, "", urls);
        return urls.toArray(new URL[urls.size()]);
    }

    private void scanDir(File dir, PathMatcher matcher, String path, ArrayList urls) {
        File[] files = dir.listFiles();
        if (null == files) {
            String message = "Bad dir specified: " + dir;
            throw new IllegalArgumentException(message);
        }
        String prefix = "";
        if (0 != path.length()) {
            prefix = path + "/";
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String newPath = prefix + file.getName();
            if (file.isDirectory()) {
                this.scanDir(file, matcher, newPath, urls);
            } else if (matcher.match(newPath)) {
                try {
                    urls.add(file.toURL());
                }
                catch (MalformedURLException mue) {
                    String message = "Error converting " + file + " to url. Reason: " + mue;
                    throw new IllegalArgumentException(message);
                }
            }
            ++i;
        }
    }

    private String[] prefixPatterns(String prefix, String[] patterns) {
        if (0 == prefix.length()) {
            return patterns;
        }
        String[] newPatterns = new String[patterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            newPatterns[i] = prefix + "/" + patterns[i];
            ++i;
        }
        return newPatterns;
    }

    private static final String normalize(String path) {
        char firstChar;
        if (".".equals(path) || "./".equals(path)) {
            return "";
        }
        if (path.length() < 2) {
            return path;
        }
        StringBuffer buff = new StringBuffer(path);
        int length = path.length();
        String prefix = null;
        if (length > 2 && buff.charAt(1) == ':') {
            prefix = path.substring(0, 2);
            buff.delete(0, 2);
            path = path.substring(2);
            length -= 2;
        }
        boolean startsWithSlash = length > 0 && (buff.charAt(0) == '/' || buff.charAt(0) == '\\');
        boolean expStart = true;
        int ptCount = 0;
        int lastSlash = length + 1;
        int upLevel = 0;
        int i = length - 1;
        while (i >= 0) {
            switch (path.charAt(i)) {
                case '\\': {
                    buff.setCharAt(i, '/');
                }
                case '/': {
                    if (lastSlash == i + 1) {
                        buff.deleteCharAt(i);
                    }
                    switch (ptCount) {
                        case 1: {
                            buff.delete(i, lastSlash);
                            break;
                        }
                        case 2: {
                            ++upLevel;
                            break;
                        }
                        default: {
                            if (upLevel <= 0 || lastSlash == i + 1) break;
                            buff.delete(i, lastSlash + 3);
                            --upLevel;
                        }
                    }
                    ptCount = 0;
                    expStart = true;
                    lastSlash = i;
                    break;
                }
                case '.': {
                    if (!expStart) break;
                    ++ptCount;
                    break;
                }
                default: {
                    ptCount = 0;
                    expStart = false;
                }
            }
            --i;
        }
        switch (ptCount) {
            case 1: {
                buff.delete(0, lastSlash);
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (upLevel > 0) {
                    if (startsWithSlash) {
                        return null;
                    }
                    upLevel = 1;
                }
                while (upLevel > 0) {
                    buff.delete(0, lastSlash + 3);
                    --upLevel;
                }
                break block9;
            }
        }
        length = buff.length();
        boolean isLengthNull = length == 0;
        char c = firstChar = isLengthNull ? (char)'\u0000' : buff.charAt(0);
        if (!startsWithSlash && !isLengthNull && firstChar == '/') {
            buff.deleteCharAt(0);
        } else if (startsWithSlash && (isLengthNull || !isLengthNull && firstChar != '/')) {
            buff.insert(0, '/');
        }
        if (prefix != null) {
            buff.insert(0, prefix);
        }
        return buff.toString();
    }
}

