/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.nio.AbstractNIOConnectionDistributor;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.utils.EchoFilter;

public class TCPNIOTransportTest
extends GrizzlyTestCase {
    public static final int PORT = 7777;
    private static final Logger logger = Grizzly.logger(TCPNIOTransportTest.class);

    @Override
    protected void setUp() throws Exception {
        ByteBufferWrapper.DEBUG_MODE = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartStop() throws IOException {
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        try {
            transport.bind(7777);
            transport.start();
        }
        finally {
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectorHandlerConnect() throws Exception {
        Connection connection = null;
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 7777);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBindUnbind() throws Exception {
        Connection connection = null;
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 7777);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.close();
            transport.unbindAll();
            future = transport.connect("localhost", 7777);
            try {
                connection = (Connection)future.get(10L, TimeUnit.SECONDS);
                TCPNIOTransportTest.assertTrue((String)"Server connection should be closed!", (boolean)false);
            }
            catch (ExecutionException e) {
                TCPNIOTransportTest.assertTrue((boolean)(e.getCause() instanceof IOException));
            }
            transport.bind(7777);
            future = transport.connect("localhost", 7777);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiBind() throws Exception {
        Connection connection = null;
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        try {
            TCPNIOServerConnection serverConnection1 = transport.bind(7777);
            TCPNIOServerConnection serverConnection2 = transport.bind(7778);
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 7777);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.close();
            future = transport.connect("localhost", 7778);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.close();
            transport.unbind((Connection)serverConnection1);
            future = transport.connect("localhost", 7777);
            try {
                connection = (Connection)future.get(10L, TimeUnit.SECONDS);
                TCPNIOTransportTest.assertTrue((String)"Server connection should be closed!", (boolean)false);
            }
            catch (ExecutionException e) {
                TCPNIOTransportTest.assertTrue((boolean)(e.getCause() instanceof IOException));
            }
            transport.unbind((Connection)serverConnection2);
            future = transport.connect("localhost", 7778);
            try {
                connection = (Connection)future.get(10L, TimeUnit.SECONDS);
                TCPNIOTransportTest.assertTrue((String)"Server connection should be closed!", (boolean)false);
            }
            catch (ExecutionException e) {
                TCPNIOTransportTest.assertTrue((boolean)(e.getCause() instanceof IOException));
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPortRangeBind() throws Exception {
        int portsTest = 10;
        int startPort = 9011;
        PortRange portRange = new PortRange(9011, 9020);
        Connection connection = null;
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().setReuseAddress(false).build();
        try {
            for (int i = 0; i < 10; ++i) {
                TCPNIOServerConnection serverConnection = transport.bind("localhost", portRange, 4096);
                TCPNIOTransportTest.assertEquals((int)(9011 + i), (int)((InetSocketAddress)serverConnection.getLocalAddress()).getPort());
            }
            try {
                transport.bind("localhost", portRange, 4096);
                TCPNIOTransportTest.fail((String)"All ports in range had to be occupied");
            }
            catch (IOException e) {
                // empty catch block
            }
            transport.start();
            for (int i = 0; i < 10; ++i) {
                GrizzlyFuture future = transport.connect("localhost", 9011 + i);
                connection = (Connection)future.get(10L, TimeUnit.SECONDS);
                TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
                connection.close();
            }
        }
        finally {
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectorHandlerConnectAndWrite() throws Exception {
        Connection connection = null;
        StreamWriter writer = null;
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.configureBlocking(true);
            writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            byte[] sendingBytes = "Hello".getBytes();
            writer.writeByteArray(sendingBytes);
            GrizzlyFuture writeFuture = writer.flush();
            Integer bytesWritten = (Integer)writeFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((boolean)writeFuture.isDone());
            TCPNIOTransportTest.assertEquals((int)sendingBytes.length, (int)bytesWritten);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleEcho() throws Exception {
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.configureBlocking(true);
            byte[] originalMessage = "Hello".getBytes();
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            writer.writeByteArray(originalMessage);
            GrizzlyFuture writeFuture = writer.flush();
            TCPNIOTransportTest.assertTrue((String)"Write timeout", (boolean)writeFuture.isDone());
            TCPNIOTransportTest.assertEquals((int)originalMessage.length, (int)((Integer)writeFuture.get()));
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            GrizzlyFuture readFuture = reader.notifyAvailable(originalMessage.length);
            TCPNIOTransportTest.assertTrue((String)"Read timeout", (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
            byte[] echoMessage = new byte[originalMessage.length];
            reader.readByteArray(echoMessage);
            TCPNIOTransportTest.assertTrue((boolean)Arrays.equals(echoMessage, originalMessage));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralPacketsEcho() throws Exception {
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7777);
            transport.start();
            transport.configureBlocking(true);
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            for (int i = 0; i < 100; ++i) {
                byte[] originalMessage = ("Hello world #" + i).getBytes();
                writer.writeByteArray(originalMessage);
                GrizzlyFuture writeFuture = writer.flush();
                TCPNIOTransportTest.assertTrue((String)"Write timeout", (boolean)writeFuture.isDone());
                TCPNIOTransportTest.assertEquals((int)originalMessage.length, (int)((Integer)writeFuture.get()));
                GrizzlyFuture readFuture = reader.notifyAvailable(originalMessage.length);
                TCPNIOTransportTest.assertTrue((String)"Read timeout", (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
                byte[] echoMessage = new byte[originalMessage.length];
                reader.readByteArray(echoMessage);
                TCPNIOTransportTest.assertTrue((boolean)Arrays.equals(echoMessage, originalMessage));
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncReadWriteEcho() throws Exception {
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            byte[] originalMessage = "Hello".getBytes();
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            writer.writeByteArray(originalMessage);
            GrizzlyFuture writeFuture = writer.flush();
            Integer writtenBytes = (Integer)writeFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertEquals((int)originalMessage.length, (int)writtenBytes);
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            GrizzlyFuture readFuture = reader.notifyAvailable(originalMessage.length);
            TCPNIOTransportTest.assertTrue((String)"Read timeout", (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
            byte[] echoMessage = new byte[originalMessage.length];
            reader.readByteArray(echoMessage);
            TCPNIOTransportTest.assertTrue((boolean)Arrays.equals(echoMessage, originalMessage));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralPacketsAsyncReadWriteEcho() throws Exception {
        int packetsNumber = 20;
        int packetSize = 17644;
        final AtomicInteger serverBytesCounter = new AtomicInteger();
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter(){

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                serverBytesCounter.addAndGet(((Buffer)ctx.getMessage()).remaining());
                return super.handleRead(ctx);
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            int i;
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            final CountDownLatch sendLatch = new CountDownLatch(packetsNumber);
            for (i = 0; i < packetsNumber; ++i) {
                final byte[] message = new byte[17644];
                Arrays.fill(message, (byte)i);
                writer.writeByteArray(message);
                writer.flush((CompletionHandler)new EmptyCompletionHandler<Integer>(){

                    public void completed(Integer result) {
                        Assert.assertEquals((int)message.length, (int)result);
                        sendLatch.countDown();
                    }

                    public void failed(Throwable throwable) {
                        throwable.printStackTrace();
                    }
                });
            }
            for (i = 0; i < packetsNumber; ++i) {
                byte[] pattern = new byte[17644];
                Arrays.fill(pattern, (byte)i);
                byte[] message = new byte[17644];
                GrizzlyFuture future = reader.notifyAvailable(17644);
                try {
                    future.get(10L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    TCPNIOTransportTest.assertTrue((String)("Timeout. Server processed " + serverBytesCounter.get() + " bytes"), (boolean)false);
                }
                TCPNIOTransportTest.assertTrue((boolean)future.isDone());
                reader.readByteArray(message);
                TCPNIOTransportTest.assertTrue((boolean)Arrays.equals(pattern, message));
            }
            TCPNIOTransportTest.assertEquals((long)0L, (long)sendLatch.getCount());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFeeder() throws Exception {
        int fullMessageSize = 2048;
        Connection connection = null;
        class CheckSizeFilter
        extends BaseFilter {
            private int size;
            private CountDownLatch latch = new CountDownLatch(1);

            public CheckSizeFilter(int size) {
                this.size = size;
            }

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                Buffer buffer = (Buffer)ctx.getMessage();
                logger.log(Level.INFO, "Feeder. Check size filter: {0}", buffer);
                if (buffer.remaining() >= this.size) {
                    this.latch.countDown();
                    return ctx.getInvokeAction();
                }
                return ctx.getStopAction((Object)buffer);
            }
        }
        CheckSizeFilter checkSizeFilter = new CheckSizeFilter(fullMessageSize);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)checkSizeFilter);
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            byte[] firstChunk = new byte[fullMessageSize / 5];
            Arrays.fill(firstChunk, (byte)1);
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            writer.writeByteArray(firstChunk);
            GrizzlyFuture writeFuture = writer.flush();
            TCPNIOTransportTest.assertTrue((String)"First chunk write timeout", ((Integer)writeFuture.get(10L, TimeUnit.SECONDS) > 0 ? 1 : 0) != 0);
            Thread.sleep(1000L);
            byte[] secondChunk = new byte[fullMessageSize - firstChunk.length];
            Arrays.fill(secondChunk, (byte)2);
            writer.writeByteArray(secondChunk);
            writeFuture = writer.flush();
            TCPNIOTransportTest.assertTrue((String)"Second chunk write timeout", ((Integer)writeFuture.get(10L, TimeUnit.SECONDS) > 0 ? 1 : 0) != 0);
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            GrizzlyFuture readFuture = reader.notifyAvailable(fullMessageSize);
            try {
                TCPNIOTransportTest.assertTrue((String)("Read timeout. CheckSizeFilter latch: " + checkSizeFilter.latch), (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
            }
            catch (TimeoutException e) {
                TCPNIOTransportTest.assertTrue((String)("Read timeout. CheckSizeFilter latch: " + checkSizeFilter.latch), (boolean)false);
            }
            byte[] pattern = new byte[fullMessageSize];
            Arrays.fill(pattern, 0, firstChunk.length, (byte)1);
            Arrays.fill(pattern, firstChunk.length, pattern.length, (byte)2);
            byte[] echoMessage = new byte[fullMessageSize];
            reader.readByteArray(echoMessage);
            TCPNIOTransportTest.assertTrue((boolean)Arrays.equals(pattern, echoMessage));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectorSwitch() throws Exception {
        Connection connection = null;
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        final CustomChannelDistributor distributor = new CustomChannelDistributor((NIOTransport)transport);
        transport.setNIOChannelDistributor((NIOChannelDistributor)distributor);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new BaseFilter(){

            public NextAction handleAccept(FilterChainContext ctx) throws IOException {
                NIOConnection connection = (NIOConnection)ctx.getConnection();
                connection.attachToSelectorRunner(distributor.getSelectorRunner());
                return ctx.getInvokeAction();
            }
        });
        filterChainBuilder.add((Filter)new EchoFilter());
        transport.setProcessor((Processor)filterChainBuilder.build());
        transport.setSelectorRunnersCount(4);
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            TCPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.configureBlocking(true);
            byte[] originalMessage = "Hello".getBytes();
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            writer.writeByteArray(originalMessage);
            GrizzlyFuture writeFuture = writer.flush();
            TCPNIOTransportTest.assertTrue((String)"Write timeout", (boolean)writeFuture.isDone());
            TCPNIOTransportTest.assertEquals((int)originalMessage.length, (int)((Integer)writeFuture.get()));
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            GrizzlyFuture readFuture = reader.notifyAvailable(originalMessage.length);
            TCPNIOTransportTest.assertTrue((String)"Read timeout", (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
            byte[] echoMessage = new byte[originalMessage.length];
            reader.readByteArray(echoMessage);
            TCPNIOTransportTest.assertTrue((boolean)Arrays.equals(echoMessage, originalMessage));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    public static class CustomChannelDistributor
    extends AbstractNIOConnectionDistributor {
        private final AtomicInteger counter = new AtomicInteger();

        public CustomChannelDistributor(NIOTransport transport) {
            super(transport);
        }

        public void registerChannel(SelectableChannel channel, int interestOps, Object attachment) throws IOException {
            SelectorRunner runner = this.getSelectorRunner();
            this.transport.getSelectorHandler().registerChannel(runner, channel, interestOps, attachment);
        }

        public GrizzlyFuture<RegisterChannelResult> registerChannelAsync(SelectableChannel channel, int interestOps, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) throws IOException {
            SelectorRunner runner = this.getSelectorRunner();
            return this.transport.getSelectorHandler().registerChannelAsync(runner, channel, interestOps, attachment, completionHandler);
        }

        public SelectorRunner getSelectorRunner() {
            SelectorRunner[] runners = this.getTransportSelectorRunners();
            int index = this.counter.getAndIncrement() % runners.length;
            return runners[index];
        }
    }
}

