/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.ChunkingFilter;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.DelayFilter;
import org.glassfish.grizzly.utils.StringFilter;

public class ProtocolChainCodecTest
extends GrizzlyTestCase {
    private static final Logger logger = Grizzly.logger(ProtocolChainCodecTest.class);
    public static final int PORT = 7784;

    public void testSyncSingleStringEcho() throws Exception {
        this.doTestStringEcho(true, 1, new Filter[0]);
    }

    public void testAsyncSingleStringEcho() throws Exception {
        this.doTestStringEcho(false, 1, new Filter[0]);
    }

    public void testSync20StringEcho() throws Exception {
        this.doTestStringEcho(true, 20, new Filter[0]);
    }

    public void testAsync20SingleStringEcho() throws Exception {
        this.doTestStringEcho(false, 20, new Filter[0]);
    }

    public void testSyncSingleChunkedStringEcho() throws Exception {
        this.doTestStringEcho(true, 1, new Filter[]{new ChunkingFilter(1)});
    }

    public void testAsyncSingleChunkedStringEcho() throws Exception {
        this.doTestStringEcho(false, 1, new Filter[]{new ChunkingFilter(1)});
    }

    public void testSync20ChunkedStringEcho() throws Exception {
        this.doTestStringEcho(true, 20, new Filter[]{new ChunkingFilter(1)});
    }

    public void testAsync20ChunkedStringEcho() throws Exception {
        this.doTestStringEcho(false, 20, new Filter[]{new ChunkingFilter(1)});
    }

    public void testSyncDelayedSingleChunkedStringEcho() throws Exception {
        logger.info("This test execution may take several seconds");
        this.doTestStringEcho(true, 1, new Filter[]{new DelayFilter(1000L, 20L), new ChunkingFilter(1)});
    }

    public void testAsyncDelayedSingleChunkedStringEcho() throws Exception {
        logger.info("This test execution may take several seconds");
        this.doTestStringEcho(false, 1, new Filter[]{new DelayFilter(1000L, 20L), new ChunkingFilter(1)});
    }

    public void testSyncDelayed5ChunkedStringEcho() throws Exception {
        logger.info("This test execution may take several seconds");
        this.doTestStringEcho(true, 5, new Filter[]{new DelayFilter(1000L, 20L), new ChunkingFilter(1)});
    }

    public void testAsyncDelayed5ChunkedStringEcho() throws Exception {
        logger.info("This test execution may take several seconds");
        this.doTestStringEcho(false, 5, new Filter[]{new DelayFilter(1000L, 20L), new ChunkingFilter(1)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doTestStringEcho(boolean blocking, int messageNum, Filter ... filters) throws Exception {
        Connection connection = null;
        String clientMessage = "Hello server! It's a client";
        String serverMessage = "Hello client! It's a server";
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        for (Filter filter : filters) {
            filterChainBuilder.add(filter);
        }
        filterChainBuilder.add((Filter)new StringFilter());
        filterChainBuilder.add((Filter)new BaseFilter(){
            volatile int counter;

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                String message = (String)ctx.getMessage();
                logger.log(Level.FINE, "Server got message: " + message);
                Assert.assertEquals((String)("Hello server! It's a client-" + this.counter), (String)message);
                ctx.write((Object)("Hello client! It's a server-" + this.counter++));
                return ctx.getStopAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7784);
            transport.start();
            final BlockingQueue resultQueue = DataStructures.getLTQInstance(String.class);
            GrizzlyFuture future = transport.connect("localhost", 7784);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            ProtocolChainCodecTest.assertTrue((connection != null ? 1 : 0) != 0);
            FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
            clientFilterChainBuilder.add((Filter)new TransportFilter());
            clientFilterChainBuilder.add((Filter)new StringFilter());
            clientFilterChainBuilder.add((Filter)new BaseFilter(){

                public NextAction handleRead(FilterChainContext ctx) throws IOException {
                    resultQueue.add((String)ctx.getMessage());
                    return ctx.getStopAction();
                }
            });
            FilterChain clientFilterChain = clientFilterChainBuilder.build();
            connection.setProcessor((Processor)clientFilterChain);
            for (int i = 0; i < messageNum; ++i) {
                GrizzlyFuture writeFuture = connection.write((Object)("Hello server! It's a client-" + i));
                ProtocolChainCodecTest.assertTrue((String)("Write timeout loop: " + i), (writeFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
                String message = (String)resultQueue.poll(10L, TimeUnit.SECONDS);
                ProtocolChainCodecTest.assertEquals((String)("Unexpected response (" + i + ")"), (String)("Hello client! It's a server-" + i), (String)message);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }
}

