/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class GrizzlyExecutorServiceTest
extends GrizzlyTestCase {
    public void testCreateInstance() throws Exception {
        int threads = 100;
        ThreadPoolConfig cfg = new ThreadPoolConfig("test", -1, threads, null, -1, 0L, null, null, 5, null, null, -1L);
        GrizzlyExecutorService r = GrizzlyExecutorService.createInstance((ThreadPoolConfig)cfg);
        int tasks = 2000000;
        this.doTest(r, 2000000);
        ThreadPoolConfig config1 = r.getConfiguration();
        GrizzlyExecutorServiceTest.assertTrue((config1.getMaxPoolSize() == threads ? 1 : 0) != 0);
        GrizzlyExecutorServiceTest.assertTrue((config1.getQueueLimit() == cfg.getQueueLimit() ? 1 : 0) != 0);
        GrizzlyExecutorServiceTest.assertTrue((boolean)config1.getQueue().getClass().getSimpleName().contains("LinkedTransferQueue"));
        this.doTest(r.reconfigure(r.getConfiguration().setQueueLimit(2000000)), 2000000);
        ThreadPoolConfig config2 = r.getConfiguration();
        GrizzlyExecutorServiceTest.assertTrue((config2.getQueueLimit() == 2000000 ? 1 : 0) != 0);
        int coresize = r.getConfiguration().getMaxPoolSize() + 1;
        this.doTest(r.reconfigure(r.getConfiguration().setQueue(new LinkedList()).setCorePoolSize(coresize).setKeepAliveTime(1L, TimeUnit.MILLISECONDS).setMaxPoolSize(threads += 50)), 2000000);
        ThreadPoolConfig config3 = r.getConfiguration();
        GrizzlyExecutorServiceTest.assertTrue((boolean)config3.getQueue().getClass().getSimpleName().contains("LinkedList"));
        GrizzlyExecutorServiceTest.assertEquals((String)config3.getPoolName(), (String)cfg.getPoolName());
        GrizzlyExecutorServiceTest.assertTrue((config3.getQueueLimit() == 2000000 ? 1 : 0) != 0);
        GrizzlyExecutorServiceTest.assertTrue((config3.getCorePoolSize() == coresize ? 1 : 0) != 0);
        GrizzlyExecutorServiceTest.assertTrue((config3.getMaxPoolSize() == threads ? 1 : 0) != 0);
        r.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionTimeout() throws Exception {
        ExecutorService threadPool = Executors.newSingleThreadExecutor();
        try {
            DelayedExecutor delayedExecutor = new DelayedExecutor(threadPool);
            int tasksNum = 10;
            long transactionTimeoutMillis = 5000L;
            final CountDownLatch cdl = new CountDownLatch(10);
            ThreadPoolConfig tpc = ThreadPoolConfig.defaultConfig().setTransactionTimeout(delayedExecutor, 5000L, TimeUnit.MILLISECONDS).setCorePoolSize(5).setMaxPoolSize(5);
            GrizzlyExecutorService ges = GrizzlyExecutorService.createInstance((ThreadPoolConfig)tpc);
            for (int i = 0; i < 10; ++i) {
                ges.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            cdl.countDown();
                        }
                    }
                });
            }
            cdl.await(7500L, TimeUnit.MILLISECONDS);
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    private void doTest(GrizzlyExecutorService r, int tasks) throws Exception {
        final CountDownLatch cl = new CountDownLatch(tasks);
        while (tasks-- > 0) {
            r.execute(new Runnable(){

                @Override
                public void run() {
                    cl.countDown();
                }
            });
        }
        GrizzlyExecutorServiceTest.assertTrue((String)"latch timed out", (boolean)cl.await(30L, TimeUnit.SECONDS));
    }
}

