/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.HeapBuffer;
import org.glassfish.grizzly.memory.HeapMemoryManager;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.MemoryProbe;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class DefaultMemoryManagerTest
extends GrizzlyTestCase {
    private static final Logger LOGGER = Grizzly.logger(DefaultMemoryManagerTest.class);

    public void testDispose() throws Exception {
        final HeapMemoryManager mm = new HeapMemoryManager();
        mm.getMonitoringConfig().addProbes((Object[])new MemoryProbe[]{new MyMemoryMonitoringProbe()});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int allocSize = 16384;
                mm.allocate(33);
                int initialSize = mm.getReadyThreadBufferSize();
                HeapBuffer buffer = mm.allocate(16384);
                Assert.assertEquals((int)(initialSize - 16384), (int)mm.getReadyThreadBufferSize());
                buffer.dispose();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
            }
        };
        this.testInWorkerThread((MemoryManager)mm, r);
    }

    public void testTrimDispose() throws Exception {
        final HeapMemoryManager mm = new HeapMemoryManager();
        mm.getMonitoringConfig().addProbes((Object[])new MemoryProbe[]{new MyMemoryMonitoringProbe()});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int allocSize = 16384;
                mm.allocate(33);
                int initialSize = mm.getReadyThreadBufferSize();
                HeapBuffer buffer = mm.allocate(16384);
                Assert.assertEquals((int)(initialSize - 16384), (int)mm.getReadyThreadBufferSize());
                buffer.position(8192);
                buffer.trim();
                Assert.assertEquals((int)(initialSize - 8192), (int)mm.getReadyThreadBufferSize());
                buffer.dispose();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
            }
        };
        this.testInWorkerThread((MemoryManager)mm, r);
    }

    public void testReallocate() throws Exception {
        final HeapMemoryManager mm = new HeapMemoryManager();
        mm.getMonitoringConfig().addProbes((Object[])new MemoryProbe[]{new MyMemoryMonitoringProbe()});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int allocSize = 16384;
                mm.allocate(33);
                int initialSize = mm.getReadyThreadBufferSize();
                HeapBuffer buffer = mm.allocate(16384);
                Assert.assertEquals((int)(initialSize - 16384), (int)mm.getReadyThreadBufferSize());
                buffer.position(8192);
                buffer.trim();
                Assert.assertEquals((int)(initialSize - 8192), (int)mm.getReadyThreadBufferSize());
                buffer.dispose();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
                buffer = mm.allocate(8192);
                Assert.assertEquals((int)(initialSize - 8192), (int)mm.getReadyThreadBufferSize());
                buffer = mm.reallocate(buffer, 16384);
                Assert.assertEquals((int)(initialSize - 16384), (int)mm.getReadyThreadBufferSize());
                buffer.dispose();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
            }
        };
        this.testInWorkerThread((MemoryManager)mm, r);
    }

    public void testSimpleAllocateHistory() throws Exception {
        final HeapMemoryManager mm = new HeapMemoryManager();
        mm.getMonitoringConfig().addProbes((Object[])new MemoryProbe[]{new MyMemoryMonitoringProbe()});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int allocSize = 16384;
                mm.allocate(33);
                int initialSize = mm.getReadyThreadBufferSize();
                int chunkSize = 4096;
                HeapBuffer buffer1 = mm.allocate(4096);
                Assert.assertEquals((int)(initialSize - 4096), (int)mm.getReadyThreadBufferSize());
                HeapBuffer buffer2 = mm.allocate(4096);
                Assert.assertEquals((int)(initialSize - 8192), (int)mm.getReadyThreadBufferSize());
                HeapBuffer buffer3 = mm.allocate(4096);
                Assert.assertEquals((int)(initialSize - 12288), (int)mm.getReadyThreadBufferSize());
                HeapBuffer buffer4 = mm.allocate(4096);
                Assert.assertEquals((int)(initialSize - 16384), (int)mm.getReadyThreadBufferSize());
                buffer4.dispose();
                Assert.assertEquals((int)(initialSize - 12288), (int)mm.getReadyThreadBufferSize());
                buffer3.dispose();
                Assert.assertEquals((int)(initialSize - 8192), (int)mm.getReadyThreadBufferSize());
                buffer2.dispose();
                Assert.assertEquals((int)(initialSize - 4096), (int)mm.getReadyThreadBufferSize());
                buffer1.dispose();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
            }
        };
        this.testInWorkerThread((MemoryManager)mm, r);
    }

    public void testTrimAllocateHistory() throws Exception {
        final HeapMemoryManager mm = new HeapMemoryManager();
        mm.getMonitoringConfig().addProbes((Object[])new MemoryProbe[]{new MyMemoryMonitoringProbe()});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int allocSize = 16384;
                mm.allocate(33);
                int initialSize = mm.getReadyThreadBufferSize();
                int chunkSize = 4096;
                HeapBuffer buffer1 = mm.allocate(4096);
                Assert.assertEquals((int)(initialSize - 4096), (int)mm.getReadyThreadBufferSize());
                buffer1.position(2048);
                buffer1.trim();
                Assert.assertEquals((int)(initialSize - 2048), (int)mm.getReadyThreadBufferSize());
                HeapBuffer buffer2 = mm.allocate(4096);
                Assert.assertEquals((int)(initialSize - 6144), (int)mm.getReadyThreadBufferSize());
                buffer2.position(2048);
                buffer2.trim();
                Assert.assertEquals((int)(initialSize - 4096), (int)mm.getReadyThreadBufferSize());
                buffer2.dispose();
                Assert.assertEquals((int)(initialSize - 2048), (int)mm.getReadyThreadBufferSize());
                buffer1.dispose();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
            }
        };
        this.testInWorkerThread((MemoryManager)mm, r);
    }

    public void testDisposeUnused() throws Exception {
        final HeapMemoryManager mm = new HeapMemoryManager();
        mm.getMonitoringConfig().addProbes((Object[])new MemoryProbe[]{new MyMemoryMonitoringProbe()});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                mm.allocate(33);
                int initialSize = mm.getReadyThreadBufferSize();
                CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)mm);
                for (int i = 0; i < 11; ++i) {
                    HeapBuffer b = mm.allocate(1228);
                    b.allowBufferDispose(true);
                    compositeBuffer.append((Object)b);
                }
                compositeBuffer.toByteBufferArray(0, 12280);
                compositeBuffer.limit(1228);
                compositeBuffer.shrink();
                Assert.assertEquals((int)(initialSize - 1228), (int)mm.getReadyThreadBufferSize());
                compositeBuffer.position(compositeBuffer.limit());
                compositeBuffer.shrink();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
            }
        };
        this.testInWorkerThread((MemoryManager)mm, r);
    }

    public void testBufferPut() {
        HeapMemoryManager mm = new HeapMemoryManager();
        HeapBuffer b = mm.allocate(127);
        int i = 0;
        while (b.hasRemaining()) {
            b.put((byte)i++);
        }
        b.flip();
        b.put((Buffer)b, 10, 117).flip();
        DefaultMemoryManagerTest.assertEquals((int)117, (int)b.remaining());
        i = 10;
        while (b.hasRemaining()) {
            DefaultMemoryManagerTest.assertEquals((int)i++, (int)b.get());
        }
    }

    public void testCompositeBufferDispose() throws Exception {
        final HeapMemoryManager mm = new HeapMemoryManager();
        mm.getMonitoringConfig().addProbes((Object[])new MemoryProbe[]{new MyMemoryMonitoringProbe()});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                mm.allocate(33);
                int initialSize = mm.getReadyThreadBufferSize();
                CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)mm);
                for (int i = 0; i < 3; ++i) {
                    HeapBuffer b = mm.allocate(100);
                    b.allowBufferDispose(true);
                    compositeBuffer.append((Object)b);
                }
                compositeBuffer.toByteBuffer(0, 100);
                compositeBuffer.position(100);
                compositeBuffer.dispose();
                Assert.assertEquals((int)initialSize, (int)mm.getReadyThreadBufferSize());
            }
        };
        this.testInWorkerThread((MemoryManager)mm, r);
    }

    private void testInWorkerThread(MemoryManager mm, final Runnable task) throws Exception {
        SafeFutureImpl future = SafeFutureImpl.create();
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig();
        config.setMemoryManager(mm);
        GrizzlyExecutorService threadPool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)config);
        threadPool.execute(new Runnable((FutureImpl)future){
            final /* synthetic */ FutureImpl val$future;
            {
                this.val$future = futureImpl;
            }

            @Override
            public void run() {
                try {
                    task.run();
                    this.val$future.result((Object)Boolean.TRUE);
                }
                catch (Throwable e) {
                    this.val$future.failure(e);
                }
            }
        });
        DefaultMemoryManagerTest.assertTrue((boolean)((Boolean)future.get(10L, TimeUnit.SECONDS)));
    }

    private static class MyMemoryMonitoringProbe
    implements MemoryProbe {
        private MyMemoryMonitoringProbe() {
        }

        public void onBufferAllocateEvent(int size) {
            LOGGER.log(Level.INFO, "allocateNewBufferEvent: {0}", size);
        }

        public void onBufferAllocateFromPoolEvent(int size) {
            LOGGER.log(Level.INFO, "allocateBufferFromPoolEvent: {0}", size);
        }

        public void onBufferReleaseToPoolEvent(int size) {
            LOGGER.log(Level.INFO, "releaseBufferToPoolEvent: {0}", size);
        }
    }
}

