/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.TrustBundleDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class TrustBundleDaoImpl
implements TrustBundleDao {
    private static final Log log = LogFactory.getLog(TrustBundleDaoImpl.class);
    @PersistenceContext
    @Autowired
    protected EntityManager entityManager;
    protected DomainDao domainDao;

    @Autowired
    public void setDomainDao(DomainDao domainDao) {
        this.domainDao = domainDao;
    }

    protected void validateState() throws ConfigurationStoreException {
        if (this.entityManager == null) {
            throw new IllegalStateException("entityManger has not been initialized");
        }
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<TrustBundle> getTrustBundles() throws ConfigurationStoreException {
        List rs;
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT tb from TrustBundle tb");
            rs = select.getResultList();
            if (rs.size() == 0) {
                return Collections.emptyList();
            }
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute trust bundle DAO query.", e);
        }
        for (TrustBundle bundle : rs) {
            if (bundle.getTrustBundleAnchors().isEmpty()) continue;
            for (TrustBundleAnchor anchor : bundle.getTrustBundleAnchors()) {
                anchor.getData();
            }
        }
        return rs;
    }

    @Override
    @Transactional(readOnly=true)
    public TrustBundle getTrustBundleByName(String bundleName) throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT tb from TrustBundle tb WHERE UPPER(tb.bundleName) = ?1");
            select.setParameter(1, (Object)bundleName.toUpperCase(Locale.getDefault()));
            TrustBundle rs = (TrustBundle)select.getSingleResult();
            if (!rs.getTrustBundleAnchors().isEmpty()) {
                for (TrustBundleAnchor anchor : rs.getTrustBundleAnchors()) {
                    anchor.getData();
                }
            }
            return rs;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute trust bundle DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public TrustBundle getTrustBundleById(long id) throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT tb from TrustBundle tb WHERE tb.id = ?1");
            select.setParameter(1, (Object)id);
            TrustBundle rs = (TrustBundle)select.getSingleResult();
            if (!rs.getTrustBundleAnchors().isEmpty()) {
                for (TrustBundleAnchor anchor : rs.getTrustBundleAnchors()) {
                    anchor.getData();
                }
            }
            return rs;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute trust bundle DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void addTrustBundle(TrustBundle bundle) throws ConfigurationStoreException {
        this.validateState();
        try {
            TrustBundle existingBundle = this.getTrustBundleByName(bundle.getBundleName());
            if (existingBundle != null) {
                throw new ConfigurationStoreException("Trust bundle " + bundle.getBundleName() + " already exists");
            }
            bundle.setCreateTime(Calendar.getInstance(Locale.getDefault()));
            this.entityManager.persist((Object)bundle);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to add trust bundle " + bundle.getBundleName(), e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void updateTrustBundleAnchors(long trustBundleId, Calendar attemptTime, Collection<TrustBundleAnchor> newAnchorSet, String bundleCheckSum) throws ConfigurationStoreException {
        this.validateState();
        try {
            TrustBundle existingBundle = this.getTrustBundleById(trustBundleId);
            if (existingBundle == null) {
                throw new ConfigurationStoreException("Trust bundle does not exist");
            }
            Query delete = this.entityManager.createQuery("DELETE from TrustBundleAnchor tba where tba.trustBundle = ?1");
            delete.setParameter(1, (Object)existingBundle);
            delete.executeUpdate();
            existingBundle.setCheckSum(bundleCheckSum);
            existingBundle.setTrustBundleAnchors(newAnchorSet);
            existingBundle.setLastRefreshAttempt(attemptTime);
            existingBundle.setLastSuccessfulRefresh(Calendar.getInstance(Locale.getDefault()));
            this.entityManager.persist((Object)existingBundle);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to update anchors in trust bundle.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void updateLastUpdateError(long trustBundleId, Calendar attemptTime, BundleRefreshError error) throws ConfigurationStoreException {
        this.validateState();
        try {
            TrustBundle existingBundle = this.getTrustBundleById(trustBundleId);
            if (existingBundle == null) {
                throw new ConfigurationStoreException("Trust bundle does not exist");
            }
            existingBundle.setLastRefreshAttempt(attemptTime);
            existingBundle.setLastRefreshError(error);
            this.entityManager.persist((Object)existingBundle);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to update bundle last refresh error.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void deleteTrustBundles(long[] trustBundleIds) throws ConfigurationStoreException {
        this.validateState();
        if (trustBundleIds == null || trustBundleIds.length == 0) {
            return;
        }
        for (long id : trustBundleIds) {
            try {
                TrustBundle bundle = this.getTrustBundleById(id);
                this.disassociateTrustBundleFromDomains(id);
                this.entityManager.remove((Object)bundle);
                this.entityManager.flush();
            }
            catch (ConfigurationStoreException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void updateTrustBundleSigningCertificate(long trustBundleId, X509Certificate signingCert) throws ConfigurationStoreException {
        this.validateState();
        try {
            TrustBundle existingBundle = this.getTrustBundleById(trustBundleId);
            if (existingBundle == null) {
                throw new ConfigurationStoreException("Trust bundle does not exist");
            }
            if (signingCert == null) {
                existingBundle.setSigningCertificateData(null);
            } else {
                existingBundle.setSigningCertificateData(signingCert.getEncoded());
            }
            this.entityManager.persist((Object)existingBundle);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to update bundle last refresh error.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void updateTrustBundleAttributes(long trustBundleId, String bundleName, String bundleUrl, X509Certificate signingCert, int refreshInterval) throws ConfigurationStoreException {
        this.validateState();
        try {
            TrustBundle existingBundle = this.getTrustBundleById(trustBundleId);
            if (existingBundle == null) {
                throw new ConfigurationStoreException("Trust bundle does not exist");
            }
            if (signingCert == null) {
                existingBundle.setSigningCertificateData(null);
            } else {
                existingBundle.setSigningCertificateData(signingCert.getEncoded());
            }
            existingBundle.setRefreshInterval(refreshInterval);
            if (bundleName != null && !bundleName.isEmpty()) {
                existingBundle.setBundleName(bundleName);
            }
            if (bundleUrl != null && !bundleUrl.isEmpty()) {
                existingBundle.setBundleURL(bundleUrl);
            }
            this.entityManager.persist((Object)existingBundle);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to update bundle last refresh error.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void associateTrustBundleToDomain(long domainId, long trustBundleId, boolean incoming, boolean outgoing) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        TrustBundle trustBundle = this.getTrustBundleById(trustBundleId);
        if (trustBundle == null) {
            throw new ConfigurationStoreException("Trust budnel with id " + trustBundle + " does not exist");
        }
        try {
            TrustBundleDomainReltn domainTrustBundleAssoc = new TrustBundleDomainReltn();
            domainTrustBundleAssoc.setDomain(domain);
            domainTrustBundleAssoc.setTrustBundle(trustBundle);
            domainTrustBundleAssoc.setIncoming(incoming);
            domainTrustBundleAssoc.setOutgoing(outgoing);
            this.entityManager.persist((Object)domainTrustBundleAssoc);
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to associate trust bundle to domain.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void disassociateTrustBundleFromDomain(long domainId, long trustBundleId) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        TrustBundle trustBundle = this.getTrustBundleById(trustBundleId);
        if (trustBundle == null) {
            throw new ConfigurationStoreException("Trust budnel with id " + trustBundle + " does not exist");
        }
        try {
            Query select = this.entityManager.createQuery("SELECT tbd from TrustBundleDomainReltn tbd where tbd.domain  = ?1  and tbd.trustBundle = ?2 ");
            select.setParameter(1, (Object)domain);
            select.setParameter(2, (Object)trustBundle);
            TrustBundleDomainReltn reltn = (TrustBundleDomainReltn)select.getSingleResult();
            this.entityManager.remove((Object)reltn);
            this.entityManager.flush();
        }
        catch (NoResultException e) {
            throw new ConfigurationStoreException("Association between domain id " + domainId + " and trust bundle id" + trustBundleId + " does not exist", e);
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to delete trust bundle to domain relation.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void disassociateTrustBundlesFromDomain(long domainId) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        try {
            Query delete = this.entityManager.createQuery("DELETE from TrustBundleDomainReltn tbd where tbd.domain  = ?1");
            delete.setParameter(1, (Object)domain);
            delete.executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to dissaccociate trust bundle from domain id ." + domainId, e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void disassociateTrustBundleFromDomains(long trustBundleId) throws ConfigurationStoreException {
        this.validateState();
        TrustBundle trustBundle = this.getTrustBundleById(trustBundleId);
        if (trustBundle == null) {
            throw new ConfigurationStoreException("Trust budnel with id " + trustBundle + " does not exist");
        }
        try {
            Query delete = this.entityManager.createQuery("DELETE from TrustBundleDomainReltn tbd where tbd.trustBundle  = ?1");
            delete.setParameter(1, (Object)trustBundle);
            delete.executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to dissaccociate domains from trust bundle id ." + trustBundleId, e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<TrustBundleDomainReltn> getTrustBundlesByDomain(long domainId) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        List retVal = null;
        try {
            Query select = this.entityManager.createQuery("SELECT tbd from TrustBundleDomainReltn tbd where tbd.domain = ?1");
            select.setParameter(1, (Object)domain);
            retVal = select.getResultList();
            if (retVal.size() == 0) {
                return Collections.emptyList();
            }
            for (TrustBundleDomainReltn reltn : retVal) {
                if (reltn.getTrustBundle().getTrustBundleAnchors().isEmpty()) continue;
                for (TrustBundleAnchor anchor : reltn.getTrustBundle().getTrustBundleAnchors()) {
                    anchor.getData();
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute trust bundle relation DAO query.", e);
        }
        return retVal;
    }
}

