/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.lang.reflect.Constructor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.delegate.DelegateDomain;
import org.eclipse.ocl.ecore.opposites.EcoreEnvironmentFactoryWithHiddenOpposites;

public class OCLDelegateDomain
implements DelegateDomain {
    public static final String OCL_DELEGATE_URI = "http://www.eclipse.org/emf/2002/Ecore/OCL";
    public static final String KEY_FOR_ENVIRONMENT_FACTORY_CLASS = "environmentFactoryClass";
    public static final String OCL_DELEGATES_USE_HIDDEN_OPPOSITES_KEY = "hiddenOpposites";
    protected final String uri;
    protected final EPackage ePackage;
    protected final OCL ocl;

    public OCLDelegateDomain(String delegateURI, EPackage ePackage) {
        ResourceSet resourceSet;
        this.uri = delegateURI;
        this.ePackage = ePackage;
        Resource res = ePackage.eResource();
        EPackage.Registry packageRegistry = null;
        if (res != null && (resourceSet = res.getResourceSet()) != null) {
            packageRegistry = resourceSet.getPackageRegistry();
        }
        if (packageRegistry == null) {
            packageRegistry = EPackage.Registry.INSTANCE;
        }
        EcoreEnvironmentFactory envFactory = null;
        EAnnotation eAnnotation = ePackage.getEAnnotation(OCL_DELEGATE_URI);
        if (eAnnotation != null) {
            EMap details = eAnnotation.getDetails();
            String clsName = (String)details.get((Object)KEY_FOR_ENVIRONMENT_FACTORY_CLASS);
            if (clsName != null) {
                ClassLoader classLoader = ePackage.getClass().getClassLoader();
                try {
                    Class<?> cls = classLoader.loadClass(clsName);
                    Constructor<?> con = cls.getConstructor(EPackage.Registry.class);
                    envFactory = (EcoreEnvironmentFactory)((Object)con.newInstance(packageRegistry));
                }
                catch (Exception e) {
                    throw new WrappedException("Error instantiating environmentFactoryClass " + clsName + ": " + e.getMessage(), e);
                }
            } else {
                String value = (String)details.get((Object)OCL_DELEGATES_USE_HIDDEN_OPPOSITES_KEY);
                if (value != null && Boolean.valueOf(value).booleanValue()) {
                    envFactory = new EcoreEnvironmentFactoryWithHiddenOpposites(packageRegistry);
                }
            }
        }
        if (envFactory == null) {
            envFactory = new EcoreEnvironmentFactory(packageRegistry);
        }
        this.ocl = OCL.newInstance(envFactory);
    }

    public void dispose() {
        if (this.ocl != null) {
            this.ocl.dispose();
        }
    }

    public OCL getOCL() {
        return this.ocl;
    }

    public String getURI() {
        return this.uri;
    }

    public String toString() {
        return String.valueOf(this.ePackage.getName()) + " : " + this.getURI();
    }
}

