/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail;

import java.util.Locale;

public class MimeStandard {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";
    public static final char Escape = '\\';
    public static final char NameValueSeparator = ':';
    public static final char BoundaryChar = '-';
    public static final String BoundarySeparator = "--";
    public static final String HeaderPrefix = "Content-";
    public static final String VersionHeader = "MIME-Version";
    public static final String ContentTypeHeader = "Content-Type";
    public static final String ContentIDHeader = "Content-ID";
    public static final String ContentDispositionHeader = "Content-Disposition";
    public static final String ContentDescriptionHeader = "Content-Description";
    public static final String ContentTransferEncodingHeader = "Content-Transfer-Encoding";
    public static final String TransferEncodingBase64 = "base64";
    public static final String TransferEncoding7Bit = "7bit";
    public static final String TransferEncodingQuoted = "quoted-printable";
    public static final String MailAddressSeparator = ",";

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    public static String combine(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("value");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        builder.append(':').append(" ");
        builder.append(value);
        return builder.toString();
    }

    public static boolean equals(String x, String y) {
        return String.CASE_INSENSITIVE_ORDER.compare(x, y) == 0;
    }

    public static boolean startsWith(String x, String y) {
        if (y.length() > x.length()) {
            return false;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(x.substring(0, y.length()), y) == 0;
    }

    public static boolean contains(String x, String y) {
        return x.toLowerCase(Locale.getDefault()).indexOf(y.toLowerCase(Locale.getDefault())) >= 0;
    }

    public static class MediaType {
        public static final String TextPlain = "text/plain";
        public static final String Default = "text/plain";
        public static final String Multipart = "multipart";
        public static final String MultipartMixed = "multipart/mixed;";
    }
}

