/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.nhindirect.stagent.AddressSource;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;

public class NHINDAddressCollection
extends ArrayList<NHINDAddress> {
    static final long serialVersionUID = -2750152014905400257L;
    public static final TrustEnforcementStatus DefaultMinTrustStatus = TrustEnforcementStatus.Success_Offline;

    public Collection<X509Certificate> getCertificates() {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (NHINDAddress add : this) {
            if (!add.hasCertificates()) continue;
            certs.addAll(add.getCertificates());
        }
        return certs;
    }

    public X509Certificate getFirstCertificate() {
        for (NHINDAddress add : this) {
            if (!add.hasCertificates()) continue;
            return add.getCertificates().iterator().next();
        }
        return null;
    }

    public Collection<NHINDAddress> getTrusted() {
        return this.getTrusted(DefaultMinTrustStatus);
    }

    public Collection<NHINDAddress> getTrusted(TrustEnforcementStatus minTrustStatus) {
        ArrayList<NHINDAddress> adds = new ArrayList<NHINDAddress>();
        for (NHINDAddress add : this) {
            if (!add.isTrusted(minTrustStatus)) continue;
            adds.add(add);
        }
        return adds;
    }

    public Collection<NHINDAddress> getUntrusted() {
        return this.getUntrusted(DefaultMinTrustStatus);
    }

    public Collection<NHINDAddress> getUntrusted(TrustEnforcementStatus minTrustStatus) {
        ArrayList<NHINDAddress> adds = new ArrayList<NHINDAddress>();
        for (NHINDAddress add : this) {
            if (add.isTrusted(minTrustStatus)) continue;
            adds.add(add);
        }
        return adds;
    }

    public boolean isTrusted() {
        return this.isTrusted(DefaultMinTrustStatus);
    }

    public boolean isTrusted(TrustEnforcementStatus minTrustStatus) {
        for (NHINDAddress add : this) {
            if (add.isTrusted(minTrustStatus)) continue;
            return false;
        }
        return true;
    }

    public void removeUntrusted() {
        this.removeUntrusted(DefaultMinTrustStatus);
    }

    public void removeUntrusted(TrustEnforcementStatus minTrustStatus) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (((NHINDAddress)((Object)this.get(i))).isTrusted(minTrustStatus)) continue;
            this.remove(i);
        }
    }

    public Collection<InternetAddress> toInternetAddressCollection() {
        ArrayList<InternetAddress> retVal = new ArrayList<InternetAddress>();
        retVal.addAll(this);
        return retVal;
    }

    public void setSource(AddressSource source) {
        for (NHINDAddress addr : this) {
            addr.setSource(source);
        }
    }

    @Override
    public String toString() {
        return InternetAddress.toString((Address[])((Address[])this.toArray(new InternetAddress[this.size()])));
    }

    public static NHINDAddressCollection create(Collection<NHINDAddress> source) {
        NHINDAddressCollection addresses = new NHINDAddressCollection();
        addresses.addAll(source);
        return addresses;
    }

    public static NHINDAddressCollection parse(String addressesLine, AddressSource source) {
        NHINDAddressCollection retVal = new NHINDAddressCollection();
        if (addressesLine != null) {
            int index = addressesLine.indexOf(58);
            String addressString = index > -1 ? addressesLine.substring(index + 1) : addressesLine;
            InternetAddress[] addresses = null;
            try {
                addresses = InternetAddress.parseHeader((String)addressString, (boolean)true);
            }
            catch (AddressException e) {
                throw new NHINDException("Invalid email address format.", (Exception)((Object)e));
            }
            for (InternetAddress addr : addresses) {
                retVal.add(new NHINDAddress(addr.getAddress(), source));
            }
        }
        return retVal;
    }
}

