/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.security.cert.X509Certificate;
import org.bouncycastle.cms.SignerInformation;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.MessageSignature;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.cert.Thumbprint;

public class DefaultMessageSignatureImpl
implements MessageSignature {
    private boolean signatureValid;
    private SignerInformation signer;
    private boolean useOrgCertificate;
    private boolean thumbprintVerified;
    private X509Certificate signerCert;

    public DefaultMessageSignatureImpl(SignerInformation signer, boolean useOrgCert, X509Certificate cert) {
        if (signer == null) {
            throw new IllegalArgumentException();
        }
        this.signer = signer;
        this.signatureValid = false;
        this.useOrgCertificate = useOrgCert;
        this.thumbprintVerified = false;
        this.signerCert = cert;
    }

    public X509Certificate getSignerCert() {
        return this.signerCert;
    }

    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    public SignerInformation getSigner() {
        return this.signer;
    }

    public boolean isUseOrgCertificate() {
        return this.useOrgCertificate;
    }

    public boolean isThumbprintVerified() {
        return this.thumbprintVerified;
    }

    @Override
    public boolean checkSignature() {
        try {
            this.signatureValid = this.signer.verify(this.signerCert, CryptoExtensions.getJCEProviderName());
        }
        catch (Exception e) {
            this.signatureValid = false;
        }
        return this.signatureValid;
    }

    @Override
    public boolean checkThumbprint(NHINDAddress messageSender) {
        this.thumbprintVerified = false;
        Thumbprint sigThumbprint = Thumbprint.toThumbprint(this.getSignerCert());
        if (messageSender.hasCertificates()) {
            for (X509Certificate checkCert : messageSender.getCertificates()) {
                if (!sigThumbprint.equals(Thumbprint.toThumbprint(checkCert))) continue;
                this.thumbprintVerified = true;
                break;
            }
        }
        return this.thumbprintVerified;
    }
}

