/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.nhindirect.stagent.cert.SignerCertPair;
import org.nhindirect.stagent.cert.Thumbprint;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class CryptoExtensions {
    private static final String DEFAULT_JCE_PROVIDER_STRING = "BC";
    private static final String DEFAULT_JCE_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final int RFC822Name_TYPE = 1;
    private static final int DNSName_TYPE = 2;
    private static CertificateFactory certFactory;

    public static void registerJCEProviders() {
        String[] providerClasses = null;
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES");
        providerClasses = param == null || param.getParamValue() == null || param.getParamValue().isEmpty() ? new String[]{DEFAULT_JCE_PROVIDER_CLASS} : param.getParamValue().split(",");
        for (String providerClass : providerClasses) {
            try {
                Class<?> providerClazz = CryptoExtensions.class.getClassLoader().loadClass(providerClass);
                Provider provider = (Provider)Provider.class.cast(providerClazz.newInstance());
                if (Security.getProvider(provider.getName()) != null) continue;
                Security.addProvider(provider);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not load and/or register JCE provider " + providerClass, e);
            }
        }
    }

    public static String getJCEProviderName() {
        String retVal = "";
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER");
        if (param == null || param.getParamValue() == null || param.getParamValue().isEmpty()) {
            retVal = DEFAULT_JCE_PROVIDER_STRING;
        } else {
            String[] JCEString = param.getParamValue().split(",");
            retVal = JCEString[0];
        }
        return retVal;
    }

    public static String getJCEProviderNameForTypeAndAlgorithm(String type, String algorithm) {
        String[] JCEString = null;
        String retVal = "";
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER");
        if (param == null || param.getParamValue() == null || param.getParamValue().isEmpty()) {
            JCEString = new String[]{DEFAULT_JCE_PROVIDER_STRING};
        } else {
            String configuredJCEString = param.getParamValue();
            JCEString = configuredJCEString.split(",");
        }
        for (String provierString : JCEString) {
            Provider provider = Security.getProvider(provierString);
            if (provider == null || provider.getService(type, algorithm) == null) continue;
            retVal = provierString;
            break;
        }
        return retVal;
    }

    public static void setJCEProviderName(String name) {
        OptionsParameter param = name == null || name.isEmpty() ? new OptionsParameter("JCE_PROVIDER", DEFAULT_JCE_PROVIDER_STRING) : new OptionsParameter("JCE_PROVIDER", name);
        OptionsManager.getInstance().setOptionsParameter(param);
    }

    public static boolean isEqualThumbprint(X509Certificate cert1, X509Certificate cert2) {
        return Thumbprint.toThumbprint(cert1).equals(Thumbprint.toThumbprint(cert2));
    }

    public static boolean containsEmailAddressInSubjectAltName(X509Certificate cert, String subjectName) {
        boolean searchingForEmailAddress = subjectName.toLowerCase(Locale.getDefault()).startsWith("emailaddress=");
        subjectName = searchingForEmailAddress ? subjectName.toLowerCase().replaceFirst("^emailaddress=", "") : subjectName;
        Collection<List<?>> altNames = null;
        try {
            altNames = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException ex) {
            return false;
        }
        if (altNames != null) {
            for (List<?> entries : altNames) {
                String name;
                Integer nameType;
                if (entries.size() < 2 || (nameType = (Integer)entries.get(0)) != 1 && nameType != 2 || !(name = (String)entries.get(1)).toLowerCase(Locale.getDefault()).equals(subjectName.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean certSubjectContainsName(X509Certificate cert, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        if (cert == null) {
            throw new IllegalArgumentException("Certificate cannot be null.");
        }
        boolean searchingForEmailAddress = name.toLowerCase(Locale.getDefault()).startsWith("emailaddress=");
        name = searchingForEmailAddress ? name.toLowerCase().replaceFirst("^emailaddress=", "") : name;
        String address = CryptoExtensions.getSubjectAddress(cert);
        if (address == null || address.isEmpty()) {
            return false;
        }
        return name.toLowerCase(Locale.getDefault()).equals(address.toLowerCase(Locale.getDefault()));
    }

    public static boolean matchName(X509Certificate cert, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        String distinguishedName = "CN=" + name;
        return cert.getSubjectDN().getName().toUpperCase(Locale.getDefault()).contains(distinguishedName.toUpperCase(Locale.getDefault()));
    }

    public static Collection<SignerCertPair> findSignersByName(CMSSignedData signedData, String name, Collection<String> excludeNames) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<SignerCertPair> retVal = null;
        try {
            CertStore certs = signedData.getCertificatesAndCRLs("Collection", CryptoExtensions.getJCEProviderName());
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                X509Certificate cert;
                Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signer.getSID());
                if (certCollection == null || certCollection.size() <= 0 || !CryptoExtensions.certSubjectContainsName(cert = (X509Certificate)certCollection.iterator().next(), name)) continue;
                boolean exclude = false;
                if (excludeNames != null) {
                    for (String excludeStr : excludeNames) {
                        if (!CryptoExtensions.certSubjectContainsName(cert, excludeStr)) continue;
                        exclude = true;
                        break;
                    }
                }
                if (exclude) continue;
                if (retVal == null) {
                    retVal = new ArrayList<SignerCertPair>();
                }
                retVal.add(new SignerCertPair(signer, CryptoExtensions.convertToProfileProvidedCertImpl(cert)));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (retVal == null) {
            return Collections.emptyList();
        }
        return retVal;
    }

    public static X509Certificate findCertByName(Collection<X509Certificate> certs, String name) {
        for (X509Certificate cert : certs) {
            if (!CryptoExtensions.certSubjectContainsName(cert, name)) continue;
            return cert;
        }
        return null;
    }

    public static SignerCertPair findSignerByCert(CMSSignedData signedData, X509Certificate searchCert) {
        if (searchCert == null) {
            throw new IllegalArgumentException();
        }
        try {
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                SignerId signerId = signer.getSID();
                if (!signerId.getIssuer().equals(searchCert.getIssuerX500Principal()) || !signerId.getSerialNumber().equals(searchCert.getSerialNumber())) continue;
                return new SignerCertPair(signer, searchCert);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static X509Certificate convertToProfileProvidedCertImpl(X509Certificate certToConvert) {
        X509Certificate retVal = null;
        try {
            BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(certToConvert.getEncoded()));
            retVal = (X509Certificate)certFactory.generateCertificate(stream);
            IOUtils.closeQuietly((InputStream)stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getSubjectAddress(X509Certificate certificate) {
        String address = "";
        Collection<List<?>> altNames = null;
        try {
            altNames = certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException ex) {
            // empty catch block
        }
        if (altNames != null) {
            for (List<?> entries : altNames) {
                if (entries.size() < 2) continue;
                Integer nameType = (Integer)entries.get(0);
                if (nameType == 1) {
                    address = (String)entries.get(1);
                    continue;
                }
                if (nameType != 2 || !address.isEmpty()) continue;
                address = (String)entries.get(1);
            }
        }
        if (!address.isEmpty()) {
            return address;
        }
        X500Principal issuerPrin = certificate.getSubjectX500Principal();
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = issuerPrin.getName("RFC1779", oidMap);
        String searchString = "EMAILADDRESS=";
        int index = prinName.indexOf(searchString);
        if (index == -1 && (index = prinName.indexOf(searchString = "CN=")) == -1) {
            return "";
        }
        int endIndex = prinName.indexOf(",", index);
        address = endIndex > -1 ? prinName.substring(index + searchString.length(), endIndex) : prinName.substring(index + searchString.length());
        return address;
    }

    static {
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

