/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.smtp.MessageProcessResult;
import org.nhindirect.gateway.smtp.james.mailet.LogMessage;
import org.nhindirect.gateway.smtp.james.mailet.MailetProperties;
import org.nhindirect.gateway.smtp.james.mailet.NHINDSecurityAndTrustMailet;
import org.nhindirect.gateway.smtp.james.mailet.SendErrors;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;

public class NHINDSecurityAndTrustMailetCust
extends NHINDSecurityAndTrustMailet {
    boolean debuging = true;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(NHINDSecurityAndTrustMailet.class);

    public void init() throws MessagingException {
        System.setProperty("jsse.enableCBCProtection", "false");
        try {
            SendErrors.startThread();
        }
        catch (SendErrors.MailetPropertiesException e) {
            LOGGER.error((Object)"Failed to load properties");
            throw new MessagingException("Failed to start SendErrors Thread");
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPreprocessMessage(Mail mail) {
        if (mail.getSender() != null) {
            boolean isInbound = false;
            if (!this.getMailetContext().isLocalServer(mail.getSender().getDomain().toLowerCase(Locale.getDefault()))) {
                isInbound = true;
            }
            Properties properties = NHINDSecurityAndTrustMailetCust.mapToProperties(MailetProperties.getPropertiesList());
            String db_hostname = properties.getProperty("mailet.db.hostname");
            String db_port = properties.getProperty("mailet.db.port");
            String db_apiname = properties.getProperty("mailet.db.apiname");
            String db_webname = properties.getProperty("mailet.db.webname");
            String db_instance = properties.getProperty("mailet.db.instance");
            String db_apiuserid = properties.getProperty("mailet.db.apiusername");
            String db_webuserid = properties.getProperty("mailet.db.webusername");
            String db_apipassword = properties.getProperty("mailet.db.apipassword");
            String db_webpassword = properties.getProperty("mailet.db.webpassword");
            String notificationSender = properties.getProperty("mailet.notification.sender");
            if (!mail.getSender().toString().toLowerCase(Locale.getDefault()).equals(notificationSender.toLowerCase(Locale.getDefault()))) {
                Connection apiconn = null;
                Connection webconn = null;
                try {
                    apiconn = this.databaseConnect(db_hostname, db_port, db_apiname, db_instance, db_apiuserid, db_apipassword);
                    webconn = this.databaseConnect(db_hostname, db_port, db_webname, db_instance, db_webuserid, db_webpassword);
                    int log_inboundOutbound = 1;
                    if (!isInbound) {
                        log_inboundOutbound = 0;
                    }
                    int mdn = 0;
                    try {
                        MimeMessage msg = mail.getMessage();
                        NHINDAddressCollection arecipients = this.getMailRecipients(mail);
                        NHINDAddress asender = this.getMailSender(mail);
                        Tx txToTrack = this.getTxToTrack(msg, asender, arecipients);
                        if (txToTrack != null && txToTrack.getMsgType().equals((Object)TxMessageType.MDN)) {
                            mdn = 1;
                        }
                    }
                    catch (MessagingException e1) {
                        LOGGER.debug((Object)"Failed to determine if message was an MDN.");
                    }
                    int web_id = LogMessage.logMessageToLog(mail, webconn, 0, log_inboundOutbound, -1);
                    int api_id = LogMessage.logMessageToLog(mail, apiconn, 0, log_inboundOutbound, mdn);
                    mail.setAttribute("log_id_web", (Serializable)Integer.valueOf(web_id));
                    mail.setAttribute("log_id_api", (Serializable)Integer.valueOf(api_id));
                }
                catch (SQLException sqlException) {
                    LOGGER.debug((Object)"SQL Server database not reachable.");
                }
                finally {
                    if (apiconn != null) {
                        try {
                            apiconn.close();
                        }
                        catch (SQLException closeAPIEx) {
                            LOGGER.debug((Object)"Failed to close SQL Database connection.");
                        }
                    }
                    if (webconn != null) {
                        try {
                            webconn.close();
                        }
                        catch (SQLException closeWebEx) {
                            LOGGER.debug((Object)"Failed to close SQL Database connection.");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostprocessMessage(Mail mail, MessageProcessResult result) {
        Collection recipients = mail.getRecipients();
        Map<String, String> properties = MailetProperties.getPropertiesList();
        String notificationSender = properties.get("mailet.notification.sender");
        String db_hostname = properties.get("mailet.db.hostname");
        String db_port = properties.get("mailet.db.port");
        String db_apiname = properties.get("mailet.db.apiname");
        String db_webname = properties.get("mailet.db.webname");
        String db_instance = properties.get("mailet.db.instance");
        String db_apiuserid = properties.get("mailet.db.apiusername");
        String db_webuserid = properties.get("mailet.db.webusername");
        String db_apipassword = properties.get("mailet.db.apipassword");
        String db_webpassword = properties.get("mailet.db.webpassword");
        MimeMessage message = null;
        try {
            message = mail.getMessage();
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging exception encountered while post-processing message.");
        }
        Connection connapi = null;
        Connection connweb = null;
        try {
            connapi = this.databaseConnect(db_hostname, db_port, db_apiname, db_instance, db_apiuserid, db_apipassword);
            connweb = this.databaseConnect(db_hostname, db_port, db_webname, db_instance, db_webuserid, db_webpassword);
            if (mail.getSender() != null && !this.getMailetContext().isLocalServer(mail.getSender().getDomain().toLowerCase(Locale.getDefault()))) {
                if (!mail.getSender().toString().toLowerCase(Locale.getDefault()).equals(notificationSender.toLowerCase(Locale.getDefault()))) {
                    try {
                        this.updateLogSuccess(connweb, mail.getAttribute("log_id_web").toString(), 1);
                        this.updateLogSuccess(connapi, mail.getAttribute("log_id_api").toString(), 1);
                    }
                    catch (SQLException se) {
                        LOGGER.debug((Object)"Failed to update status of incoming message during post-processing.");
                    }
                    String log_attachmentTypes = LogMessage.parseAttachments(message);
                    if (log_attachmentTypes != null) {
                        try {
                            this.updateLogAttachments(connweb, mail.getAttribute("log_id_web").toString(), log_attachmentTypes);
                            this.updateLogAttachments(connapi, mail.getAttribute("log_id_api").toString(), log_attachmentTypes);
                            LOGGER.info((Object)"Updated incoming message log after successful processing.");
                        }
                        catch (SQLException se) {
                            LOGGER.debug((Object)"Failed to update attachment types of message during post-processing.");
                        }
                    }
                }
            } else if (mail.getSender() != null && !mail.getSender().toString().toLowerCase(Locale.getDefault()).equals(notificationSender.toLowerCase(Locale.getDefault()))) {
                LOGGER.debug((Object)"Message is local");
                try {
                    this.updateLogSuccess(connweb, mail.getAttribute("log_id_web").toString(), 1);
                    this.updateLogSuccess(connapi, mail.getAttribute("log_id_api").toString(), 1);
                }
                catch (SQLException se) {
                    LOGGER.debug((Object)"Failed to update status of outbound message during post-processing.");
                }
            } else {
                LOGGER.debug((Object)"Message is local notification, do not process for outbound message log.");
            }
            boolean MDN = false;
            try {
                MimeMessage msg = mail.getMessage();
                NHINDAddressCollection arecipients = this.getMailRecipients(mail);
                NHINDAddress asender = this.getMailSender(mail);
                Tx txToTrack = this.getTxToTrack(msg, asender, arecipients);
                if (txToTrack != null && txToTrack.getMsgType() == TxMessageType.MDN) {
                    MDN = true;
                }
            }
            catch (MessagingException e1) {
                LOGGER.debug((Object)"Failed to see if MDN");
            }
            if (MDN) {
                this.updateLogMDN(connapi, mail.getAttribute("log_id_api").toString(), 1);
            }
            if (recipients != null && recipients.size() >= 1 && !MDN) {
                LogMessage.sendExternalNotification(connweb, mail);
            }
        }
        catch (SQLException sqlException) {
            LOGGER.debug((Object)"SQL Server database not reachable");
        }
        finally {
            if (connapi != null) {
                try {
                    connapi.close();
                }
                catch (SQLException connCloseAPIEx) {
                    LOGGER.debug((Object)"SQL Database connection could not be closed.");
                }
            }
            if (connweb != null) {
                try {
                    connweb.close();
                }
                catch (SQLException connCloseWebEx) {
                    LOGGER.debug((Object)"SQL Database connection could not be closed.");
                }
            }
        }
    }

    public static Properties mapToProperties(Map<String, String> map) {
        Properties p = new Properties();
        p.putAll(map);
        return p;
    }

    private Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_p) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_p);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            throw sqlException;
        }
        return conn;
    }

    private void updateLogSuccess(Connection conn, String log_id, int success) throws SQLException {
        String updateMessageStatusQuery = "UPDATE mail_log SET success = ? WHERE id = ?";
        PreparedStatement updateMessageLogapi = null;
        try {
            updateMessageLogapi = conn.prepareStatement(updateMessageStatusQuery);
            updateMessageLogapi.setString(1, Integer.toString(success));
            updateMessageLogapi.setString(2, log_id);
            updateMessageLogapi.executeUpdate();
        }
        catch (SQLException se) {
            LOGGER.debug((Object)"SQL Exception while updating status of logged message.");
            throw se;
        }
        finally {
            if (updateMessageLogapi != null) {
                try {
                    updateMessageLogapi.close();
                }
                catch (SQLException se) {
                    LOGGER.debug((Object)"failed to close statement.");
                }
            }
        }
    }

    private void updateLogMDN(Connection conn, String log_id, int mdn) throws SQLException {
        String updateMessageStatusQuery = "UPDATE mail_log SET mdn = ? WHERE id = ?";
        PreparedStatement updateMessageLogapi = null;
        try {
            updateMessageLogapi = conn.prepareStatement(updateMessageStatusQuery);
            updateMessageLogapi.setString(1, Integer.toString(mdn));
            updateMessageLogapi.setString(2, log_id);
            updateMessageLogapi.executeUpdate();
        }
        catch (SQLException se) {
            LOGGER.debug((Object)"SQL Exception while updating MDN status of logged message.");
            throw se;
        }
        finally {
            if (updateMessageLogapi != null) {
                try {
                    updateMessageLogapi.close();
                }
                catch (SQLException se) {
                    LOGGER.debug((Object)"failed to close statement.");
                }
            }
        }
    }

    private void updateLogAttachments(Connection conn, String log_id, String attachments) throws SQLException {
        String updateMessageStatusQuery = "UPDATE mail_log SET attachment_types = ? WHERE id = ?";
        PreparedStatement updateMessageLogapi = null;
        try {
            updateMessageLogapi = conn.prepareStatement(updateMessageStatusQuery);
            updateMessageLogapi.setString(1, attachments);
            updateMessageLogapi.setString(2, log_id);
            updateMessageLogapi.executeUpdate();
        }
        catch (SQLException se) {
            LOGGER.debug((Object)"SQL Exception while updating attachments of logged message.");
            throw se;
        }
        finally {
            if (updateMessageLogapi != null) {
                try {
                    updateMessageLogapi.close();
                }
                catch (SQLException se) {
                    LOGGER.debug((Object)"failed to close statement.");
                }
            }
        }
    }
}

