/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.nhindirect.gateway.smtp.james.mailet.NHINDSecurityAndTrustMailet;

public class DeliverMail
extends GenericMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DeliverMail.class);

    public void service(Mail mail) throws MessagingException {
        Map<String, String> properties = this.getPropertiesList();
        String db_hostname = properties.get("mailet.db.hostname");
        String db_port = properties.get("mailet.db.port");
        String db_name = properties.get("mailet.db.mailname");
        String db_instance = properties.get("mailet.db.instance");
        String db_userid = properties.get("mailet.db.mailusername");
        String db_password = properties.get("mailet.db.mailpassword");
        Connection conn = null;
        try {
            conn = this.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
            MimeMessage message = null;
            String sender = null;
            Collection recipients = null;
            long size = 0L;
            Date date = null;
            String subject = null;
            String attachments = null;
            String body = null;
            try {
                message = mail.getMessage();
                recipients = mail.getRecipients();
                sender = mail.getSender().toString();
                size = mail.getMessageSize();
                date = mail.getLastUpdated();
                subject = message.getSubject();
                attachments = this.parseAttachments(message);
                try {
                    body = this.parseBody(message);
                }
                catch (IOException ex) {
                    Logger.getLogger(DeliverMail.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (MessagingException me) {
                LOGGER.debug((Object)"Messaging execption while retrieving message.");
            }
            String sqlQuery = "INSERT INTO mailboxes (recipients, sender, box ,attachment_types, subject, time, folder, size, message_read, message, body) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement prepQuery = null;
            prepQuery = conn.prepareStatement(sqlQuery, 1);
            if (prepQuery != null) {
                prepQuery.setString(1, recipients.toString());
                prepQuery.setString(2, sender);
                prepQuery.setString(4, attachments);
                prepQuery.setString(5, subject);
                prepQuery.setLong(6, date.getTime());
                prepQuery.setString(7, "INBOX");
                prepQuery.setLong(8, size);
                prepQuery.setInt(9, 0);
                prepQuery.setString(11, body);
            }
            Iterator<String> i = this.check_users(recipients, properties);
            while (i.hasNext()) {
                try {
                    prepQuery.setBytes(10, DeliverMail.serialize(message));
                }
                catch (IOException ex) {
                    Logger.getLogger(DeliverMail.class.getName()).log(Level.SEVERE, null, ex);
                }
                prepQuery.setString(3, i.next());
                prepQuery.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            LOGGER.trace((Object)"Failed to connect or prepare SQL Server statement");
        }
        try {
            conn.close();
        }
        catch (SQLException ex) {
            LOGGER.trace((Object)"Failed to close connection");
        }
    }

    private Map<String, String> getPropertiesList() {
        HashMap<String, String> props = new HashMap<String, String>();
        Properties properties = this.getProperties();
        for (String key : properties.stringPropertyNames()) {
            props.put(key, properties.getProperty(key));
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() {
        Properties properties = System.getProperties();
        InputStream propertiesFile = null;
        try {
            propertiesFile = NHINDSecurityAndTrustMailet.class.getResourceAsStream("/mailet.properties");
            properties.load(propertiesFile);
        }
        catch (IOException e) {
            LOGGER.trace((Object)"Could not load mailet properties file");
        }
        finally {
            try {
                propertiesFile.close();
            }
            catch (IOException propCloseEx) {
                LOGGER.debug((Object)"Could not close mailet properties file");
            }
        }
        return properties;
    }

    private Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_password) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_password);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            throw sqlException;
        }
        return conn;
    }

    private String parseAttachments(MimeMessage message) {
        String attachmentTypes;
        block8: {
            attachmentTypes = "";
            try {
                if (message.getContentType().contains("text/plain")) break block8;
                MimeMultipart attachments = new MimeMultipart();
                try {
                    attachments = (MimeMultipart)message.getContent();
                }
                catch (ClassCastException ce) {
                    attachments = null;
                }
                catch (IOException ie) {
                    LOGGER.debug((Object)"IO Error while post-processing incoming message.");
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
                }
                if (attachments != null) {
                    for (int i = 0; i < attachments.getCount(); ++i) {
                        BodyPart part = attachments.getBodyPart(i);
                        if (FilenameUtils.getExtension((String)part.getFileName()) == null) continue;
                        attachmentTypes = attachmentTypes + part.getFileName() + "/";
                    }
                    attachmentTypes = attachmentTypes.trim();
                }
            }
            catch (MessagingException me) {
                LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            }
        }
        return attachmentTypes;
    }

    private String parseBody(MimeMessage message) throws IOException {
        block9: {
            try {
                if (!message.getContentType().contains("text/plain")) {
                    MimeMultipart attachments = new MimeMultipart();
                    try {
                        attachments = (MimeMultipart)message.getContent();
                    }
                    catch (ClassCastException ce) {
                        attachments = null;
                    }
                    catch (IOException ie) {
                        LOGGER.debug((Object)"IO Error while post-processing incoming message.");
                    }
                    catch (MessagingException me) {
                        LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
                    }
                    if (attachments != null) {
                        for (int i = 0; i < attachments.getCount(); ++i) {
                            BodyPart part = attachments.getBodyPart(i);
                            if (!part.getContentType().contains("text/plain")) continue;
                            return part.getContent().toString();
                        }
                        return "dd";
                    }
                    break block9;
                }
                return message.getContent().toString();
            }
            catch (MessagingException me) {
                LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            }
        }
        return null;
    }

    private Iterator<String> check_users(Collection<MailAddress> users, Map<String, String> properties) {
        String ldap_protocol = properties.get("mailet.ldap.protocol");
        String ldap_host = properties.get("mailet.ldap.host");
        String ldap_port = properties.get("mailet.ldap.port");
        String ldap_api = properties.get("mailet.ldap.api");
        String ldap_domain = properties.get("mailet.ldap.domain");
        String ldap_user_dn = properties.get("mailet.ldap.user_dn");
        String ldap_password = properties.get("mailet.ldap.password");
        InitialDirContext ctx = this.ldapConnect(ldap_host, ldap_port, ldap_protocol, ldap_domain, ldap_user_dn, ldap_password);
        ArrayList<String> list = new ArrayList<String>();
        Iterator<MailAddress> each = users.iterator();
        while (each.hasNext()) {
            String address = each.next().toString();
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                NamingEnumeration<SearchResult> answers = ctx.search(ldap_api, "(&(mail=" + address + "))", searchControls);
                if (!answers.hasMoreElements()) continue;
                list.add(address.substring(0, address.indexOf("@")));
            }
            catch (NamingException ne) {
                LOGGER.debug((Object)"Naming exception trying to get user.");
            }
        }
        return list.iterator();
    }

    private InitialDirContext ldapConnect(String ldap_host, String ldap_port, String ldap_protocol, String ldap_domain, String ldap_user_dn, String ldap_password) {
        InitialDirContext ctx = null;
        String ldapUrl = ldap_protocol + "://" + ldap_host + ":" + ldap_port + "/" + ldap_domain;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ht.put("java.naming.provider.url", ldapUrl);
        ht.put("java.naming.security.authentication", "simple");
        ht.put("java.naming.security.principal", ldap_user_dn);
        ht.put("java.naming.security.credentials", ldap_password);
        try {
            ctx = new InitialDirContext(ht);
        }
        catch (NamingException name_ex) {
            LOGGER.debug((Object)"Naming exception encountered while looking up accounts.");
        }
        return ctx;
    }

    public static byte[] serialize(MimeMessage message) throws IOException, MessagingException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        message.writeTo((OutputStream)b);
        return b.toByteArray();
    }
}

