/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.RuntimeOperationsException;
import mx4j.log.Log;
import mx4j.log.Logger;

public class NotificationBroadcasterSupport
implements NotificationBroadcaster {
    private static final NotificationFilter NULL_FILTER = new NotificationFilter(){

        public boolean isNotificationEnabled(Notification notification) {
            return true;
        }

        public String toString() {
            return "null filter";
        }
    };
    private static final Object NULL_HANDBACK = new Object(){

        public String toString() {
            return "null handback";
        }
    };
    private HashMap m_listeners = new HashMap();

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Adding notification listener: " + listener + ", filter: " + filter + ", handback: " + handback);
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification listener cannot be null"));
        }
        if (filter == null) {
            filter = NULL_FILTER;
        }
        if (handback == null) {
            handback = NULL_HANDBACK;
        }
        FilterHandbackPair pair = new FilterHandbackPair(filter, handback);
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            ArrayList<FilterHandbackPair> pairs = (ArrayList<FilterHandbackPair>)this.m_listeners.get(listener);
            if (pairs == null) {
                pairs = new ArrayList<FilterHandbackPair>();
                pairs.add(pair);
                this.m_listeners.put(listener, pairs);
            } else {
                int i = 0;
                while (i < pairs.size()) {
                    FilterHandbackPair other = (FilterHandbackPair)pairs.get(i);
                    if (pair.getNotificationFilter().equals(other.getNotificationFilter()) && pair.getHandback().equals(other.getHandback())) {
                        throw new RuntimeOperationsException(new IllegalArgumentException("Notification listener is already registered"));
                    }
                    ++i;
                }
                pairs.add(pair);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("Filters - Handbacks for this listener: " + pairs);
            }
        }
        if (logger.isEnabledFor(20)) {
            logger.info("Notification listener added successfully");
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Removing notification listener: " + listener);
        }
        int removed = this.removeNotificationListenerImpl(listener, null, null);
        if (logger.isEnabledFor(20)) {
            logger.info(removed + "notification listener(s) removed successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeNotificationListenerImpl(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            ArrayList pairs = (ArrayList)this.m_listeners.get(listener);
            if (pairs == null) {
                throw new ListenerNotFoundException("Notification listener not found");
            }
            if (filter == null) {
                if (handback == null) {
                    ArrayList removed = (ArrayList)this.m_listeners.remove(listener);
                    return removed.size();
                }
                int count = 0;
                int i = 0;
                while (i < pairs.size()) {
                    Object hand = ((FilterHandbackPair)pairs.get(i)).getHandback();
                    if (handback.equals(hand)) {
                        pairs.remove(i);
                        ++count;
                    }
                    ++i;
                }
                if (pairs.isEmpty()) {
                    this.m_listeners.remove(listener);
                }
                return count;
            }
            if (handback == null) {
                int count = 0;
                int i = 0;
                while (i < pairs.size()) {
                    NotificationFilter filt = ((FilterHandbackPair)pairs.get(i)).getNotificationFilter();
                    if (filter.equals(filt)) {
                        pairs.remove(i);
                        ++count;
                    }
                    ++i;
                }
                if (pairs.isEmpty()) {
                    this.m_listeners.remove(listener);
                }
                return count;
            }
            int count = 0;
            int i = 0;
            while (i < pairs.size()) {
                FilterHandbackPair pair = (FilterHandbackPair)pairs.get(i);
                if (filter.equals(pair.getNotificationFilter()) && handback.equals(pair.getHandback())) {
                    pairs.remove(i);
                    ++count;
                }
                ++i;
            }
            if (pairs.isEmpty()) {
                this.m_listeners.remove(listener);
            }
            return count;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasListeners() {
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            return this.m_listeners.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(final Notification n) {
        final Logger logger = this.getLogger();
        boolean debug = logger.isEnabledFor(10);
        final boolean info = logger.isEnabledFor(20);
        HashMap listeners = null;
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            listeners = (HashMap)this.m_listeners.clone();
        }
        Iterator i = listeners.keySet().iterator();
        if (i.hasNext() && info) {
            logger.info("Sending notifications...");
        }
        while (i.hasNext()) {
            final NotificationListener listener = (NotificationListener)i.next();
            if (info) {
                logger.info("\tListener is: " + listener);
            }
            ArrayList pairs = null;
            NotificationBroadcasterSupport notificationBroadcasterSupport2 = this;
            synchronized (notificationBroadcasterSupport2) {
                pairs = (ArrayList)this.m_listeners.get(listener);
                pairs = (ArrayList)pairs.clone();
            }
            if (debug) {
                logger.debug("\tFilters - Handback for this listener: " + pairs);
            }
            int j = 0;
            while (j < pairs.size()) {
                FilterHandbackPair pair = (FilterHandbackPair)pairs.get(j);
                final NotificationFilter filter = pair.getNotificationFilter();
                Object hb = pair.getHandback();
                if (hb == NULL_HANDBACK) {
                    hb = null;
                }
                final Object handback = hb;
                Runnable run = new Runnable(){

                    public void run() {
                        block7: {
                            boolean enabled;
                            block6: {
                                enabled = false;
                                try {
                                    enabled = filter != null && filter.isNotificationEnabled(n);
                                }
                                catch (RuntimeException x) {
                                    if (!info) break block6;
                                    logger.info("\t\tRuntimeException caught from isNotificationEnabled", x);
                                }
                            }
                            if (info) {
                                logger.info("\t\tFilter is: " + filter + ", enabled: " + enabled);
                            }
                            if (!enabled) break block7;
                            if (info) {
                                logger.info("\t\tHandback is: " + handback);
                                logger.info("\t\tSending notification " + n);
                            }
                            try {
                                listener.handleNotification(n, handback);
                            }
                            catch (RuntimeException x) {
                                if (!info) break block7;
                                logger.info("\t\tRuntimeException caught from handleNotification", x);
                            }
                        }
                    }
                };
                if (listener instanceof Serializable) {
                    new Thread(run, "NotificationBroadcasterSupport Thread").start();
                } else {
                    run.run();
                }
                ++j;
            }
        }
    }

    private static class FilterHandbackPair {
        private NotificationFilter m_filter;
        private Object m_handback;

        public FilterHandbackPair(NotificationFilter filter, Object handback) {
            this.m_filter = filter;
            this.m_handback = handback;
        }

        public NotificationFilter getNotificationFilter() {
            return this.m_filter;
        }

        public Object getHandback() {
            return this.m_handback;
        }
    }
}

