/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.jaxp;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import com.sun.msv.verifier.jaxp.SAXParserImpl;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    private final SAXParserFactory core;
    private final VerifierFactory jarvFactory;
    private Schema schema;

    public SAXParserFactoryImpl() {
        this(SAXParserFactory.newInstance());
    }

    public SAXParserFactoryImpl(SAXParserFactory sAXParserFactory) {
        this(sAXParserFactory, null);
    }

    public SAXParserFactoryImpl(Schema schema) {
        this(SAXParserFactory.newInstance(), schema);
    }

    public SAXParserFactoryImpl(File file) throws VerifierConfigurationException, SAXException, IOException {
        this();
        this.schema = this.jarvFactory.compileSchema(file);
    }

    public SAXParserFactoryImpl(InputSource inputSource) throws VerifierConfigurationException, SAXException, IOException {
        this();
        this.schema = this.jarvFactory.compileSchema(inputSource);
    }

    public SAXParserFactoryImpl(String string) throws VerifierConfigurationException, SAXException, IOException {
        this();
        this.schema = this.jarvFactory.compileSchema(string);
    }

    public SAXParserFactoryImpl(SAXParserFactory sAXParserFactory, Schema schema) {
        this.core = sAXParserFactory;
        this.core.setNamespaceAware(true);
        this.jarvFactory = new TheFactoryImpl(this.core);
        this.schema = schema;
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://www.sun.com/xmlns/msv/features/panicMode")) {
            return this.jarvFactory.isFeature(string);
        }
        return this.core.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://www.sun.com/xmlns/msv/features/panicMode")) {
            this.jarvFactory.setFeature(string, bl);
        }
        this.core.setFeature(string, bl);
    }

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        try {
            return new SAXParserImpl(this.core.newSAXParser(), this.jarvFactory, this.schema == null ? null : this.schema.newVerifier());
        }
        catch (VerifierConfigurationException verifierConfigurationException) {
            throw new SAXException((Exception)((Object)verifierConfigurationException));
        }
    }

    public void setNamespaceAware(boolean bl) {
        this.core.setNamespaceAware(bl);
    }

    public boolean isNamespaceAware() {
        return this.core.isNamespaceAware();
    }

    public void setValidating(boolean bl) {
        this.core.setValidating(bl);
    }

    public boolean isValidating() {
        return this.core.isValidating();
    }
}

