/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.AnchorDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AnchorDaoImpl
implements AnchorDao {
    @PersistenceContext
    @Autowired
    private EntityManager entityManager;
    private static final Log log = LogFactory.getLog(AnchorDaoImpl.class);

    @Override
    @Transactional(readOnly=true)
    public Anchor load(String owner) {
        List<Anchor> anchors = this.list(Arrays.asList(owner));
        if (anchors != null && anchors.size() > 0) {
            return (Anchor)anchors.iterator().next();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Anchor> listAll() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = Collections.emptyList();
        Query select = null;
        select = this.entityManager.createQuery("SELECT a from Anchor a");
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof Anchor) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Anchor> list(List<String> owners) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (owners == null || owners.size() == 0) {
            return this.listAll();
        }
        List result = Collections.emptyList();
        Query select = null;
        StringBuffer nameList = new StringBuffer("(");
        for (String owner : owners) {
            if (nameList.length() > 1) {
                nameList.append(", ");
            }
            nameList.append("'").append(owner.toUpperCase(Locale.getDefault())).append("'");
        }
        nameList.append(")");
        String query = "SELECT a from Anchor a WHERE UPPER(a.owner) IN " + nameList.toString();
        select = this.entityManager.createQuery(query);
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof Anchor) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=false)
    public void add(Anchor anchor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (anchor != null) {
            anchor.setCreateTime(Calendar.getInstance());
            try {
                X509Certificate cert = anchor.toCertificate();
                if (anchor.getValidStartDate() == null) {
                    Calendar startDate = Calendar.getInstance();
                    startDate.setTime(cert.getNotBefore());
                    anchor.setValidStartDate(startDate);
                }
                if (anchor.getValidEndDate() == null) {
                    Calendar endDate = Calendar.getInstance();
                    endDate.setTime(cert.getNotAfter());
                    anchor.setValidEndDate(endDate);
                }
                if (anchor.getStatus() == null) {
                    anchor.setStatus(EntityStatus.NEW);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling JPA to persist the Anchor");
            }
            this.entityManager.persist((Object)anchor);
            this.entityManager.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returned from JPA: Anchor ID=" + anchor.getId()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Anchor anchor) {
        if (anchor != null) {
            ArrayList<Anchor> anchors = new ArrayList<Anchor>();
            anchors.add(anchor);
            this.save(anchors);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void save(List<Anchor> anchorList) {
        if (anchorList != null && anchorList.size() > 0) {
            for (Anchor anchor : anchorList) {
                this.save(anchor);
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<Anchor> listByIds(List<Long> anchorIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (anchorIds == null || anchorIds.size() == 0) {
            return Collections.emptyList();
        }
        List result = Collections.emptyList();
        Query select = null;
        StringBuffer ids = new StringBuffer("(");
        for (Long id : anchorIds) {
            if (ids.length() > 1) {
                ids.append(", ");
            }
            ids.append(id);
        }
        ids.append(")");
        String query = "SELECT a from Anchor a WHERE a.id IN " + ids.toString();
        select = this.entityManager.createQuery(query);
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof Anchor) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=false)
    public void setStatus(List<Long> anchorIDs, EntityStatus status) {
        List<Anchor> anchors;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if ((anchors = this.listByIds(anchorIDs)) == null || anchors.size() == 0) {
            return;
        }
        for (Anchor anchor : anchors) {
            anchor.setStatus(status);
            this.entityManager.merge((Object)anchor);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void setStatus(String owner, EntityStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (owner == null) {
            return;
        }
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(owner);
        List<Anchor> anchors = this.list(owners);
        if (anchors == null || anchors.size() == 0) {
            return;
        }
        for (Anchor anchor : anchors) {
            anchor.setStatus(status);
            this.entityManager.merge((Object)anchor);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(List<Long> idList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (idList != null && idList.size() > 0) {
            StringBuffer ids = new StringBuffer("(");
            for (Long id : idList) {
                if (ids.length() > 1) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            ids.append(")");
            String query = "DELETE FROM Anchor a WHERE a.id IN " + ids.toString();
            int count = 0;
            Query delete = this.entityManager.createQuery(query);
            count = delete.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: " + count + " anchor records deleted"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(String owner) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (owner == null) {
            return;
        }
        int count = 0;
        if (owner != null) {
            Query delete = this.entityManager.createQuery("DELETE FROM Anchor a WHERE UPPER(a.owner) = ?1");
            delete.setParameter(1, (Object)owner.toUpperCase(Locale.getDefault()));
            count = delete.executeUpdate();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: " + count + " anchor records deleted"));
        }
    }
}

