/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Enumeration;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.Thumbprint;

@Entity
@Table(name="certificate")
public class Certificate {
    private static final String DEFAULT_JCE_PROVIDER_STRING = "BC";
    private static final String JCE_PROVIDER_STRING_SYS_PARAM = "org.nhindirect.config.JCEProviderName";
    private static final Log log;
    public static final byte[] NULL_CERT;
    private String owner;
    private String thumbprint;
    private long id = 0L;
    private byte[] data;
    private Calendar createTime;
    private Calendar validStartDate;
    private Calendar validEndDate;
    private EntityStatus status;
    private boolean privateKey;

    public static String getJCEProviderName() {
        String retVal = System.getProperty(JCE_PROVIDER_STRING_SYS_PARAM);
        if (retVal == null || retVal.isEmpty()) {
            retVal = DEFAULT_JCE_PROVIDER_STRING;
        }
        return retVal;
    }

    public static void setJCEProviderName(String name) {
        if (name == null || name.isEmpty()) {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, DEFAULT_JCE_PROVIDER_STRING);
        } else {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, name);
        }
    }

    @Column(name="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column(name="certificateData", length=4096)
    @Lob
    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) throws CertificateException {
        this.data = data;
        if (data == NULL_CERT) {
            this.setThumbprint("");
        } else {
            this.loadCertFromData();
        }
    }

    @Column(name="privateKey")
    public boolean isPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(boolean b) throws CertificateException {
        this.privateKey = b;
    }

    private void setThumbprint(String aThumbprint) {
        this.thumbprint = aThumbprint;
    }

    @Column(name="thumbprint")
    public String getThumbprint() {
        return this.thumbprint;
    }

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="createTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Calendar timestamp) {
        this.createTime = timestamp;
    }

    @Column(name="status")
    @Enumerated
    public EntityStatus getStatus() {
        return this.status;
    }

    public void setStatus(EntityStatus status) {
        this.status = status;
    }

    @Column(name="validStartDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidStartDate() {
        return this.validStartDate;
    }

    public void setValidStartDate(Calendar validStartDate) {
        this.validStartDate = validStartDate;
    }

    @Column(name="validEndDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidEndDate() {
        return this.validEndDate;
    }

    public void setValidEndDate(Calendar validEndDate) {
        this.validEndDate = validEndDate;
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }

    private boolean hasData() {
        return this.data != null && !this.data.equals(NULL_CERT);
    }

    public void clearData() {
        try {
            this.setData(NULL_CERT);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
    }

    private void loadCertFromData() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            CertContainer container = this.toCredential();
            cert = container.getCert();
            this.setThumbprint(Thumbprint.toThumbprint(cert).toString());
            this.setPrivateKey(container.getKey() != null);
        }
        catch (Exception e) {
            this.setData(NULL_CERT);
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
    }

    public CertContainer toCredential() throws CertificateException {
        CertContainer certContainer = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", Certificate.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(this.data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return certContainer;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        log = LogFactory.getLog(Certificate.class);
        NULL_CERT = new byte[0];
    }

    public static class CertContainer {
        private final X509Certificate cert;
        private final Key key;

        public CertContainer(X509Certificate cert, Key key) {
            this.cert = cert;
            this.key = key;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public Key getKey() {
            return this.key;
        }
    }
}

