/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.monitor.Monitor;
import org.apache.avalon.excalibur.monitor.Resource;

public abstract class AbstractMonitor
implements Monitor {
    private Map m_resources = new HashMap();

    public final void addResources(Resource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            this.addResource(resources[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResource(Resource resource) {
        Map map = this.m_resources;
        synchronized (map) {
            String resourceKey = resource.getResourceKey();
            if (this.m_resources.containsKey(resourceKey)) {
                Resource original = (Resource)this.m_resources.get(resourceKey);
                original.addPropertyChangeListenersFrom(resource);
            } else {
                this.m_resources.put(resourceKey, resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String key) {
        Map map = this.m_resources;
        synchronized (map) {
            return (Resource)this.m_resources.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResource(String key) {
        Map map = this.m_resources;
        synchronized (map) {
            Resource resource = (Resource)this.m_resources.remove(key);
            resource.removeAllPropertyChangeListeners();
        }
    }

    public final void removeResource(Resource resource) {
        this.removeResource(resource.getResourceKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource[] getResources() {
        Map map = this.m_resources;
        synchronized (map) {
            Collection collection = this.m_resources.values();
            return collection.toArray(new Resource[collection.size()]);
        }
    }

    protected void scanAllResources() {
        long currentTestTime = System.currentTimeMillis();
        Resource[] resources = this.getResources();
        for (int i = 0; i < resources.length; ++i) {
            resources[i].testModifiedAfter(currentTestTime);
        }
    }
}

