/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.ChunkedTransferEncoding;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.FixedLengthTransferEncoding;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.HttpProbeNotifier;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.ParsingResult;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.CacheableDataChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.utils.ArraySet;

public abstract class HttpCodecFilter
extends BaseFilter
implements JmxMonitoringAware<HttpProbe> {
    public static final int DEFAULT_MAX_HTTP_PACKET_HEADER_SIZE = 8192;
    private final ArraySet<TransferEncoding> transferEncodings = new ArraySet(TransferEncoding.class);
    protected final ArraySet<ContentEncoding> contentEncodings = new ArraySet(ContentEncoding.class);
    protected final boolean chunkingEnabled;
    protected final AbstractJmxMonitoringConfig<HttpProbe> monitoringConfig = new AbstractJmxMonitoringConfig<HttpProbe>(HttpProbe.class){

        public JmxObject createManagementObject() {
            return HttpCodecFilter.this.createJmxManagementObject();
        }
    };
    protected final int maxHeadersSize;

    abstract boolean decodeInitialLine(HttpPacketParsing var1, HeaderParsingState var2, Buffer var3);

    abstract Buffer encodeInitialLine(HttpPacket var1, Buffer var2, MemoryManager var3);

    abstract boolean onHttpPacketParsed(HttpHeader var1, FilterChainContext var2);

    abstract boolean onHttpHeaderParsed(HttpHeader var1, Buffer var2, FilterChainContext var3);

    protected abstract void onHttpError(HttpHeader var1, FilterChainContext var2) throws IOException;

    public HttpCodecFilter(boolean chunkingEnabled, int maxHeadersSize) {
        this.maxHeadersSize = maxHeadersSize;
        this.chunkingEnabled = chunkingEnabled;
        this.transferEncodings.addAll((Object[])new TransferEncoding[]{new FixedLengthTransferEncoding(), new ChunkedTransferEncoding(maxHeadersSize)});
    }

    public TransferEncoding[] getTransferEncodings() {
        return (TransferEncoding[])this.transferEncodings.obtainArrayCopy();
    }

    public void addTransferEncoding(TransferEncoding transferEncoding) {
        this.transferEncodings.add((Object)transferEncoding);
    }

    public boolean removeTransferEncoding(TransferEncoding transferEncoding) {
        return this.transferEncodings.remove((Object)transferEncoding);
    }

    public ContentEncoding[] getContentEncodings() {
        return (ContentEncoding[])this.contentEncodings.obtainArrayCopy();
    }

    public void addContentEncoding(ContentEncoding contentEncoding) {
        this.contentEncodings.add((Object)contentEncoding);
    }

    public boolean removeContentEncoding(ContentEncoding contentEncoding) {
        return this.contentEncodings.remove((Object)contentEncoding);
    }

    public final NextAction handleRead(FilterChainContext ctx, HttpPacketParsing httpPacket) throws IOException {
        Buffer input = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        HttpProbeNotifier.notifyDataReceived(this, connection, input);
        boolean wasHeaderParsed = httpPacket.isHeaderParsed();
        HttpHeader httpHeader = (HttpHeader)((Object)httpPacket);
        try {
            TransferEncoding transferEncoding;
            if (!wasHeaderParsed) {
                if (!this.decodeHttpPacket(httpPacket, input)) {
                    return ctx.getStopAction((Object)input);
                }
                int headerSizeInBytes = input.position();
                httpPacket.setHeaderParsed(true);
                httpPacket.getHeaderParsingState().recycle();
                if (this.onHttpHeaderParsed(httpHeader, input, ctx)) {
                    throw new IllegalStateException("Bad HTTP headers");
                }
                input = input.hasRemaining() ? input.slice() : Buffers.EMPTY_BUFFER;
                this.setTransferEncodingOnParsing(httpHeader);
                this.setContentEncodingsOnParsing(httpHeader);
                HttpProbeNotifier.notifyHeaderParse(this, connection, (HttpHeader)((Object)httpPacket), headerSizeInBytes);
            }
            if ((transferEncoding = httpHeader.getTransferEncoding()) != null) {
                return this.decodeWithTransferEncoding(ctx, httpHeader, input, wasHeaderParsed);
            }
            if (!httpHeader.isChunked() && httpHeader.getContentLength() < 0L) {
                HttpContent.Builder builder;
                HttpContent message;
                HttpContent decodedContent;
                if (input.hasRemaining() && (decodedContent = this.decodeContent(connection, message = ((HttpContent.Builder)(builder = httpHeader.httpContentBuilder()).content(input)).build())) != null) {
                    if (httpHeader.isSkipRemainder()) {
                        return ctx.getStopAction();
                    }
                    HttpProbeNotifier.notifyContentChunkParse(this, connection, decodedContent);
                    ctx.setMessage((Object)decodedContent);
                    return ctx.getInvokeAction();
                }
                if (!wasHeaderParsed) {
                    boolean isLast;
                    boolean bl = isLast = !httpHeader.isExpectContent();
                    if (isLast) {
                        this.onHttpPacketParsed(httpHeader, ctx);
                    }
                    HttpContent emptyContent = ((HttpContent.Builder)HttpContent.builder(httpHeader).last(isLast)).build();
                    HttpProbeNotifier.notifyContentChunkParse(this, connection, emptyContent);
                    ctx.setMessage((Object)emptyContent);
                    return ctx.getInvokeAction();
                }
                return ctx.getStopAction();
            }
            throw new IllegalStateException("Error parsing HTTP packet: " + httpHeader);
        }
        catch (RuntimeException re) {
            HttpProbeNotifier.notifyProbesError(this, connection, re);
            this.onHttpError(httpHeader, ctx);
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.completeAndRecycle();
            return suspendAction;
        }
    }

    private NextAction decodeWithTransferEncoding(FilterChainContext ctx, HttpHeader httpHeader, Buffer input, boolean wasHeaderParsed) {
        boolean isLast;
        Connection connection = ctx.getConnection();
        ParsingResult result = this.parseWithTransferEncoding(ctx.getConnection(), httpHeader, input);
        HttpContent httpContent = result.getHttpContent();
        Buffer remainderBuffer = result.getRemainderBuffer();
        boolean hasRemainder = remainderBuffer != null && remainderBuffer.hasRemaining();
        result.recycle();
        boolean bl = isLast = !httpHeader.isExpectContent();
        if (httpContent != null) {
            if (httpContent.isLast()) {
                isLast = true;
                this.onHttpPacketParsed(httpHeader, ctx);
                httpHeader.setExpectContent(false);
            }
            if (httpHeader.isSkipRemainder()) {
                if (remainderBuffer != null) {
                    ctx.setMessage((Object)remainderBuffer);
                    return ctx.getRerunFilterAction();
                }
                return ctx.getStopAction();
            }
            HttpContent decodedContent = this.decodeContent(connection, httpContent);
            if (decodedContent != null) {
                HttpProbeNotifier.notifyContentChunkParse(this, connection, decodedContent);
                ctx.setMessage((Object)decodedContent);
                return ctx.getInvokeAction(hasRemainder ? remainderBuffer : null);
            }
            if (hasRemainder) {
                HttpContent emptyContent = ((HttpContent.Builder)HttpContent.builder(httpHeader).last(isLast)).build();
                HttpProbeNotifier.notifyContentChunkParse(this, connection, emptyContent);
                ctx.setMessage((Object)emptyContent);
                return ctx.getInvokeAction((Object)remainderBuffer);
            }
        }
        if (!wasHeaderParsed || isLast) {
            HttpContent emptyContent = ((HttpContent.Builder)HttpContent.builder(httpHeader).last(isLast)).build();
            HttpProbeNotifier.notifyContentChunkParse(this, connection, emptyContent);
            ctx.setMessage((Object)emptyContent);
            return ctx.getInvokeAction(hasRemainder ? remainderBuffer : null);
        }
        return ctx.getStopAction(hasRemainder ? remainderBuffer : null);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (HttpPacket.isHttp(message)) {
            HttpPacket input = (HttpPacket)ctx.getMessage();
            Connection connection = ctx.getConnection();
            try {
                Buffer output = this.encodeHttpPacket(connection, input);
                if (output != null) {
                    HttpProbeNotifier.notifyDataSent(this, connection, output);
                    ctx.setMessage((Object)output);
                    return ctx.getInvokeAction();
                }
                return ctx.getStopAction();
            }
            catch (RuntimeException re) {
                HttpProbeNotifier.notifyProbesError(this, connection, re);
                throw re;
            }
        }
        return ctx.getInvokeAction();
    }

    protected boolean decodeHttpPacket(HttpPacketParsing httpPacket, Buffer input) {
        HeaderParsingState parsingState = httpPacket.getHeaderParsingState();
        switch (parsingState.state) {
            case 0: {
                if (!this.decodeInitialLine(httpPacket, parsingState, input)) {
                    parsingState.checkOverflow();
                    return false;
                }
                ++parsingState.state;
            }
            case 1: {
                if (!HttpCodecFilter.parseHeaders((HttpHeader)((Object)httpPacket), httpPacket.getHeaders(), parsingState, input)) {
                    parsingState.checkOverflow();
                    return false;
                }
                ++parsingState.state;
            }
            case 2: {
                input.position(parsingState.offset);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    protected Buffer encodeHttpPacket(Connection connection, HttpPacket input) {
        HttpHeader httpHeader;
        HttpContent httpContent;
        MemoryManager memoryManager = connection.getTransport().getMemoryManager();
        boolean isHeader = input.isHeader();
        if (isHeader) {
            httpContent = null;
            httpHeader = (HttpHeader)input;
        } else {
            httpContent = (HttpContent)input;
            httpHeader = httpContent.getHttpHeader();
        }
        Buffer encodedBuffer = null;
        if (!httpHeader.isCommitted()) {
            HttpResponsePacket response;
            if (!httpHeader.isRequest() && (response = (HttpResponsePacket)httpHeader).isAcknowledgement()) {
                encodedBuffer = memoryManager.allocate(128);
                encodedBuffer = this.encodeInitialLine(httpHeader, encodedBuffer, memoryManager);
                encodedBuffer = HttpCodecUtils.put(memoryManager, encodedBuffer, Constants.CRLF_BYTES);
                encodedBuffer = HttpCodecUtils.put(memoryManager, encodedBuffer, Constants.CRLF_BYTES);
                encodedBuffer.trim();
                encodedBuffer.allowBufferDispose(true);
                HttpProbeNotifier.notifyHeaderSerialize(this, connection, httpHeader, encodedBuffer);
                response.acknowledged();
                return encodedBuffer;
            }
            this.setContentEncodingsOnSerializing(httpHeader);
            this.setTransferEncodingOnSerializing(connection, httpHeader, httpContent);
            encodedBuffer = memoryManager.allocate(8192);
            encodedBuffer = this.encodeInitialLine(httpHeader, encodedBuffer, memoryManager);
            encodedBuffer = HttpCodecUtils.put(memoryManager, encodedBuffer, Constants.CRLF_BYTES);
            encodedBuffer = HttpCodecFilter.encodeKnownHeaders(memoryManager, encodedBuffer, httpHeader);
            MimeHeaders mimeHeaders = httpHeader.getHeaders();
            encodedBuffer = HttpCodecFilter.encodeMimeHeaders(memoryManager, encodedBuffer, mimeHeaders);
            encodedBuffer = HttpCodecUtils.put(memoryManager, encodedBuffer, Constants.CRLF_BYTES);
            encodedBuffer.trim();
            encodedBuffer.allowBufferDispose(true);
            httpHeader.setCommitted(true);
            HttpProbeNotifier.notifyHeaderSerialize(this, connection, httpHeader, encodedBuffer);
        }
        if (!isHeader) {
            HttpProbeNotifier.notifyContentChunkSerialize(this, connection, httpContent);
            HttpContent encodedHttpContent = this.encodeContent(connection, httpContent);
            if (encodedHttpContent == null) {
                return encodedBuffer;
            }
            TransferEncoding contentEncoder = httpHeader.getTransferEncoding();
            Buffer content = this.serializeWithTransferEncoding(connection, encodedHttpContent, contentEncoder);
            if ((encodedBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)encodedBuffer, (Buffer)content)).isComposite()) {
                encodedBuffer.allowBufferDispose(true);
            }
        }
        return encodedBuffer;
    }

    protected static Buffer encodeKnownHeaders(MemoryManager memoryManager, Buffer buffer, HttpHeader httpHeader) {
        boolean hasContentEncodings;
        CacheableDataChunk name = CacheableDataChunk.create();
        CacheableDataChunk value = CacheableDataChunk.create();
        name.setString("content-type");
        httpHeader.extractContentType(value);
        if (!value.isNull()) {
            buffer = HttpCodecFilter.encodeMimeHeader(memoryManager, buffer, name, value, true);
        }
        name.reset();
        value.reset();
        List<ContentEncoding> packetContentEncodings = httpHeader.getContentEncodings(true);
        boolean bl = hasContentEncodings = !packetContentEncodings.isEmpty();
        if (hasContentEncodings) {
            buffer = HttpCodecFilter.encodeContentEncodingHeader(memoryManager, buffer, httpHeader, name, value);
        }
        name.recycle();
        value.recycle();
        httpHeader.makeUpgradeHeader();
        return buffer;
    }

    private static Buffer encodeContentEncodingHeader(MemoryManager memoryManager, Buffer buffer, HttpHeader httpHeader, CacheableDataChunk name, CacheableDataChunk value) {
        List<ContentEncoding> packetContentEncodings = httpHeader.getContentEncodings(true);
        name.setString("content-encoding");
        httpHeader.extractContentEncoding(value);
        boolean needComma = !value.isNull();
        buffer = HttpCodecFilter.encodeMimeHeader(memoryManager, buffer, name, value, false);
        for (ContentEncoding encoding : packetContentEncodings) {
            if (needComma) {
                buffer = HttpCodecUtils.put(memoryManager, buffer, (byte)44);
            }
            buffer = HttpCodecUtils.put(memoryManager, buffer, encoding.getName());
            needComma = true;
        }
        buffer = HttpCodecUtils.put(memoryManager, buffer, Constants.CRLF_BYTES);
        return buffer;
    }

    protected static Buffer encodeMimeHeaders(MemoryManager memoryManager, Buffer buffer, MimeHeaders mimeHeaders) {
        int mimeHeadersNum = mimeHeaders.size();
        for (int i = 0; i < mimeHeadersNum; ++i) {
            DataChunk value;
            if (mimeHeaders.getAndSetSerialized(i, true) || (value = mimeHeaders.getValue(i)).isNull()) continue;
            buffer = HttpCodecFilter.encodeMimeHeader(memoryManager, buffer, mimeHeaders.getName(i), value, true);
        }
        return buffer;
    }

    protected static Buffer encodeMimeHeader(MemoryManager memoryManager, Buffer buffer, DataChunk name, DataChunk value, boolean encodeLastCRLF) {
        buffer = HttpCodecUtils.put(memoryManager, buffer, name);
        buffer = HttpCodecUtils.put(memoryManager, buffer, Constants.COLON_BYTES);
        buffer = HttpCodecUtils.put(memoryManager, buffer, value);
        if (encodeLastCRLF) {
            buffer = HttpCodecUtils.put(memoryManager, buffer, Constants.CRLF_BYTES);
        }
        return buffer;
    }

    protected static boolean parseHeaders(HttpHeader httpHeader, MimeHeaders mimeHeaders, HeaderParsingState parsingState, Buffer input) {
        do {
            boolean parseKnownHeaders;
            if (parsingState.subState != 0) continue;
            int eol = HttpCodecFilter.checkEOL(parsingState, input);
            if (eol == 0) {
                return true;
            }
            if (eol == -2) {
                return false;
            }
            parsingState.isTransferEncodingHeader = parseKnownHeaders = httpHeader != null;
            parsingState.isContentLengthHeader = parseKnownHeaders;
            parsingState.isUpgradeHeader = parseKnownHeaders && httpHeader.isRequest();
            boolean bl = parsingState.isExpect100Header = parseKnownHeaders && httpHeader.isRequest();
        } while (HttpCodecFilter.parseHeader(httpHeader, mimeHeaders, parsingState, input));
        return false;
    }

    protected static boolean parseHeader(HttpHeader httpHeader, MimeHeaders mimeHeaders, HeaderParsingState parsingState, Buffer input) {
        block6: while (true) {
            int subState = parsingState.subState++;
            switch (subState) {
                case 0: {
                    parsingState.start = parsingState.offset;
                }
                case 1: {
                    if (!HttpCodecFilter.parseHeaderName(httpHeader, mimeHeaders, parsingState, input)) {
                        return false;
                    }
                    ++parsingState.subState;
                    parsingState.start = -1;
                }
                case 2: {
                    int nonSpaceIdx = HttpCodecFilter.skipSpaces(input, parsingState.offset, parsingState.packetLimit);
                    if (nonSpaceIdx == -1) {
                        parsingState.offset = input.limit();
                        return false;
                    }
                    ++parsingState.subState;
                    parsingState.offset = nonSpaceIdx;
                    if (parsingState.start == -1) {
                        parsingState.start = nonSpaceIdx;
                        parsingState.checkpoint = nonSpaceIdx;
                        parsingState.checkpoint2 = nonSpaceIdx;
                    }
                }
                case 3: {
                    int result = HttpCodecFilter.parseHeaderValue(httpHeader, parsingState, input);
                    if (result == -1) {
                        return false;
                    }
                    if (result == -2) {
                        parsingState.subState = 2;
                        continue block6;
                    }
                    parsingState.subState = 0;
                    parsingState.start = -1;
                    return true;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected static boolean parseHeaderName(HttpHeader httpHeader, MimeHeaders mimeHeaders, HeaderParsingState parsingState, Buffer input) {
        int offset;
        int limit = Math.min(input.limit(), parsingState.packetLimit);
        int start = parsingState.start;
        for (offset = parsingState.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 58) {
                parsingState.headerValueStorage = mimeHeaders.addValue(input, parsingState.start, offset);
                parsingState.offset = offset + 1;
                HttpCodecFilter.finalizeKnownHeaderNames(httpHeader, parsingState, offset - start);
                return true;
            }
            if (b >= 65 && b <= 90) {
                b = (byte)(b + 32);
                input.put(offset, b);
            }
            HttpCodecFilter.checkKnownHeaderNames(parsingState, b, offset - start);
        }
        parsingState.offset = offset;
        return false;
    }

    protected static int parseHeaderValue(HttpHeader httpHeader, HeaderParsingState parsingState, Buffer input) {
        boolean hasShift;
        int limit = Math.min(input.limit(), parsingState.packetLimit);
        int offset = parsingState.offset;
        boolean bl = hasShift = offset != parsingState.checkpoint;
        while (offset < limit) {
            byte b = input.get(offset);
            if (b != 13) {
                if (b == 10) {
                    if (offset + 1 < limit) {
                        byte b2 = input.get(offset + 1);
                        if (b2 == 32 || b2 == 9) {
                            input.put(parsingState.checkpoint++, b2);
                            parsingState.offset = offset + 2;
                            return -2;
                        }
                        parsingState.offset = offset + 1;
                        HttpCodecFilter.finalizeKnownHeaderValues(httpHeader, parsingState, input);
                        parsingState.headerValueStorage.setBuffer(input, parsingState.start, parsingState.checkpoint2);
                        return 0;
                    }
                    parsingState.offset = offset;
                    return -1;
                }
                if (b == 32) {
                    if (hasShift) {
                        input.put(parsingState.checkpoint++, b);
                    } else {
                        ++parsingState.checkpoint;
                    }
                } else {
                    HttpCodecFilter.checkKnownHeaderValues(httpHeader, parsingState, b);
                    if (hasShift) {
                        input.put(parsingState.checkpoint++, b);
                    }
                    parsingState.checkpoint2 = ++parsingState.checkpoint;
                }
            }
            ++offset;
        }
        parsingState.offset = offset;
        return -1;
    }

    private static void checkKnownHeaderNames(HeaderParsingState parsingState, byte b, int idx) {
        if (parsingState.isContentLengthHeader) {
            boolean bl = parsingState.isContentLengthHeader = idx < Constants.CONTENT_LENGTH_HEADER_BYTES.length && b == Constants.CONTENT_LENGTH_HEADER_BYTES[idx];
        }
        if (parsingState.isTransferEncodingHeader) {
            boolean bl = parsingState.isTransferEncodingHeader = idx < Constants.TRANSFER_ENCODING_HEADER_BYTES.length && b == Constants.TRANSFER_ENCODING_HEADER_BYTES[idx];
        }
        if (parsingState.isUpgradeHeader) {
            boolean bl = parsingState.isUpgradeHeader = idx < Constants.UPGRADE_HEADER_BYTES.length && b == Constants.UPGRADE_HEADER_BYTES[idx];
        }
        if (parsingState.isExpect100Header) {
            parsingState.isExpect100Header = idx < Constants.EXPECT_100_CONTINUE_NAME_BYTES.length && b == Constants.EXPECT_100_CONTINUE_NAME_BYTES[idx];
        }
    }

    private static void finalizeKnownHeaderNames(HttpHeader httpHeader, HeaderParsingState parsingState, int size) {
        if (parsingState.isContentLengthHeader) {
            boolean bl = parsingState.isContentLengthHeader = size == Constants.CONTENT_LENGTH_HEADER_BYTES.length;
            if (parsingState.isContentLengthHeader && parsingState.hasContentLength) {
                throw new IllegalStateException("Two content-length headers are not allowed");
            }
            parsingState.hasContentLength = true;
        } else if (parsingState.isTransferEncodingHeader) {
            parsingState.isTransferEncodingHeader = size == Constants.TRANSFER_ENCODING_HEADER_BYTES.length;
        } else if (parsingState.isUpgradeHeader) {
            parsingState.isUpgradeHeader = size == Constants.UPGRADE_HEADER_BYTES.length;
        } else if (parsingState.isExpect100Header) {
            if (size == Constants.EXPECT_100_CONTINUE_NAME_BYTES.length) {
                ((HttpRequestPacket)httpHeader).requiresAcknowledgement(true);
            }
            parsingState.isExpect100Header = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkKnownHeaderValues(HttpHeader httpHeader, HeaderParsingState parsingState, byte b) {
        if (parsingState.isContentLengthHeader) {
            if (!Ascii.isDigit(b)) throw new IllegalStateException("Content-length value is not digital");
            parsingState.parsingNumericValue = parsingState.parsingNumericValue * 10L + (long)(b - 48);
            httpHeader.setContentLength(parsingState.parsingNumericValue);
            return;
        } else {
            int idx;
            if (!parsingState.isTransferEncodingHeader || (idx = parsingState.checkpoint - parsingState.start) >= Constants.CHUNKED_ENCODING_BYTES.length) return;
            boolean bl = parsingState.isTransferEncodingHeader = b == Constants.CHUNKED_ENCODING_BYTES[idx];
            if (idx != Constants.CHUNKED_ENCODING_BYTES.length - 1 || !parsingState.isTransferEncodingHeader) return;
            httpHeader.setChunked(true);
            parsingState.isTransferEncodingHeader = false;
        }
    }

    private static void finalizeKnownHeaderValues(HttpHeader httpHeader, HeaderParsingState parsingState, Buffer input) {
        parsingState.isTransferEncodingHeader = false;
        if (parsingState.isUpgradeHeader) {
            httpHeader.getUpgradeDC().setBuffer(input, parsingState.start, parsingState.checkpoint2);
            parsingState.isUpgradeHeader = false;
        }
    }

    protected static int checkEOL(HeaderParsingState parsingState, Buffer input) {
        int b2;
        byte b1;
        int offset = parsingState.offset;
        int avail = input.limit() - offset;
        if (avail >= 2) {
            short s = input.getShort(offset);
            b1 = (byte)(s >>> 8);
            b2 = (byte)(s & 0xFF);
        } else if (avail == 1) {
            b1 = input.get(offset);
            b2 = -1;
        } else {
            return -2;
        }
        if (b1 == 13) {
            if (b2 == 10) {
                parsingState.offset += 2;
                return 0;
            }
            if (b2 == -1) {
                return -2;
            }
        } else if (b1 == 10) {
            ++parsingState.offset;
            return 0;
        }
        return -1;
    }

    protected static boolean findEOL(HeaderParsingState state, Buffer input) {
        int offset;
        int limit = Math.min(input.limit(), state.packetLimit);
        for (offset = state.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 13) {
                state.checkpoint = offset;
                continue;
            }
            if (b != 10) continue;
            if (state.checkpoint == -1) {
                state.checkpoint = offset;
            }
            state.offset = offset + 1;
            return true;
        }
        state.offset = offset;
        return false;
    }

    protected static int findSpace(Buffer input, int offset, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte b = input.get(offset);
            if (b == 32 || b == 9) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    protected static int skipSpaces(Buffer input, int offset, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte b = input.get(offset);
            if (b != 32 && b != 9) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    protected static int indexOf(Buffer input, int offset, byte b, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte currentByte = input.get(offset);
            if (currentByte == b) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    final void setTransferEncodingOnParsing(HttpHeader httpHeader) {
        TransferEncoding[] encodings = (TransferEncoding[])this.transferEncodings.getArray();
        if (encodings == null) {
            return;
        }
        for (TransferEncoding encoding : encodings) {
            if (!encoding.wantDecode(httpHeader)) continue;
            httpHeader.setTransferEncoding(encoding);
            return;
        }
    }

    final void setTransferEncodingOnSerializing(Connection c, HttpHeader httpHeader, HttpContent httpContent) {
        TransferEncoding[] encodings = (TransferEncoding[])this.transferEncodings.getArray();
        if (encodings == null) {
            return;
        }
        for (TransferEncoding encoding : encodings) {
            if (!encoding.wantEncode(httpHeader)) continue;
            encoding.prepareSerialize(c, httpHeader, httpContent);
            httpHeader.setTransferEncoding(encoding);
            return;
        }
    }

    final HttpContent decodeContent(Connection connection, HttpContent httpContent) {
        if (!httpContent.getContent().hasRemaining()) {
            httpContent.recycle();
            return null;
        }
        MemoryManager memoryManager = connection.getTransport().getMemoryManager();
        HttpHeader httpHeader = httpContent.getHttpHeader();
        ContentParsingState parsingState = ((HttpPacketParsing)((Object)httpHeader)).getContentParsingState();
        List<ContentEncoding> encodings = httpHeader.getContentEncodings(true);
        int encodingsNum = encodings.size();
        for (int i = 0; i < encodingsNum; ++i) {
            ParsingResult result;
            Buffer newRemainder;
            ContentEncoding encoding = encodings.get(i);
            HttpProbeNotifier.notifyContentEncodingParse(this, connection, httpHeader, httpContent.getContent(), encoding);
            Buffer oldRemainder = parsingState.removeContentDecodingRemainder(i);
            if (oldRemainder != null) {
                Buffer newChunk = httpContent.getContent();
                httpContent.setContent(Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)oldRemainder, (Buffer)newChunk));
            }
            if ((newRemainder = (result = encoding.decode(connection, httpContent)).getRemainderBuffer()) != null) {
                parsingState.setContentDecodingRemainder(i, newRemainder);
            }
            HttpContent decodedContent = result.getHttpContent();
            result.recycle();
            if (decodedContent == null) {
                httpContent.recycle();
                return null;
            }
            httpContent = decodedContent;
        }
        return httpContent;
    }

    final HttpContent encodeContent(Connection connection, HttpContent httpContent) {
        HttpHeader httpHeader = httpContent.getHttpHeader();
        List<ContentEncoding> encodings = httpHeader.getContentEncodings(true);
        int len = encodings.size();
        for (int i = 0; i < len; ++i) {
            ContentEncoding encoding = encodings.get(i);
            HttpProbeNotifier.notifyContentEncodingSerialize(this, connection, httpHeader, httpContent.getContent(), encoding);
            HttpContent encodedContent = encoding.encode(connection, httpContent);
            if (encodedContent == null) {
                httpContent.recycle();
                return null;
            }
            httpContent = encodedContent;
        }
        return httpContent;
    }

    final void setContentEncodingsOnParsing(HttpHeader httpHeader) {
        DataChunk bc = httpHeader.getHeaders().getValue("content-encoding");
        if (bc != null) {
            int commaIdx;
            List<ContentEncoding> encodings = httpHeader.getContentEncodings(true);
            int currentIdx = 0;
            do {
                ContentEncoding ce;
                if ((ce = this.lookupContentEncoding(bc, currentIdx, (commaIdx = bc.indexOf(',', currentIdx)) >= 0 ? commaIdx : bc.getLength())) == null || !ce.wantDecode(httpHeader)) {
                    return;
                }
                encodings.add(ce);
                currentIdx = commaIdx + 1;
            } while (commaIdx >= 0);
        }
    }

    final void setContentEncodingsOnSerializing(HttpHeader httpHeader) {
        DataChunk bc = httpHeader.getHeaders().getValue("content-encoding");
        boolean isSomeEncodingApplied = bc != null && bc.getLength() > 0;
        ContentEncoding[] encodingsLibrary = (ContentEncoding[])this.contentEncodings.getArray();
        if (encodingsLibrary == null) {
            return;
        }
        List<ContentEncoding> httpPacketEncoders = httpHeader.getContentEncodings(true);
        boolean specifiedLength = httpHeader.getContentLength() >= 0L;
        for (ContentEncoding encoding : encodingsLibrary) {
            if (isSomeEncodingApplied && HttpCodecFilter.lookupAlias(encoding, bc, 0) || !encoding.wantEncode(httpHeader)) continue;
            if (specifiedLength && this.chunkingEnabled) {
                httpHeader.setContentLength(-1);
                httpHeader.setChunked(true);
            } else if (specifiedLength) continue;
            httpPacketEncoders.add(encoding);
        }
    }

    private ContentEncoding lookupContentEncoding(DataChunk bc, int startIdx, int endIdx) {
        ContentEncoding[] encodings = (ContentEncoding[])this.contentEncodings.getArray();
        if (encodings != null) {
            for (ContentEncoding encoding : encodings) {
                if (!HttpCodecFilter.lookupAlias(encoding, bc, startIdx)) continue;
                return encoding;
            }
        }
        return null;
    }

    private ParsingResult parseWithTransferEncoding(Connection connection, HttpHeader httpHeader, Buffer input) {
        TransferEncoding encoding = httpHeader.getTransferEncoding();
        HttpProbeNotifier.notifyTransferEncodingParse(this, connection, httpHeader, input, encoding);
        return encoding.parsePacket(connection, httpHeader, input);
    }

    private Buffer serializeWithTransferEncoding(Connection connection, HttpContent httpContent, TransferEncoding encoding) {
        if (encoding != null) {
            HttpProbeNotifier.notifyTransferEncodingParse(this, connection, httpContent.getHttpHeader(), httpContent.getContent(), encoding);
            return encoding.serializePacket(connection, httpContent);
        }
        return httpContent.getContent();
    }

    private static boolean lookupAlias(ContentEncoding encoding, DataChunk aliasBuffer, int startIdx) {
        String[] aliases;
        for (String alias : aliases = encoding.getAliases()) {
            int aliasLen = alias.length();
            for (int i = 0; i < aliasLen; ++i) {
                if (!aliasBuffer.startsWithIgnoreCase(alias, startIdx)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isSecure(Connection connection) {
        return SSLUtils.getSSLEngine((AttributeStorage)connection) != null;
    }

    public JmxMonitoringConfig<HttpProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.http.jmx.HttpCodecFilter(this);
    }

    protected static final class ContentParsingState {
        public boolean isLastChunk;
        public int chunkContentStart = -1;
        public long chunkLength = -1L;
        public long chunkRemainder = -1L;
        public final MimeHeaders trailerHeaders = new MimeHeaders();
        private Buffer[] contentDecodingRemainders = new Buffer[1];
        private final Buffer[] contentEncodingRemainders = new Buffer[1];

        protected ContentParsingState() {
        }

        public void recycle() {
            this.isLastChunk = false;
            this.chunkContentStart = -1;
            this.chunkLength = -1L;
            this.chunkRemainder = -1L;
            this.trailerHeaders.clear();
            Arrays.fill(this.contentDecodingRemainders, null);
            Arrays.fill(this.contentEncodingRemainders, null);
        }

        private Buffer removeContentDecodingRemainder(int i) {
            Buffer remainder = this.contentDecodingRemainders[i];
            this.contentDecodingRemainders[i] = null;
            return remainder;
        }

        private void setContentDecodingRemainder(int i, Buffer remainder) {
            if (i >= this.contentDecodingRemainders.length) {
                this.contentDecodingRemainders = Arrays.copyOf(this.contentDecodingRemainders, i + 1);
            }
            this.contentDecodingRemainders[i] = remainder;
        }
    }

    protected static final class HeaderParsingState {
        public int packetLimit;
        public int state;
        public int subState;
        public int start;
        public int offset;
        public int checkpoint = -1;
        public int checkpoint2 = -1;
        public DataChunk headerValueStorage;
        public long parsingNumericValue;
        public boolean isContentLengthHeader;
        public boolean hasContentLength;
        public boolean isTransferEncodingHeader;
        public boolean isUpgradeHeader;
        public boolean isExpect100Header;

        protected HeaderParsingState() {
        }

        public void initialize(int initialOffset, int maxHeaderSize) {
            this.offset = initialOffset;
            this.packetLimit = this.offset + maxHeaderSize;
        }

        public void set(int state, int subState, int start, int offset) {
            this.state = state;
            this.subState = subState;
            this.start = start;
            this.offset = offset;
        }

        public void recycle() {
            this.state = 0;
            this.subState = 0;
            this.start = 0;
            this.offset = 0;
            this.checkpoint = -1;
            this.checkpoint2 = -1;
            this.headerValueStorage = null;
            this.parsingNumericValue = 0L;
            this.isTransferEncodingHeader = false;
            this.isContentLengthHeader = false;
            this.isUpgradeHeader = false;
            this.isExpect100Header = false;
            this.hasContentLength = false;
        }

        public final void checkOverflow() {
            if (this.offset < this.packetLimit) {
                return;
            }
            throw new IllegalStateException("HTTP packet is too long");
        }
    }
}

