/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.stagent.options.OptionsParameter;

public class OptionsManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(OptionsManager.class);
    protected static final String OPTIONS_PROPERTIES_FILE_JVM_PARAM = "org.nhindirect.stagent.PropertiesFile";
    protected static final String DEFAULT_PROPERTIES_FILE = "agentSettings.properties";
    protected static final Map<String, String> JVM_PARAMS = new HashMap<String, String>();
    protected final Map<String, OptionsParameter> options = new HashMap<String, OptionsParameter>();
    protected static OptionsManager INSTANCE;

    public static synchronized void addInitParameters(Map<String, String> initParams) {
        JVM_PARAMS.putAll(initParams);
        if (INSTANCE != null) {
            for (String param : initParams.keySet()) {
                INSTANCE.initParam(param);
            }
        }
    }

    public static synchronized OptionsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OptionsManager();
        }
        return INSTANCE;
    }

    protected OptionsManager() {
        this.initParams();
    }

    public synchronized Collection<OptionsParameter> getParameters() {
        return Collections.unmodifiableCollection(this.options.values());
    }

    public synchronized OptionsParameter getParameter(String paramName) {
        if (paramName == null || paramName.isEmpty()) {
            throw new IllegalArgumentException("Parameter name cannot be null or empty");
        }
        return this.options.get(paramName);
    }

    public synchronized void setOptionsParameter(OptionsParameter param) {
        if (param == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        this.options.put(param.getParamName(), param);
    }

    public synchronized void setOptionsParameters(Collection<OptionsParameter> params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        for (OptionsParameter param : params) {
            this.setOptionsParameter(param);
        }
    }

    protected void initParams() {
        this.loadParamsFromPropertiesFile();
        for (String param : JVM_PARAMS.keySet()) {
            this.initParam(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadParamsFromPropertiesFile() {
        File optionsFile;
        String propFileName = System.getProperty(OPTIONS_PROPERTIES_FILE_JVM_PARAM, DEFAULT_PROPERTIES_FILE);
        if (propFileName.isEmpty()) {
            propFileName = DEFAULT_PROPERTIES_FILE;
        }
        if ((optionsFile = new File(propFileName)).exists()) {
            FileInputStream inStream = null;
            try {
                inStream = FileUtils.openInputStream((File)optionsFile);
                Properties props = new Properties();
                props.load(inStream);
                for (Object paramName : props.keySet()) {
                    String propValue;
                    String paramValue = System.getProperty(paramName.toString(), "");
                    if (!paramValue.isEmpty() || (propValue = props.getProperty(paramName.toString(), null)) == null) continue;
                    System.setProperty(paramName.toString(), propValue);
                    this.options.put(paramName.toString(), new OptionsParameter(paramName.toString(), propValue));
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Exception occured loading options settings from properties file " + optionsFile), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inStream);
            }
        }
    }

    protected void initParam(String paramName) {
        String value;
        String jvmArg = JVM_PARAMS.get(paramName);
        if (jvmArg != null && jvmArg.length() > 0 && (value = System.getProperty(jvmArg)) != null && value.length() > 0) {
            this.options.put(paramName, new OptionsParameter(paramName, value));
        }
    }

    static {
        JVM_PARAMS.put("JCE_PROVIDER", "org.nhindirect.stagent.cryptography.JCEProviderName");
        JVM_PARAMS.put("JCE_PROVIDER_CLASSES", "org.nhindirect.stagent.cryptography.JCEProviderClassNames");
        JVM_PARAMS.put("CRL_CACHE_LOCATION", "org.nhindirect.stagent.cert.CRLCacheLocation");
        JVM_PARAMS.put("DNS_CERT_RESOLVER_RETRIES", "org.nhindirect.stagent.cert.dnsresolver.ServerRetries");
        JVM_PARAMS.put("DNS_CERT_RESOLVER_TIMEOUT", "org.nhindirect.stagent.cert.dnsresolver.ServerTimeout");
        JVM_PARAMS.put("DNS_CERT_RESOLVER_USE_TCP", "org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP");
        JVM_PARAMS.put("DNS_CERT_RESOLVER_MAX_CACHE_SIZE", "org.nhindirect.stagent.cert.dnsresolver.MaxCacheSize");
        JVM_PARAMS.put("DNS_CERT_RESOLVER_CACHE_TTL", "org.nhindirect.stagent.cert.dnsresolver.CacheTTL");
        JVM_PARAMS.put("LDAP_CERT_RESOLVER_MAX_CACHE_SIZE", "org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize");
        JVM_PARAMS.put("LDAP_CERT_RESOLVER_CACHE_TTL", "org.nhindirect.stagent.cert.ldapresolver.CacheTTL");
        JVM_PARAMS.put("CRYPTOGRAHPER_SMIME_ENCRYPTION_ALGORITHM", "org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm");
        JVM_PARAMS.put("CRYPTOGRAHPER_SMIME_DIGEST_ALGORITHM", "org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm");
    }
}

