/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools.certgen;

import java.io.File;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.tools.certgen.CertCreateFields;

public class CertGenerator {
    private static final String PBE_WITH_MD5_AND_DES_CBC_OID = "1.2.840.113549.1.5.3";

    public static CertCreateFields createCertificate(CertCreateFields fields) throws Exception {
        return CertGenerator.createCertificate(fields, false);
    }

    public static CertCreateFields createCertificate(CertCreateFields fields, boolean addAltNames) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", CryptoExtensions.getJCEProviderName());
        kpg.initialize(fields.getKeyStrength(), new SecureRandom());
        KeyPair keyPair = kpg.generateKeyPair();
        if (fields.getSignerCert() == null) {
            return CertGenerator.createNewCA(fields, keyPair, addAltNames);
        }
        return CertGenerator.createLeafCertificate(fields, keyPair, addAltNames);
    }

    private static long generatePositiveRandom() {
        long retVal = -1L;
        byte[] seed = new byte[8];
        VMPCRandomGenerator seedGen = new VMPCRandomGenerator();
        seedGen.addSeedMaterial(new SecureRandom().nextLong());
        seedGen.nextBytes(seed);
        SecureRandom ranGen = new SecureRandom(seed);
        while (retVal < 1L) {
            retVal = ranGen.nextLong();
        }
        return retVal;
    }

    private static CertCreateFields createNewCA(CertCreateFields fields, KeyPair keyPair, boolean addAltNames) throws Exception {
        String DN;
        StringBuilder dnBuilder = new StringBuilder();
        String altName = "";
        if (fields.getAttributes().containsKey("EMAILADDRESS")) {
            dnBuilder.append("EMAILADDRESS=").append(fields.getAttributes().get("EMAILADDRESS")).append(", ");
            altName = fields.getAttributes().get("EMAILADDRESS").toString();
        }
        if (fields.getAttributes().containsKey("CN")) {
            dnBuilder.append("CN=").append(fields.getAttributes().get("CN")).append(", ");
        }
        if (fields.getAttributes().containsKey("C")) {
            dnBuilder.append("C=").append(fields.getAttributes().get("C")).append(", ");
        }
        if (fields.getAttributes().containsKey("ST")) {
            dnBuilder.append("ST=").append(fields.getAttributes().get("ST")).append(", ");
        }
        if (fields.getAttributes().containsKey("L")) {
            dnBuilder.append("L=").append(fields.getAttributes().get("L")).append(", ");
        }
        if (fields.getAttributes().containsKey("O")) {
            dnBuilder.append("O=").append(fields.getAttributes().get("O")).append(", ");
        }
        if ((DN = dnBuilder.toString().trim()).endsWith(",")) {
            DN = DN.substring(0, DN.length() - 1);
        }
        X509V3CertificateGenerator v1CertGen = new X509V3CertificateGenerator();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.add(5, fields.getExpDays());
        v1CertGen.setSerialNumber(BigInteger.valueOf(CertGenerator.generatePositiveRandom()));
        v1CertGen.setIssuerDN((X509Name)new X509Principal(DN));
        v1CertGen.setNotBefore(start.getTime());
        v1CertGen.setNotAfter(end.getTime());
        v1CertGen.setSubjectDN((X509Name)new X509Principal(DN));
        v1CertGen.setPublicKey(keyPair.getPublic());
        v1CertGen.setSignatureAlgorithm("SHA1WithRSAEncryption");
        v1CertGen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(true));
        if (addAltNames && !altName.isEmpty()) {
            int nameType = altName.contains("@") ? 1 : 2;
            GeneralNames subjectAltName = new GeneralNames(new GeneralName(nameType, altName));
            v1CertGen.addExtension(X509Extensions.SubjectAlternativeName, false, (DEREncodable)subjectAltName);
        }
        X509Certificate newCACert = v1CertGen.generate(keyPair.getPrivate(), CryptoExtensions.getJCEProviderName());
        newCACert.verify(keyPair.getPublic());
        CertGenerator.writeCertAndKey(newCACert, keyPair.getPrivate(), fields);
        return fields;
    }

    private static CertCreateFields createLeafCertificate(CertCreateFields fields, KeyPair keyPair, boolean addAltNames) throws Exception {
        String DN;
        String altName = "";
        StringBuilder dnBuilder = new StringBuilder();
        if (fields.getAttributes().containsKey("EMAILADDRESS")) {
            dnBuilder.append("EMAILADDRESS=").append(fields.getAttributes().get("EMAILADDRESS")).append(", ");
            altName = fields.getAttributes().get("EMAILADDRESS").toString();
        }
        if (fields.getAttributes().containsKey("CN")) {
            dnBuilder.append("CN=").append(fields.getAttributes().get("CN")).append(", ");
        }
        if (fields.getAttributes().containsKey("C")) {
            dnBuilder.append("C=").append(fields.getAttributes().get("C")).append(", ");
        }
        if (fields.getAttributes().containsKey("ST")) {
            dnBuilder.append("ST=").append(fields.getAttributes().get("ST")).append(", ");
        }
        if (fields.getAttributes().containsKey("L")) {
            dnBuilder.append("L=").append(fields.getAttributes().get("L")).append(", ");
        }
        if (fields.getAttributes().containsKey("O")) {
            dnBuilder.append("O=").append(fields.getAttributes().get("O")).append(", ");
        }
        if ((DN = dnBuilder.toString().trim()).endsWith(",")) {
            DN = DN.substring(0, DN.length() - 1);
        }
        X509V3CertificateGenerator v1CertGen = new X509V3CertificateGenerator();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.add(5, fields.getExpDays());
        v1CertGen.setSerialNumber(BigInteger.valueOf(CertGenerator.generatePositiveRandom()));
        v1CertGen.setIssuerDN(fields.getSignerCert().getSubjectX500Principal());
        v1CertGen.setNotBefore(start.getTime());
        v1CertGen.setNotAfter(end.getTime());
        v1CertGen.setSubjectDN((X509Name)new X509Principal(DN));
        v1CertGen.setPublicKey(keyPair.getPublic());
        v1CertGen.setSignatureAlgorithm("SHA1WithRSAEncryption");
        v1CertGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(fields.getSignerCert()));
        v1CertGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(keyPair.getPublic()));
        boolean allowToSign = fields.getAttributes().get("ALLOWTOSIGN") != null && fields.getAttributes().get("ALLOWTOSIGN").toString().equalsIgnoreCase("true");
        v1CertGen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(allowToSign));
        if (fields.getSignerCert().getSubjectAlternativeNames() != null) {
            for (List<?> names : fields.getSignerCert().getSubjectAlternativeNames()) {
                GeneralNames issuerAltName = new GeneralNames(new GeneralName(((Integer)names.get(0)).intValue(), names.get(1).toString()));
                v1CertGen.addExtension(X509Extensions.IssuerAlternativeName, false, (DEREncodable)issuerAltName);
            }
        }
        if (addAltNames && !altName.isEmpty()) {
            int nameType = altName.contains("@") ? 1 : 2;
            GeneralNames subjectAltName = new GeneralNames(new GeneralName(nameType, altName));
            v1CertGen.addExtension(X509Extensions.SubjectAlternativeName, false, (DEREncodable)subjectAltName);
        }
        X509Certificate newCACert = v1CertGen.generate((PrivateKey)fields.getSignerKey(), CryptoExtensions.getJCEProviderName());
        newCACert.verify(fields.getSignerCert().getPublicKey());
        CertGenerator.writeCertAndKey(newCACert, keyPair.getPrivate(), fields);
        return fields;
    }

    private static void writeCertAndKey(X509Certificate cert, PrivateKey key, CertCreateFields fields) throws Exception {
        FileUtils.writeByteArrayToFile((File)fields.getNewCertFile(), (byte[])cert.getEncoded());
        if (fields.getNewPassword() == null || fields.getNewPassword().length == 0) {
            FileUtils.writeByteArrayToFile((File)fields.getNewKeyFile(), (byte[])key.getEncoded());
        } else {
            byte[] salt = new byte[8];
            VMPCRandomGenerator ranGen = new VMPCRandomGenerator();
            ranGen.addSeedMaterial(new SecureRandom().nextLong());
            ranGen.nextBytes(salt);
            PBEParameterSpec pbeSpec = new PBEParameterSpec(salt, 20);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(fields.getNewPassword());
            SecretKey sKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES", CryptoExtensions.getJCEProviderName()).generateSecret(pbeKeySpec);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES", CryptoExtensions.getJCEProviderName());
            cipher.init(1, (Key)sKey, pbeSpec, null);
            byte[] plain = key.getEncoded();
            byte[] encrKey = cipher.doFinal(plain, 0, plain.length);
            AlgorithmParameters pbeParams = AlgorithmParameters.getInstance(PBE_WITH_MD5_AND_DES_CBC_OID, Security.getProvider("SunJCE"));
            pbeParams.init(pbeSpec);
            EncryptedPrivateKeyInfo info = new EncryptedPrivateKeyInfo(pbeParams, encrKey);
            FileUtils.writeByteArrayToFile((File)fields.getNewKeyFile(), (byte[])info.getEncoded());
        }
        if (fields.getSignerCert() == null) {
            fields.setSignerCert(cert);
        }
        if (fields.getSignerKey() == null) {
            fields.setSignerKey(key);
        }
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

