/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.tools.DNSRecordPrinter;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.security.CERTConverter;

public class DefaultDNSRecordPrinter
implements DNSRecordPrinter {
    private final PrintWriter writer = new PrintWriter(System.out);

    @Override
    public void print(Collection<DnsRecord> records) {
        if (records == null || records.size() == 0) {
            this.writer.println("Empty record list");
            return;
        }
        for (DnsRecord record : records) {
            this.print(record);
        }
    }

    @Override
    public void print(DnsRecord[] records) {
        if (records == null || records.length == 0) {
            this.writer.println("Empty record array");
            return;
        }
        this.print(Arrays.asList(records));
    }

    private String typeToString(int type) {
        switch (type) {
            case 1: {
                return "A";
            }
            case 15: {
                return "MX";
            }
            case 6: {
                return "SOA";
            }
            case 37: {
                return "CERT";
            }
        }
        return "Unknown";
    }

    @Override
    public void print(DnsRecord record) {
        if (record == null) {
            this.writer.println("Null Resource Record");
            return;
        }
        this.writer.println("-----------");
        this.print("Record Name", record.getName());
        this.print("Type", this.typeToString(record.getType()));
        this.print("TTL", String.valueOf(record.getTtl()));
        switch (record.getType()) {
            default: {
                break;
            }
            case 1: {
                this.print((ARecord)this.toRecord(record));
                break;
            }
            case 6: {
                this.print((SOARecord)this.toRecord(record));
                break;
            }
            case 15: {
                this.print((MXRecord)this.toRecord(record));
                break;
            }
            case 37: {
                this.print((CERTRecord)this.toRecord(record));
            }
        }
        this.writer.flush();
    }

    private Name nameFromString(String str) {
        if (!str.endsWith(".")) {
            str = str + ".";
        }
        try {
            return Name.fromString((String)str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid DNS name");
        }
    }

    private Record toRecord(DnsRecord rec) {
        return Record.newRecord((Name)this.nameFromString(rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
    }

    private void print(ARecord body) {
        if (body == null) {
            this.print("Null A Record Body");
            return;
        }
        this.print("IPAddress", body.getAddress().getHostAddress());
    }

    private void print(MXRecord body) {
        if (body == null) {
            this.print("Null MX Record Body");
            return;
        }
        this.print("Access Exchage Server", body.getTarget().toString());
        this.print("Priority", String.valueOf(body.getPriority()));
    }

    private void print(SOARecord soa) {
        if (soa == null) {
            this.print("Null SOA Record Body");
            return;
        }
        this.print("DomainName", soa.getName().toString());
        this.print("Primary Name Server", soa.getHost().toString());
        this.print("Refresh", String.valueOf(soa.getRefresh()));
        this.print("Retry", String.valueOf(soa.getRetry()));
        this.print("Expire", String.valueOf(soa.getExpire()));
        this.print("Minimum", String.valueOf(soa.getMinimum()));
    }

    private void print(CERTRecord certbody) {
        if (certbody == null) {
            this.print("Null CERT Record Body");
            return;
        }
        Certificate cert = CERTConverter.parseRecord((CERTRecord)certbody);
        if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            this.print("Certificate Subject", xcert.getSubjectDN().getName());
        }
    }

    private void print(String name, String value) {
        this.writer.println(name + ": " + value);
    }

    private void print(String message) {
        this.writer.println(message);
    }
}

