/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import java.net.URL;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.config.DNSServerConfig;
import org.nhindirect.dns.provider.WSDNSServerConfigProvider;

public class DNSServerConfigModule
extends AbstractModule {
    private final URL configLocation;
    private final Provider<DNSStore> storeProvider;
    private final Provider<DNSServerSettings> settings;

    public static DNSServerConfigModule create(URL configLocation, Provider<DNSStore> storeProvider, Provider<DNSServerSettings> settings) {
        return new DNSServerConfigModule(configLocation, storeProvider, settings);
    }

    private DNSServerConfigModule(URL configLocation, Provider<DNSStore> storeProvider, Provider<DNSServerSettings> settings) {
        this.configLocation = configLocation;
        this.storeProvider = storeProvider;
        this.settings = settings;
    }

    protected void configure() {
        WSDNSServerConfigProvider provider = null;
        if (provider == null) {
            if (this.configLocation.getProtocol().equalsIgnoreCase("HTTP") || this.configLocation.getProtocol().equalsIgnoreCase("HTTPS")) {
                provider = new WSDNSServerConfigProvider(this.configLocation, this.storeProvider, this.settings);
            } else {
                throw new IllegalArgumentException("Configuration URL uses an unsupported protocol: " + this.configLocation.getProtocol());
            }
        }
        this.bind(DNSServerConfig.class).toProvider(provider);
    }
}

