/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.datatypes.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.openhealthtools.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.openhealthtools.mdht.uml.hl7.datatypes.DatatypesPackage;
import org.openhealthtools.mdht.uml.hl7.datatypes.EN;
import org.openhealthtools.mdht.uml.hl7.datatypes.operations.ANYOperations;
import org.openhealthtools.mdht.uml.hl7.vocab.EntityNamePartType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ENOperations
extends ANYOperations {
    protected static final OCL EOCL_ENV = OCL.newInstance();
    protected static final String VALIDATE_DELIMITER__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.delimiter->forAll(enxp : datatypes::ENXP | enxp.partType = vocab::EntityNamePartType::DEL)";
    protected static Constraint VALIDATE_DELIMITER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;
    protected static final String VALIDATE_FAMILY__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.family->forAll(enxp : datatypes::ENXP | enxp.partType = vocab::EntityNamePartType::FAM)";
    protected static Constraint VALIDATE_FAMILY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;
    protected static final String VALIDATE_GIVEN__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.given->forAll(enxp : datatypes::ENXP | enxp.partType = vocab::EntityNamePartType::GIV)";
    protected static Constraint VALIDATE_GIVEN__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;
    protected static final String VALIDATE_PREFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.prefix->forAll(enxp : datatypes::ENXP | enxp.partType = vocab::EntityNamePartType::PFX)";
    protected static Constraint VALIDATE_PREFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;
    protected static final String VALIDATE_SUFFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.suffix->forAll(enxp : datatypes::ENXP | enxp.partType = vocab::EntityNamePartType::SFX)";
    protected static Constraint VALIDATE_SUFFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

    protected ENOperations() {
    }

    public static boolean validateDelimiter(EN en, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (VALIDATE_DELIMITER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext((Object)DatatypesPackage.Literals.EN);
            try {
                VALIDATE_DELIMITER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = (Constraint)helper.createInvariant(VALIDATE_DELIMITER__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(VALIDATE_DELIMITER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check((Object)en)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.openhealthtools.mdht.uml.hl7.datatypes", 43, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validateDelimiter", EObjectValidator.getObjectLabel((EObject)en, context)}), new Object[]{en}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateFamily(EN en, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (VALIDATE_FAMILY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext((Object)DatatypesPackage.Literals.EN);
            try {
                VALIDATE_FAMILY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = (Constraint)helper.createInvariant(VALIDATE_FAMILY__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(VALIDATE_FAMILY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check((Object)en)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.openhealthtools.mdht.uml.hl7.datatypes", 44, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validateFamily", EObjectValidator.getObjectLabel((EObject)en, context)}), new Object[]{en}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateGiven(EN en, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (VALIDATE_GIVEN__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext((Object)DatatypesPackage.Literals.EN);
            try {
                VALIDATE_GIVEN__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = (Constraint)helper.createInvariant(VALIDATE_GIVEN__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(VALIDATE_GIVEN__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check((Object)en)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.openhealthtools.mdht.uml.hl7.datatypes", 45, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validateGiven", EObjectValidator.getObjectLabel((EObject)en, context)}), new Object[]{en}));
            }
            return false;
        }
        return true;
    }

    public static boolean validatePrefix(EN en, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (VALIDATE_PREFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext((Object)DatatypesPackage.Literals.EN);
            try {
                VALIDATE_PREFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = (Constraint)helper.createInvariant(VALIDATE_PREFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(VALIDATE_PREFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check((Object)en)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.openhealthtools.mdht.uml.hl7.datatypes", 46, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validatePrefix", EObjectValidator.getObjectLabel((EObject)en, context)}), new Object[]{en}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateSuffix(EN en, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (VALIDATE_SUFFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext((Object)DatatypesPackage.Literals.EN);
            try {
                VALIDATE_SUFFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = (Constraint)helper.createInvariant(VALIDATE_SUFFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(VALIDATE_SUFFIX__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check((Object)en)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.openhealthtools.mdht.uml.hl7.datatypes", 47, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validateSuffix", EObjectValidator.getObjectLabel((EObject)en, context)}), new Object[]{en}));
            }
            return false;
        }
        return true;
    }

    public static EN addDelimiter(EN en, String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter is null");
        }
        en.getDelimiters().add((Object)DatatypesFactory.eINSTANCE.createENXP(EntityNamePartType.DEL, delimiter));
        return en;
    }

    public static EN addFamily(EN en, String family) {
        if (family == null) {
            throw new IllegalArgumentException("family is null");
        }
        en.getFamilies().add((Object)DatatypesFactory.eINSTANCE.createENXP(EntityNamePartType.FAM, family));
        return en;
    }

    public static EN addGiven(EN en, String given) {
        if (given == null) {
            throw new IllegalArgumentException("given is null");
        }
        en.getGivens().add((Object)DatatypesFactory.eINSTANCE.createENXP(EntityNamePartType.GIV, given));
        return en;
    }

    public static EN addPrefix(EN en, String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        en.getPrefixes().add((Object)DatatypesFactory.eINSTANCE.createENXP(EntityNamePartType.PFX, prefix));
        return en;
    }

    public static EN addSuffix(EN en, String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("suffix is null");
        }
        en.getSuffixes().add((Object)DatatypesFactory.eINSTANCE.createENXP(EntityNamePartType.SFX, suffix));
        return en;
    }

    public static EN addText(EN en, String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        FeatureMapUtil.addText((FeatureMap)en.getMixed(), (String)text);
        return en;
    }

    public static String getText(EN en) {
        StringBuffer text = new StringBuffer("");
        for (FeatureMap.Entry entry : en.getMixed()) {
            if (!FeatureMapUtil.isText((FeatureMap.Entry)entry)) continue;
            text.append(entry.getValue().toString());
        }
        return text.toString();
    }

    public static String getText(EN en, boolean trim) {
        if (trim) {
            return ENOperations.getText(en).trim();
        }
        return ENOperations.getText(en);
    }
}

