/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class RevokeRoleConstantAction
extends DDLConstantAction {
    private List roleNames;
    private List grantees;
    private final boolean withAdminOption = false;

    public RevokeRoleConstantAction(List list, List list2) {
        this.roleNames = list;
        this.grantees = list2;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        String string = languageConnectionContext.getAuthorizationId();
        dataDictionary.startWriting(languageConnectionContext);
        Iterator iterator = this.roleNames.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Iterator iterator2 = this.grantees.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                RoleDescriptor roleDescriptor = dataDictionary.getRoleDefinitionDescriptor(string2);
                if (roleDescriptor == null) {
                    throw StandardException.newException("0P000", string2);
                }
                if (!string.equals(roleDescriptor.getGrantee())) {
                    throw StandardException.newException("4251A", "REVOKE role");
                }
                roleDescriptor = dataDictionary.getRoleGrantDescriptor(string2, string3, string);
                if (roleDescriptor != null) {
                    // empty if block
                }
                if (roleDescriptor != null) {
                    roleDescriptor.drop(languageConnectionContext);
                    continue;
                }
                activation.addWarning(StandardException.newWarning("01007", string2, string3));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.roleNames.iterator();
        while (object.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object.next().toString());
        }
        object = new StringBuffer();
        Iterator iterator = this.grantees.iterator();
        while (iterator.hasNext()) {
            if (((StringBuffer)object).length() > 0) {
                ((StringBuffer)object).append(", ");
            }
            ((StringBuffer)object).append(iterator.next().toString());
        }
        return "REVOKE " + stringBuffer.toString() + " FROM: " + ((StringBuffer)object).toString() + "\n";
    }
}

