/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests.optional;

import java.util.List;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.SieveMailException;
import org.apache.jsieve.tests.AbstractTest;

public class Body
extends AbstractTest {
    private StringListArgument strings = null;

    protected void validateArguments(Arguments args, SieveContext ctx) throws SieveException {
        List<Argument> arglist = args.getArgumentList();
        if (arglist.size() != 2) {
            throw new SyntaxException("Currently body-test can only two arguments");
        }
        Argument arg = arglist.get(0);
        if (!(arg instanceof TagArgument)) {
            throw new SyntaxException("Body expects a :contains tag");
        }
        if (!((TagArgument)arg).getTag().equals(":contains")) {
            throw new SyntaxException("Body expects a :contains tag");
        }
        arg = arglist.get(1);
        if (!(arg instanceof StringListArgument)) {
            throw new SyntaxException("Body expects a list of strings");
        }
        this.strings = (StringListArgument)args.getArgumentList().get(1);
    }

    protected boolean executeBasic(MailAdapter mail, Arguments args, SieveContext ctx) throws SieveException {
        if (mail.getContentType().indexOf("text/") != 0) {
            throw new SieveMailException("Message is not of type 'text'");
        }
        for (String phrase : this.strings.getList()) {
            if (!mail.isInBodyText(phrase)) continue;
            return true;
        }
        return false;
    }
}

